/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSFileWriterSync.h"

#include "ExceptionCode.h"
#include "FileWriterSync.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFileWriterSyncTableValues[] =
{
    { "position", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterSyncPosition), (intptr_t)0, NoIntrinsic },
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterSyncLength), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileWriterSyncTable = { 4, 3, JSFileWriterSyncTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSFileWriterSyncPrototypeTableValues[] =
{
    { "write", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterSyncPrototypeFunctionWrite), (intptr_t)1, NoIntrinsic },
    { "seek", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterSyncPrototypeFunctionSeek), (intptr_t)1, NoIntrinsic },
    { "truncate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterSyncPrototypeFunctionTruncate), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileWriterSyncPrototypeTable = { 8, 7, JSFileWriterSyncPrototypeTableValues, 0 };
static const HashTable* getJSFileWriterSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileWriterSyncPrototypeTable);
}

const ClassInfo JSFileWriterSyncPrototype::s_info = { "FileWriterSyncPrototype", &Base::s_info, 0, getJSFileWriterSyncPrototypeTable, CREATE_METHOD_TABLE(JSFileWriterSyncPrototype) };

JSObject* JSFileWriterSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileWriterSync>(exec, globalObject);
}

bool JSFileWriterSyncPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileWriterSyncPrototype* thisObject = jsCast<JSFileWriterSyncPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSFileWriterSyncPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFileWriterSyncPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileWriterSyncPrototype* thisObject = jsCast<JSFileWriterSyncPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSFileWriterSyncPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSFileWriterSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileWriterSyncTable);
}

const ClassInfo JSFileWriterSync::s_info = { "FileWriterSync", &Base::s_info, 0, getJSFileWriterSyncTable , CREATE_METHOD_TABLE(JSFileWriterSync) };

JSFileWriterSync::JSFileWriterSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileWriterSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSFileWriterSync::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileWriterSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileWriterSyncPrototype::create(exec->vm(), globalObject, JSFileWriterSyncPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSFileWriterSync::destroy(JSC::JSCell* cell)
{
    JSFileWriterSync* thisObject = static_cast<JSFileWriterSync*>(cell);
    thisObject->JSFileWriterSync::~JSFileWriterSync();
}

JSFileWriterSync::~JSFileWriterSync()
{
    releaseImplIfNotNull();
}

bool JSFileWriterSync::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileWriterSync* thisObject = jsCast<JSFileWriterSync*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSFileWriterSync, Base>(exec, getJSFileWriterSyncTable(exec), thisObject, propertyName, slot);
}

bool JSFileWriterSync::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileWriterSync* thisObject = jsCast<JSFileWriterSync*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSFileWriterSync, Base>(exec, getJSFileWriterSyncTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsFileWriterSyncPosition(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriterSync* castedThis = jsCast<JSFileWriterSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriterSync* impl = static_cast<FileWriterSync*>(castedThis->impl());
    JSValue result = jsNumber(impl->position());
    return result;
}


JSValue jsFileWriterSyncLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriterSync* castedThis = jsCast<JSFileWriterSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriterSync* impl = static_cast<FileWriterSync*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsFileWriterSyncPrototypeFunctionWrite(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriterSync::s_info))
        return throwVMTypeError(exec);
    JSFileWriterSync* castedThis = jsCast<JSFileWriterSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriterSync::s_info);
    FileWriterSync* impl = static_cast<FileWriterSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Blob* data(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->write(data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterSyncPrototypeFunctionSeek(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriterSync::s_info))
        return throwVMTypeError(exec);
    JSFileWriterSync* castedThis = jsCast<JSFileWriterSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriterSync::s_info);
    FileWriterSync* impl = static_cast<FileWriterSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    long long position(toInt64(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->seek(position, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterSyncPrototypeFunctionTruncate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriterSync::s_info))
        return throwVMTypeError(exec);
    JSFileWriterSync* castedThis = jsCast<JSFileWriterSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriterSync::s_info);
    FileWriterSync* impl = static_cast<FileWriterSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    long long size(toInt64(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->truncate(size, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSFileWriterSync* jsFileWriterSync)
{
    if (jsFileWriterSync->hasCustomProperties())
        return true;
    return false;
}

bool JSFileWriterSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSFileWriterSync* jsFileWriterSync = jsCast<JSFileWriterSync*>(handle.get().asCell());
    if (!isObservable(jsFileWriterSync))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSFileWriterSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSFileWriterSync* jsFileWriterSync = jsCast<JSFileWriterSync*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileWriterSync->impl(), jsFileWriterSync);
    jsFileWriterSync->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileWriterSync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14FileWriterSyncE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileWriterSync* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFileWriterSync>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FileWriterSync@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14FileWriterSyncE[2];
#if COMPILER(CLANG)
    // If this fails FileWriterSync does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FileWriterSync), FileWriterSync_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FileWriterSync has subclasses. If FileWriterSync has subclasses that get passed
    // to toJS() we currently require FileWriterSync you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<FileWriterSync>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSFileWriterSync>(exec, globalObject, impl);
}

FileWriterSync* toFileWriterSync(JSC::JSValue value)
{
    return value.inherits(&JSFileWriterSync::s_info) ? jsCast<JSFileWriterSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
