/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSFileWriter.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "FileError.h"
#include "FileWriter.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSFileError.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFileWriterTableValues[] =
{
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterReadyState), (intptr_t)0, NoIntrinsic },
    { "error", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterError), (intptr_t)0, NoIntrinsic },
    { "position", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterPosition), (intptr_t)0, NoIntrinsic },
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterLength), (intptr_t)0, NoIntrinsic },
    { "onwritestart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterOnwritestart), (intptr_t)setJSFileWriterOnwritestart, NoIntrinsic },
    { "onprogress", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterOnprogress), (intptr_t)setJSFileWriterOnprogress, NoIntrinsic },
    { "onwrite", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterOnwrite), (intptr_t)setJSFileWriterOnwrite, NoIntrinsic },
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterOnabort), (intptr_t)setJSFileWriterOnabort, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterOnerror), (intptr_t)setJSFileWriterOnerror, NoIntrinsic },
    { "onwriteend", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterOnwriteend), (intptr_t)setJSFileWriterOnwriteend, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileWriterTable = { 33, 31, JSFileWriterTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSFileWriterPrototypeTableValues[] =
{
    { "INIT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterINIT), (intptr_t)0, NoIntrinsic },
    { "WRITING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterWRITING), (intptr_t)0, NoIntrinsic },
    { "DONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileWriterDONE), (intptr_t)0, NoIntrinsic },
    { "write", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionWrite), (intptr_t)1, NoIntrinsic },
    { "seek", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionSeek), (intptr_t)1, NoIntrinsic },
    { "truncate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionTruncate), (intptr_t)1, NoIntrinsic },
    { "abort", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionAbort), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileWriterPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileWriterPrototypeTable = { 33, 31, JSFileWriterPrototypeTableValues, 0 };
static const HashTable* getJSFileWriterPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileWriterPrototypeTable);
}

const ClassInfo JSFileWriterPrototype::s_info = { "FileWriterPrototype", &Base::s_info, 0, getJSFileWriterPrototypeTable, CREATE_METHOD_TABLE(JSFileWriterPrototype) };

JSObject* JSFileWriterPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileWriter>(exec, globalObject);
}

bool JSFileWriterPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileWriterPrototype* thisObject = jsCast<JSFileWriterPrototype*>(cell);
    return getStaticPropertySlot<JSFileWriterPrototype, JSObject>(exec, getJSFileWriterPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFileWriterPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileWriterPrototype* thisObject = jsCast<JSFileWriterPrototype*>(object);
    return getStaticPropertyDescriptor<JSFileWriterPrototype, JSObject>(exec, getJSFileWriterPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSFileWriterTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileWriterTable);
}

const ClassInfo JSFileWriter::s_info = { "FileWriter", &Base::s_info, 0, getJSFileWriterTable , CREATE_METHOD_TABLE(JSFileWriter) };

JSFileWriter::JSFileWriter(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileWriter> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSFileWriter::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileWriter::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileWriterPrototype::create(exec->vm(), globalObject, JSFileWriterPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSFileWriter::destroy(JSC::JSCell* cell)
{
    JSFileWriter* thisObject = static_cast<JSFileWriter*>(cell);
    thisObject->JSFileWriter::~JSFileWriter();
}

JSFileWriter::~JSFileWriter()
{
    releaseImplIfNotNull();
}

bool JSFileWriter::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileWriter* thisObject = jsCast<JSFileWriter*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSFileWriter, Base>(exec, getJSFileWriterTable(exec), thisObject, propertyName, slot);
}

bool JSFileWriter::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileWriter* thisObject = jsCast<JSFileWriter*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSFileWriter, Base>(exec, getJSFileWriterTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsFileWriterReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    JSValue result = jsNumber(impl->readyState());
    return result;
}


JSValue jsFileWriterError(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->error()));
    return result;
}


JSValue jsFileWriterPosition(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    JSValue result = jsNumber(impl->position());
    return result;
}


JSValue jsFileWriterLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsFileWriterOnwritestart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (EventListener* listener = impl->onwritestart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileWriterOnprogress(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (EventListener* listener = impl->onprogress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileWriterOnwrite(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (EventListener* listener = impl->onwrite()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileWriterOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileWriterOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileWriterOnwriteend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (EventListener* listener = impl->onwriteend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


void JSFileWriter::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSFileWriter* thisObject = jsCast<JSFileWriter*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSFileWriter, Base>(exec, propertyName, value, getJSFileWriterTable(exec), thisObject, slot);
}

void setJSFileWriterOnwritestart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(thisObject);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    impl->setOnwritestart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileWriterOnprogress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(thisObject);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    impl->setOnprogress(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileWriterOnwrite(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(thisObject);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    impl->setOnwrite(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileWriterOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(thisObject);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    impl->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileWriterOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(thisObject);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileWriterOnwriteend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(thisObject);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    impl->setOnwriteend(createJSAttributeEventListener(exec, value, thisObject));
}


EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionWrite(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Blob* data(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->write(data, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionSeek(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    long long position(toInt64(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->seek(position, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionTruncate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    long long size(toInt64(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->truncate(size, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionAbort(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->abort(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileWriterPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileWriter::s_info))
        return throwVMTypeError(exec);
    JSFileWriter* castedThis = jsCast<JSFileWriter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileWriter::s_info);
    FileWriter* impl = static_cast<FileWriter*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSFileWriter::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSFileWriter* thisObject = jsCast<JSFileWriter*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

// Constant getters

JSValue jsFileWriterINIT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsFileWriterWRITING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsFileWriterDONE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSFileWriter* jsFileWriter)
{
    if (jsFileWriter->hasCustomProperties())
        return true;
    if (jsFileWriter->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSFileWriterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSFileWriter* jsFileWriter = jsCast<JSFileWriter*>(handle.get().asCell());
    if (jsFileWriter->impl()->hasPendingActivity())
        return true;
    if (jsFileWriter->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsFileWriter))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSFileWriterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSFileWriter* jsFileWriter = jsCast<JSFileWriter*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileWriter->impl(), jsFileWriter);
    jsFileWriter->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileWriter@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10FileWriterE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileWriter* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFileWriter>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FileWriter@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10FileWriterE[2];
#if COMPILER(CLANG)
    // If this fails FileWriter does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FileWriter), FileWriter_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FileWriter has subclasses. If FileWriter has subclasses that get passed
    // to toJS() we currently require FileWriter you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<FileWriter>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSFileWriter>(exec, globalObject, impl);
}

FileWriter* toFileWriter(JSC::JSValue value)
{
    return value.inherits(&JSFileWriter::s_info) ? jsCast<JSFileWriter*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
