/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(BLOB)

#include "JSFileReader.h"

#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "FileError.h"
#include "FileReader.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSFileError.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFileReaderTableValues[] =
{
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderReadyState), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderResult), (intptr_t)0, NoIntrinsic },
    { "error", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderError), (intptr_t)0, NoIntrinsic },
    { "onloadstart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnloadstart), (intptr_t)setJSFileReaderOnloadstart, NoIntrinsic },
    { "onprogress", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnprogress), (intptr_t)setJSFileReaderOnprogress, NoIntrinsic },
    { "onload", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnload), (intptr_t)setJSFileReaderOnload, NoIntrinsic },
    { "onabort", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnabort), (intptr_t)setJSFileReaderOnabort, NoIntrinsic },
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnerror), (intptr_t)setJSFileReaderOnerror, NoIntrinsic },
    { "onloadend", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderOnloadend), (intptr_t)setJSFileReaderOnloadend, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileReaderTable = { 34, 31, JSFileReaderTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSFileReaderConstructorTableValues[] =
{
    { "EMPTY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderEMPTY), (intptr_t)0, NoIntrinsic },
    { "LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderLOADING), (intptr_t)0, NoIntrinsic },
    { "DONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderDONE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileReaderConstructorTable = { 9, 7, JSFileReaderConstructorTableValues, 0 };

COMPILE_ASSERT(0 == FileReader::EMPTY, FileReaderEnumEMPTYIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == FileReader::LOADING, FileReaderEnumLOADINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == FileReader::DONE, FileReaderEnumDONEIsWrongUseDoNotCheckConstants);

EncodedJSValue JSC_HOST_CALL JSFileReaderConstructor::constructJSFileReader(ExecState* exec)
{
    JSFileReaderConstructor* castedThis = jsCast<JSFileReaderConstructor*>(exec->callee());
    ScriptExecutionContext* context = castedThis->scriptExecutionContext();
    if (!context)
        return throwVMError(exec, createReferenceError(exec, "FileReader constructor associated document is unavailable"));
    RefPtr<FileReader> object = FileReader::create(context);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

static const HashTable* getJSFileReaderConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileReaderConstructorTable);
}

const ClassInfo JSFileReaderConstructor::s_info = { "FileReaderConstructor", &Base::s_info, 0, getJSFileReaderConstructorTable, CREATE_METHOD_TABLE(JSFileReaderConstructor) };

JSFileReaderConstructor::JSFileReaderConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFileReaderConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSFileReaderPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSFileReaderConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileReaderConstructor, JSDOMWrapper>(exec, getJSFileReaderConstructorTable(exec), jsCast<JSFileReaderConstructor*>(cell), propertyName, slot);
}

bool JSFileReaderConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileReaderConstructor, JSDOMWrapper>(exec, getJSFileReaderConstructorTable(exec), jsCast<JSFileReaderConstructor*>(object), propertyName, descriptor);
}

ConstructType JSFileReaderConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSFileReader;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSFileReaderPrototypeTableValues[] =
{
    { "EMPTY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderEMPTY), (intptr_t)0, NoIntrinsic },
    { "LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderLOADING), (intptr_t)0, NoIntrinsic },
    { "DONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileReaderDONE), (intptr_t)0, NoIntrinsic },
    { "readAsArrayBuffer", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsArrayBuffer), (intptr_t)1, NoIntrinsic },
    { "readAsBinaryString", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsBinaryString), (intptr_t)1, NoIntrinsic },
    { "readAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsText), (intptr_t)1, NoIntrinsic },
    { "readAsDataURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionReadAsDataURL), (intptr_t)1, NoIntrinsic },
    { "abort", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionAbort), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileReaderPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileReaderPrototypeTable = { 35, 31, JSFileReaderPrototypeTableValues, 0 };
static const HashTable* getJSFileReaderPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileReaderPrototypeTable);
}

const ClassInfo JSFileReaderPrototype::s_info = { "FileReaderPrototype", &Base::s_info, 0, getJSFileReaderPrototypeTable, CREATE_METHOD_TABLE(JSFileReaderPrototype) };

JSObject* JSFileReaderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileReader>(exec, globalObject);
}

bool JSFileReaderPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileReaderPrototype* thisObject = jsCast<JSFileReaderPrototype*>(cell);
    return getStaticPropertySlot<JSFileReaderPrototype, JSObject>(exec, getJSFileReaderPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFileReaderPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileReaderPrototype* thisObject = jsCast<JSFileReaderPrototype*>(object);
    return getStaticPropertyDescriptor<JSFileReaderPrototype, JSObject>(exec, getJSFileReaderPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSFileReaderTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileReaderTable);
}

const ClassInfo JSFileReader::s_info = { "FileReader", &Base::s_info, 0, getJSFileReaderTable , CREATE_METHOD_TABLE(JSFileReader) };

JSFileReader::JSFileReader(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileReader> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSFileReader::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileReader::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileReaderPrototype::create(exec->vm(), globalObject, JSFileReaderPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSFileReader::destroy(JSC::JSCell* cell)
{
    JSFileReader* thisObject = static_cast<JSFileReader*>(cell);
    thisObject->JSFileReader::~JSFileReader();
}

JSFileReader::~JSFileReader()
{
    releaseImplIfNotNull();
}

bool JSFileReader::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileReader* thisObject = jsCast<JSFileReader*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSFileReader, Base>(exec, getJSFileReaderTable(exec), thisObject, propertyName, slot);
}

bool JSFileReader::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileReader* thisObject = jsCast<JSFileReader*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSFileReader, Base>(exec, getJSFileReaderTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsFileReaderReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    JSValue result = jsNumber(impl->readyState());
    return result;
}


JSValue jsFileReaderResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    return castedThis->result(exec);
}


JSValue jsFileReaderError(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->error()));
    return result;
}


JSValue jsFileReaderOnloadstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = impl->onloadstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileReaderOnprogress(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = impl->onprogress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileReaderOnload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = impl->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileReaderOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileReaderOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileReaderOnloadend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (EventListener* listener = impl->onloadend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsFileReaderConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileReader* domObject = jsCast<JSFileReader*>(asObject(slotBase));
    return JSFileReader::getConstructor(exec, domObject->globalObject());
}

void JSFileReader::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSFileReader* thisObject = jsCast<JSFileReader*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSFileReader, Base>(exec, propertyName, value, getJSFileReaderTable(exec), thisObject, slot);
}

void setJSFileReaderOnloadstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(thisObject);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->setOnloadstart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileReaderOnprogress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(thisObject);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->setOnprogress(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileReaderOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(thisObject);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileReaderOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(thisObject);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileReaderOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(thisObject);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSFileReaderOnloadend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(thisObject);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->setOnloadend(createJSAttributeEventListener(exec, value, thisObject));
}


JSValue JSFileReader::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileReaderConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsArrayBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->readAsArrayBuffer(blob, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsBinaryString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->readAsBinaryString(blob, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->readAsText(blob, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    const String& encoding(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->readAsText(blob, encoding, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionReadAsDataURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Blob* blob(toBlob(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->readAsDataURL(blob, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionAbort(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    impl->abort();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsFileReaderPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileReader::s_info))
        return throwVMTypeError(exec);
    JSFileReader* castedThis = jsCast<JSFileReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileReader::s_info);
    FileReader* impl = static_cast<FileReader*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSFileReader::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSFileReader* thisObject = jsCast<JSFileReader*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

// Constant getters

JSValue jsFileReaderEMPTY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsFileReaderLOADING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsFileReaderDONE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSFileReader* jsFileReader)
{
    if (jsFileReader->hasCustomProperties())
        return true;
    if (jsFileReader->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSFileReaderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSFileReader* jsFileReader = jsCast<JSFileReader*>(handle.get().asCell());
    if (jsFileReader->impl()->hasPendingActivity())
        return true;
    if (jsFileReader->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsFileReader))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSFileReaderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSFileReader* jsFileReader = jsCast<JSFileReader*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileReader->impl(), jsFileReader);
    jsFileReader->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileReader@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10FileReaderE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileReader* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFileReader>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FileReader@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10FileReaderE[2];
#if COMPILER(CLANG)
    // If this fails FileReader does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FileReader), FileReader_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FileReader has subclasses. If FileReader has subclasses that get passed
    // to toJS() we currently require FileReader you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<FileReader>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSFileReader>(exec, globalObject, impl);
}

FileReader* toFileReader(JSC::JSValue value)
{
    return value.inherits(&JSFileReader::s_info) ? jsCast<JSFileReader*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(BLOB)
