/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSFileEntrySync.h"

#include "ExceptionCode.h"
#include "File.h"
#include "FileEntrySync.h"
#include "FileWriterSync.h"
#include "JSDOMBinding.h"
#include "JSFile.h"
#include "JSFileWriterSync.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSFileEntrySyncPrototypeTableValues[] =
{
    { "file", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileEntrySyncPrototypeFunctionFile), (intptr_t)0, NoIntrinsic },
    { "createWriter", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileEntrySyncPrototypeFunctionCreateWriter), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileEntrySyncPrototypeTable = { 5, 3, JSFileEntrySyncPrototypeTableValues, 0 };
static const HashTable* getJSFileEntrySyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSFileEntrySyncPrototypeTable);
}

const ClassInfo JSFileEntrySyncPrototype::s_info = { "FileEntrySyncPrototype", &Base::s_info, 0, getJSFileEntrySyncPrototypeTable, CREATE_METHOD_TABLE(JSFileEntrySyncPrototype) };

JSObject* JSFileEntrySyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileEntrySync>(exec, globalObject);
}

bool JSFileEntrySyncPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileEntrySyncPrototype* thisObject = jsCast<JSFileEntrySyncPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSFileEntrySyncPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFileEntrySyncPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileEntrySyncPrototype* thisObject = jsCast<JSFileEntrySyncPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSFileEntrySyncPrototypeTable(exec), thisObject, propertyName, descriptor);
}

const ClassInfo JSFileEntrySync::s_info = { "FileEntrySync", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSFileEntrySync) };

JSFileEntrySync::JSFileEntrySync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileEntrySync> impl)
    : JSEntrySync(structure, globalObject, impl)
{
}

void JSFileEntrySync::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileEntrySync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileEntrySyncPrototype::create(exec->vm(), globalObject, JSFileEntrySyncPrototype::createStructure(exec->vm(), globalObject, JSEntrySyncPrototype::self(exec, globalObject)));
}

EncodedJSValue JSC_HOST_CALL jsFileEntrySyncPrototypeFunctionFile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileEntrySync::s_info))
        return throwVMTypeError(exec);
    JSFileEntrySync* castedThis = jsCast<JSFileEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileEntrySync::s_info);
    FileEntrySync* impl = static_cast<FileEntrySync*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->file(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsFileEntrySyncPrototypeFunctionCreateWriter(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileEntrySync::s_info))
        return throwVMTypeError(exec);
    JSFileEntrySync* castedThis = jsCast<JSFileEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileEntrySync::s_info);
    FileEntrySync* impl = static_cast<FileEntrySync*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createWriter(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileEntrySync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13FileEntrySyncE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileEntrySync* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSFileEntrySync>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7FileEntrySync@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13FileEntrySyncE[2];
#if COMPILER(CLANG)
    // If this fails FileEntrySync does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(FileEntrySync), FileEntrySync_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // FileEntrySync has subclasses. If FileEntrySync has subclasses that get passed
    // to toJS() we currently require FileEntrySync you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<FileEntrySync>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSFileEntrySync>(exec, globalObject, impl);
}

FileEntrySync* toFileEntrySync(JSC::JSValue value)
{
    return value.inherits(&JSFileEntrySync::s_info) ? jsCast<JSFileEntrySync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
