/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSEntrySync_h
#define JSEntrySync_h

#if ENABLE(FILE_SYSTEM)

#include "EntrySync.h"
#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSEntrySync : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSEntrySync* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EntrySync> impl)
    {
        JSEntrySync* ptr = new (NotNull, JSC::allocateCell<JSEntrySync>(globalObject->vm().heap)) JSEntrySync(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void destroy(JSC::JSCell*);
    ~JSEntrySync();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    EntrySync* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    EntrySync* m_impl;
protected:
    JSEntrySync(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<EntrySync>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};

class JSEntrySyncOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, EntrySync*)
{
    DEFINE_STATIC_LOCAL(JSEntrySyncOwner, jsEntrySyncOwner, ());
    return &jsEntrySyncOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, EntrySync*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, EntrySync*);
EntrySync* toEntrySync(JSC::JSValue);

class JSEntrySyncPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSEntrySyncPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEntrySyncPrototype* ptr = new (NotNull, JSC::allocateCell<JSEntrySyncPrototype>(vm.heap)) JSEntrySyncPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSEntrySyncPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionGetMetadata(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionMoveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionCopyTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionToURL(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionRemove(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionGetParent(JSC::ExecState*);
// Attributes

JSC::JSValue jsEntrySyncIsFile(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsEntrySyncIsDirectory(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsEntrySyncName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsEntrySyncFullPath(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsEntrySyncFilesystem(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(FILE_SYSTEM)

#endif
