/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSEntrySync.h"

#include "DOMFileSystemSync.h"
#include "DirectoryEntrySync.h"
#include "EntrySync.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMFileSystemSync.h"
#include "JSDirectoryEntrySync.h"
#include "JSEntrySync.h"
#include "JSMetadata.h"
#include "KURL.h"
#include "Metadata.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEntrySyncTableValues[] =
{
    { "isFile", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntrySyncIsFile), (intptr_t)0, NoIntrinsic },
    { "isDirectory", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntrySyncIsDirectory), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntrySyncName), (intptr_t)0, NoIntrinsic },
    { "fullPath", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntrySyncFullPath), (intptr_t)0, NoIntrinsic },
    { "filesystem", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntrySyncFilesystem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntrySyncTable = { 16, 15, JSEntrySyncTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSEntrySyncPrototypeTableValues[] =
{
    { "getMetadata", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntrySyncPrototypeFunctionGetMetadata), (intptr_t)0, NoIntrinsic },
    { "moveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntrySyncPrototypeFunctionMoveTo), (intptr_t)2, NoIntrinsic },
    { "copyTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntrySyncPrototypeFunctionCopyTo), (intptr_t)2, NoIntrinsic },
    { "toURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntrySyncPrototypeFunctionToURL), (intptr_t)0, NoIntrinsic },
    { "remove", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntrySyncPrototypeFunctionRemove), (intptr_t)0, NoIntrinsic },
    { "getParent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntrySyncPrototypeFunctionGetParent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntrySyncPrototypeTable = { 17, 15, JSEntrySyncPrototypeTableValues, 0 };
static const HashTable* getJSEntrySyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEntrySyncPrototypeTable);
}

const ClassInfo JSEntrySyncPrototype::s_info = { "EntrySyncPrototype", &Base::s_info, 0, getJSEntrySyncPrototypeTable, CREATE_METHOD_TABLE(JSEntrySyncPrototype) };

JSObject* JSEntrySyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntrySync>(exec, globalObject);
}

bool JSEntrySyncPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntrySyncPrototype* thisObject = jsCast<JSEntrySyncPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSEntrySyncPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSEntrySyncPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntrySyncPrototype* thisObject = jsCast<JSEntrySyncPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSEntrySyncPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSEntrySyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEntrySyncTable);
}

const ClassInfo JSEntrySync::s_info = { "EntrySync", &Base::s_info, 0, getJSEntrySyncTable , CREATE_METHOD_TABLE(JSEntrySync) };

JSEntrySync::JSEntrySync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EntrySync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSEntrySync::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSEntrySync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEntrySyncPrototype::create(exec->vm(), globalObject, JSEntrySyncPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSEntrySync::destroy(JSC::JSCell* cell)
{
    JSEntrySync* thisObject = static_cast<JSEntrySync*>(cell);
    thisObject->JSEntrySync::~JSEntrySync();
}

JSEntrySync::~JSEntrySync()
{
    releaseImplIfNotNull();
}

bool JSEntrySync::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntrySync* thisObject = jsCast<JSEntrySync*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSEntrySync, Base>(exec, getJSEntrySyncTable(exec), thisObject, propertyName, slot);
}

bool JSEntrySync::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntrySync* thisObject = jsCast<JSEntrySync*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSEntrySync, Base>(exec, getJSEntrySyncTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsEntrySyncIsFile(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isFile());
    return result;
}


JSValue jsEntrySyncIsDirectory(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isDirectory());
    return result;
}


JSValue jsEntrySyncName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsEntrySyncFullPath(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fullPath());
    return result;
}


JSValue jsEntrySyncFilesystem(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->filesystem()));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionGetMetadata(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntrySync::s_info))
        return throwVMTypeError(exec);
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntrySync::s_info);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getMetadata(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionMoveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntrySync::s_info))
        return throwVMTypeError(exec);
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntrySync::s_info);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    DirectoryEntrySync* parent(toDirectoryEntrySync(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& name(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->moveTo(parent, name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionCopyTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntrySync::s_info))
        return throwVMTypeError(exec);
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntrySync::s_info);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    DirectoryEntrySync* parent(toDirectoryEntrySync(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& name(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->copyTo(parent, name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionToURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntrySync::s_info))
        return throwVMTypeError(exec);
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntrySync::s_info);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->toURL());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntrySync::s_info))
        return throwVMTypeError(exec);
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntrySync::s_info);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->remove(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEntrySyncPrototypeFunctionGetParent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntrySync::s_info))
        return throwVMTypeError(exec);
    JSEntrySync* castedThis = jsCast<JSEntrySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntrySync::s_info);
    EntrySync* impl = static_cast<EntrySync*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getParent()));
    return JSValue::encode(result);
}

static inline bool isObservable(JSEntrySync* jsEntrySync)
{
    if (jsEntrySync->hasCustomProperties())
        return true;
    return false;
}

bool JSEntrySyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSEntrySync* jsEntrySync = jsCast<JSEntrySync*>(handle.get().asCell());
    if (!isObservable(jsEntrySync))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEntrySyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSEntrySync* jsEntrySync = jsCast<JSEntrySync*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEntrySync->impl(), jsEntrySync);
    jsEntrySync->releaseImpl();
}

EntrySync* toEntrySync(JSC::JSValue value)
{
    return value.inherits(&JSEntrySync::s_info) ? jsCast<JSEntrySync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
