/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSEntryArraySync.h"

#include "EntryArraySync.h"
#include "EntrySync.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEntrySync.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEntryArraySyncTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryArraySyncLength), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntryArraySyncTable = { 2, 1, JSEntryArraySyncTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSEntryArraySyncPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntryArraySyncPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntryArraySyncPrototypeTable = { 2, 1, JSEntryArraySyncPrototypeTableValues, 0 };
static const HashTable* getJSEntryArraySyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEntryArraySyncPrototypeTable);
}

const ClassInfo JSEntryArraySyncPrototype::s_info = { "EntryArraySyncPrototype", &Base::s_info, 0, getJSEntryArraySyncPrototypeTable, CREATE_METHOD_TABLE(JSEntryArraySyncPrototype) };

JSObject* JSEntryArraySyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntryArraySync>(exec, globalObject);
}

bool JSEntryArraySyncPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntryArraySyncPrototype* thisObject = jsCast<JSEntryArraySyncPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSEntryArraySyncPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSEntryArraySyncPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntryArraySyncPrototype* thisObject = jsCast<JSEntryArraySyncPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSEntryArraySyncPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSEntryArraySyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEntryArraySyncTable);
}

const ClassInfo JSEntryArraySync::s_info = { "EntryArraySync", &Base::s_info, 0, getJSEntryArraySyncTable , CREATE_METHOD_TABLE(JSEntryArraySync) };

JSEntryArraySync::JSEntryArraySync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EntryArraySync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSEntryArraySync::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSEntryArraySync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEntryArraySyncPrototype::create(exec->vm(), globalObject, JSEntryArraySyncPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSEntryArraySync::destroy(JSC::JSCell* cell)
{
    JSEntryArraySync* thisObject = static_cast<JSEntryArraySync*>(cell);
    thisObject->JSEntryArraySync::~JSEntryArraySync();
}

JSEntryArraySync::~JSEntryArraySync()
{
    releaseImplIfNotNull();
}

bool JSEntryArraySync::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntryArraySync* thisObject = jsCast<JSEntryArraySync*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSEntryArraySync>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<EntryArraySync*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSEntryArraySync, Base>(exec, getJSEntryArraySyncTable(exec), thisObject, propertyName, slot);
}

bool JSEntryArraySync::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntryArraySync* thisObject = jsCast<JSEntryArraySync*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSEntryArraySyncTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<EntryArraySync*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSEntryArraySync, Base>(exec, getJSEntryArraySyncTable(exec), thisObject, propertyName, descriptor);
}

bool JSEntryArraySync::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSEntryArraySync* thisObject = jsCast<JSEntryArraySync*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<EntryArraySync*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsEntryArraySyncLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntryArraySync* castedThis = jsCast<JSEntryArraySync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntryArraySync* impl = static_cast<EntryArraySync*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


void JSEntryArraySync::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSEntryArraySync* thisObject = jsCast<JSEntryArraySync*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<EntryArraySync*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

EncodedJSValue JSC_HOST_CALL jsEntryArraySyncPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntryArraySync::s_info))
        return throwVMTypeError(exec);
    JSEntryArraySync* castedThis = jsCast<JSEntryArraySync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntryArraySync::s_info);
    EntryArraySync* impl = static_cast<EntryArraySync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSEntryArraySync::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSEntryArraySync* thisObj = jsCast<JSEntryArraySync*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<EntryArraySync*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSEntryArraySync* jsEntryArraySync)
{
    if (jsEntryArraySync->hasCustomProperties())
        return true;
    return false;
}

bool JSEntryArraySyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSEntryArraySync* jsEntryArraySync = jsCast<JSEntryArraySync*>(handle.get().asCell());
    if (!isObservable(jsEntryArraySync))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEntryArraySyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSEntryArraySync* jsEntryArraySync = jsCast<JSEntryArraySync*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEntryArraySync->impl(), jsEntryArraySync);
    jsEntryArraySync->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, EntryArraySync* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEntryArraySync>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to EntryArraySync.
    COMPILE_ASSERT(!__is_polymorphic(EntryArraySync), EntryArraySync_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<EntryArraySync>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSEntryArraySync>(exec, globalObject, impl);
}

EntryArraySync* toEntryArraySync(JSC::JSValue value)
{
    return value.inherits(&JSEntryArraySync::s_info) ? jsCast<JSEntryArraySync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
