/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSEntryArray.h"

#include "Entry.h"
#include "EntryArray.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEntry.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEntryArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntryArrayLength), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntryArrayTable = { 2, 1, JSEntryArrayTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSEntryArrayPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEntryArrayPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntryArrayPrototypeTable = { 2, 1, JSEntryArrayPrototypeTableValues, 0 };
static const HashTable* getJSEntryArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEntryArrayPrototypeTable);
}

const ClassInfo JSEntryArrayPrototype::s_info = { "EntryArrayPrototype", &Base::s_info, 0, getJSEntryArrayPrototypeTable, CREATE_METHOD_TABLE(JSEntryArrayPrototype) };

JSObject* JSEntryArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntryArray>(exec, globalObject);
}

bool JSEntryArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntryArrayPrototype* thisObject = jsCast<JSEntryArrayPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSEntryArrayPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSEntryArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntryArrayPrototype* thisObject = jsCast<JSEntryArrayPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSEntryArrayPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSEntryArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSEntryArrayTable);
}

const ClassInfo JSEntryArray::s_info = { "EntryArray", &Base::s_info, 0, getJSEntryArrayTable , CREATE_METHOD_TABLE(JSEntryArray) };

JSEntryArray::JSEntryArray(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EntryArray> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSEntryArray::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSEntryArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEntryArrayPrototype::create(exec->vm(), globalObject, JSEntryArrayPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSEntryArray::destroy(JSC::JSCell* cell)
{
    JSEntryArray* thisObject = static_cast<JSEntryArray*>(cell);
    thisObject->JSEntryArray::~JSEntryArray();
}

JSEntryArray::~JSEntryArray()
{
    releaseImplIfNotNull();
}

bool JSEntryArray::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntryArray* thisObject = jsCast<JSEntryArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSEntryArray>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<EntryArray*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSEntryArray, Base>(exec, getJSEntryArrayTable(exec), thisObject, propertyName, slot);
}

bool JSEntryArray::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntryArray* thisObject = jsCast<JSEntryArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSEntryArrayTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<EntryArray*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSEntryArray, Base>(exec, getJSEntryArrayTable(exec), thisObject, propertyName, descriptor);
}

bool JSEntryArray::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSEntryArray* thisObject = jsCast<JSEntryArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<EntryArray*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsEntryArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntryArray* castedThis = jsCast<JSEntryArray*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    EntryArray* impl = static_cast<EntryArray*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


void JSEntryArray::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSEntryArray* thisObject = jsCast<JSEntryArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<EntryArray*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

EncodedJSValue JSC_HOST_CALL jsEntryArrayPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEntryArray::s_info))
        return throwVMTypeError(exec);
    JSEntryArray* castedThis = jsCast<JSEntryArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEntryArray::s_info);
    EntryArray* impl = static_cast<EntryArray*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    int index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSEntryArray::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSEntryArray* thisObj = jsCast<JSEntryArray*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<EntryArray*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSEntryArray* jsEntryArray)
{
    if (jsEntryArray->hasCustomProperties())
        return true;
    return false;
}

bool JSEntryArrayOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSEntryArray* jsEntryArray = jsCast<JSEntryArray*>(handle.get().asCell());
    if (!isObservable(jsEntryArray))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEntryArrayOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSEntryArray* jsEntryArray = jsCast<JSEntryArray*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEntryArray->impl(), jsEntryArray);
    jsEntryArray->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, EntryArray* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSEntryArray>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to EntryArray.
    COMPILE_ASSERT(!__is_polymorphic(EntryArray), EntryArray_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<EntryArray>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSEntryArray>(exec, globalObject, impl);
}

EntryArray* toEntryArray(JSC::JSValue value)
{
    return value.inherits(&JSEntryArray::s_info) ? jsCast<JSEntryArray*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
