/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSElementTimeControl.h"

#include "ElementTimeControl.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSElementTimeControlPrototypeTableValues[] =
{
    { "beginElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementTimeControlPrototypeFunctionBeginElement), (intptr_t)0, NoIntrinsic },
    { "beginElementAt", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementTimeControlPrototypeFunctionBeginElementAt), (intptr_t)0, NoIntrinsic },
    { "endElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementTimeControlPrototypeFunctionEndElement), (intptr_t)0, NoIntrinsic },
    { "endElementAt", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsElementTimeControlPrototypeFunctionEndElementAt), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSElementTimeControlPrototypeTable = { 9, 7, JSElementTimeControlPrototypeTableValues, 0 };
const ClassInfo JSElementTimeControlPrototype::s_info = { "ElementTimeControlPrototype", &Base::s_info, &JSElementTimeControlPrototypeTable, 0, CREATE_METHOD_TABLE(JSElementTimeControlPrototype) };

JSObject* JSElementTimeControlPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSElementTimeControl>(exec, globalObject);
}

bool JSElementTimeControlPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSElementTimeControlPrototype* thisObject = jsCast<JSElementTimeControlPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSElementTimeControlPrototypeTable, thisObject, propertyName, slot);
}

bool JSElementTimeControlPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSElementTimeControlPrototype* thisObject = jsCast<JSElementTimeControlPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSElementTimeControlPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSElementTimeControl::s_info = { "ElementTimeControl", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSElementTimeControl) };

JSElementTimeControl::JSElementTimeControl(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ElementTimeControl> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSElementTimeControl::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSElementTimeControl::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSElementTimeControlPrototype::create(exec->vm(), globalObject, JSElementTimeControlPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSElementTimeControl::destroy(JSC::JSCell* cell)
{
    JSElementTimeControl* thisObject = static_cast<JSElementTimeControl*>(cell);
    thisObject->JSElementTimeControl::~JSElementTimeControl();
}

JSElementTimeControl::~JSElementTimeControl()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionBeginElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwVMTypeError(exec);
    JSElementTimeControl* castedThis = jsCast<JSElementTimeControl*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElementTimeControl::s_info);
    ElementTimeControl* impl = static_cast<ElementTimeControl*>(castedThis->impl());
    impl->beginElement();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionBeginElementAt(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwVMTypeError(exec);
    JSElementTimeControl* castedThis = jsCast<JSElementTimeControl*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElementTimeControl::s_info);
    ElementTimeControl* impl = static_cast<ElementTimeControl*>(castedThis->impl());
    float offset(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->beginElementAt(offset);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionEndElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwVMTypeError(exec);
    JSElementTimeControl* castedThis = jsCast<JSElementTimeControl*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElementTimeControl::s_info);
    ElementTimeControl* impl = static_cast<ElementTimeControl*>(castedThis->impl());
    impl->endElement();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionEndElementAt(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwVMTypeError(exec);
    JSElementTimeControl* castedThis = jsCast<JSElementTimeControl*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSElementTimeControl::s_info);
    ElementTimeControl* impl = static_cast<ElementTimeControl*>(castedThis->impl());
    float offset(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->endElementAt(offset);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSElementTimeControl* jsElementTimeControl)
{
    if (jsElementTimeControl->hasCustomProperties())
        return true;
    return false;
}

bool JSElementTimeControlOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSElementTimeControl* jsElementTimeControl = jsCast<JSElementTimeControl*>(handle.get().asCell());
    if (!isObservable(jsElementTimeControl))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSElementTimeControlOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSElementTimeControl* jsElementTimeControl = jsCast<JSElementTimeControl*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsElementTimeControl->impl(), jsElementTimeControl);
    jsElementTimeControl->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ElementTimeControl@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18ElementTimeControlE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ElementTimeControl* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSElementTimeControl>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ElementTimeControl@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore18ElementTimeControlE[2];
#if COMPILER(CLANG)
    // If this fails ElementTimeControl does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ElementTimeControl), ElementTimeControl_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ElementTimeControl has subclasses. If ElementTimeControl has subclasses that get passed
    // to toJS() we currently require ElementTimeControl you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<ElementTimeControl>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSElementTimeControl>(exec, globalObject, impl);
}

ElementTimeControl* toElementTimeControl(JSC::JSValue value)
{
    return value.inherits(&JSElementTimeControl::s_info) ? jsCast<JSElementTimeControl*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
