/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSDynamicsCompressorNode.h"

#include "AudioParam.h"
#include "DynamicsCompressorNode.h"
#include "JSAudioParam.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDynamicsCompressorNodeTableValues[] =
{
    { "threshold", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeThreshold), (intptr_t)0, NoIntrinsic },
    { "knee", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeKnee), (intptr_t)0, NoIntrinsic },
    { "ratio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeRatio), (intptr_t)0, NoIntrinsic },
    { "reduction", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeReduction), (intptr_t)0, NoIntrinsic },
    { "attack", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeAttack), (intptr_t)0, NoIntrinsic },
    { "release", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeRelease), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDynamicsCompressorNodeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDynamicsCompressorNodeTable = { 17, 15, JSDynamicsCompressorNodeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDynamicsCompressorNodeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDynamicsCompressorNodeConstructorTable = { 1, 0, JSDynamicsCompressorNodeConstructorTableValues, 0 };
const ClassInfo JSDynamicsCompressorNodeConstructor::s_info = { "DynamicsCompressorNodeConstructor", &Base::s_info, &JSDynamicsCompressorNodeConstructorTable, 0, CREATE_METHOD_TABLE(JSDynamicsCompressorNodeConstructor) };

JSDynamicsCompressorNodeConstructor::JSDynamicsCompressorNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDynamicsCompressorNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDynamicsCompressorNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDynamicsCompressorNodeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDynamicsCompressorNodeConstructor, JSDOMWrapper>(exec, &JSDynamicsCompressorNodeConstructorTable, jsCast<JSDynamicsCompressorNodeConstructor*>(cell), propertyName, slot);
}

bool JSDynamicsCompressorNodeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDynamicsCompressorNodeConstructor, JSDOMWrapper>(exec, &JSDynamicsCompressorNodeConstructorTable, jsCast<JSDynamicsCompressorNodeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDynamicsCompressorNodePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDynamicsCompressorNodePrototypeTable = { 1, 0, JSDynamicsCompressorNodePrototypeTableValues, 0 };
const ClassInfo JSDynamicsCompressorNodePrototype::s_info = { "DynamicsCompressorNodePrototype", &Base::s_info, &JSDynamicsCompressorNodePrototypeTable, 0, CREATE_METHOD_TABLE(JSDynamicsCompressorNodePrototype) };

JSObject* JSDynamicsCompressorNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDynamicsCompressorNode>(exec, globalObject);
}

const ClassInfo JSDynamicsCompressorNode::s_info = { "DynamicsCompressorNode", &Base::s_info, &JSDynamicsCompressorNodeTable, 0 , CREATE_METHOD_TABLE(JSDynamicsCompressorNode) };

JSDynamicsCompressorNode::JSDynamicsCompressorNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DynamicsCompressorNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSDynamicsCompressorNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDynamicsCompressorNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDynamicsCompressorNodePrototype::create(exec->vm(), globalObject, JSDynamicsCompressorNodePrototype::createStructure(exec->vm(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSDynamicsCompressorNode::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDynamicsCompressorNode* thisObject = jsCast<JSDynamicsCompressorNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDynamicsCompressorNode, Base>(exec, &JSDynamicsCompressorNodeTable, thisObject, propertyName, slot);
}

bool JSDynamicsCompressorNode::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDynamicsCompressorNode* thisObject = jsCast<JSDynamicsCompressorNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDynamicsCompressorNode, Base>(exec, &JSDynamicsCompressorNodeTable, thisObject, propertyName, descriptor);
}

JSValue jsDynamicsCompressorNodeThreshold(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* castedThis = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DynamicsCompressorNode* impl = static_cast<DynamicsCompressorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->threshold()));
    return result;
}


JSValue jsDynamicsCompressorNodeKnee(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* castedThis = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DynamicsCompressorNode* impl = static_cast<DynamicsCompressorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->knee()));
    return result;
}


JSValue jsDynamicsCompressorNodeRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* castedThis = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DynamicsCompressorNode* impl = static_cast<DynamicsCompressorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->ratio()));
    return result;
}


JSValue jsDynamicsCompressorNodeReduction(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* castedThis = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DynamicsCompressorNode* impl = static_cast<DynamicsCompressorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->reduction()));
    return result;
}


JSValue jsDynamicsCompressorNodeAttack(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* castedThis = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DynamicsCompressorNode* impl = static_cast<DynamicsCompressorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->attack()));
    return result;
}


JSValue jsDynamicsCompressorNodeRelease(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* castedThis = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DynamicsCompressorNode* impl = static_cast<DynamicsCompressorNode*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->release()));
    return result;
}


JSValue jsDynamicsCompressorNodeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDynamicsCompressorNode* domObject = jsCast<JSDynamicsCompressorNode*>(asObject(slotBase));
    return JSDynamicsCompressorNode::getConstructor(exec, domObject->globalObject());
}

JSValue JSDynamicsCompressorNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDynamicsCompressorNodeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DynamicsCompressorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22DynamicsCompressorNodeE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DynamicsCompressorNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDynamicsCompressorNode>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DynamicsCompressorNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore22DynamicsCompressorNodeE[2];
#if COMPILER(CLANG)
    // If this fails DynamicsCompressorNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DynamicsCompressorNode), DynamicsCompressorNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DynamicsCompressorNode has subclasses. If DynamicsCompressorNode has subclasses that get passed
    // to toJS() we currently require DynamicsCompressorNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DynamicsCompressorNode>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDynamicsCompressorNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
