/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDirectoryReader.h"

#include "DirectoryReader.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEntriesCallback.h"
#include "JSErrorCallback.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSDirectoryReaderPrototypeTableValues[] =
{
    { "readEntries", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryReaderPrototypeFunctionReadEntries), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDirectoryReaderPrototypeTable = { 2, 1, JSDirectoryReaderPrototypeTableValues, 0 };
static const HashTable* getJSDirectoryReaderPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDirectoryReaderPrototypeTable);
}

const ClassInfo JSDirectoryReaderPrototype::s_info = { "DirectoryReaderPrototype", &Base::s_info, 0, getJSDirectoryReaderPrototypeTable, CREATE_METHOD_TABLE(JSDirectoryReaderPrototype) };

JSObject* JSDirectoryReaderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDirectoryReader>(exec, globalObject);
}

bool JSDirectoryReaderPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDirectoryReaderPrototype* thisObject = jsCast<JSDirectoryReaderPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSDirectoryReaderPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSDirectoryReaderPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDirectoryReaderPrototype* thisObject = jsCast<JSDirectoryReaderPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDirectoryReaderPrototypeTable(exec), thisObject, propertyName, descriptor);
}

const ClassInfo JSDirectoryReader::s_info = { "DirectoryReader", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSDirectoryReader) };

JSDirectoryReader::JSDirectoryReader(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DirectoryReader> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDirectoryReader::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDirectoryReader::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDirectoryReaderPrototype::create(exec->vm(), globalObject, JSDirectoryReaderPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDirectoryReader::destroy(JSC::JSCell* cell)
{
    JSDirectoryReader* thisObject = static_cast<JSDirectoryReader*>(cell);
    thisObject->JSDirectoryReader::~JSDirectoryReader();
}

JSDirectoryReader::~JSDirectoryReader()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsDirectoryReaderPrototypeFunctionReadEntries(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryReader::s_info))
        return throwVMTypeError(exec);
    JSDirectoryReader* castedThis = jsCast<JSDirectoryReader*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryReader::s_info);
    DirectoryReader* impl = static_cast<DirectoryReader*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<EntriesCallback> successCallback = JSEntriesCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    impl->readEntries(successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSDirectoryReader* jsDirectoryReader)
{
    if (jsDirectoryReader->hasCustomProperties())
        return true;
    return false;
}

bool JSDirectoryReaderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDirectoryReader* jsDirectoryReader = jsCast<JSDirectoryReader*>(handle.get().asCell());
    if (!isObservable(jsDirectoryReader))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDirectoryReaderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDirectoryReader* jsDirectoryReader = jsCast<JSDirectoryReader*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDirectoryReader->impl(), jsDirectoryReader);
    jsDirectoryReader->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DirectoryReader* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDirectoryReader>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DirectoryReader.
    COMPILE_ASSERT(!__is_polymorphic(DirectoryReader), DirectoryReader_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<DirectoryReader>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDirectoryReader>(exec, globalObject, impl);
}

DirectoryReader* toDirectoryReader(JSC::JSValue value)
{
    return value.inherits(&JSDirectoryReader::s_info) ? jsCast<JSDirectoryReader*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
