/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDirectoryEntry_h
#define JSDirectoryEntry_h

#if ENABLE(FILE_SYSTEM)

#include "DirectoryEntry.h"
#include "JSEntry.h"
#include <runtime/JSObject.h>

namespace WebCore {

class JSDirectoryEntry : public JSEntry {
public:
    typedef JSEntry Base;
    static JSDirectoryEntry* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DirectoryEntry> impl)
    {
        JSDirectoryEntry* ptr = new (NotNull, JSC::allocateCell<JSDirectoryEntry>(globalObject->vm().heap)) JSDirectoryEntry(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    DirectoryEntry* impl() const
    {
        return static_cast<DirectoryEntry*>(Base::impl());
    }
protected:
    JSDirectoryEntry(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<DirectoryEntry>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, DirectoryEntry*);
DirectoryEntry* toDirectoryEntry(JSC::JSValue);

class JSDirectoryEntryPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSDirectoryEntryPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDirectoryEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSDirectoryEntryPrototype>(vm.heap)) JSDirectoryEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSDirectoryEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionCreateReader(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionGetFile(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionGetDirectory(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionRemoveRecursively(JSC::ExecState*);

} // namespace WebCore

#endif // ENABLE(FILE_SYSTEM)

#endif
