/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDirectoryEntry.h"

#include "Dictionary.h"
#include "DirectoryEntry.h"
#include "DirectoryReader.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDirectoryReader.h"
#include "JSEntryCallback.h"
#include "JSErrorCallback.h"
#include "JSVoidCallback.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSDirectoryEntryPrototypeTableValues[] =
{
    { "createReader", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionCreateReader), (intptr_t)0, NoIntrinsic },
    { "getFile", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionGetFile), (intptr_t)1, NoIntrinsic },
    { "getDirectory", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionGetDirectory), (intptr_t)1, NoIntrinsic },
    { "removeRecursively", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDirectoryEntryPrototypeFunctionRemoveRecursively), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDirectoryEntryPrototypeTable = { 10, 7, JSDirectoryEntryPrototypeTableValues, 0 };
static const HashTable* getJSDirectoryEntryPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDirectoryEntryPrototypeTable);
}

const ClassInfo JSDirectoryEntryPrototype::s_info = { "DirectoryEntryPrototype", &Base::s_info, 0, getJSDirectoryEntryPrototypeTable, CREATE_METHOD_TABLE(JSDirectoryEntryPrototype) };

JSObject* JSDirectoryEntryPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDirectoryEntry>(exec, globalObject);
}

bool JSDirectoryEntryPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDirectoryEntryPrototype* thisObject = jsCast<JSDirectoryEntryPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSDirectoryEntryPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSDirectoryEntryPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDirectoryEntryPrototype* thisObject = jsCast<JSDirectoryEntryPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDirectoryEntryPrototypeTable(exec), thisObject, propertyName, descriptor);
}

const ClassInfo JSDirectoryEntry::s_info = { "DirectoryEntry", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSDirectoryEntry) };

JSDirectoryEntry::JSDirectoryEntry(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DirectoryEntry> impl)
    : JSEntry(structure, globalObject, impl)
{
}

void JSDirectoryEntry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDirectoryEntry::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDirectoryEntryPrototype::create(exec->vm(), globalObject, JSDirectoryEntryPrototype::createStructure(exec->vm(), globalObject, JSEntryPrototype::self(exec, globalObject)));
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionCreateReader(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = jsCast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    DirectoryEntry* impl = static_cast<DirectoryEntry*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createReader()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionGetFile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = jsCast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    DirectoryEntry* impl = static_cast<DirectoryEntry*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& path(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Dictionary options(exec, exec->argument(1));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<EntryCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSEntryCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }
    impl->getFile(path, options, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionGetDirectory(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = jsCast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    DirectoryEntry* impl = static_cast<DirectoryEntry*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& path(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Dictionary options(exec, exec->argument(1));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<EntryCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSEntryCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }
    impl->getDirectory(path, options, successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDirectoryEntryPrototypeFunctionRemoveRecursively(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDirectoryEntry::s_info))
        return throwVMTypeError(exec);
    JSDirectoryEntry* castedThis = jsCast<JSDirectoryEntry*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDirectoryEntry::s_info);
    DirectoryEntry* impl = static_cast<DirectoryEntry*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<VoidCallback> successCallback = JSVoidCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    RefPtr<ErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    impl->removeRecursively(successCallback, errorCallback);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DirectoryEntry@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14DirectoryEntryE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DirectoryEntry* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDirectoryEntry>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DirectoryEntry@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14DirectoryEntryE[2];
#if COMPILER(CLANG)
    // If this fails DirectoryEntry does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DirectoryEntry), DirectoryEntry_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DirectoryEntry has subclasses. If DirectoryEntry has subclasses that get passed
    // to toJS() we currently require DirectoryEntry you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DirectoryEntry>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDirectoryEntry>(exec, globalObject, impl);
}

DirectoryEntry* toDirectoryEntry(JSC::JSValue value)
{
    return value.inherits(&JSDirectoryEntry::s_info) ? jsCast<JSDirectoryEntry*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
