/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DEVICE_ORIENTATION)

#include "JSDeviceOrientationEvent.h"

#include "DeviceOrientationEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDeviceOrientationEventTableValues[] =
{
    { "alpha", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventAlpha), (intptr_t)0, NoIntrinsic },
    { "beta", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventBeta), (intptr_t)0, NoIntrinsic },
    { "gamma", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventGamma), (intptr_t)0, NoIntrinsic },
    { "absolute", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventAbsolute), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceOrientationEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDeviceOrientationEventTable = { 16, 15, JSDeviceOrientationEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDeviceOrientationEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDeviceOrientationEventConstructorTable = { 1, 0, JSDeviceOrientationEventConstructorTableValues, 0 };
const ClassInfo JSDeviceOrientationEventConstructor::s_info = { "DeviceOrientationEventConstructor", &Base::s_info, &JSDeviceOrientationEventConstructorTable, 0, CREATE_METHOD_TABLE(JSDeviceOrientationEventConstructor) };

JSDeviceOrientationEventConstructor::JSDeviceOrientationEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDeviceOrientationEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDeviceOrientationEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDeviceOrientationEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDeviceOrientationEventConstructor, JSDOMWrapper>(exec, &JSDeviceOrientationEventConstructorTable, jsCast<JSDeviceOrientationEventConstructor*>(cell), propertyName, slot);
}

bool JSDeviceOrientationEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDeviceOrientationEventConstructor, JSDOMWrapper>(exec, &JSDeviceOrientationEventConstructorTable, jsCast<JSDeviceOrientationEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDeviceOrientationEventPrototypeTableValues[] =
{
    { "initDeviceOrientationEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDeviceOrientationEventPrototypeTable = { 2, 1, JSDeviceOrientationEventPrototypeTableValues, 0 };
const ClassInfo JSDeviceOrientationEventPrototype::s_info = { "DeviceOrientationEventPrototype", &Base::s_info, &JSDeviceOrientationEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSDeviceOrientationEventPrototype) };

JSObject* JSDeviceOrientationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDeviceOrientationEvent>(exec, globalObject);
}

bool JSDeviceOrientationEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDeviceOrientationEventPrototype* thisObject = jsCast<JSDeviceOrientationEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDeviceOrientationEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSDeviceOrientationEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDeviceOrientationEventPrototype* thisObject = jsCast<JSDeviceOrientationEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDeviceOrientationEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDeviceOrientationEvent::s_info = { "DeviceOrientationEvent", &Base::s_info, &JSDeviceOrientationEventTable, 0 , CREATE_METHOD_TABLE(JSDeviceOrientationEvent) };

JSDeviceOrientationEvent::JSDeviceOrientationEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DeviceOrientationEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSDeviceOrientationEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDeviceOrientationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDeviceOrientationEventPrototype::create(exec->vm(), globalObject, JSDeviceOrientationEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSDeviceOrientationEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDeviceOrientationEvent* thisObject = jsCast<JSDeviceOrientationEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDeviceOrientationEvent, Base>(exec, &JSDeviceOrientationEventTable, thisObject, propertyName, slot);
}

bool JSDeviceOrientationEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDeviceOrientationEvent* thisObject = jsCast<JSDeviceOrientationEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDeviceOrientationEvent, Base>(exec, &JSDeviceOrientationEventTable, thisObject, propertyName, descriptor);
}

JSValue jsDeviceOrientationEventAlpha(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceOrientationEvent* castedThis = jsCast<JSDeviceOrientationEvent*>(asObject(slotBase));
    return castedThis->alpha(exec);
}


JSValue jsDeviceOrientationEventBeta(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceOrientationEvent* castedThis = jsCast<JSDeviceOrientationEvent*>(asObject(slotBase));
    return castedThis->beta(exec);
}


JSValue jsDeviceOrientationEventGamma(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceOrientationEvent* castedThis = jsCast<JSDeviceOrientationEvent*>(asObject(slotBase));
    return castedThis->gamma(exec);
}


JSValue jsDeviceOrientationEventAbsolute(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceOrientationEvent* castedThis = jsCast<JSDeviceOrientationEvent*>(asObject(slotBase));
    return castedThis->absolute(exec);
}


JSValue jsDeviceOrientationEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceOrientationEvent* domObject = jsCast<JSDeviceOrientationEvent*>(asObject(slotBase));
    return JSDeviceOrientationEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSDeviceOrientationEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeviceOrientationEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDeviceOrientationEventPrototypeFunctionInitDeviceOrientationEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDeviceOrientationEvent::s_info))
        return throwVMTypeError(exec);
    JSDeviceOrientationEvent* castedThis = jsCast<JSDeviceOrientationEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDeviceOrientationEvent::s_info);
    return JSValue::encode(castedThis->initDeviceOrientationEvent(exec));
}


}

#endif // ENABLE(DEVICE_ORIENTATION)
