/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DEVICE_ORIENTATION)

#include "JSDeviceMotionEvent.h"

#include "DeviceMotionEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDeviceMotionEventTableValues[] =
{
    { "acceleration", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventAcceleration), (intptr_t)0, NoIntrinsic },
    { "accelerationIncludingGravity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventAccelerationIncludingGravity), (intptr_t)0, NoIntrinsic },
    { "rotationRate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventRotationRate), (intptr_t)0, NoIntrinsic },
    { "interval", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventInterval), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDeviceMotionEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDeviceMotionEventTable = { 18, 15, JSDeviceMotionEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDeviceMotionEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDeviceMotionEventConstructorTable = { 1, 0, JSDeviceMotionEventConstructorTableValues, 0 };
const ClassInfo JSDeviceMotionEventConstructor::s_info = { "DeviceMotionEventConstructor", &Base::s_info, &JSDeviceMotionEventConstructorTable, 0, CREATE_METHOD_TABLE(JSDeviceMotionEventConstructor) };

JSDeviceMotionEventConstructor::JSDeviceMotionEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDeviceMotionEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDeviceMotionEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDeviceMotionEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDeviceMotionEventConstructor, JSDOMWrapper>(exec, &JSDeviceMotionEventConstructorTable, jsCast<JSDeviceMotionEventConstructor*>(cell), propertyName, slot);
}

bool JSDeviceMotionEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDeviceMotionEventConstructor, JSDOMWrapper>(exec, &JSDeviceMotionEventConstructorTable, jsCast<JSDeviceMotionEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDeviceMotionEventPrototypeTableValues[] =
{
    { "initDeviceMotionEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDeviceMotionEventPrototypeTable = { 2, 1, JSDeviceMotionEventPrototypeTableValues, 0 };
const ClassInfo JSDeviceMotionEventPrototype::s_info = { "DeviceMotionEventPrototype", &Base::s_info, &JSDeviceMotionEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSDeviceMotionEventPrototype) };

JSObject* JSDeviceMotionEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDeviceMotionEvent>(exec, globalObject);
}

bool JSDeviceMotionEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDeviceMotionEventPrototype* thisObject = jsCast<JSDeviceMotionEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDeviceMotionEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSDeviceMotionEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDeviceMotionEventPrototype* thisObject = jsCast<JSDeviceMotionEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDeviceMotionEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDeviceMotionEvent::s_info = { "DeviceMotionEvent", &Base::s_info, &JSDeviceMotionEventTable, 0 , CREATE_METHOD_TABLE(JSDeviceMotionEvent) };

JSDeviceMotionEvent::JSDeviceMotionEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DeviceMotionEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSDeviceMotionEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDeviceMotionEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDeviceMotionEventPrototype::create(exec->vm(), globalObject, JSDeviceMotionEventPrototype::createStructure(exec->vm(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSDeviceMotionEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDeviceMotionEvent* thisObject = jsCast<JSDeviceMotionEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDeviceMotionEvent, Base>(exec, &JSDeviceMotionEventTable, thisObject, propertyName, slot);
}

bool JSDeviceMotionEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDeviceMotionEvent* thisObject = jsCast<JSDeviceMotionEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDeviceMotionEvent, Base>(exec, &JSDeviceMotionEventTable, thisObject, propertyName, descriptor);
}

JSValue jsDeviceMotionEventAcceleration(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceMotionEvent* castedThis = jsCast<JSDeviceMotionEvent*>(asObject(slotBase));
    return castedThis->acceleration(exec);
}


JSValue jsDeviceMotionEventAccelerationIncludingGravity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceMotionEvent* castedThis = jsCast<JSDeviceMotionEvent*>(asObject(slotBase));
    return castedThis->accelerationIncludingGravity(exec);
}


JSValue jsDeviceMotionEventRotationRate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceMotionEvent* castedThis = jsCast<JSDeviceMotionEvent*>(asObject(slotBase));
    return castedThis->rotationRate(exec);
}


JSValue jsDeviceMotionEventInterval(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceMotionEvent* castedThis = jsCast<JSDeviceMotionEvent*>(asObject(slotBase));
    return castedThis->interval(exec);
}


JSValue jsDeviceMotionEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDeviceMotionEvent* domObject = jsCast<JSDeviceMotionEvent*>(asObject(slotBase));
    return JSDeviceMotionEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSDeviceMotionEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDeviceMotionEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDeviceMotionEventPrototypeFunctionInitDeviceMotionEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDeviceMotionEvent::s_info))
        return throwVMTypeError(exec);
    JSDeviceMotionEvent* castedThis = jsCast<JSDeviceMotionEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDeviceMotionEvent::s_info);
    return JSValue::encode(castedThis->initDeviceMotionEvent(exec));
}


}

#endif // ENABLE(DEVICE_ORIENTATION)
