/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SQL_DATABASE)

#include "JSDatabaseSync.h"

#include "DatabaseSync.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSQLTransactionSyncCallback.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDatabaseSyncTableValues[] =
{
    { "version", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDatabaseSyncVersion), (intptr_t)0, NoIntrinsic },
    { "lastErrorMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDatabaseSyncLastErrorMessage), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDatabaseSyncTable = { 4, 3, JSDatabaseSyncTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDatabaseSyncPrototypeTableValues[] =
{
    { "changeVersion", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionChangeVersion), (intptr_t)2, NoIntrinsic },
    { "transaction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionTransaction), (intptr_t)1, NoIntrinsic },
    { "readTransaction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDatabaseSyncPrototypeFunctionReadTransaction), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDatabaseSyncPrototypeTable = { 8, 7, JSDatabaseSyncPrototypeTableValues, 0 };
static const HashTable* getJSDatabaseSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDatabaseSyncPrototypeTable);
}

const ClassInfo JSDatabaseSyncPrototype::s_info = { "DatabaseSyncPrototype", &Base::s_info, 0, getJSDatabaseSyncPrototypeTable, CREATE_METHOD_TABLE(JSDatabaseSyncPrototype) };

JSObject* JSDatabaseSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDatabaseSync>(exec, globalObject);
}

bool JSDatabaseSyncPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDatabaseSyncPrototype* thisObject = jsCast<JSDatabaseSyncPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSDatabaseSyncPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSDatabaseSyncPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDatabaseSyncPrototype* thisObject = jsCast<JSDatabaseSyncPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDatabaseSyncPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSDatabaseSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDatabaseSyncTable);
}

const ClassInfo JSDatabaseSync::s_info = { "DatabaseSync", &Base::s_info, 0, getJSDatabaseSyncTable , CREATE_METHOD_TABLE(JSDatabaseSync) };

JSDatabaseSync::JSDatabaseSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DatabaseSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDatabaseSync::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDatabaseSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDatabaseSyncPrototype::create(exec->vm(), globalObject, JSDatabaseSyncPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDatabaseSync::destroy(JSC::JSCell* cell)
{
    JSDatabaseSync* thisObject = static_cast<JSDatabaseSync*>(cell);
    thisObject->JSDatabaseSync::~JSDatabaseSync();
}

JSDatabaseSync::~JSDatabaseSync()
{
    releaseImplIfNotNull();
}

bool JSDatabaseSync::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDatabaseSync* thisObject = jsCast<JSDatabaseSync*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDatabaseSync, Base>(exec, getJSDatabaseSyncTable(exec), thisObject, propertyName, slot);
}

bool JSDatabaseSync::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDatabaseSync* thisObject = jsCast<JSDatabaseSync*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDatabaseSync, Base>(exec, getJSDatabaseSyncTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsDatabaseSyncVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDatabaseSync* castedThis = jsCast<JSDatabaseSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DatabaseSync* impl = static_cast<DatabaseSync*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->version());
    return result;
}


JSValue jsDatabaseSyncLastErrorMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDatabaseSync* castedThis = jsCast<JSDatabaseSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DatabaseSync* impl = static_cast<DatabaseSync*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lastErrorMessage());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionChangeVersion(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = jsCast<JSDatabaseSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabaseSync::s_info);
    DatabaseSync* impl = static_cast<DatabaseSync*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& oldVersion(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& newVersion(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<SQLTransactionSyncCallback> callback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        callback = JSSQLTransactionSyncCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    impl->changeVersion(oldVersion, newVersion, callback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = jsCast<JSDatabaseSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabaseSync::s_info);
    DatabaseSync* impl = static_cast<DatabaseSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<SQLTransactionSyncCallback> callback = JSSQLTransactionSyncCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    impl->transaction(callback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDatabaseSyncPrototypeFunctionReadTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabaseSync::s_info))
        return throwVMTypeError(exec);
    JSDatabaseSync* castedThis = jsCast<JSDatabaseSync*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabaseSync::s_info);
    DatabaseSync* impl = static_cast<DatabaseSync*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<SQLTransactionSyncCallback> callback = JSSQLTransactionSyncCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    impl->readTransaction(callback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSDatabaseSync* jsDatabaseSync)
{
    if (jsDatabaseSync->hasCustomProperties())
        return true;
    return false;
}

bool JSDatabaseSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDatabaseSync* jsDatabaseSync = jsCast<JSDatabaseSync*>(handle.get().asCell());
    if (!isObservable(jsDatabaseSync))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDatabaseSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDatabaseSync* jsDatabaseSync = jsCast<JSDatabaseSync*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDatabaseSync->impl(), jsDatabaseSync);
    jsDatabaseSync->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DatabaseSync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12DatabaseSyncE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DatabaseSync* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDatabaseSync>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DatabaseSync@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12DatabaseSyncE[2];
#if COMPILER(CLANG)
    // If this fails DatabaseSync does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DatabaseSync), DatabaseSync_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DatabaseSync has subclasses. If DatabaseSync has subclasses that get passed
    // to toJS() we currently require DatabaseSync you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DatabaseSync>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDatabaseSync>(exec, globalObject, impl);
}

DatabaseSync* toDatabaseSync(JSC::JSValue value)
{
    return value.inherits(&JSDatabaseSync::s_info) ? jsCast<JSDatabaseSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SQL_DATABASE)
