/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SQL_DATABASE)

#include "JSDatabase.h"

#include "Database.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSQLTransactionCallback.h"
#include "JSSQLTransactionErrorCallback.h"
#include "JSVoidCallback.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDatabaseTableValues[] =
{
    { "version", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDatabaseVersion), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDatabaseTable = { 2, 1, JSDatabaseTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDatabasePrototypeTableValues[] =
{
    { "changeVersion", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDatabasePrototypeFunctionChangeVersion), (intptr_t)2, NoIntrinsic },
    { "transaction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDatabasePrototypeFunctionTransaction), (intptr_t)1, NoIntrinsic },
    { "readTransaction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDatabasePrototypeFunctionReadTransaction), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDatabasePrototypeTable = { 8, 7, JSDatabasePrototypeTableValues, 0 };
static const HashTable* getJSDatabasePrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDatabasePrototypeTable);
}

const ClassInfo JSDatabasePrototype::s_info = { "DatabasePrototype", &Base::s_info, 0, getJSDatabasePrototypeTable, CREATE_METHOD_TABLE(JSDatabasePrototype) };

JSObject* JSDatabasePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDatabase>(exec, globalObject);
}

bool JSDatabasePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDatabasePrototype* thisObject = jsCast<JSDatabasePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSDatabasePrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSDatabasePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDatabasePrototype* thisObject = jsCast<JSDatabasePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDatabasePrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSDatabaseTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDatabaseTable);
}

const ClassInfo JSDatabase::s_info = { "Database", &Base::s_info, 0, getJSDatabaseTable , CREATE_METHOD_TABLE(JSDatabase) };

JSDatabase::JSDatabase(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Database> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDatabase::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDatabase::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDatabasePrototype::create(exec->vm(), globalObject, JSDatabasePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDatabase::destroy(JSC::JSCell* cell)
{
    JSDatabase* thisObject = static_cast<JSDatabase*>(cell);
    thisObject->JSDatabase::~JSDatabase();
}

JSDatabase::~JSDatabase()
{
    releaseImplIfNotNull();
}

bool JSDatabase::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDatabase* thisObject = jsCast<JSDatabase*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDatabase, Base>(exec, getJSDatabaseTable(exec), thisObject, propertyName, slot);
}

bool JSDatabase::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDatabase* thisObject = jsCast<JSDatabase*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDatabase, Base>(exec, getJSDatabaseTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsDatabaseVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDatabase* castedThis = jsCast<JSDatabase*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Database* impl = static_cast<Database*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->version());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsDatabasePrototypeFunctionChangeVersion(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabase::s_info))
        return throwVMTypeError(exec);
    JSDatabase* castedThis = jsCast<JSDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabase::s_info);
    Database* impl = static_cast<Database*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& oldVersion(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& newVersion(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<SQLTransactionCallback> callback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        callback = JSSQLTransactionCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    RefPtr<SQLTransactionErrorCallback> errorCallback;
    if (exec->argumentCount() > 3 && !exec->argument(3).isUndefinedOrNull()) {
        if (!exec->argument(3).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSSQLTransactionErrorCallback::create(asObject(exec->argument(3)), castedThis->globalObject());
    }
    RefPtr<VoidCallback> successCallback;
    if (exec->argumentCount() > 4 && !exec->argument(4).isUndefinedOrNull()) {
        if (!exec->argument(4).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSVoidCallback::create(asObject(exec->argument(4)), castedThis->globalObject());
    }
    impl->changeVersion(oldVersion, newVersion, callback, errorCallback, successCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDatabasePrototypeFunctionTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabase::s_info))
        return throwVMTypeError(exec);
    JSDatabase* castedThis = jsCast<JSDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabase::s_info);
    Database* impl = static_cast<Database*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<SQLTransactionCallback> callback = JSSQLTransactionCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    RefPtr<SQLTransactionErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSSQLTransactionErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    RefPtr<VoidCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSVoidCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    impl->transaction(callback, errorCallback, successCallback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDatabasePrototypeFunctionReadTransaction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDatabase::s_info))
        return throwVMTypeError(exec);
    JSDatabase* castedThis = jsCast<JSDatabase*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDatabase::s_info);
    Database* impl = static_cast<Database*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() <= 0 || !exec->argument(0).isFunction())
        return throwVMTypeError(exec);
    RefPtr<SQLTransactionCallback> callback = JSSQLTransactionCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    RefPtr<SQLTransactionErrorCallback> errorCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSSQLTransactionErrorCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    RefPtr<VoidCallback> successCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        successCallback = JSVoidCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    impl->readTransaction(callback, errorCallback, successCallback);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSDatabase* jsDatabase)
{
    if (jsDatabase->hasCustomProperties())
        return true;
    return false;
}

bool JSDatabaseOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDatabase* jsDatabase = jsCast<JSDatabase*>(handle.get().asCell());
    if (!isObservable(jsDatabase))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDatabaseOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDatabase* jsDatabase = jsCast<JSDatabase*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDatabase->impl(), jsDatabase);
    jsDatabase->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Database@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8DatabaseE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Database* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDatabase>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Database@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore8DatabaseE[2];
#if COMPILER(CLANG)
    // If this fails Database does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Database), Database_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Database has subclasses. If Database has subclasses that get passed
    // to toJS() we currently require Database you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<Database>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDatabase>(exec, globalObject, impl);
}

Database* toDatabase(JSC::JSValue value)
{
    return value.inherits(&JSDatabase::s_info) ? jsCast<JSDatabase*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SQL_DATABASE)
