/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATA_TRANSFER_ITEMS)

#include "JSDataTransferItem.h"

#include "Blob.h"
#include "DataTransferItem.h"
#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSStringCallback.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDataTransferItemTableValues[] =
{
    { "kind", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferItemKind), (intptr_t)0, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDataTransferItemType), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDataTransferItemTable = { 4, 3, JSDataTransferItemTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDataTransferItemPrototypeTableValues[] =
{
    { "getAsString", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDataTransferItemPrototypeFunctionGetAsString), (intptr_t)0, NoIntrinsic },
    { "getAsFile", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDataTransferItemPrototypeFunctionGetAsFile), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDataTransferItemPrototypeTable = { 4, 3, JSDataTransferItemPrototypeTableValues, 0 };
const ClassInfo JSDataTransferItemPrototype::s_info = { "DataTransferItemPrototype", &Base::s_info, &JSDataTransferItemPrototypeTable, 0, CREATE_METHOD_TABLE(JSDataTransferItemPrototype) };

JSObject* JSDataTransferItemPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDataTransferItem>(exec, globalObject);
}

bool JSDataTransferItemPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDataTransferItemPrototype* thisObject = jsCast<JSDataTransferItemPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDataTransferItemPrototypeTable, thisObject, propertyName, slot);
}

bool JSDataTransferItemPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDataTransferItemPrototype* thisObject = jsCast<JSDataTransferItemPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDataTransferItemPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDataTransferItem::s_info = { "DataTransferItem", &Base::s_info, &JSDataTransferItemTable, 0 , CREATE_METHOD_TABLE(JSDataTransferItem) };

JSDataTransferItem::JSDataTransferItem(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DataTransferItem> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDataTransferItem::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDataTransferItem::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDataTransferItemPrototype::create(exec->vm(), globalObject, JSDataTransferItemPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDataTransferItem::destroy(JSC::JSCell* cell)
{
    JSDataTransferItem* thisObject = static_cast<JSDataTransferItem*>(cell);
    thisObject->JSDataTransferItem::~JSDataTransferItem();
}

JSDataTransferItem::~JSDataTransferItem()
{
    releaseImplIfNotNull();
}

bool JSDataTransferItem::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDataTransferItem* thisObject = jsCast<JSDataTransferItem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDataTransferItem, Base>(exec, &JSDataTransferItemTable, thisObject, propertyName, slot);
}

bool JSDataTransferItem::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDataTransferItem* thisObject = jsCast<JSDataTransferItem*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDataTransferItem, Base>(exec, &JSDataTransferItemTable, thisObject, propertyName, descriptor);
}

JSValue jsDataTransferItemKind(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDataTransferItem* castedThis = jsCast<JSDataTransferItem*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataTransferItem* impl = static_cast<DataTransferItem*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->kind());
    return result;
}


JSValue jsDataTransferItemType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDataTransferItem* castedThis = jsCast<JSDataTransferItem*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DataTransferItem* impl = static_cast<DataTransferItem*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsDataTransferItemPrototypeFunctionGetAsString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataTransferItem::s_info))
        return throwVMTypeError(exec);
    JSDataTransferItem* castedThis = jsCast<JSDataTransferItem*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataTransferItem::s_info);
    DataTransferItem* impl = static_cast<DataTransferItem*>(castedThis->impl());
    RefPtr<StringCallback> callback;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull()) {
        if (!exec->argument(0).isFunction())
            return throwVMTypeError(exec);
        callback = JSStringCallback::create(asObject(exec->argument(0)), castedThis->globalObject());
    }
    impl->getAsString(callback);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDataTransferItemPrototypeFunctionGetAsFile(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDataTransferItem::s_info))
        return throwVMTypeError(exec);
    JSDataTransferItem* castedThis = jsCast<JSDataTransferItem*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDataTransferItem::s_info);
    DataTransferItem* impl = static_cast<DataTransferItem*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getAsFile()));
    return JSValue::encode(result);
}

static inline bool isObservable(JSDataTransferItem* jsDataTransferItem)
{
    if (jsDataTransferItem->hasCustomProperties())
        return true;
    return false;
}

bool JSDataTransferItemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDataTransferItem* jsDataTransferItem = jsCast<JSDataTransferItem*>(handle.get().asCell());
    if (!isObservable(jsDataTransferItem))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDataTransferItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDataTransferItem* jsDataTransferItem = jsCast<JSDataTransferItem*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDataTransferItem->impl(), jsDataTransferItem);
    jsDataTransferItem->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DataTransferItem* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDataTransferItem>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DataTransferItem.
    COMPILE_ASSERT(!__is_polymorphic(DataTransferItem), DataTransferItem_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<DataTransferItem>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDataTransferItem>(exec, globalObject, impl);
}

DataTransferItem* toDataTransferItem(JSC::JSValue value)
{
    return value.inherits(&JSDataTransferItem::s_info) ? jsCast<JSDataTransferItem*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATA_TRANSFER_ITEMS)
