/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMSecurityPolicy_h
#define JSDOMSecurityPolicy_h

#if ENABLE(CSP_NEXT)

#include "DOMSecurityPolicy.h"
#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSDOMSecurityPolicy : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSDOMSecurityPolicy* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMSecurityPolicy> impl)
    {
        JSDOMSecurityPolicy* ptr = new (NotNull, JSC::allocateCell<JSDOMSecurityPolicy>(globalObject->vm().heap)) JSDOMSecurityPolicy(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void destroy(JSC::JSCell*);
    ~JSDOMSecurityPolicy();
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    DOMSecurityPolicy* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull()
    {
        if (m_impl) {
            m_impl->deref();
            m_impl = 0;
        }
    }

private:
    DOMSecurityPolicy* m_impl;
protected:
    JSDOMSecurityPolicy(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<DOMSecurityPolicy>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
};

class JSDOMSecurityPolicyOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, DOMSecurityPolicy*)
{
    DEFINE_STATIC_LOCAL(JSDOMSecurityPolicyOwner, jsDOMSecurityPolicyOwner, ());
    return &jsDOMSecurityPolicyOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, DOMSecurityPolicy*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, DOMSecurityPolicy*);
DOMSecurityPolicy* toDOMSecurityPolicy(JSC::JSValue);

class JSDOMSecurityPolicyPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSDOMSecurityPolicyPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMSecurityPolicyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMSecurityPolicyPrototype>(vm.heap)) JSDOMSecurityPolicyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSDOMSecurityPolicyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSDOMSecurityPolicyConstructor : public DOMConstructorObject {
private:
    JSDOMSecurityPolicyConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSDOMSecurityPolicyConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSDOMSecurityPolicyConstructor* ptr = new (NotNull, JSC::allocateCell<JSDOMSecurityPolicyConstructor>(*exec->heap())) JSDOMSecurityPolicyConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsConnectionTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsFontFrom(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsFormAction(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsFrameFrom(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsImageFrom(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsMediaFrom(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsObjectFrom(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsPluginType(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsScriptFrom(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsStyleFrom(JSC::ExecState*);
// Attributes

JSC::JSValue jsDOMSecurityPolicyAllowsEval(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMSecurityPolicyAllowsInlineScript(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMSecurityPolicyAllowsInlineStyle(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMSecurityPolicyIsActive(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMSecurityPolicyReportURIs(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMSecurityPolicyConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif // ENABLE(CSP_NEXT)

#endif
