/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSP_NEXT)

#include "JSDOMSecurityPolicy.h"

#include "DOMSecurityPolicy.h"
#include "DOMStringList.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMStringList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMSecurityPolicyTableValues[] =
{
    { "allowsEval", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSecurityPolicyAllowsEval), (intptr_t)0, NoIntrinsic },
    { "allowsInlineScript", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSecurityPolicyAllowsInlineScript), (intptr_t)0, NoIntrinsic },
    { "allowsInlineStyle", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSecurityPolicyAllowsInlineStyle), (intptr_t)0, NoIntrinsic },
    { "isActive", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSecurityPolicyIsActive), (intptr_t)0, NoIntrinsic },
    { "reportURIs", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSecurityPolicyReportURIs), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMSecurityPolicyConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMSecurityPolicyTable = { 17, 15, JSDOMSecurityPolicyTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMSecurityPolicyConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMSecurityPolicyConstructorTable = { 1, 0, JSDOMSecurityPolicyConstructorTableValues, 0 };
const ClassInfo JSDOMSecurityPolicyConstructor::s_info = { "SecurityPolicyConstructor", &Base::s_info, &JSDOMSecurityPolicyConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMSecurityPolicyConstructor) };

JSDOMSecurityPolicyConstructor::JSDOMSecurityPolicyConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMSecurityPolicyConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDOMSecurityPolicyPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDOMSecurityPolicyConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMSecurityPolicyConstructor, JSDOMWrapper>(exec, &JSDOMSecurityPolicyConstructorTable, jsCast<JSDOMSecurityPolicyConstructor*>(cell), propertyName, slot);
}

bool JSDOMSecurityPolicyConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMSecurityPolicyConstructor, JSDOMWrapper>(exec, &JSDOMSecurityPolicyConstructorTable, jsCast<JSDOMSecurityPolicyConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDOMSecurityPolicyPrototypeTableValues[] =
{
    { "allowsConnectionTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsConnectionTo), (intptr_t)1, NoIntrinsic },
    { "allowsFontFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsFontFrom), (intptr_t)1, NoIntrinsic },
    { "allowsFormAction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsFormAction), (intptr_t)1, NoIntrinsic },
    { "allowsFrameFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsFrameFrom), (intptr_t)1, NoIntrinsic },
    { "allowsImageFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsImageFrom), (intptr_t)1, NoIntrinsic },
    { "allowsMediaFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsMediaFrom), (intptr_t)1, NoIntrinsic },
    { "allowsObjectFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsObjectFrom), (intptr_t)1, NoIntrinsic },
    { "allowsPluginType", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsPluginType), (intptr_t)1, NoIntrinsic },
    { "allowsScriptFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsScriptFrom), (intptr_t)1, NoIntrinsic },
    { "allowsStyleFrom", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMSecurityPolicyPrototypeFunctionAllowsStyleFrom), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMSecurityPolicyPrototypeTable = { 33, 31, JSDOMSecurityPolicyPrototypeTableValues, 0 };
const ClassInfo JSDOMSecurityPolicyPrototype::s_info = { "SecurityPolicyPrototype", &Base::s_info, &JSDOMSecurityPolicyPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMSecurityPolicyPrototype) };

JSObject* JSDOMSecurityPolicyPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMSecurityPolicy>(exec, globalObject);
}

bool JSDOMSecurityPolicyPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMSecurityPolicyPrototype* thisObject = jsCast<JSDOMSecurityPolicyPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMSecurityPolicyPrototypeTable, thisObject, propertyName, slot);
}

bool JSDOMSecurityPolicyPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMSecurityPolicyPrototype* thisObject = jsCast<JSDOMSecurityPolicyPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMSecurityPolicyPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDOMSecurityPolicy::s_info = { "SecurityPolicy", &Base::s_info, &JSDOMSecurityPolicyTable, 0 , CREATE_METHOD_TABLE(JSDOMSecurityPolicy) };

JSDOMSecurityPolicy::JSDOMSecurityPolicy(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMSecurityPolicy> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMSecurityPolicy::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMSecurityPolicy::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMSecurityPolicyPrototype::create(exec->vm(), globalObject, JSDOMSecurityPolicyPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDOMSecurityPolicy::destroy(JSC::JSCell* cell)
{
    JSDOMSecurityPolicy* thisObject = static_cast<JSDOMSecurityPolicy*>(cell);
    thisObject->JSDOMSecurityPolicy::~JSDOMSecurityPolicy();
}

JSDOMSecurityPolicy::~JSDOMSecurityPolicy()
{
    releaseImplIfNotNull();
}

bool JSDOMSecurityPolicy::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMSecurityPolicy* thisObject = jsCast<JSDOMSecurityPolicy*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMSecurityPolicy, Base>(exec, &JSDOMSecurityPolicyTable, thisObject, propertyName, slot);
}

bool JSDOMSecurityPolicy::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMSecurityPolicy* thisObject = jsCast<JSDOMSecurityPolicy*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMSecurityPolicy, Base>(exec, &JSDOMSecurityPolicyTable, thisObject, propertyName, descriptor);
}

JSValue jsDOMSecurityPolicyAllowsEval(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    JSValue result = jsBoolean(impl->allowsEval());
    return result;
}


JSValue jsDOMSecurityPolicyAllowsInlineScript(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    JSValue result = jsBoolean(impl->allowsInlineScript());
    return result;
}


JSValue jsDOMSecurityPolicyAllowsInlineStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    JSValue result = jsBoolean(impl->allowsInlineStyle());
    return result;
}


JSValue jsDOMSecurityPolicyIsActive(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isActive());
    return result;
}


JSValue jsDOMSecurityPolicyReportURIs(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->reportURIs()));
    return result;
}


JSValue jsDOMSecurityPolicyConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMSecurityPolicy* domObject = jsCast<JSDOMSecurityPolicy*>(asObject(slotBase));
    return JSDOMSecurityPolicy::getConstructor(exec, domObject->globalObject());
}

JSValue JSDOMSecurityPolicy::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMSecurityPolicyConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsConnectionTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsConnectionTo(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsFontFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsFontFrom(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsFormAction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsFormAction(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsFrameFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsFrameFrom(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsImageFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsImageFrom(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsMediaFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsMediaFrom(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsObjectFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsObjectFrom(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsPluginType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsPluginType(type));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsScriptFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsScriptFrom(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMSecurityPolicyPrototypeFunctionAllowsStyleFrom(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMSecurityPolicy::s_info))
        return throwVMTypeError(exec);
    JSDOMSecurityPolicy* castedThis = jsCast<JSDOMSecurityPolicy*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMSecurityPolicy::s_info);
    DOMSecurityPolicy* impl = static_cast<DOMSecurityPolicy*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->allowsStyleFrom(url));
    return JSValue::encode(result);
}

static inline bool isObservable(JSDOMSecurityPolicy* jsDOMSecurityPolicy)
{
    if (jsDOMSecurityPolicy->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMSecurityPolicyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMSecurityPolicy* jsDOMSecurityPolicy = jsCast<JSDOMSecurityPolicy*>(handle.get().asCell());
    if (!isObservable(jsDOMSecurityPolicy))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMSecurityPolicyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMSecurityPolicy* jsDOMSecurityPolicy = jsCast<JSDOMSecurityPolicy*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMSecurityPolicy->impl(), jsDOMSecurityPolicy);
    jsDOMSecurityPolicy->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMSecurityPolicy@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17DOMSecurityPolicyE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMSecurityPolicy* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMSecurityPolicy>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMSecurityPolicy@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17DOMSecurityPolicyE[2];
#if COMPILER(CLANG)
    // If this fails DOMSecurityPolicy does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMSecurityPolicy), DOMSecurityPolicy_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMSecurityPolicy has subclasses. If DOMSecurityPolicy has subclasses that get passed
    // to toJS() we currently require DOMSecurityPolicy you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DOMSecurityPolicy>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDOMSecurityPolicy>(exec, globalObject, impl);
}

DOMSecurityPolicy* toDOMSecurityPolicy(JSC::JSValue value)
{
    return value.inherits(&JSDOMSecurityPolicy::s_info) ? jsCast<JSDOMSecurityPolicy*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(CSP_NEXT)
