/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CANVAS_PATH)

#include "JSDOMPath.h"

#include "DOMPath.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMPath.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMPathTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPathConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPathTable = { 2, 1, JSDOMPathTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMPathConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPathConstructorTable = { 1, 0, JSDOMPathConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSDOMPathConstructor::constructJSDOMPath1(ExecState* exec)
{
    JSDOMPathConstructor* castedThis = jsCast<JSDOMPathConstructor*>(exec->callee());
    RefPtr<DOMPath> object = DOMPath::create();
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

EncodedJSValue JSC_HOST_CALL JSDOMPathConstructor::constructJSDOMPath2(ExecState* exec)
{
    JSDOMPathConstructor* castedThis = jsCast<JSDOMPathConstructor*>(exec->callee());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    DOMPath* path(toDOMPath(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<DOMPath> object = DOMPath::create(path);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

EncodedJSValue JSC_HOST_CALL JSDOMPathConstructor::constructJSDOMPath3(ExecState* exec)
{
    JSDOMPathConstructor* castedThis = jsCast<JSDOMPathConstructor*>(exec->callee());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& text(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<DOMPath> object = DOMPath::create(text);
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

EncodedJSValue JSC_HOST_CALL JSDOMPathConstructor::constructJSDOMPath(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    if (argsCount == 0)
        return JSDOMPathConstructor::constructJSDOMPath1(exec);
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isObject() && asObject(arg0)->inherits(&JSDOMPath::s_info))))
        return JSDOMPathConstructor::constructJSDOMPath2(exec);
    if (argsCount == 1)
        return JSDOMPathConstructor::constructJSDOMPath3(exec);
    return throwVMTypeError(exec);
}

const ClassInfo JSDOMPathConstructor::s_info = { "PathConstructor", &Base::s_info, &JSDOMPathConstructorTable, 0, CREATE_METHOD_TABLE(JSDOMPathConstructor) };

JSDOMPathConstructor::JSDOMPathConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMPathConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDOMPathPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDOMPathConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMPathConstructor, JSDOMWrapper>(exec, &JSDOMPathConstructorTable, jsCast<JSDOMPathConstructor*>(cell), propertyName, slot);
}

bool JSDOMPathConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMPathConstructor, JSDOMWrapper>(exec, &JSDOMPathConstructorTable, jsCast<JSDOMPathConstructor*>(object), propertyName, descriptor);
}

ConstructType JSDOMPathConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSDOMPath;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSDOMPathPrototypeTableValues[] =
{
    { "closePath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionClosePath), (intptr_t)0, NoIntrinsic },
    { "moveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionMoveTo), (intptr_t)0, NoIntrinsic },
    { "lineTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionLineTo), (intptr_t)0, NoIntrinsic },
    { "quadraticCurveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionQuadraticCurveTo), (intptr_t)0, NoIntrinsic },
    { "bezierCurveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionBezierCurveTo), (intptr_t)0, NoIntrinsic },
    { "arcTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionArcTo), (intptr_t)0, NoIntrinsic },
    { "rect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionRect), (intptr_t)0, NoIntrinsic },
    { "arc", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMPathPrototypeFunctionArc), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMPathPrototypeTable = { 16, 15, JSDOMPathPrototypeTableValues, 0 };
const ClassInfo JSDOMPathPrototype::s_info = { "PathPrototype", &Base::s_info, &JSDOMPathPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMPathPrototype) };

JSObject* JSDOMPathPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMPath>(exec, globalObject);
}

bool JSDOMPathPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMPathPrototype* thisObject = jsCast<JSDOMPathPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMPathPrototypeTable, thisObject, propertyName, slot);
}

bool JSDOMPathPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMPathPrototype* thisObject = jsCast<JSDOMPathPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMPathPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDOMPath::s_info = { "Path", &Base::s_info, &JSDOMPathTable, 0 , CREATE_METHOD_TABLE(JSDOMPath) };

JSDOMPath::JSDOMPath(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMPath> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMPath::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMPath::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMPathPrototype::create(exec->vm(), globalObject, JSDOMPathPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDOMPath::destroy(JSC::JSCell* cell)
{
    JSDOMPath* thisObject = static_cast<JSDOMPath*>(cell);
    thisObject->JSDOMPath::~JSDOMPath();
}

JSDOMPath::~JSDOMPath()
{
    releaseImplIfNotNull();
}

bool JSDOMPath::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMPath* thisObject = jsCast<JSDOMPath*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMPath, Base>(exec, &JSDOMPathTable, thisObject, propertyName, slot);
}

bool JSDOMPath::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMPath* thisObject = jsCast<JSDOMPath*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMPath, Base>(exec, &JSDOMPathTable, thisObject, propertyName, descriptor);
}

JSValue jsDOMPathConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMPath* domObject = jsCast<JSDOMPath*>(asObject(slotBase));
    return JSDOMPath::getConstructor(exec, domObject->globalObject());
}

JSValue JSDOMPath::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPathConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionClosePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    impl->closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionMoveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->moveTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionLineTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->lineTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionQuadraticCurveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    float cpx(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cpy(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->quadraticCurveTo(cpx, cpy, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionBezierCurveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    float cp1x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cp1y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cp2x(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cp2y(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(5).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionArcTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x1(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float radius(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->rect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsDOMPathPrototypeFunctionArc(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPath::s_info))
        return throwVMTypeError(exec);
    JSDOMPath* castedThis = jsCast<JSDOMPath*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDOMPath::s_info);
    DOMPath* impl = static_cast<DOMPath*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float radius(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float startAngle(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float endAngle(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool anticlockwise(exec->argument(5).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSDOMPath* jsDOMPath)
{
    if (jsDOMPath->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMPathOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMPath* jsDOMPath = jsCast<JSDOMPath*>(handle.get().asCell());
    if (!isObservable(jsDOMPath))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMPathOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMPath* jsDOMPath = jsCast<JSDOMPath*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMPath->impl(), jsDOMPath);
    jsDOMPath->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMPath@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore7DOMPathE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMPath* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMPath>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMPath@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore7DOMPathE[2];
#if COMPILER(CLANG)
    // If this fails DOMPath does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMPath), DOMPath_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMPath has subclasses. If DOMPath has subclasses that get passed
    // to toJS() we currently require DOMPath you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DOMPath>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDOMPath>(exec, globalObject, impl);
}

DOMPath* toDOMPath(JSC::JSValue value)
{
    return value.inherits(&JSDOMPath::s_info) ? jsCast<JSDOMPath*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(CANVAS_PATH)
