/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDOMFileSystemSync.h"

#include "DOMFileSystemSync.h"
#include "DirectoryEntrySync.h"
#include "JSDirectoryEntrySync.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMFileSystemSyncTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemSyncName), (intptr_t)0, NoIntrinsic },
    { "root", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemSyncRoot), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMFileSystemSyncTable = { 4, 3, JSDOMFileSystemSyncTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDOMFileSystemSyncPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMFileSystemSyncPrototypeTable = { 1, 0, JSDOMFileSystemSyncPrototypeTableValues, 0 };
static const HashTable* getJSDOMFileSystemSyncPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDOMFileSystemSyncPrototypeTable);
}

const ClassInfo JSDOMFileSystemSyncPrototype::s_info = { "DOMFileSystemSyncPrototype", &Base::s_info, 0, getJSDOMFileSystemSyncPrototypeTable, CREATE_METHOD_TABLE(JSDOMFileSystemSyncPrototype) };

JSObject* JSDOMFileSystemSyncPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMFileSystemSync>(exec, globalObject);
}

static const HashTable* getJSDOMFileSystemSyncTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDOMFileSystemSyncTable);
}

const ClassInfo JSDOMFileSystemSync::s_info = { "DOMFileSystemSync", &Base::s_info, 0, getJSDOMFileSystemSyncTable , CREATE_METHOD_TABLE(JSDOMFileSystemSync) };

JSDOMFileSystemSync::JSDOMFileSystemSync(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMFileSystemSync> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMFileSystemSync::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMFileSystemSync::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMFileSystemSyncPrototype::create(exec->vm(), globalObject, JSDOMFileSystemSyncPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDOMFileSystemSync::destroy(JSC::JSCell* cell)
{
    JSDOMFileSystemSync* thisObject = static_cast<JSDOMFileSystemSync*>(cell);
    thisObject->JSDOMFileSystemSync::~JSDOMFileSystemSync();
}

JSDOMFileSystemSync::~JSDOMFileSystemSync()
{
    releaseImplIfNotNull();
}

bool JSDOMFileSystemSync::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMFileSystemSync* thisObject = jsCast<JSDOMFileSystemSync*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMFileSystemSync, Base>(exec, getJSDOMFileSystemSyncTable(exec), thisObject, propertyName, slot);
}

bool JSDOMFileSystemSync::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMFileSystemSync* thisObject = jsCast<JSDOMFileSystemSync*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMFileSystemSync, Base>(exec, getJSDOMFileSystemSyncTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsDOMFileSystemSyncName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMFileSystemSync* castedThis = jsCast<JSDOMFileSystemSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMFileSystemSync* impl = static_cast<DOMFileSystemSync*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsDOMFileSystemSyncRoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMFileSystemSync* castedThis = jsCast<JSDOMFileSystemSync*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMFileSystemSync* impl = static_cast<DOMFileSystemSync*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->root()));
    return result;
}


static inline bool isObservable(JSDOMFileSystemSync* jsDOMFileSystemSync)
{
    if (jsDOMFileSystemSync->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMFileSystemSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMFileSystemSync* jsDOMFileSystemSync = jsCast<JSDOMFileSystemSync*>(handle.get().asCell());
    if (!isObservable(jsDOMFileSystemSync))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMFileSystemSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMFileSystemSync* jsDOMFileSystemSync = jsCast<JSDOMFileSystemSync*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMFileSystemSync->impl(), jsDOMFileSystemSync);
    jsDOMFileSystemSync->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMFileSystemSync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17DOMFileSystemSyncE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMFileSystemSync* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMFileSystemSync>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMFileSystemSync@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17DOMFileSystemSyncE[2];
#if COMPILER(CLANG)
    // If this fails DOMFileSystemSync does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMFileSystemSync), DOMFileSystemSync_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMFileSystemSync has subclasses. If DOMFileSystemSync has subclasses that get passed
    // to toJS() we currently require DOMFileSystemSync you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DOMFileSystemSync>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDOMFileSystemSync>(exec, globalObject, impl);
}

DOMFileSystemSync* toDOMFileSystemSync(JSC::JSValue value)
{
    return value.inherits(&JSDOMFileSystemSync::s_info) ? jsCast<JSDOMFileSystemSync*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
