/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILE_SYSTEM)

#include "JSDOMFileSystem.h"

#include "DOMFileSystem.h"
#include "DirectoryEntry.h"
#include "JSDirectoryEntry.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMFileSystemTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemName), (intptr_t)0, NoIntrinsic },
    { "root", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMFileSystemRoot), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMFileSystemTable = { 4, 3, JSDOMFileSystemTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDOMFileSystemPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMFileSystemPrototypeTable = { 1, 0, JSDOMFileSystemPrototypeTableValues, 0 };
static const HashTable* getJSDOMFileSystemPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDOMFileSystemPrototypeTable);
}

const ClassInfo JSDOMFileSystemPrototype::s_info = { "DOMFileSystemPrototype", &Base::s_info, 0, getJSDOMFileSystemPrototypeTable, CREATE_METHOD_TABLE(JSDOMFileSystemPrototype) };

JSObject* JSDOMFileSystemPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMFileSystem>(exec, globalObject);
}

static const HashTable* getJSDOMFileSystemTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSDOMFileSystemTable);
}

const ClassInfo JSDOMFileSystem::s_info = { "DOMFileSystem", &Base::s_info, 0, getJSDOMFileSystemTable , CREATE_METHOD_TABLE(JSDOMFileSystem) };

JSDOMFileSystem::JSDOMFileSystem(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMFileSystem> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMFileSystem::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMFileSystem::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMFileSystemPrototype::create(exec->vm(), globalObject, JSDOMFileSystemPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDOMFileSystem::destroy(JSC::JSCell* cell)
{
    JSDOMFileSystem* thisObject = static_cast<JSDOMFileSystem*>(cell);
    thisObject->JSDOMFileSystem::~JSDOMFileSystem();
}

JSDOMFileSystem::~JSDOMFileSystem()
{
    releaseImplIfNotNull();
}

bool JSDOMFileSystem::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMFileSystem* thisObject = jsCast<JSDOMFileSystem*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMFileSystem, Base>(exec, getJSDOMFileSystemTable(exec), thisObject, propertyName, slot);
}

bool JSDOMFileSystem::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMFileSystem* thisObject = jsCast<JSDOMFileSystem*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMFileSystem, Base>(exec, getJSDOMFileSystemTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsDOMFileSystemName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMFileSystem* castedThis = jsCast<JSDOMFileSystem*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMFileSystem* impl = static_cast<DOMFileSystem*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsDOMFileSystemRoot(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMFileSystem* castedThis = jsCast<JSDOMFileSystem*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMFileSystem* impl = static_cast<DOMFileSystem*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->root()));
    return result;
}


static inline bool isObservable(JSDOMFileSystem* jsDOMFileSystem)
{
    if (jsDOMFileSystem->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMFileSystemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMFileSystem* jsDOMFileSystem = jsCast<JSDOMFileSystem*>(handle.get().asCell());
    if (jsDOMFileSystem->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsDOMFileSystem))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMFileSystemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMFileSystem* jsDOMFileSystem = jsCast<JSDOMFileSystem*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMFileSystem->impl(), jsDOMFileSystem);
    jsDOMFileSystem->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DOMFileSystem@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13DOMFileSystemE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMFileSystem* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMFileSystem>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7DOMFileSystem@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13DOMFileSystemE[2];
#if COMPILER(CLANG)
    // If this fails DOMFileSystem does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(DOMFileSystem), DOMFileSystem_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // DOMFileSystem has subclasses. If DOMFileSystem has subclasses that get passed
    // to toJS() we currently require DOMFileSystem you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<DOMFileSystem>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDOMFileSystem>(exec, globalObject, impl);
}

DOMFileSystem* toDOMFileSystem(JSC::JSValue value)
{
    return value.inherits(&JSDOMFileSystem::s_info) ? jsCast<JSDOMFileSystem*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(FILE_SYSTEM)
