/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMError.h"

#include "DOMError.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMErrorTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMErrorName), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMErrorTable = { 2, 1, JSDOMErrorTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSDOMErrorPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMErrorPrototypeTable = { 1, 0, JSDOMErrorPrototypeTableValues, 0 };
const ClassInfo JSDOMErrorPrototype::s_info = { "DOMErrorPrototype", &Base::s_info, &JSDOMErrorPrototypeTable, 0, CREATE_METHOD_TABLE(JSDOMErrorPrototype) };

JSObject* JSDOMErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMError>(exec, globalObject);
}

const ClassInfo JSDOMError::s_info = { "DOMError", &Base::s_info, &JSDOMErrorTable, 0 , CREATE_METHOD_TABLE(JSDOMError) };

JSDOMError::JSDOMError(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMError> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMError::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMErrorPrototype::create(exec->vm(), globalObject, JSDOMErrorPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSDOMError::destroy(JSC::JSCell* cell)
{
    JSDOMError* thisObject = static_cast<JSDOMError*>(cell);
    thisObject->JSDOMError::~JSDOMError();
}

JSDOMError::~JSDOMError()
{
    releaseImplIfNotNull();
}

bool JSDOMError::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMError* thisObject = jsCast<JSDOMError*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMError, Base>(exec, &JSDOMErrorTable, thisObject, propertyName, slot);
}

bool JSDOMError::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMError* thisObject = jsCast<JSDOMError*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMError, Base>(exec, &JSDOMErrorTable, thisObject, propertyName, descriptor);
}

JSValue jsDOMErrorName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMError* castedThis = jsCast<JSDOMError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMError* impl = static_cast<DOMError*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


static inline bool isObservable(JSDOMError* jsDOMError)
{
    if (jsDOMError->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMError* jsDOMError = jsCast<JSDOMError*>(handle.get().asCell());
    if (!isObservable(jsDOMError))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMError* jsDOMError = jsCast<JSDOMError*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMError->impl(), jsDOMError);
    jsDOMError->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMError* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSDOMError>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMError.
    COMPILE_ASSERT(!__is_polymorphic(DOMError), DOMError_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<DOMError>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSDOMError>(exec, globalObject, impl);
}

DOMError* toDOMError(JSC::JSValue value)
{
    return value.inherits(&JSDOMError::s_info) ? jsCast<JSDOMError*>(asObject(value))->impl() : 0;
}

}
