/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CUSTOM_ELEMENTS)

#include "JSCustomElementConstructor.h"

#include "CustomElementConstructor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSCustomElementConstructorPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCustomElementConstructorPrototypeTable = { 1, 0, JSCustomElementConstructorPrototypeTableValues, 0 };
const ClassInfo JSCustomElementConstructorPrototype::s_info = { "CustomElementConstructorPrototype", &Base::s_info, &JSCustomElementConstructorPrototypeTable, 0, CREATE_METHOD_TABLE(JSCustomElementConstructorPrototype) };

JSObject* JSCustomElementConstructorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCustomElementConstructor>(exec, globalObject);
}

const ClassInfo JSCustomElementConstructor::s_info = { "CustomElementConstructor", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSCustomElementConstructor) };

JSCustomElementConstructor::JSCustomElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CustomElementConstructor> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCustomElementConstructor::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCustomElementConstructor::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCustomElementConstructorPrototype::create(exec->vm(), globalObject, JSCustomElementConstructorPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSCustomElementConstructor::destroy(JSC::JSCell* cell)
{
    JSCustomElementConstructor* thisObject = static_cast<JSCustomElementConstructor*>(cell);
    thisObject->JSCustomElementConstructor::~JSCustomElementConstructor();
}

JSCustomElementConstructor::~JSCustomElementConstructor()
{
    releaseImplIfNotNull();
}

static inline bool isObservable(JSCustomElementConstructor* jsCustomElementConstructor)
{
    if (jsCustomElementConstructor->hasCustomProperties())
        return true;
    return false;
}

bool JSCustomElementConstructorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCustomElementConstructor* jsCustomElementConstructor = jsCast<JSCustomElementConstructor*>(handle.get().asCell());
    if (!isObservable(jsCustomElementConstructor))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSCustomElementConstructorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCustomElementConstructor* jsCustomElementConstructor = jsCast<JSCustomElementConstructor*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCustomElementConstructor->impl(), jsCustomElementConstructor);
    jsCustomElementConstructor->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CustomElementConstructor@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24CustomElementConstructorE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, CustomElementConstructor* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCustomElementConstructor>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7CustomElementConstructor@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24CustomElementConstructorE[2];
#if COMPILER(CLANG)
    // If this fails CustomElementConstructor does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(CustomElementConstructor), CustomElementConstructor_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // CustomElementConstructor has subclasses. If CustomElementConstructor has subclasses that get passed
    // to toJS() we currently require CustomElementConstructor you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<CustomElementConstructor>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSCustomElementConstructor>(exec, globalObject, impl);
}

CustomElementConstructor* toCustomElementConstructor(JSC::JSValue value)
{
    return value.inherits(&JSCustomElementConstructor::s_info) ? jsCast<JSCustomElementConstructor*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(CUSTOM_ELEMENTS)
