/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCrypto.h"

#include "Crypto.h"
#include <runtime/Error.h>
#include <wtf/ArrayBufferView.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSCryptoPrototypeTableValues[] =
{
    { "getRandomValues", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCryptoPrototypeFunctionGetRandomValues), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCryptoPrototypeTable = { 2, 1, JSCryptoPrototypeTableValues, 0 };
const ClassInfo JSCryptoPrototype::s_info = { "CryptoPrototype", &Base::s_info, &JSCryptoPrototypeTable, 0, CREATE_METHOD_TABLE(JSCryptoPrototype) };

JSObject* JSCryptoPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCrypto>(exec, globalObject);
}

bool JSCryptoPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCryptoPrototype* thisObject = jsCast<JSCryptoPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCryptoPrototypeTable, thisObject, propertyName, slot);
}

bool JSCryptoPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCryptoPrototype* thisObject = jsCast<JSCryptoPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCryptoPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCrypto::s_info = { "Crypto", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSCrypto) };

JSCrypto::JSCrypto(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Crypto> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCrypto::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCrypto::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCryptoPrototype::create(exec->vm(), globalObject, JSCryptoPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSCrypto::destroy(JSC::JSCell* cell)
{
    JSCrypto* thisObject = static_cast<JSCrypto*>(cell);
    thisObject->JSCrypto::~JSCrypto();
}

JSCrypto::~JSCrypto()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsCryptoPrototypeFunctionGetRandomValues(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCrypto::s_info))
        return throwVMTypeError(exec);
    JSCrypto* castedThis = jsCast<JSCrypto*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCrypto::s_info);
    return JSValue::encode(castedThis->getRandomValues(exec));
}

static inline bool isObservable(JSCrypto* jsCrypto)
{
    if (jsCrypto->hasCustomProperties())
        return true;
    return false;
}

bool JSCryptoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCrypto* jsCrypto = jsCast<JSCrypto*>(handle.get().asCell());
    if (!isObservable(jsCrypto))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSCryptoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCrypto* jsCrypto = jsCast<JSCrypto*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCrypto->impl(), jsCrypto);
    jsCrypto->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Crypto* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCrypto>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Crypto.
    COMPILE_ASSERT(!__is_polymorphic(Crypto), Crypto_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<Crypto>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSCrypto>(exec, globalObject, impl);
}

Crypto* toCrypto(JSC::JSValue value)
{
    return value.inherits(&JSCrypto::s_info) ? jsCast<JSCrypto*>(asObject(value))->impl() : 0;
}

}
