/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSCoordinates.h"

#include "Coordinates.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCoordinatesTableValues[] =
{
    { "latitude", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesLatitude), (intptr_t)0, NoIntrinsic },
    { "longitude", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesLongitude), (intptr_t)0, NoIntrinsic },
    { "altitude", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesAltitude), (intptr_t)0, NoIntrinsic },
    { "accuracy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesAccuracy), (intptr_t)0, NoIntrinsic },
    { "altitudeAccuracy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesAltitudeAccuracy), (intptr_t)0, NoIntrinsic },
    { "heading", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesHeading), (intptr_t)0, NoIntrinsic },
    { "speed", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCoordinatesSpeed), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCoordinatesTable = { 16, 15, JSCoordinatesTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSCoordinatesPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCoordinatesPrototypeTable = { 1, 0, JSCoordinatesPrototypeTableValues, 0 };
const ClassInfo JSCoordinatesPrototype::s_info = { "CoordinatesPrototype", &Base::s_info, &JSCoordinatesPrototypeTable, 0, CREATE_METHOD_TABLE(JSCoordinatesPrototype) };

JSObject* JSCoordinatesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCoordinates>(exec, globalObject);
}

const ClassInfo JSCoordinates::s_info = { "Coordinates", &Base::s_info, &JSCoordinatesTable, 0 , CREATE_METHOD_TABLE(JSCoordinates) };

JSCoordinates::JSCoordinates(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Coordinates> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCoordinates::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCoordinates::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCoordinatesPrototype::create(exec->vm(), globalObject, JSCoordinatesPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSCoordinates::destroy(JSC::JSCell* cell)
{
    JSCoordinates* thisObject = static_cast<JSCoordinates*>(cell);
    thisObject->JSCoordinates::~JSCoordinates();
}

JSCoordinates::~JSCoordinates()
{
    releaseImplIfNotNull();
}

bool JSCoordinates::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCoordinates* thisObject = jsCast<JSCoordinates*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCoordinates, Base>(exec, &JSCoordinatesTable, thisObject, propertyName, slot);
}

bool JSCoordinates::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCoordinates* thisObject = jsCast<JSCoordinates*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCoordinates, Base>(exec, &JSCoordinatesTable, thisObject, propertyName, descriptor);
}

JSValue jsCoordinatesLatitude(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->latitude());
    return result;
}


JSValue jsCoordinatesLongitude(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->longitude());
    return result;
}


JSValue jsCoordinatesAltitude(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    bool isNull = false;
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->altitude(isNull));
    if (isNull)
        return jsNull();
    return result;
}


JSValue jsCoordinatesAccuracy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->accuracy());
    return result;
}


JSValue jsCoordinatesAltitudeAccuracy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    bool isNull = false;
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->altitudeAccuracy(isNull));
    if (isNull)
        return jsNull();
    return result;
}


JSValue jsCoordinatesHeading(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    bool isNull = false;
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->heading(isNull));
    if (isNull)
        return jsNull();
    return result;
}


JSValue jsCoordinatesSpeed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCoordinates* castedThis = jsCast<JSCoordinates*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    bool isNull = false;
    Coordinates* impl = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(impl->speed(isNull));
    if (isNull)
        return jsNull();
    return result;
}


static inline bool isObservable(JSCoordinates* jsCoordinates)
{
    if (jsCoordinates->hasCustomProperties())
        return true;
    return false;
}

bool JSCoordinatesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSCoordinates* jsCoordinates = jsCast<JSCoordinates*>(handle.get().asCell());
    if (!isObservable(jsCoordinates))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSCoordinatesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSCoordinates* jsCoordinates = jsCast<JSCoordinates*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsCoordinates->impl(), jsCoordinates);
    jsCoordinates->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Coordinates* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSCoordinates>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Coordinates.
    COMPILE_ASSERT(!__is_polymorphic(Coordinates), Coordinates_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<Coordinates>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSCoordinates>(exec, globalObject, impl);
}

Coordinates* toCoordinates(JSC::JSValue value)
{
    return value.inherits(&JSCoordinates::s_info) ? jsCast<JSCoordinates*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
