/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClientRect.h"

#include "ClientRect.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSClientRectTableValues[] =
{
    { "top", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectTop), (intptr_t)0, NoIntrinsic },
    { "right", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectRight), (intptr_t)0, NoIntrinsic },
    { "bottom", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectBottom), (intptr_t)0, NoIntrinsic },
    { "left", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectLeft), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectHeight), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClientRectConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSClientRectTable = { 18, 15, JSClientRectTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSClientRectConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSClientRectConstructorTable = { 1, 0, JSClientRectConstructorTableValues, 0 };
const ClassInfo JSClientRectConstructor::s_info = { "ClientRectConstructor", &Base::s_info, &JSClientRectConstructorTable, 0, CREATE_METHOD_TABLE(JSClientRectConstructor) };

JSClientRectConstructor::JSClientRectConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSClientRectConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSClientRectPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSClientRectConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClientRectConstructor, JSDOMWrapper>(exec, &JSClientRectConstructorTable, jsCast<JSClientRectConstructor*>(cell), propertyName, slot);
}

bool JSClientRectConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSClientRectConstructor, JSDOMWrapper>(exec, &JSClientRectConstructorTable, jsCast<JSClientRectConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSClientRectPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSClientRectPrototypeTable = { 1, 0, JSClientRectPrototypeTableValues, 0 };
const ClassInfo JSClientRectPrototype::s_info = { "ClientRectPrototype", &Base::s_info, &JSClientRectPrototypeTable, 0, CREATE_METHOD_TABLE(JSClientRectPrototype) };

JSObject* JSClientRectPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClientRect>(exec, globalObject);
}

const ClassInfo JSClientRect::s_info = { "ClientRect", &Base::s_info, &JSClientRectTable, 0 , CREATE_METHOD_TABLE(JSClientRect) };

JSClientRect::JSClientRect(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ClientRect> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSClientRect::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSClientRect::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSClientRectPrototype::create(exec->vm(), globalObject, JSClientRectPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSClientRect::destroy(JSC::JSCell* cell)
{
    JSClientRect* thisObject = static_cast<JSClientRect*>(cell);
    thisObject->JSClientRect::~JSClientRect();
}

JSClientRect::~JSClientRect()
{
    releaseImplIfNotNull();
}

bool JSClientRect::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSClientRect* thisObject = jsCast<JSClientRect*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSClientRect, Base>(exec, &JSClientRectTable, thisObject, propertyName, slot);
}

bool JSClientRect::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSClientRect* thisObject = jsCast<JSClientRect*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSClientRect, Base>(exec, &JSClientRectTable, thisObject, propertyName, descriptor);
}

JSValue jsClientRectTop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* castedThis = jsCast<JSClientRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRect* impl = static_cast<ClientRect*>(castedThis->impl());
    JSValue result = jsNumber(impl->top());
    return result;
}


JSValue jsClientRectRight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* castedThis = jsCast<JSClientRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRect* impl = static_cast<ClientRect*>(castedThis->impl());
    JSValue result = jsNumber(impl->right());
    return result;
}


JSValue jsClientRectBottom(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* castedThis = jsCast<JSClientRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRect* impl = static_cast<ClientRect*>(castedThis->impl());
    JSValue result = jsNumber(impl->bottom());
    return result;
}


JSValue jsClientRectLeft(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* castedThis = jsCast<JSClientRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRect* impl = static_cast<ClientRect*>(castedThis->impl());
    JSValue result = jsNumber(impl->left());
    return result;
}


JSValue jsClientRectWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* castedThis = jsCast<JSClientRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRect* impl = static_cast<ClientRect*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsClientRectHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* castedThis = jsCast<JSClientRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ClientRect* impl = static_cast<ClientRect*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsClientRectConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSClientRect* domObject = jsCast<JSClientRect*>(asObject(slotBase));
    return JSClientRect::getConstructor(exec, domObject->globalObject());
}

JSValue JSClientRect::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClientRectConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSClientRect* jsClientRect)
{
    if (jsClientRect->hasCustomProperties())
        return true;
    return false;
}

bool JSClientRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSClientRect* jsClientRect = jsCast<JSClientRect*>(handle.get().asCell());
    if (!isObservable(jsClientRect))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSClientRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSClientRect* jsClientRect = jsCast<JSClientRect*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsClientRect->impl(), jsClientRect);
    jsClientRect->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ClientRect* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSClientRect>(exec, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ClientRect.
    COMPILE_ASSERT(!__is_polymorphic(ClientRect), ClientRect_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<ClientRect>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSClientRect>(exec, globalObject, impl);
}

ClientRect* toClientRect(JSC::JSValue value)
{
    return value.inherits(&JSClientRect::s_info) ? jsCast<JSClientRect*>(asObject(value))->impl() : 0;
}

}
