/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSChannelMergerNode.h"

#include "ChannelMergerNode.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSChannelMergerNodeTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsChannelMergerNodeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSChannelMergerNodeTable = { 2, 1, JSChannelMergerNodeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSChannelMergerNodeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSChannelMergerNodeConstructorTable = { 1, 0, JSChannelMergerNodeConstructorTableValues, 0 };
const ClassInfo JSChannelMergerNodeConstructor::s_info = { "ChannelMergerNodeConstructor", &Base::s_info, &JSChannelMergerNodeConstructorTable, 0, CREATE_METHOD_TABLE(JSChannelMergerNodeConstructor) };

JSChannelMergerNodeConstructor::JSChannelMergerNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSChannelMergerNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSChannelMergerNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSChannelMergerNodeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSChannelMergerNodeConstructor, JSDOMWrapper>(exec, &JSChannelMergerNodeConstructorTable, jsCast<JSChannelMergerNodeConstructor*>(cell), propertyName, slot);
}

bool JSChannelMergerNodeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSChannelMergerNodeConstructor, JSDOMWrapper>(exec, &JSChannelMergerNodeConstructorTable, jsCast<JSChannelMergerNodeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSChannelMergerNodePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSChannelMergerNodePrototypeTable = { 1, 0, JSChannelMergerNodePrototypeTableValues, 0 };
const ClassInfo JSChannelMergerNodePrototype::s_info = { "ChannelMergerNodePrototype", &Base::s_info, &JSChannelMergerNodePrototypeTable, 0, CREATE_METHOD_TABLE(JSChannelMergerNodePrototype) };

JSObject* JSChannelMergerNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSChannelMergerNode>(exec, globalObject);
}

const ClassInfo JSChannelMergerNode::s_info = { "ChannelMergerNode", &Base::s_info, &JSChannelMergerNodeTable, 0 , CREATE_METHOD_TABLE(JSChannelMergerNode) };

JSChannelMergerNode::JSChannelMergerNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ChannelMergerNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSChannelMergerNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSChannelMergerNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSChannelMergerNodePrototype::create(exec->vm(), globalObject, JSChannelMergerNodePrototype::createStructure(exec->vm(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSChannelMergerNode::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSChannelMergerNode* thisObject = jsCast<JSChannelMergerNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSChannelMergerNode, Base>(exec, &JSChannelMergerNodeTable, thisObject, propertyName, slot);
}

bool JSChannelMergerNode::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSChannelMergerNode* thisObject = jsCast<JSChannelMergerNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSChannelMergerNode, Base>(exec, &JSChannelMergerNodeTable, thisObject, propertyName, descriptor);
}

JSValue jsChannelMergerNodeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSChannelMergerNode* domObject = jsCast<JSChannelMergerNode*>(asObject(slotBase));
    return JSChannelMergerNode::getConstructor(exec, domObject->globalObject());
}

JSValue JSChannelMergerNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSChannelMergerNodeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ChannelMergerNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17ChannelMergerNodeE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ChannelMergerNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSChannelMergerNode>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7ChannelMergerNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17ChannelMergerNodeE[2];
#if COMPILER(CLANG)
    // If this fails ChannelMergerNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(ChannelMergerNode), ChannelMergerNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // ChannelMergerNode has subclasses. If ChannelMergerNode has subclasses that get passed
    // to toJS() we currently require ChannelMergerNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<ChannelMergerNode>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSChannelMergerNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
