/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSAudioTrack.h"

#include "AudioTrack.h"
#include "Element.h"
#include "JSNodeCustom.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAudioTrackTableValues[] =
{
    { "id", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackId), (intptr_t)0, NoIntrinsic },
    { "kind", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackKind), (intptr_t)0, NoIntrinsic },
    { "label", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackLabel), (intptr_t)0, NoIntrinsic },
    { "language", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackLanguage), (intptr_t)0, NoIntrinsic },
    { "enabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackEnabled), (intptr_t)setJSAudioTrackEnabled, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioTrackTable = { 16, 15, JSAudioTrackTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSAudioTrackPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioTrackPrototypeTable = { 1, 0, JSAudioTrackPrototypeTableValues, 0 };
const ClassInfo JSAudioTrackPrototype::s_info = { "AudioTrackPrototype", &Base::s_info, &JSAudioTrackPrototypeTable, 0, CREATE_METHOD_TABLE(JSAudioTrackPrototype) };

JSObject* JSAudioTrackPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioTrack>(exec, globalObject);
}

const ClassInfo JSAudioTrack::s_info = { "AudioTrack", &Base::s_info, &JSAudioTrackTable, 0 , CREATE_METHOD_TABLE(JSAudioTrack) };

JSAudioTrack::JSAudioTrack(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioTrack> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSAudioTrack::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioTrack::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioTrackPrototype::create(exec->vm(), globalObject, JSAudioTrackPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSAudioTrack::destroy(JSC::JSCell* cell)
{
    JSAudioTrack* thisObject = static_cast<JSAudioTrack*>(cell);
    thisObject->JSAudioTrack::~JSAudioTrack();
}

JSAudioTrack::~JSAudioTrack()
{
    releaseImplIfNotNull();
}

bool JSAudioTrack::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAudioTrack* thisObject = jsCast<JSAudioTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSAudioTrack, Base>(exec, &JSAudioTrackTable, thisObject, propertyName, slot);
}

bool JSAudioTrack::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAudioTrack* thisObject = jsCast<JSAudioTrack*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSAudioTrack, Base>(exec, &JSAudioTrackTable, thisObject, propertyName, descriptor);
}

JSValue jsAudioTrackId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrack* castedThis = jsCast<JSAudioTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrack* impl = static_cast<AudioTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->id());
    return result;
}


JSValue jsAudioTrackKind(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrack* castedThis = jsCast<JSAudioTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrack* impl = static_cast<AudioTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->kind());
    return result;
}


JSValue jsAudioTrackLabel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrack* castedThis = jsCast<JSAudioTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrack* impl = static_cast<AudioTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->label());
    return result;
}


JSValue jsAudioTrackLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrack* castedThis = jsCast<JSAudioTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrack* impl = static_cast<AudioTrack*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->language());
    return result;
}


JSValue jsAudioTrackEnabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioTrack* castedThis = jsCast<JSAudioTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioTrack* impl = static_cast<AudioTrack*>(castedThis->impl());
    JSValue result = jsBoolean(impl->enabled());
    return result;
}


void JSAudioTrack::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSAudioTrack* thisObject = jsCast<JSAudioTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSAudioTrack, Base>(exec, propertyName, value, &JSAudioTrackTable, thisObject, slot);
}

void setJSAudioTrackEnabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAudioTrack* castedThis = jsCast<JSAudioTrack*>(thisObject);
    AudioTrack* impl = static_cast<AudioTrack*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setEnabled(nativeValue);
}


static inline bool isObservable(JSAudioTrack* jsAudioTrack)
{
    if (jsAudioTrack->hasCustomProperties())
        return true;
    return false;
}

bool JSAudioTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAudioTrack* jsAudioTrack = jsCast<JSAudioTrack*>(handle.get().asCell());
    if (!isObservable(jsAudioTrack))
        return false;
    Element* element = jsAudioTrack->impl()->element();
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSAudioTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAudioTrack* jsAudioTrack = jsCast<JSAudioTrack*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioTrack->impl(), jsAudioTrack);
    jsAudioTrack->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioTrack@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10AudioTrackE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioTrack* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioTrack>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioTrack@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10AudioTrackE[2];
#if COMPILER(CLANG)
    // If this fails AudioTrack does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioTrack), AudioTrack_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioTrack has subclasses. If AudioTrack has subclasses that get passed
    // to toJS() we currently require AudioTrack you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<AudioTrack>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSAudioTrack>(exec, globalObject, impl);
}

AudioTrack* toAudioTrack(JSC::JSValue value)
{
    return value.inherits(&JSAudioTrack::s_info) ? jsCast<JSAudioTrack*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO_TRACK)
