/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioParam.h"

#include "AudioParam.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSFloat32Array.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAudioParamTableValues[] =
{
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamValue), (intptr_t)setJSAudioParamValue, NoIntrinsic },
    { "minValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamMinValue), (intptr_t)0, NoIntrinsic },
    { "maxValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamMaxValue), (intptr_t)0, NoIntrinsic },
    { "defaultValue", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamDefaultValue), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamName), (intptr_t)0, NoIntrinsic },
    { "units", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamUnits), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioParamConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioParamTable = { 18, 15, JSAudioParamTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSAudioParamConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioParamConstructorTable = { 1, 0, JSAudioParamConstructorTableValues, 0 };
const ClassInfo JSAudioParamConstructor::s_info = { "AudioParamConstructor", &Base::s_info, &JSAudioParamConstructorTable, 0, CREATE_METHOD_TABLE(JSAudioParamConstructor) };

JSAudioParamConstructor::JSAudioParamConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAudioParamConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSAudioParamPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSAudioParamConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAudioParamConstructor, JSDOMWrapper>(exec, &JSAudioParamConstructorTable, jsCast<JSAudioParamConstructor*>(cell), propertyName, slot);
}

bool JSAudioParamConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAudioParamConstructor, JSDOMWrapper>(exec, &JSAudioParamConstructorTable, jsCast<JSAudioParamConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSAudioParamPrototypeTableValues[] =
{
    { "setValueAtTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetValueAtTime), (intptr_t)2, NoIntrinsic },
    { "linearRampToValueAtTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionLinearRampToValueAtTime), (intptr_t)2, NoIntrinsic },
    { "exponentialRampToValueAtTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionExponentialRampToValueAtTime), (intptr_t)2, NoIntrinsic },
    { "setTargetAtTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetTargetAtTime), (intptr_t)3, NoIntrinsic },
    { "setValueCurveAtTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetValueCurveAtTime), (intptr_t)3, NoIntrinsic },
    { "cancelScheduledValues", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionCancelScheduledValues), (intptr_t)1, NoIntrinsic },
#if ENABLE(LEGACY_WEB_AUDIO)
    { "setTargetValueAtTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAudioParamPrototypeFunctionSetTargetValueAtTime), (intptr_t)3, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioParamPrototypeTable = { 18, 15, JSAudioParamPrototypeTableValues, 0 };
const ClassInfo JSAudioParamPrototype::s_info = { "AudioParamPrototype", &Base::s_info, &JSAudioParamPrototypeTable, 0, CREATE_METHOD_TABLE(JSAudioParamPrototype) };

JSObject* JSAudioParamPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioParam>(exec, globalObject);
}

bool JSAudioParamPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAudioParamPrototype* thisObject = jsCast<JSAudioParamPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSAudioParamPrototypeTable, thisObject, propertyName, slot);
}

bool JSAudioParamPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAudioParamPrototype* thisObject = jsCast<JSAudioParamPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAudioParamPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSAudioParam::s_info = { "AudioParam", &Base::s_info, &JSAudioParamTable, 0 , CREATE_METHOD_TABLE(JSAudioParam) };

JSAudioParam::JSAudioParam(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioParam> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSAudioParam::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioParam::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioParamPrototype::create(exec->vm(), globalObject, JSAudioParamPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSAudioParam::destroy(JSC::JSCell* cell)
{
    JSAudioParam* thisObject = static_cast<JSAudioParam*>(cell);
    thisObject->JSAudioParam::~JSAudioParam();
}

JSAudioParam::~JSAudioParam()
{
    releaseImplIfNotNull();
}

bool JSAudioParam::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAudioParam* thisObject = jsCast<JSAudioParam*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSAudioParam, Base>(exec, &JSAudioParamTable, thisObject, propertyName, slot);
}

bool JSAudioParam::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAudioParam* thisObject = jsCast<JSAudioParam*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSAudioParam, Base>(exec, &JSAudioParamTable, thisObject, propertyName, descriptor);
}

JSValue jsAudioParamValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(impl->value());
    return result;
}


JSValue jsAudioParamMinValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(impl->minValue());
    return result;
}


JSValue jsAudioParamMaxValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(impl->maxValue());
    return result;
}


JSValue jsAudioParamDefaultValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(impl->defaultValue());
    return result;
}


JSValue jsAudioParamName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsAudioParamUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    JSValue result = jsNumber(impl->units());
    return result;
}


JSValue jsAudioParamConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioParam* domObject = jsCast<JSAudioParam*>(asObject(slotBase));
    return JSAudioParam::getConstructor(exec, domObject->globalObject());
}

void JSAudioParam::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSAudioParam* thisObject = jsCast<JSAudioParam*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSAudioParam, Base>(exec, propertyName, value, &JSAudioParamTable, thisObject, slot);
}

void setJSAudioParamValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(thisObject);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setValue(nativeValue);
}


JSValue JSAudioParam::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioParamConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float value(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionLinearRampToValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float value(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->linearRampToValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionExponentialRampToValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float value(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->exponentialRampToValueAtTime(value, time);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float target(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float timeConstant(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTargetAtTime(target, time, timeConstant);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetValueCurveAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Float32Array* values(toFloat32Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float duration(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setValueCurveAtTime(values, time, duration);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionCancelScheduledValues(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float startTime(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->cancelScheduledValues(startTime);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(LEGACY_WEB_AUDIO)
EncodedJSValue JSC_HOST_CALL jsAudioParamPrototypeFunctionSetTargetValueAtTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAudioParam::s_info))
        return throwVMTypeError(exec);
    JSAudioParam* castedThis = jsCast<JSAudioParam*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAudioParam::s_info);
    AudioParam* impl = static_cast<AudioParam*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float targetValue(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float time(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float timeConstant(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTargetAtTime(targetValue, time, timeConstant);
    return JSValue::encode(jsUndefined());
}

#endif

static inline bool isObservable(JSAudioParam* jsAudioParam)
{
    if (jsAudioParam->hasCustomProperties())
        return true;
    return false;
}

bool JSAudioParamOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAudioParam* jsAudioParam = jsCast<JSAudioParam*>(handle.get().asCell());
    if (!isObservable(jsAudioParam))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSAudioParamOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAudioParam* jsAudioParam = jsCast<JSAudioParam*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioParam->impl(), jsAudioParam);
    jsAudioParam->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioParam@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10AudioParamE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioParam* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioParam>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AudioParam@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10AudioParamE[2];
#if COMPILER(CLANG)
    // If this fails AudioParam does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AudioParam), AudioParam_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AudioParam has subclasses. If AudioParam has subclasses that get passed
    // to toJS() we currently require AudioParam you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<AudioParam>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSAudioParam>(exec, globalObject, impl);
}

AudioParam* toAudioParam(JSC::JSValue value)
{
    return value.inherits(&JSAudioParam::s_info) ? jsCast<JSAudioParam*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_AUDIO)
