/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioDestinationNode.h"

#include "AudioDestinationNode.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAudioDestinationNodeTableValues[] =
{
    { "maxChannelCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioDestinationNodeMaxChannelCount), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioDestinationNodeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioDestinationNodeTable = { 5, 3, JSAudioDestinationNodeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSAudioDestinationNodeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioDestinationNodeConstructorTable = { 1, 0, JSAudioDestinationNodeConstructorTableValues, 0 };
const ClassInfo JSAudioDestinationNodeConstructor::s_info = { "AudioDestinationNodeConstructor", &Base::s_info, &JSAudioDestinationNodeConstructorTable, 0, CREATE_METHOD_TABLE(JSAudioDestinationNodeConstructor) };

JSAudioDestinationNodeConstructor::JSAudioDestinationNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAudioDestinationNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSAudioDestinationNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSAudioDestinationNodeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAudioDestinationNodeConstructor, JSDOMWrapper>(exec, &JSAudioDestinationNodeConstructorTable, jsCast<JSAudioDestinationNodeConstructor*>(cell), propertyName, slot);
}

bool JSAudioDestinationNodeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAudioDestinationNodeConstructor, JSDOMWrapper>(exec, &JSAudioDestinationNodeConstructorTable, jsCast<JSAudioDestinationNodeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSAudioDestinationNodePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAudioDestinationNodePrototypeTable = { 1, 0, JSAudioDestinationNodePrototypeTableValues, 0 };
const ClassInfo JSAudioDestinationNodePrototype::s_info = { "AudioDestinationNodePrototype", &Base::s_info, &JSAudioDestinationNodePrototypeTable, 0, CREATE_METHOD_TABLE(JSAudioDestinationNodePrototype) };

JSObject* JSAudioDestinationNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioDestinationNode>(exec, globalObject);
}

const ClassInfo JSAudioDestinationNode::s_info = { "AudioDestinationNode", &Base::s_info, &JSAudioDestinationNodeTable, 0 , CREATE_METHOD_TABLE(JSAudioDestinationNode) };

JSAudioDestinationNode::JSAudioDestinationNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AudioDestinationNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSAudioDestinationNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAudioDestinationNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAudioDestinationNodePrototype::create(exec->vm(), globalObject, JSAudioDestinationNodePrototype::createStructure(exec->vm(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSAudioDestinationNode::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAudioDestinationNode* thisObject = jsCast<JSAudioDestinationNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSAudioDestinationNode, Base>(exec, &JSAudioDestinationNodeTable, thisObject, propertyName, slot);
}

bool JSAudioDestinationNode::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAudioDestinationNode* thisObject = jsCast<JSAudioDestinationNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSAudioDestinationNode, Base>(exec, &JSAudioDestinationNodeTable, thisObject, propertyName, descriptor);
}

JSValue jsAudioDestinationNodeMaxChannelCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioDestinationNode* castedThis = jsCast<JSAudioDestinationNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AudioDestinationNode* impl = static_cast<AudioDestinationNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->maxChannelCount());
    return result;
}


JSValue jsAudioDestinationNodeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAudioDestinationNode* domObject = jsCast<JSAudioDestinationNode*>(asObject(slotBase));
    return JSAudioDestinationNode::getConstructor(exec, domObject->globalObject());
}

JSValue JSAudioDestinationNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioDestinationNodeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AudioDestinationNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioDestinationNode>(exec, impl))
        return result;
    ReportMemoryCost<AudioDestinationNode>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSAudioDestinationNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
