/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAsyncImageDecoder.h"

#include "AsyncImageDecoder.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSHTMLImageElement.h"
#include "JSVoidCallback.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSAsyncImageDecoderPrototypeTableValues[] =
{
    { "decode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAsyncImageDecoderPrototypeFunctionDecode), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAsyncImageDecoderPrototypeTable = { 2, 1, JSAsyncImageDecoderPrototypeTableValues, 0 };
const ClassInfo JSAsyncImageDecoderPrototype::s_info = { "AsyncImageDecoderPrototype", &Base::s_info, &JSAsyncImageDecoderPrototypeTable, 0, CREATE_METHOD_TABLE(JSAsyncImageDecoderPrototype) };

JSObject* JSAsyncImageDecoderPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAsyncImageDecoder>(exec, globalObject);
}

bool JSAsyncImageDecoderPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAsyncImageDecoderPrototype* thisObject = jsCast<JSAsyncImageDecoderPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSAsyncImageDecoderPrototypeTable, thisObject, propertyName, slot);
}

bool JSAsyncImageDecoderPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAsyncImageDecoderPrototype* thisObject = jsCast<JSAsyncImageDecoderPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAsyncImageDecoderPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSAsyncImageDecoder::s_info = { "AsyncImageDecoder", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSAsyncImageDecoder) };

JSAsyncImageDecoder::JSAsyncImageDecoder(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AsyncImageDecoder> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSAsyncImageDecoder::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAsyncImageDecoder::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAsyncImageDecoderPrototype::create(exec->vm(), globalObject, JSAsyncImageDecoderPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSAsyncImageDecoder::destroy(JSC::JSCell* cell)
{
    JSAsyncImageDecoder* thisObject = static_cast<JSAsyncImageDecoder*>(cell);
    thisObject->JSAsyncImageDecoder::~JSAsyncImageDecoder();
}

JSAsyncImageDecoder::~JSAsyncImageDecoder()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsAsyncImageDecoderPrototypeFunctionDecode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAsyncImageDecoder::s_info))
        return throwVMTypeError(exec);
    JSAsyncImageDecoder* castedThis = jsCast<JSAsyncImageDecoder*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAsyncImageDecoder::s_info);
    AsyncImageDecoder* impl = static_cast<AsyncImageDecoder*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    HTMLImageElement* img(toHTMLImageElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<VoidCallback> resultCallback;
    if (exec->argumentCount() > 1 && !exec->argument(1).isUndefinedOrNull()) {
        if (!exec->argument(1).isFunction())
            return throwVMTypeError(exec);
        resultCallback = JSVoidCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    }
    impl->decode(img, resultCallback);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSAsyncImageDecoder* jsAsyncImageDecoder)
{
    if (jsAsyncImageDecoder->hasCustomProperties())
        return true;
    return false;
}

bool JSAsyncImageDecoderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAsyncImageDecoder* jsAsyncImageDecoder = jsCast<JSAsyncImageDecoder*>(handle.get().asCell());
    if (!isObservable(jsAsyncImageDecoder))
        return false;
    Frame* root = jsAsyncImageDecoder->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSAsyncImageDecoderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAsyncImageDecoder* jsAsyncImageDecoder = jsCast<JSAsyncImageDecoder*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAsyncImageDecoder->impl(), jsAsyncImageDecoder);
    jsAsyncImageDecoder->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AsyncImageDecoder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17AsyncImageDecoderE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AsyncImageDecoder* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAsyncImageDecoder>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AsyncImageDecoder@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17AsyncImageDecoderE[2];
#if COMPILER(CLANG)
    // If this fails AsyncImageDecoder does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AsyncImageDecoder), AsyncImageDecoder_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AsyncImageDecoder has subclasses. If AsyncImageDecoder has subclasses that get passed
    // to toJS() we currently require AsyncImageDecoder you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<AsyncImageDecoder>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSAsyncImageDecoder>(exec, globalObject, impl);
}

AsyncImageDecoder* toAsyncImageDecoder(JSC::JSValue value)
{
    return value.inherits(&JSAsyncImageDecoder::s_info) ? jsCast<JSAsyncImageDecoder*>(asObject(value))->impl() : 0;
}

}
