/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAnalyserNode.h"

#include "AnalyserNode.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSFloat32Array.h"
#include "JSUint8Array.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAnalyserNodeTableValues[] =
{
    { "fftSize", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeFftSize), (intptr_t)setJSAnalyserNodeFftSize, NoIntrinsic },
    { "frequencyBinCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeFrequencyBinCount), (intptr_t)0, NoIntrinsic },
    { "minDecibels", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeMinDecibels), (intptr_t)setJSAnalyserNodeMinDecibels, NoIntrinsic },
    { "maxDecibels", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeMaxDecibels), (intptr_t)setJSAnalyserNodeMaxDecibels, NoIntrinsic },
    { "smoothingTimeConstant", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeSmoothingTimeConstant), (intptr_t)setJSAnalyserNodeSmoothingTimeConstant, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnalyserNodeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAnalyserNodeTable = { 17, 15, JSAnalyserNodeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSAnalyserNodeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAnalyserNodeConstructorTable = { 1, 0, JSAnalyserNodeConstructorTableValues, 0 };
const ClassInfo JSAnalyserNodeConstructor::s_info = { "AnalyserNodeConstructor", &Base::s_info, &JSAnalyserNodeConstructorTable, 0, CREATE_METHOD_TABLE(JSAnalyserNodeConstructor) };

JSAnalyserNodeConstructor::JSAnalyserNodeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSAnalyserNodeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSAnalyserNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSAnalyserNodeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAnalyserNodeConstructor, JSDOMWrapper>(exec, &JSAnalyserNodeConstructorTable, jsCast<JSAnalyserNodeConstructor*>(cell), propertyName, slot);
}

bool JSAnalyserNodeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAnalyserNodeConstructor, JSDOMWrapper>(exec, &JSAnalyserNodeConstructorTable, jsCast<JSAnalyserNodeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSAnalyserNodePrototypeTableValues[] =
{
    { "getFloatFrequencyData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAnalyserNodePrototypeFunctionGetFloatFrequencyData), (intptr_t)1, NoIntrinsic },
    { "getByteFrequencyData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAnalyserNodePrototypeFunctionGetByteFrequencyData), (intptr_t)1, NoIntrinsic },
    { "getByteTimeDomainData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAnalyserNodePrototypeFunctionGetByteTimeDomainData), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAnalyserNodePrototypeTable = { 8, 7, JSAnalyserNodePrototypeTableValues, 0 };
const ClassInfo JSAnalyserNodePrototype::s_info = { "AnalyserNodePrototype", &Base::s_info, &JSAnalyserNodePrototypeTable, 0, CREATE_METHOD_TABLE(JSAnalyserNodePrototype) };

JSObject* JSAnalyserNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAnalyserNode>(exec, globalObject);
}

bool JSAnalyserNodePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAnalyserNodePrototype* thisObject = jsCast<JSAnalyserNodePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSAnalyserNodePrototypeTable, thisObject, propertyName, slot);
}

bool JSAnalyserNodePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAnalyserNodePrototype* thisObject = jsCast<JSAnalyserNodePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAnalyserNodePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSAnalyserNode::s_info = { "AnalyserNode", &Base::s_info, &JSAnalyserNodeTable, 0 , CREATE_METHOD_TABLE(JSAnalyserNode) };

JSAnalyserNode::JSAnalyserNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AnalyserNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
}

void JSAnalyserNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAnalyserNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAnalyserNodePrototype::create(exec->vm(), globalObject, JSAnalyserNodePrototype::createStructure(exec->vm(), globalObject, JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSAnalyserNode::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAnalyserNode* thisObject = jsCast<JSAnalyserNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSAnalyserNode, Base>(exec, &JSAnalyserNodeTable, thisObject, propertyName, slot);
}

bool JSAnalyserNode::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAnalyserNode* thisObject = jsCast<JSAnalyserNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSAnalyserNode, Base>(exec, &JSAnalyserNodeTable, thisObject, propertyName, descriptor);
}

JSValue jsAnalyserNodeFftSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->fftSize());
    return result;
}


JSValue jsAnalyserNodeFrequencyBinCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->frequencyBinCount());
    return result;
}


JSValue jsAnalyserNodeMinDecibels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->minDecibels());
    return result;
}


JSValue jsAnalyserNodeMaxDecibels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->maxDecibels());
    return result;
}


JSValue jsAnalyserNodeSmoothingTimeConstant(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(impl->smoothingTimeConstant());
    return result;
}


JSValue jsAnalyserNodeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAnalyserNode* domObject = jsCast<JSAnalyserNode*>(asObject(slotBase));
    return JSAnalyserNode::getConstructor(exec, domObject->globalObject());
}

void JSAnalyserNode::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSAnalyserNode* thisObject = jsCast<JSAnalyserNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSAnalyserNode, Base>(exec, propertyName, value, &JSAnalyserNodeTable, thisObject, slot);
}

void setJSAnalyserNodeFftSize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(thisObject);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setFftSize(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSAnalyserNodeMinDecibels(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(thisObject);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setMinDecibels(nativeValue);
}


void setJSAnalyserNodeMaxDecibels(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(thisObject);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setMaxDecibels(nativeValue);
}


void setJSAnalyserNodeSmoothingTimeConstant(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(thisObject);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setSmoothingTimeConstant(nativeValue);
}


JSValue JSAnalyserNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnalyserNodeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetFloatFrequencyData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAnalyserNode::s_info))
        return throwVMTypeError(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAnalyserNode::s_info);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Float32Array* array(toFloat32Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->getFloatFrequencyData(array);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteFrequencyData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAnalyserNode::s_info))
        return throwVMTypeError(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAnalyserNode::s_info);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Uint8Array* array(toUint8Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->getByteFrequencyData(array);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAnalyserNodePrototypeFunctionGetByteTimeDomainData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAnalyserNode::s_info))
        return throwVMTypeError(exec);
    JSAnalyserNode* castedThis = jsCast<JSAnalyserNode*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAnalyserNode::s_info);
    AnalyserNode* impl = static_cast<AnalyserNode*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Uint8Array* array(toUint8Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->getByteTimeDomainData(array);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AnalyserNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AnalyserNodeE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AnalyserNode* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAnalyserNode>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7AnalyserNode@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12AnalyserNodeE[2];
#if COMPILER(CLANG)
    // If this fails AnalyserNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(AnalyserNode), AnalyserNode_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // AnalyserNode has subclasses. If AnalyserNode has subclasses that get passed
    // to toJS() we currently require AnalyserNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<AnalyserNode>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSAnalyserNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
