/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSAbstractWorker.h"

#include "AbstractWorker.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSAbstractWorkerTableValues[] =
{
    { "onerror", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAbstractWorkerOnerror), (intptr_t)setJSAbstractWorkerOnerror, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAbstractWorkerTable = { 2, 1, JSAbstractWorkerTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSAbstractWorkerPrototypeTableValues[] =
{
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAbstractWorkerPrototypeFunctionAddEventListener), (intptr_t)2, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAbstractWorkerPrototypeFunctionRemoveEventListener), (intptr_t)2, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsAbstractWorkerPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSAbstractWorkerPrototypeTable = { 8, 7, JSAbstractWorkerPrototypeTableValues, 0 };
const ClassInfo JSAbstractWorkerPrototype::s_info = { "AbstractWorkerPrototype", &Base::s_info, &JSAbstractWorkerPrototypeTable, 0, CREATE_METHOD_TABLE(JSAbstractWorkerPrototype) };

JSObject* JSAbstractWorkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAbstractWorker>(exec, globalObject);
}

bool JSAbstractWorkerPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAbstractWorkerPrototype* thisObject = jsCast<JSAbstractWorkerPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSAbstractWorkerPrototypeTable, thisObject, propertyName, slot);
}

bool JSAbstractWorkerPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAbstractWorkerPrototype* thisObject = jsCast<JSAbstractWorkerPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAbstractWorkerPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSAbstractWorker::s_info = { "AbstractWorker", &Base::s_info, &JSAbstractWorkerTable, 0 , CREATE_METHOD_TABLE(JSAbstractWorker) };

JSAbstractWorker::JSAbstractWorker(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<AbstractWorker> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSAbstractWorker::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSAbstractWorker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSAbstractWorkerPrototype::create(exec->vm(), globalObject, JSAbstractWorkerPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSAbstractWorker::destroy(JSC::JSCell* cell)
{
    JSAbstractWorker* thisObject = static_cast<JSAbstractWorker*>(cell);
    thisObject->JSAbstractWorker::~JSAbstractWorker();
}

JSAbstractWorker::~JSAbstractWorker()
{
    releaseImplIfNotNull();
}

bool JSAbstractWorker::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSAbstractWorker* thisObject = jsCast<JSAbstractWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSAbstractWorker, Base>(exec, &JSAbstractWorkerTable, thisObject, propertyName, slot);
}

bool JSAbstractWorker::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSAbstractWorker* thisObject = jsCast<JSAbstractWorker*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSAbstractWorker, Base>(exec, &JSAbstractWorkerTable, thisObject, propertyName, descriptor);
}

JSValue jsAbstractWorkerOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSAbstractWorker* castedThis = jsCast<JSAbstractWorker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    AbstractWorker* impl = static_cast<AbstractWorker*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


void JSAbstractWorker::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSAbstractWorker* thisObject = jsCast<JSAbstractWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSAbstractWorker, Base>(exec, propertyName, value, &JSAbstractWorkerTable, thisObject, slot);
}

void setJSAbstractWorkerOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSAbstractWorker* castedThis = jsCast<JSAbstractWorker*>(thisObject);
    AbstractWorker* impl = static_cast<AbstractWorker*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


EncodedJSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwVMTypeError(exec);
    JSAbstractWorker* castedThis = jsCast<JSAbstractWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAbstractWorker::s_info);
    AbstractWorker* impl = static_cast<AbstractWorker*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwVMTypeError(exec);
    JSAbstractWorker* castedThis = jsCast<JSAbstractWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAbstractWorker::s_info);
    AbstractWorker* impl = static_cast<AbstractWorker*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwVMTypeError(exec);
    JSAbstractWorker* castedThis = jsCast<JSAbstractWorker*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSAbstractWorker::s_info);
    AbstractWorker* impl = static_cast<AbstractWorker*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* evt(toEvent(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSAbstractWorker::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSAbstractWorker* thisObject = jsCast<JSAbstractWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSAbstractWorker* jsAbstractWorker)
{
    if (jsAbstractWorker->hasCustomProperties())
        return true;
    if (jsAbstractWorker->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSAbstractWorkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSAbstractWorker* jsAbstractWorker = jsCast<JSAbstractWorker*>(handle.get().asCell());
    if (jsAbstractWorker->impl()->hasPendingActivity())
        return true;
    if (jsAbstractWorker->impl()->isFiringEventListeners())
        return true;
    if (!isObservable(jsAbstractWorker))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSAbstractWorkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSAbstractWorker* jsAbstractWorker = jsCast<JSAbstractWorker*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAbstractWorker->impl(), jsAbstractWorker);
    jsAbstractWorker->releaseImpl();
}

AbstractWorker* toAbstractWorker(JSC::JSValue value)
{
    return value.inherits(&JSAbstractWorker::s_info) ? jsCast<JSAbstractWorker*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
