/*
 * Copyright (C) 2013 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebViewClient_h
#define WebViewClient_h

#include "APIClient.h"
#include "Cursor.h"
#include "EditorState.h"
#include "WebEvent.h"
#include <WKView.h>
#include <WebCore/IntSize.h>
#include <wtf/Forward.h>
#include <wtf/Vector.h>

namespace WebCore {
class IntPoint;
class IntRect;
class ResourceRequest;
struct WindowFeatures;
}

namespace WebKit {

class NativeWebKeyboardEvent;
class WebFrameProxy;
class WebPageProxy;
class WebView;

class WebViewClient : public APIClient<WKViewClient, kWKViewClientCurrentVersion> {
public:
    void setViewNeedsDisplay(WebView*, const WebCore::IntRect&);
    WebCore::IntSize viewSize(WebView*);
#if ENABLE(MANX_CURSOR_NAVIGATION)
    void setCursorPosition(WebView*, const WebCore::IntPoint& cursorPosition);
#endif
    void enterFullScreen(WebView*);
    void exitFullScreen(WebView*);
    void closeFullScreen(WebView*);
    void beganEnterFullScreen(WebView*, const WebCore::IntRect& initialFrame, const WebCore::IntRect& finalFrame);
    void beganExitFullScreen(WebView*, const WebCore::IntRect& initialFrame, const WebCore::IntRect& finalFrame);
    void didChangeContentsSize(WebView*, const WebCore::IntSize&);
    void didChangeEditorState(WebView*, int eventType, const WebKit::EditorState&);
    void didChangeCompositionState(WebView*, const WebCore::IntRect& compositonRect);
    void didChangeSelectionState(WebView*, const String& selectedText, const WebCore::IntRect& selectedRect);
    void runJavaScriptAlert(WebView*, const String& alertText, WebFrameProxy*);
    void runJavaScriptConfirm(WebView*, const String& message, WebFrameProxy*);
    void runJavaScriptPrompt(WebView*, const String& message, const String& defaultValue, WebFrameProxy*);
    void authenticationRequiredRequest(WebView*, const String& hostname, const String& realm, const String& prefilledUsername, const String& prefilledPassword, WebFrameProxy*);
    void certificateVerificationRequest(WebView*, uint32_t error, const String& url, const Vector<CString>& certificates, WebFrameProxy*);
    void createNewPage(WebView*, const WebCore::ResourceRequest&, const WebCore::WindowFeatures&, WebEvent::Modifiers, WebMouseEvent::Button);
    void doneWithKeyEvent(WebView*, const NativeWebKeyboardEvent&, bool wasEventHandled);
    void doneWithMouseDownEvent(WebView*, bool wasEventHandled);
    void doneWithMouseUpEvent(WebView*, bool wasEventHandled);

    void enterAcceleratedCompositingMode(WebView*);
    void exitAcceleratedCompositingMode(WebView*);

    void setCursor(WebView*, const WebCore::Cursor&);

    void didUpdateBackingStoreState(WebView*);
    void didCommitCoordinatedGraphicsState(WebView*);

private:
    static WKCursorType convertCursorToWKCursorType(const WebCore::Cursor&);
};

} // namespace WebKit

#endif // WebViewClient_h
