///////////////////////////////////////////////////////////////////////////////
// Copyright 2006,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEURL_H__
#define __CEURL_H__


//#include "ceutypes.h"
#include "ICEUString.h"
#include "CEApiFSPathname.h"
#include "ICETextSupport.h"
#include "CEUrlCommon.h" // for CEURIScheme

//WARNING: READ THIS BEFORE USING ...
/*

Currently CEURL library is stupidly statically linked to the old Utility library.
There are only two things used from Utility (Linked List Implementation and
conversion of port string to a UINT16 value). This should be undone later.

Currently URL encoding and escaping issues are not handled. The user of the URL library
probably should not have to worry about such things. So we need to decide how to handle 
this internally within the URL library. For now we just just parse URL and give structures
representing what was parsed. We also allow simple mutators that are similar to those
used in CEHtmlURL. However, it's important to note that This library's accessors are *NOT* 
thread safe. That is we often return a pointer to an internal struct inside the URL instead
of copying the data. Should we also add some thread safe  methods that copy data? 

*/


/*
ceurl currently only supports HTTP/HTTPS/FILE schemes.

ip-schemepart="//"login["/" urlpath]
login          = [ user [ ":" password ] "@" ] hostport
hostport       = host [ ":" port ]
host           = hostname | hostnumber
hostname       = *[ domainlabel "." ] toplabel
domainlabel    = alphadigit | alphadigit *[ alphadigit | "-" ] alphadigit
toplabel       = alpha | alpha *[ alphadigit | "-" ] alphadigit
alphadigit     = alpha | digit
hostnumber     = digits "." digits "." digits "." digits
port           = digits
user           = *[ uchar | ";" | "?" | "&" | "=" ]
password       = *[ uchar | ";" | "?" | "&" | "=" ]

HTTP/HTTPS Scheme:
(Although HTTP/HTTPS scheme is an ip based protocol, we will not support
"login" due to security concerns)
httpurl        = "http://" hostport [ "/" hpath [ "?" search ]]
hpath          = hsegment *[ "/" hsegment ]
hsegment       = *[ uchar | ";" | ":" | "@" | "&" | "=" ]
search         = *[ uchar | ";" | ":" | "@" | "&" | "=" ]


FILE Scheme:
(File scheme is only supported in debug mode. So return an error otherwise.
Also, it only supports files on the localhost. So we use cefs for this.)
fileurl        = "file://" [ host | "localhost" ] "/" fpath
 */

typedef CEHResult (*CEURI_STRING_CONVERTER2)(const char*, void*);


enum CEURIProperty2
{
	CEURIProperty2_URI,
	CEURIProperty2_HttpPath,
	CEURIProperty2_HttpPathWithoutFileName,
	CEURIProperty2_HttpHost,
	CEURIProperty2_HttpPort,
	CEURIProperty2_HttpQuery,
	CEURIProperty2_HttpFragment,
	CEURIProperty2_FilePath,
	CEURIProperty2_FileUnescapedPath,
	CEURIProperty2_KURL,
};

typedef struct
{
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	ICEFSPathname** _pathName;

	bool         _dataScheme;
	const UINT8* _mediaType;
	const UINT8* _data;
	int          _numBytes;

} CEURL_FileInfo;

typedef CEHResult (*_ceurl_init)(void*);
typedef CEHResult (*_ceurl_shutdown)();
typedef CEHResult (*_ceurl_create)(void**const iOut);

typedef struct
{
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	_ceurl_init     init;
	_ceurl_shutdown shutdown;
	_ceurl_create   create;
}CEURLInterface;

#ifdef __cplusplus
extern "C" {
#endif

CE_DLL_EXPORT CEHResult ceurl_init(void* ceutilHandle);
CE_DLL_EXPORT CEHResult ceurl_shutdown();
CE_DLL_EXPORT CEHResult ceurl_create(void**const iOut);

CE_DLL_EXPORT CEHResult convertCStringToICEUString(const char* src, void* dst);
CE_DLL_EXPORT CEHResult convertCStringToICEUStringUTF8(const char* src, void* dst);

#ifdef __cplusplus
}
#endif


#endif
