///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEPluginSharedObjectLoader_h
#define ICEPluginSharedObjectLoader_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
    eCEPluginInfo_MIMEType,
    eCEPluginInfo_FileExtension,
    eCEPluginInfo_Description,
	eCEPluginInfo_OpenName,
	eCEPluginInfo_ProductName,
} eCEPluginInfo;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEPluginSharedObjectLoader ICEPluginSharedObjectLoader
 * @{
 */

/*!
 * ID of ICEPluginSharedObjectLoader
 */
#define CEComIID_ICEPluginSharedObjectLoader 0xacd5d8dd

/*!
 * ICEPluginSharedObjectLoader
 */
typedef struct ICEPluginSharedObjectLoader
{
	const struct ICEPluginSharedObjectLoader_vtbl* _vtbl;
} ICEPluginSharedObjectLoader;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginSharedObjectLoader	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEPluginSharedObjectLoader_queryInterface) (ICEPluginSharedObjectLoader* iPluginSharedObjectLoader, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginSharedObjectLoader_addRef) (ICEPluginSharedObjectLoader* iPluginSharedObjectLoader);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginSharedObjectLoader_release) (ICEPluginSharedObjectLoader* iPluginSharedObjectLoader);

typedef CEHResult (*iCEPluginSharedObjectLoader_loadSharedObject) (ICEPluginSharedObjectLoader* iPluginSharedObjectLoader, const CHAR8* filename, void** handleOut);

typedef CEHResult (*iCEPluginSharedObjectLoader_unloadSharedObject) (ICEPluginSharedObjectLoader* iPluginSharedObjectLoader, void* handle);

/*!
 * V-table of ICEPluginSharedObjectLoader
 */
struct ICEPluginSharedObjectLoader_vtbl
{
	iCEPluginSharedObjectLoader_queryInterface	_queryInterface;	//!< Query interface.
	iCEPluginSharedObjectLoader_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEPluginSharedObjectLoader_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEPluginSharedObjectLoader_loadSharedObject	_loadSharedObject;
	iCEPluginSharedObjectLoader_unloadSharedObject	_unloadSharedObject;
};

/*! @}
 * end of ICEPluginSharedObjectLoader
 */

/*! \defgroup ICEPluginModuleLoader ICEPluginModuleLoader
 * @{
 */

/*!
 * ID of ICEPluginModuleLoader
 */
#define CEComIID_ICEPluginModuleLoader 0xf457ff2a

/*!
 * ICEPluginModuleLoader
 */
typedef struct ICEPluginModuleLoader
{
	const struct ICEPluginModuleLoader_vtbl* _vtbl;
} ICEPluginModuleLoader;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginModuleLoader	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEPluginModuleLoader_queryInterface) (ICEPluginModuleLoader* iPluginModuleLoader, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginModuleLoader_addRef) (ICEPluginModuleLoader* iPluginModuleLoader);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginModuleLoader_release) (ICEPluginModuleLoader* iPluginModuleLoader);

typedef CEHResult (*iCEPluginModuleLoader_loadModule) (ICEPluginModuleLoader* iPluginModuleLoader, struct ICEUString* iModuleName, void** handleOut);

typedef CEHResult (*iCEPluginModuleLoader_unloadModule) (ICEPluginModuleLoader* iPluginModuleLoader, void* handle);

typedef CEHResult (*iCEPluginModuleLoader_findSymbol) (ICEPluginModuleLoader* iPluginModuleLoader, void* handle, const CHAR8* symbolName, const UINT32 symbolNameLength, void** symbolOut);

typedef CEHResult (*iCEPluginModuleLoader_getModuleInfoString) (ICEPluginModuleLoader* iPluginModuleLoader, void* handle, struct ICEUString** valueOut);

/*!
 * V-table of ICEPluginModuleLoader
 */
struct ICEPluginModuleLoader_vtbl
{
	iCEPluginModuleLoader_queryInterface	_queryInterface;	//!< Query interface.
	iCEPluginModuleLoader_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEPluginModuleLoader_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEPluginModuleLoader_loadModule	_loadModule;
	iCEPluginModuleLoader_unloadModule	_unloadModule;
	iCEPluginModuleLoader_findSymbol	_findSymbol;
	iCEPluginModuleLoader_getModuleInfoString	_getModuleInfoString;
};

/*! @}
 * end of ICEPluginModuleLoader
 */

/*! \defgroup ICEPluginModuleInfoReader ICEPluginModuleInfoReader
 * @{
 */

/*!
 * ID of ICEPluginModuleInfoReader
 */
#define CEComIID_ICEPluginModuleInfoReader 0x764b6846

/*!
 * ICEPluginModuleInfoReader
 */
typedef struct ICEPluginModuleInfoReader
{
	const struct ICEPluginModuleInfoReader_vtbl* _vtbl;
} ICEPluginModuleInfoReader;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginModuleInfoReader	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEPluginModuleInfoReader_queryInterface) (ICEPluginModuleInfoReader* iPluginModuleInfoReader, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginModuleInfoReader_addRef) (ICEPluginModuleInfoReader* iPluginModuleInfoReader);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginModuleInfoReader_release) (ICEPluginModuleInfoReader* iPluginModuleInfoReader);

typedef CEHResult (*iCEPluginModuleInfoReader_readModuleInfo) (ICEPluginModuleInfoReader* iPluginModuleInfoReader, struct ICEUString* iModuleName, eCEPluginInfo info, struct ICEUString** valueOut);

/*!
 * V-table of ICEPluginModuleInfoReader
 */
struct ICEPluginModuleInfoReader_vtbl
{
	iCEPluginModuleInfoReader_queryInterface	_queryInterface;	//!< Query interface.
	iCEPluginModuleInfoReader_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEPluginModuleInfoReader_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEPluginModuleInfoReader_readModuleInfo	_readModuleInfo;
};

/*! @}
 * end of ICEPluginModuleInfoReader
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEPluginSharedObjectLoaderRef CEComICEPluginSharedObjectLoaderRef
 * @{
 */

class CEComICEPluginSharedObjectLoaderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEPluginSharedObjectLoaderRef() : _iPluginSharedObjectLoader(0) {}
	CEComICEPluginSharedObjectLoaderRef(ICEPluginSharedObjectLoader* iOther) : _iPluginSharedObjectLoader(0)
	{
		if (iOther)
		{
			_iPluginSharedObjectLoader = iOther;
			_iPluginSharedObjectLoader->_vtbl->_addRef(_iPluginSharedObjectLoader);
		}
	}

	CEComICEPluginSharedObjectLoaderRef(const CEComICEPluginSharedObjectLoaderRef& other) : _iPluginSharedObjectLoader(0)
	{
		if (other._iPluginSharedObjectLoader)
		{
			_iPluginSharedObjectLoader = other._iPluginSharedObjectLoader;
			_iPluginSharedObjectLoader->_vtbl->_addRef(_iPluginSharedObjectLoader);
		}
	}

	~CEComICEPluginSharedObjectLoaderRef()
	{
		if (_iPluginSharedObjectLoader)
		{
			ICEPluginSharedObjectLoader* tmp = _iPluginSharedObjectLoader;
			_iPluginSharedObjectLoader = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEPluginSharedObjectLoader* iPluginSharedObjectLoader;
				void* _ptr;
			} uIntf;
			uIntf.iPluginSharedObjectLoader = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEPluginSharedObjectLoader, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginSharedObjectLoader)
				{
					ICEPluginSharedObjectLoader* tmp = _iPluginSharedObjectLoader;
					_iPluginSharedObjectLoader = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginSharedObjectLoader = uIntf.iPluginSharedObjectLoader;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEPluginSharedObjectLoader* object() const	{ return _iPluginSharedObjectLoader; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEPluginSharedObjectLoader* iOther)
	{
		if (_iPluginSharedObjectLoader)
		{
			ICEPluginSharedObjectLoader* tmp = _iPluginSharedObjectLoader;
			_iPluginSharedObjectLoader = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginSharedObjectLoader = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEPluginSharedObjectLoader* detach()
	{
		ICEPluginSharedObjectLoader* iIntf = _iPluginSharedObjectLoader;
		_iPluginSharedObjectLoader = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEPluginSharedObjectLoader* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginSharedObjectLoader;
		if (_iPluginSharedObjectLoader)
		{
			_iPluginSharedObjectLoader->_vtbl->_addRef(_iPluginSharedObjectLoader);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEPluginSharedObjectLoader*() const	{ return _iPluginSharedObjectLoader; }
	FORCEINLINE_WITHOUT_DEBUG ICEPluginSharedObjectLoader& operator*() const	{ return *_iPluginSharedObjectLoader; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginSharedObjectLoader == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEPluginSharedObjectLoader* iOther) const	{ return (_iPluginSharedObjectLoader != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEPluginSharedObjectLoader* iOther) const	{ return (_iPluginSharedObjectLoader == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEPluginSharedObjectLoaderRef& operator=(const CEComICEPluginSharedObjectLoaderRef& other)	{ return operator=(other._iPluginSharedObjectLoader); }

	CEComICEPluginSharedObjectLoaderRef& operator=(const ICEPluginSharedObjectLoader* iOther)
	{
		if (_iPluginSharedObjectLoader != iOther)
		{
			if (_iPluginSharedObjectLoader)
			{
				ICEPluginSharedObjectLoader* tmp = _iPluginSharedObjectLoader;
				_iPluginSharedObjectLoader = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginSharedObjectLoader = const_cast<ICEPluginSharedObjectLoader*>(iOther);
			if (_iPluginSharedObjectLoader)
			{
				_iPluginSharedObjectLoader->_vtbl->_addRef(_iPluginSharedObjectLoader);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEPluginSharedObjectLoader** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEPluginSharedObjectLoaderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginSharedObjectLoader && "has a com object reference. clear first.");
		return & _iPluginSharedObjectLoader; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEPluginSharedObjectLoaderRef& other)
	{
		bool result = false;
		if (_iPluginSharedObjectLoader)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginSharedObjectLoader);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginSharedObjectLoader ? _iPluginSharedObjectLoader->_vtbl->_queryInterface(_iPluginSharedObjectLoader, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginSharedObjectLoader) { _iPluginSharedObjectLoader->_vtbl->_addRef(_iPluginSharedObjectLoader); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginSharedObjectLoader) { _iPluginSharedObjectLoader->_vtbl->_release(_iPluginSharedObjectLoader); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loadSharedObject(const CHAR8* filename, void** handleOut)	{ return _iPluginSharedObjectLoader ? _iPluginSharedObjectLoader->_vtbl->_loadSharedObject(_iPluginSharedObjectLoader, filename, handleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unloadSharedObject(void* handle)	{ return _iPluginSharedObjectLoader ? _iPluginSharedObjectLoader->_vtbl->_unloadSharedObject(_iPluginSharedObjectLoader, handle) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEPluginSharedObjectLoader* _iPluginSharedObjectLoader;
};

/*! @}
 * end of CEComICEPluginSharedObjectLoaderRef
 */

/*! \defgroup CEComICEPluginModuleLoaderRef CEComICEPluginModuleLoaderRef
 * @{
 */

class CEComICEPluginModuleLoaderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEPluginModuleLoaderRef() : _iPluginModuleLoader(0) {}
	CEComICEPluginModuleLoaderRef(ICEPluginModuleLoader* iOther) : _iPluginModuleLoader(0)
	{
		if (iOther)
		{
			_iPluginModuleLoader = iOther;
			_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
		}
	}

	CEComICEPluginModuleLoaderRef(const CEComICEPluginModuleLoaderRef& other) : _iPluginModuleLoader(0)
	{
		if (other._iPluginModuleLoader)
		{
			_iPluginModuleLoader = other._iPluginModuleLoader;
			_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
		}
	}

	~CEComICEPluginModuleLoaderRef()
	{
		if (_iPluginModuleLoader)
		{
			ICEPluginModuleLoader* tmp = _iPluginModuleLoader;
			_iPluginModuleLoader = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEPluginModuleLoader* iPluginModuleLoader;
				void* _ptr;
			} uIntf;
			uIntf.iPluginModuleLoader = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEPluginModuleLoader, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginModuleLoader)
				{
					ICEPluginModuleLoader* tmp = _iPluginModuleLoader;
					_iPluginModuleLoader = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginModuleLoader = uIntf.iPluginModuleLoader;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEPluginModuleLoader* object() const	{ return _iPluginModuleLoader; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEPluginModuleLoader* iOther)
	{
		if (_iPluginModuleLoader)
		{
			ICEPluginModuleLoader* tmp = _iPluginModuleLoader;
			_iPluginModuleLoader = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginModuleLoader = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEPluginModuleLoader* detach()
	{
		ICEPluginModuleLoader* iIntf = _iPluginModuleLoader;
		_iPluginModuleLoader = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEPluginModuleLoader* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginModuleLoader;
		if (_iPluginModuleLoader)
		{
			_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEPluginModuleLoader*() const	{ return _iPluginModuleLoader; }
	FORCEINLINE_WITHOUT_DEBUG ICEPluginModuleLoader& operator*() const	{ return *_iPluginModuleLoader; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginModuleLoader == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEPluginModuleLoader* iOther) const	{ return (_iPluginModuleLoader != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEPluginModuleLoader* iOther) const	{ return (_iPluginModuleLoader == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEPluginModuleLoaderRef& operator=(const CEComICEPluginModuleLoaderRef& other)	{ return operator=(other._iPluginModuleLoader); }

	CEComICEPluginModuleLoaderRef& operator=(const ICEPluginModuleLoader* iOther)
	{
		if (_iPluginModuleLoader != iOther)
		{
			if (_iPluginModuleLoader)
			{
				ICEPluginModuleLoader* tmp = _iPluginModuleLoader;
				_iPluginModuleLoader = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginModuleLoader = const_cast<ICEPluginModuleLoader*>(iOther);
			if (_iPluginModuleLoader)
			{
				_iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEPluginModuleLoader** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEPluginModuleLoaderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginModuleLoader && "has a com object reference. clear first.");
		return & _iPluginModuleLoader; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEPluginModuleLoaderRef& other)
	{
		bool result = false;
		if (_iPluginModuleLoader)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginModuleLoader);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_queryInterface(_iPluginModuleLoader, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginModuleLoader) { _iPluginModuleLoader->_vtbl->_addRef(_iPluginModuleLoader); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginModuleLoader) { _iPluginModuleLoader->_vtbl->_release(_iPluginModuleLoader); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult loadModule(struct ICEUString* iModuleName, void** handleOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_loadModule(_iPluginModuleLoader, iModuleName, handleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unloadModule(void* handle)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_unloadModule(_iPluginModuleLoader, handle) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult findSymbol(void* handle, const CHAR8* symbolName, const UINT32 symbolNameLength, void** symbolOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_findSymbol(_iPluginModuleLoader, handle, symbolName, symbolNameLength, symbolOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getModuleInfoString(void* handle, struct ICEUString** valueOut)	{ return _iPluginModuleLoader ? _iPluginModuleLoader->_vtbl->_getModuleInfoString(_iPluginModuleLoader, handle, valueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEPluginModuleLoader* _iPluginModuleLoader;
};

/*! @}
 * end of CEComICEPluginModuleLoaderRef
 */

/*! \defgroup CEComICEPluginModuleInfoReaderRef CEComICEPluginModuleInfoReaderRef
 * @{
 */

class CEComICEPluginModuleInfoReaderRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEPluginModuleInfoReaderRef() : _iPluginModuleInfoReader(0) {}
	CEComICEPluginModuleInfoReaderRef(ICEPluginModuleInfoReader* iOther) : _iPluginModuleInfoReader(0)
	{
		if (iOther)
		{
			_iPluginModuleInfoReader = iOther;
			_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
		}
	}

	CEComICEPluginModuleInfoReaderRef(const CEComICEPluginModuleInfoReaderRef& other) : _iPluginModuleInfoReader(0)
	{
		if (other._iPluginModuleInfoReader)
		{
			_iPluginModuleInfoReader = other._iPluginModuleInfoReader;
			_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
		}
	}

	~CEComICEPluginModuleInfoReaderRef()
	{
		if (_iPluginModuleInfoReader)
		{
			ICEPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
			_iPluginModuleInfoReader = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEPluginModuleInfoReader* iPluginModuleInfoReader;
				void* _ptr;
			} uIntf;
			uIntf.iPluginModuleInfoReader = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEPluginModuleInfoReader, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginModuleInfoReader)
				{
					ICEPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
					_iPluginModuleInfoReader = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginModuleInfoReader = uIntf.iPluginModuleInfoReader;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEPluginModuleInfoReader* object() const	{ return _iPluginModuleInfoReader; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEPluginModuleInfoReader* iOther)
	{
		if (_iPluginModuleInfoReader)
		{
			ICEPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
			_iPluginModuleInfoReader = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginModuleInfoReader = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEPluginModuleInfoReader* detach()
	{
		ICEPluginModuleInfoReader* iIntf = _iPluginModuleInfoReader;
		_iPluginModuleInfoReader = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEPluginModuleInfoReader* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginModuleInfoReader;
		if (_iPluginModuleInfoReader)
		{
			_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEPluginModuleInfoReader*() const	{ return _iPluginModuleInfoReader; }
	FORCEINLINE_WITHOUT_DEBUG ICEPluginModuleInfoReader& operator*() const	{ return *_iPluginModuleInfoReader; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginModuleInfoReader == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEPluginModuleInfoReader* iOther) const	{ return (_iPluginModuleInfoReader != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEPluginModuleInfoReader* iOther) const	{ return (_iPluginModuleInfoReader == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEPluginModuleInfoReaderRef& operator=(const CEComICEPluginModuleInfoReaderRef& other)	{ return operator=(other._iPluginModuleInfoReader); }

	CEComICEPluginModuleInfoReaderRef& operator=(const ICEPluginModuleInfoReader* iOther)
	{
		if (_iPluginModuleInfoReader != iOther)
		{
			if (_iPluginModuleInfoReader)
			{
				ICEPluginModuleInfoReader* tmp = _iPluginModuleInfoReader;
				_iPluginModuleInfoReader = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginModuleInfoReader = const_cast<ICEPluginModuleInfoReader*>(iOther);
			if (_iPluginModuleInfoReader)
			{
				_iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEPluginModuleInfoReader** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEPluginModuleInfoReaderRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginModuleInfoReader && "has a com object reference. clear first.");
		return & _iPluginModuleInfoReader; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEPluginModuleInfoReaderRef& other)
	{
		bool result = false;
		if (_iPluginModuleInfoReader)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginModuleInfoReader);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginModuleInfoReader ? _iPluginModuleInfoReader->_vtbl->_queryInterface(_iPluginModuleInfoReader, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginModuleInfoReader) { _iPluginModuleInfoReader->_vtbl->_addRef(_iPluginModuleInfoReader); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginModuleInfoReader) { _iPluginModuleInfoReader->_vtbl->_release(_iPluginModuleInfoReader); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult readModuleInfo(struct ICEUString* iModuleName, eCEPluginInfo info, struct ICEUString** valueOut)	{ return _iPluginModuleInfoReader ? _iPluginModuleInfoReader->_vtbl->_readModuleInfo(_iPluginModuleInfoReader, iModuleName, info, valueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEPluginModuleInfoReader* _iPluginModuleInfoReader;
};

/*! @}
 * end of CEComICEPluginModuleInfoReaderRef
 */

#endif // __cplusplus

#endif
