///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEMRL_h
#define ICEMRL_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------

struct ICEMRLLayer;
struct ICEMRLLayerCallback;
struct ICEMRLLayerRenderer;
struct ICEVGContext;
struct ICEVGSurface;
struct ICEUString;

//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	eCEMRLCompositingCoordinatesOrientation_TopDown,
	eCEMRLCompositingCoordinatesOrientation_BottomUp
} eCEMRLCompositingCoordinatesOrientation;

typedef enum
{
	eCEMRLLayerType_RootLayer,
	eCEMRLLayerType_Layer
} eCEMRLLayerType;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEMRLFactory ICEMRLFactory
 * @{
 */

/*!
 * ID of ICEMRLFactory
 */
#define CEComIID_ICEMRLFactory 0x71a43fd0

/*!
 * ICEMRLFactory
 */
typedef struct ICEMRLFactory
{
	const struct ICEMRLFactory_vtbl* _vtbl;
} ICEMRLFactory;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iMRLFactory	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEMRLFactory_queryInterface) (ICEMRLFactory* iMRLFactory, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLFactory_addRef) (ICEMRLFactory* iMRLFactory);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLFactory_release) (ICEMRLFactory* iMRLFactory);

typedef CEHResult (*iCEMRLFactory_createLayer) (ICEMRLFactory* iMRLFactory, eCEMRLLayerType type, struct ICEMRLLayer* *const layerOut);

typedef CEHResult (*iCEMRLFactory_createLayerRenderer) (ICEMRLFactory* iMRLFactory, struct ICEMRLLayerRenderer* *const rendererOut);

/*!
 * V-table of ICEMRLFactory
 */
struct ICEMRLFactory_vtbl
{
	iCEMRLFactory_queryInterface	_queryInterface;	//!< Query interface.
	iCEMRLFactory_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEMRLFactory_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEMRLFactory_createLayer	_createLayer;
	iCEMRLFactory_createLayerRenderer	_createLayerRenderer;
};

/*! @}
 * end of ICEMRLFactory
 */

/*! \defgroup ICEMRLLayerRenderer ICEMRLLayerRenderer
 * @{
 */

/*!
 * ID of ICEMRLLayerRenderer
 */
#define CEComIID_ICEMRLLayerRenderer 0x7ac98aed

/*!
 * ICEMRLLayerRenderer
 */
typedef struct ICEMRLLayerRenderer
{
	const struct ICEMRLLayerRenderer_vtbl* _vtbl;
} ICEMRLLayerRenderer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iMRLLayerRenderer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEMRLLayerRenderer_queryInterface) (ICEMRLLayerRenderer* iMRLLayerRenderer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLayerRenderer_addRef) (ICEMRLLayerRenderer* iMRLLayerRenderer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLayerRenderer_release) (ICEMRLLayerRenderer* iMRLLayerRenderer);

typedef CEHResult (*iCEMRLLayerRenderer_render) (ICEMRLLayerRenderer* iMRLLayerRenderer, struct ICEVGFactory* vgFactory, struct ICEVGContext* vgc, struct ICEMRLLayer* rootLayer, INT32 scX, INT32 scY, INT32 vpWidth, INT32 vpHeight);

typedef CEHResult (*iCEMRLLayerRenderer_getMode) (ICEMRLLayerRenderer* iMRLLayerRenderer, UINT8* c8sOut, UINT32 nC8s);

/*!
 * V-table of ICEMRLLayerRenderer
 */
struct ICEMRLLayerRenderer_vtbl
{
	iCEMRLLayerRenderer_queryInterface	_queryInterface;	//!< Query interface.
	iCEMRLLayerRenderer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEMRLLayerRenderer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEMRLLayerRenderer_render	_render;
	iCEMRLLayerRenderer_getMode	_getMode;
};

/*! @}
 * end of ICEMRLLayerRenderer
 */

/*! \defgroup ICEMRLLayerCallback ICEMRLLayerCallback
 * @{
 */

/*!
 * ID of ICEMRLLayerCallback
 */
#define CEComIID_ICEMRLLayerCallback 0xe1222c96

/*!
 * ICEMRLLayerCallback
 */
typedef struct ICEMRLLayerCallback
{
	const struct ICEMRLLayerCallback_vtbl* _vtbl;
} ICEMRLLayerCallback;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iMRLLayerCallback	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEMRLLayerCallback_queryInterface) (ICEMRLLayerCallback* iMRLLayerCallback, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLayerCallback_addRef) (ICEMRLLayerCallback* iMRLLayerCallback);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLayerCallback_release) (ICEMRLLayerCallback* iMRLLayerCallback);

typedef CEHResult (*iCEMRLLayerCallback_render) (ICEMRLLayerCallback* iMRLLayerCallback, struct ICEVGContext* iVgc);

typedef CEHResult (*iCEMRLLayerCallback_syncChildren) (ICEMRLLayerCallback* iMRLLayerCallback);

/*!
 * V-table of ICEMRLLayerCallback
 */
struct ICEMRLLayerCallback_vtbl
{
	iCEMRLLayerCallback_queryInterface	_queryInterface;	//!< Query interface.
	iCEMRLLayerCallback_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEMRLLayerCallback_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEMRLLayerCallback_render	_render;
	iCEMRLLayerCallback_syncChildren	_syncChildren;
};

/*! @}
 * end of ICEMRLLayerCallback
 */

/*! \defgroup ICEMRLLWindow ICEMRLLWindow
 * @{
 */

/*!
 * ID of ICEMRLLWindow
 */
#define CEComIID_ICEMRLLWindow 0x77737bc6

/*!
 * ICEMRLLWindow
 */
typedef struct ICEMRLLWindow
{
	const struct ICEMRLLWindow_vtbl* _vtbl;
} ICEMRLLWindow;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iMRLLWindow	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEMRLLWindow_queryInterface) (ICEMRLLWindow* iMRLLWindow, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLWindow_addRef) (ICEMRLLWindow* iMRLLWindow);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLWindow_release) (ICEMRLLWindow* iMRLLWindow);

typedef CEHResult (*iCEMRLLWindow_invalidateRect) (ICEMRLLWindow* iMRLLWindow, INT32 x, INT32 y, INT32 width, INT32 height);

typedef CEHResult (*iCEMRLLWindow_invalidate) (ICEMRLLWindow* iMRLLWindow);

/*!
 * V-table of ICEMRLLWindow
 */
struct ICEMRLLWindow_vtbl
{
	iCEMRLLWindow_queryInterface	_queryInterface;	//!< Query interface.
	iCEMRLLWindow_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEMRLLWindow_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEMRLLWindow_invalidateRect	_invalidateRect;
	iCEMRLLWindow_invalidate	_invalidate;
};

/*! @}
 * end of ICEMRLLWindow
 */

/*! \defgroup ICEMRLLayer ICEMRLLayer
 * @{
 */

/*!
 * ID of ICEMRLLayer
 */
#define CEComIID_ICEMRLLayer 0xf00d3972

/*!
 * ICEMRLLayer
 */
typedef struct ICEMRLLayer
{
	const struct ICEMRLLayer_vtbl* _vtbl;
} ICEMRLLayer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iMRLLayer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEMRLLayer_queryInterface) (ICEMRLLayer* iMRLLayer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLayer_addRef) (ICEMRLLayer* iMRLLayer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEMRLLayer_release) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_setUserData) (ICEMRLLayer* iMRLLayer, void* userData);

typedef CEHResult (*iCEMRLLayer_getUserData) (ICEMRLLayer* iMRLLayer, void* *const userDataOut);

typedef CEHResult (*iCEMRLLayer_setCallback) (ICEMRLLayer* iMRLLayer, struct ICEMRLLayerCallback* cb);

typedef CEHResult (*iCEMRLLayer_setName) (ICEMRLLayer* iMRLLayer, struct ICEUString* name);

typedef CEHResult (*iCEMRLLayer_setWindow) (ICEMRLLayer* iMRLLayer, struct ICEMRLLWindow* iWin);

typedef CEHResult (*iCEMRLLayer_printTree) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_setNeedsDisplay) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_setNeedsDisplayInRect) (ICEMRLLayer* iMRLLayer, float x, float y, float width, float height);

typedef CEHResult (*iCEMRLLayer_syncCompositingState) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_parent) (ICEMRLLayer* iMRLLayer, struct ICEMRLLayer* *const parentOut);

typedef CEHResult (*iCEMRLLayer_addChild) (ICEMRLLayer* iMRLLayer, struct ICEMRLLayer* layer);

typedef CEHResult (*iCEMRLLayer_removeFromParent) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_removeAllChildren) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_setPosition) (ICEMRLLayer* iMRLLayer, float x, float y);

typedef CEHResult (*iCEMRLLayer_setAnchorPoint) (ICEMRLLayer* iMRLLayer, float x, float y, float z);

typedef CEHResult (*iCEMRLLayer_setSize) (ICEMRLLayer* iMRLLayer, float width, float height);

typedef CEHResult (*iCEMRLLayer_setTransform) (ICEMRLLayer* iMRLLayer, const float* m16);

typedef CEHResult (*iCEMRLLayer_setChildrenTransform) (ICEMRLLayer* iMRLLayer, const float* m16);

typedef CEHResult (*iCEMRLLayer_setPreserves3D) (ICEMRLLayer* iMRLLayer, bool b);

typedef CEHResult (*iCEMRLLayer_setMasksToBounds) (ICEMRLLayer* iMRLLayer, bool b);

typedef CEHResult (*iCEMRLLayer_setDrawsContent) (ICEMRLLayer* iMRLLayer, bool b);

typedef CEHResult (*iCEMRLLayer_setBackgroundColor) (ICEMRLLayer* iMRLLayer, float r, float g, float b, float a);

typedef CEHResult (*iCEMRLLayer_clearBackgroundColor) (ICEMRLLayer* iMRLLayer);

typedef CEHResult (*iCEMRLLayer_setContentsOpaque) (ICEMRLLayer* iMRLLayer, bool b);

typedef CEHResult (*iCEMRLLayer_setBackfaceVisibility) (ICEMRLLayer* iMRLLayer, bool b);

typedef CEHResult (*iCEMRLLayer_setOpacity) (ICEMRLLayer* iMRLLayer, float o);

typedef CEHResult (*iCEMRLLayer_setContentsRect) (ICEMRLLayer* iMRLLayer, INT32 x, INT32 y, INT32 width, INT32 height);

typedef CEHResult (*iCEMRLLayer_setContentsToImage) (ICEMRLLayer* iMRLLayer, struct ICEVGSurface* imgSurface);

typedef CEHResult (*iCEMRLLayer_setContentsToMedia) (ICEMRLLayer* iMRLLayer, struct ICEUnknown* mediaSurface);

typedef CEHResult (*iCEMRLLayer_setContentsBackgroundColor) (ICEMRLLayer* iMRLLayer, float r, float g, float b, float a);

typedef CEHResult (*iCEMRLLayer_setGeometryOrientation) (ICEMRLLayer* iMRLLayer, eCEMRLCompositingCoordinatesOrientation orientation);

typedef CEHResult (*iCEMRLLayer_setContentsOrientation) (ICEMRLLayer* iMRLLayer, eCEMRLCompositingCoordinatesOrientation orientation);

/*!
 * V-table of ICEMRLLayer
 */
struct ICEMRLLayer_vtbl
{
	iCEMRLLayer_queryInterface	_queryInterface;	//!< Query interface.
	iCEMRLLayer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEMRLLayer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEMRLLayer_setUserData	_setUserData;
	iCEMRLLayer_getUserData	_getUserData;
	iCEMRLLayer_setCallback	_setCallback;
	iCEMRLLayer_setName	_setName;
	iCEMRLLayer_setWindow	_setWindow;
	iCEMRLLayer_printTree	_printTree;
	iCEMRLLayer_setNeedsDisplay	_setNeedsDisplay;
	iCEMRLLayer_setNeedsDisplayInRect	_setNeedsDisplayInRect;
	iCEMRLLayer_syncCompositingState	_syncCompositingState;
	iCEMRLLayer_parent	_parent;
	iCEMRLLayer_addChild	_addChild;
	iCEMRLLayer_removeFromParent	_removeFromParent;
	iCEMRLLayer_removeAllChildren	_removeAllChildren;
	iCEMRLLayer_setPosition	_setPosition;
	iCEMRLLayer_setAnchorPoint	_setAnchorPoint;
	iCEMRLLayer_setSize	_setSize;
	iCEMRLLayer_setTransform	_setTransform;
	iCEMRLLayer_setChildrenTransform	_setChildrenTransform;
	iCEMRLLayer_setPreserves3D	_setPreserves3D;
	iCEMRLLayer_setMasksToBounds	_setMasksToBounds;
	iCEMRLLayer_setDrawsContent	_setDrawsContent;
	iCEMRLLayer_setBackgroundColor	_setBackgroundColor;
	iCEMRLLayer_clearBackgroundColor	_clearBackgroundColor;
	iCEMRLLayer_setContentsOpaque	_setContentsOpaque;
	iCEMRLLayer_setBackfaceVisibility	_setBackfaceVisibility;
	iCEMRLLayer_setOpacity	_setOpacity;
	iCEMRLLayer_setContentsRect	_setContentsRect;
	iCEMRLLayer_setContentsToImage	_setContentsToImage;
	iCEMRLLayer_setContentsToMedia	_setContentsToMedia;
	iCEMRLLayer_setContentsBackgroundColor	_setContentsBackgroundColor;
	iCEMRLLayer_setGeometryOrientation	_setGeometryOrientation;
	iCEMRLLayer_setContentsOrientation	_setContentsOrientation;
};

/*! @}
 * end of ICEMRLLayer
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEMRLFactoryRef CEComICEMRLFactoryRef
 * @{
 */

class CEComICEMRLFactoryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEMRLFactoryRef() : _iMRLFactory(0) {}
	CEComICEMRLFactoryRef(ICEMRLFactory* iOther) : _iMRLFactory(0)
	{
		if (iOther)
		{
			_iMRLFactory = iOther;
			_iMRLFactory->_vtbl->_addRef(_iMRLFactory);
		}
	}

	CEComICEMRLFactoryRef(const CEComICEMRLFactoryRef& other) : _iMRLFactory(0)
	{
		if (other._iMRLFactory)
		{
			_iMRLFactory = other._iMRLFactory;
			_iMRLFactory->_vtbl->_addRef(_iMRLFactory);
		}
	}

	~CEComICEMRLFactoryRef()
	{
		if (_iMRLFactory)
		{
			ICEMRLFactory* tmp = _iMRLFactory;
			_iMRLFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEMRLFactory* iMRLFactory;
				void* _ptr;
			} uIntf;
			uIntf.iMRLFactory = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEMRLFactory, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iMRLFactory)
				{
					ICEMRLFactory* tmp = _iMRLFactory;
					_iMRLFactory = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iMRLFactory = uIntf.iMRLFactory;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEMRLFactory* object() const	{ return _iMRLFactory; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEMRLFactory* iOther)
	{
		if (_iMRLFactory)
		{
			ICEMRLFactory* tmp = _iMRLFactory;
			_iMRLFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iMRLFactory = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEMRLFactory* detach()
	{
		ICEMRLFactory* iIntf = _iMRLFactory;
		_iMRLFactory = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEMRLFactory* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iMRLFactory;
		if (_iMRLFactory)
		{
			_iMRLFactory->_vtbl->_addRef(_iMRLFactory);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEMRLFactory*() const	{ return _iMRLFactory; }
	FORCEINLINE_WITHOUT_DEBUG ICEMRLFactory& operator*() const	{ return *_iMRLFactory; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iMRLFactory == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEMRLFactory* iOther) const	{ return (_iMRLFactory != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEMRLFactory* iOther) const	{ return (_iMRLFactory == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEMRLFactoryRef& operator=(const CEComICEMRLFactoryRef& other)	{ return operator=(other._iMRLFactory); }

	CEComICEMRLFactoryRef& operator=(const ICEMRLFactory* iOther)
	{
		if (_iMRLFactory != iOther)
		{
			if (_iMRLFactory)
			{
				ICEMRLFactory* tmp = _iMRLFactory;
				_iMRLFactory = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iMRLFactory = const_cast<ICEMRLFactory*>(iOther);
			if (_iMRLFactory)
			{
				_iMRLFactory->_vtbl->_addRef(_iMRLFactory);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEMRLFactory** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEMRLFactoryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iMRLFactory && "has a com object reference. clear first.");
		return & _iMRLFactory; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEMRLFactoryRef& other)
	{
		bool result = false;
		if (_iMRLFactory)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iMRLFactory);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iMRLFactory ? _iMRLFactory->_vtbl->_queryInterface(_iMRLFactory, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iMRLFactory) { _iMRLFactory->_vtbl->_addRef(_iMRLFactory); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iMRLFactory) { _iMRLFactory->_vtbl->_release(_iMRLFactory); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createLayer(eCEMRLLayerType type, struct ICEMRLLayer* *const layerOut)	{ return _iMRLFactory ? _iMRLFactory->_vtbl->_createLayer(_iMRLFactory, type, layerOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createLayerRenderer(struct ICEMRLLayerRenderer* *const rendererOut)	{ return _iMRLFactory ? _iMRLFactory->_vtbl->_createLayerRenderer(_iMRLFactory, rendererOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEMRLFactory* _iMRLFactory;
};

/*! @}
 * end of CEComICEMRLFactoryRef
 */

/*! \defgroup CEComICEMRLLayerRendererRef CEComICEMRLLayerRendererRef
 * @{
 */

class CEComICEMRLLayerRendererRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEMRLLayerRendererRef() : _iMRLLayerRenderer(0) {}
	CEComICEMRLLayerRendererRef(ICEMRLLayerRenderer* iOther) : _iMRLLayerRenderer(0)
	{
		if (iOther)
		{
			_iMRLLayerRenderer = iOther;
			_iMRLLayerRenderer->_vtbl->_addRef(_iMRLLayerRenderer);
		}
	}

	CEComICEMRLLayerRendererRef(const CEComICEMRLLayerRendererRef& other) : _iMRLLayerRenderer(0)
	{
		if (other._iMRLLayerRenderer)
		{
			_iMRLLayerRenderer = other._iMRLLayerRenderer;
			_iMRLLayerRenderer->_vtbl->_addRef(_iMRLLayerRenderer);
		}
	}

	~CEComICEMRLLayerRendererRef()
	{
		if (_iMRLLayerRenderer)
		{
			ICEMRLLayerRenderer* tmp = _iMRLLayerRenderer;
			_iMRLLayerRenderer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEMRLLayerRenderer* iMRLLayerRenderer;
				void* _ptr;
			} uIntf;
			uIntf.iMRLLayerRenderer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEMRLLayerRenderer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iMRLLayerRenderer)
				{
					ICEMRLLayerRenderer* tmp = _iMRLLayerRenderer;
					_iMRLLayerRenderer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iMRLLayerRenderer = uIntf.iMRLLayerRenderer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayerRenderer* object() const	{ return _iMRLLayerRenderer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEMRLLayerRenderer* iOther)
	{
		if (_iMRLLayerRenderer)
		{
			ICEMRLLayerRenderer* tmp = _iMRLLayerRenderer;
			_iMRLLayerRenderer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iMRLLayerRenderer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEMRLLayerRenderer* detach()
	{
		ICEMRLLayerRenderer* iIntf = _iMRLLayerRenderer;
		_iMRLLayerRenderer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEMRLLayerRenderer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iMRLLayerRenderer;
		if (_iMRLLayerRenderer)
		{
			_iMRLLayerRenderer->_vtbl->_addRef(_iMRLLayerRenderer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEMRLLayerRenderer*() const	{ return _iMRLLayerRenderer; }
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayerRenderer& operator*() const	{ return *_iMRLLayerRenderer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iMRLLayerRenderer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEMRLLayerRenderer* iOther) const	{ return (_iMRLLayerRenderer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEMRLLayerRenderer* iOther) const	{ return (_iMRLLayerRenderer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEMRLLayerRendererRef& operator=(const CEComICEMRLLayerRendererRef& other)	{ return operator=(other._iMRLLayerRenderer); }

	CEComICEMRLLayerRendererRef& operator=(const ICEMRLLayerRenderer* iOther)
	{
		if (_iMRLLayerRenderer != iOther)
		{
			if (_iMRLLayerRenderer)
			{
				ICEMRLLayerRenderer* tmp = _iMRLLayerRenderer;
				_iMRLLayerRenderer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iMRLLayerRenderer = const_cast<ICEMRLLayerRenderer*>(iOther);
			if (_iMRLLayerRenderer)
			{
				_iMRLLayerRenderer->_vtbl->_addRef(_iMRLLayerRenderer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayerRenderer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEMRLLayerRendererRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iMRLLayerRenderer && "has a com object reference. clear first.");
		return & _iMRLLayerRenderer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEMRLLayerRendererRef& other)
	{
		bool result = false;
		if (_iMRLLayerRenderer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iMRLLayerRenderer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iMRLLayerRenderer ? _iMRLLayerRenderer->_vtbl->_queryInterface(_iMRLLayerRenderer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iMRLLayerRenderer) { _iMRLLayerRenderer->_vtbl->_addRef(_iMRLLayerRenderer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iMRLLayerRenderer) { _iMRLLayerRenderer->_vtbl->_release(_iMRLLayerRenderer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult render(struct ICEVGFactory* vgFactory, struct ICEVGContext* vgc, struct ICEMRLLayer* rootLayer, INT32 scX, INT32 scY, INT32 vpWidth, INT32 vpHeight)	{ return _iMRLLayerRenderer ? _iMRLLayerRenderer->_vtbl->_render(_iMRLLayerRenderer, vgFactory, vgc, rootLayer, scX, scY, vpWidth, vpHeight) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getMode(UINT8* c8sOut, UINT32 nC8s)	{ return _iMRLLayerRenderer ? _iMRLLayerRenderer->_vtbl->_getMode(_iMRLLayerRenderer, c8sOut, nC8s) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEMRLLayerRenderer* _iMRLLayerRenderer;
};

/*! @}
 * end of CEComICEMRLLayerRendererRef
 */

/*! \defgroup CEComICEMRLLayerCallbackRef CEComICEMRLLayerCallbackRef
 * @{
 */

class CEComICEMRLLayerCallbackRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEMRLLayerCallbackRef() : _iMRLLayerCallback(0) {}
	CEComICEMRLLayerCallbackRef(ICEMRLLayerCallback* iOther) : _iMRLLayerCallback(0)
	{
		if (iOther)
		{
			_iMRLLayerCallback = iOther;
			_iMRLLayerCallback->_vtbl->_addRef(_iMRLLayerCallback);
		}
	}

	CEComICEMRLLayerCallbackRef(const CEComICEMRLLayerCallbackRef& other) : _iMRLLayerCallback(0)
	{
		if (other._iMRLLayerCallback)
		{
			_iMRLLayerCallback = other._iMRLLayerCallback;
			_iMRLLayerCallback->_vtbl->_addRef(_iMRLLayerCallback);
		}
	}

	~CEComICEMRLLayerCallbackRef()
	{
		if (_iMRLLayerCallback)
		{
			ICEMRLLayerCallback* tmp = _iMRLLayerCallback;
			_iMRLLayerCallback = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEMRLLayerCallback* iMRLLayerCallback;
				void* _ptr;
			} uIntf;
			uIntf.iMRLLayerCallback = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEMRLLayerCallback, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iMRLLayerCallback)
				{
					ICEMRLLayerCallback* tmp = _iMRLLayerCallback;
					_iMRLLayerCallback = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iMRLLayerCallback = uIntf.iMRLLayerCallback;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayerCallback* object() const	{ return _iMRLLayerCallback; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEMRLLayerCallback* iOther)
	{
		if (_iMRLLayerCallback)
		{
			ICEMRLLayerCallback* tmp = _iMRLLayerCallback;
			_iMRLLayerCallback = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iMRLLayerCallback = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEMRLLayerCallback* detach()
	{
		ICEMRLLayerCallback* iIntf = _iMRLLayerCallback;
		_iMRLLayerCallback = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEMRLLayerCallback* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iMRLLayerCallback;
		if (_iMRLLayerCallback)
		{
			_iMRLLayerCallback->_vtbl->_addRef(_iMRLLayerCallback);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEMRLLayerCallback*() const	{ return _iMRLLayerCallback; }
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayerCallback& operator*() const	{ return *_iMRLLayerCallback; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iMRLLayerCallback == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEMRLLayerCallback* iOther) const	{ return (_iMRLLayerCallback != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEMRLLayerCallback* iOther) const	{ return (_iMRLLayerCallback == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEMRLLayerCallbackRef& operator=(const CEComICEMRLLayerCallbackRef& other)	{ return operator=(other._iMRLLayerCallback); }

	CEComICEMRLLayerCallbackRef& operator=(const ICEMRLLayerCallback* iOther)
	{
		if (_iMRLLayerCallback != iOther)
		{
			if (_iMRLLayerCallback)
			{
				ICEMRLLayerCallback* tmp = _iMRLLayerCallback;
				_iMRLLayerCallback = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iMRLLayerCallback = const_cast<ICEMRLLayerCallback*>(iOther);
			if (_iMRLLayerCallback)
			{
				_iMRLLayerCallback->_vtbl->_addRef(_iMRLLayerCallback);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayerCallback** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEMRLLayerCallbackRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iMRLLayerCallback && "has a com object reference. clear first.");
		return & _iMRLLayerCallback; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEMRLLayerCallbackRef& other)
	{
		bool result = false;
		if (_iMRLLayerCallback)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iMRLLayerCallback);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iMRLLayerCallback ? _iMRLLayerCallback->_vtbl->_queryInterface(_iMRLLayerCallback, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iMRLLayerCallback) { _iMRLLayerCallback->_vtbl->_addRef(_iMRLLayerCallback); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iMRLLayerCallback) { _iMRLLayerCallback->_vtbl->_release(_iMRLLayerCallback); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult render(struct ICEVGContext* iVgc)	{ return _iMRLLayerCallback ? _iMRLLayerCallback->_vtbl->_render(_iMRLLayerCallback, iVgc) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult syncChildren()	{ return _iMRLLayerCallback ? _iMRLLayerCallback->_vtbl->_syncChildren(_iMRLLayerCallback) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEMRLLayerCallback* _iMRLLayerCallback;
};

/*! @}
 * end of CEComICEMRLLayerCallbackRef
 */

/*! \defgroup CEComICEMRLLWindowRef CEComICEMRLLWindowRef
 * @{
 */

class CEComICEMRLLWindowRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEMRLLWindowRef() : _iMRLLWindow(0) {}
	CEComICEMRLLWindowRef(ICEMRLLWindow* iOther) : _iMRLLWindow(0)
	{
		if (iOther)
		{
			_iMRLLWindow = iOther;
			_iMRLLWindow->_vtbl->_addRef(_iMRLLWindow);
		}
	}

	CEComICEMRLLWindowRef(const CEComICEMRLLWindowRef& other) : _iMRLLWindow(0)
	{
		if (other._iMRLLWindow)
		{
			_iMRLLWindow = other._iMRLLWindow;
			_iMRLLWindow->_vtbl->_addRef(_iMRLLWindow);
		}
	}

	~CEComICEMRLLWindowRef()
	{
		if (_iMRLLWindow)
		{
			ICEMRLLWindow* tmp = _iMRLLWindow;
			_iMRLLWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEMRLLWindow* iMRLLWindow;
				void* _ptr;
			} uIntf;
			uIntf.iMRLLWindow = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEMRLLWindow, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iMRLLWindow)
				{
					ICEMRLLWindow* tmp = _iMRLLWindow;
					_iMRLLWindow = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iMRLLWindow = uIntf.iMRLLWindow;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLWindow* object() const	{ return _iMRLLWindow; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEMRLLWindow* iOther)
	{
		if (_iMRLLWindow)
		{
			ICEMRLLWindow* tmp = _iMRLLWindow;
			_iMRLLWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iMRLLWindow = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEMRLLWindow* detach()
	{
		ICEMRLLWindow* iIntf = _iMRLLWindow;
		_iMRLLWindow = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEMRLLWindow* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iMRLLWindow;
		if (_iMRLLWindow)
		{
			_iMRLLWindow->_vtbl->_addRef(_iMRLLWindow);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEMRLLWindow*() const	{ return _iMRLLWindow; }
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLWindow& operator*() const	{ return *_iMRLLWindow; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iMRLLWindow == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEMRLLWindow* iOther) const	{ return (_iMRLLWindow != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEMRLLWindow* iOther) const	{ return (_iMRLLWindow == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEMRLLWindowRef& operator=(const CEComICEMRLLWindowRef& other)	{ return operator=(other._iMRLLWindow); }

	CEComICEMRLLWindowRef& operator=(const ICEMRLLWindow* iOther)
	{
		if (_iMRLLWindow != iOther)
		{
			if (_iMRLLWindow)
			{
				ICEMRLLWindow* tmp = _iMRLLWindow;
				_iMRLLWindow = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iMRLLWindow = const_cast<ICEMRLLWindow*>(iOther);
			if (_iMRLLWindow)
			{
				_iMRLLWindow->_vtbl->_addRef(_iMRLLWindow);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEMRLLWindow** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEMRLLWindowRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iMRLLWindow && "has a com object reference. clear first.");
		return & _iMRLLWindow; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEMRLLWindowRef& other)
	{
		bool result = false;
		if (_iMRLLWindow)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iMRLLWindow);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iMRLLWindow ? _iMRLLWindow->_vtbl->_queryInterface(_iMRLLWindow, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iMRLLWindow) { _iMRLLWindow->_vtbl->_addRef(_iMRLLWindow); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iMRLLWindow) { _iMRLLWindow->_vtbl->_release(_iMRLLWindow); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidateRect(INT32 x, INT32 y, INT32 width, INT32 height)	{ return _iMRLLWindow ? _iMRLLWindow->_vtbl->_invalidateRect(_iMRLLWindow, x, y, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult invalidate()	{ return _iMRLLWindow ? _iMRLLWindow->_vtbl->_invalidate(_iMRLLWindow) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEMRLLWindow* _iMRLLWindow;
};

/*! @}
 * end of CEComICEMRLLWindowRef
 */

/*! \defgroup CEComICEMRLLayerRef CEComICEMRLLayerRef
 * @{
 */

class CEComICEMRLLayerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEMRLLayerRef() : _iMRLLayer(0) {}
	CEComICEMRLLayerRef(ICEMRLLayer* iOther) : _iMRLLayer(0)
	{
		if (iOther)
		{
			_iMRLLayer = iOther;
			_iMRLLayer->_vtbl->_addRef(_iMRLLayer);
		}
	}

	CEComICEMRLLayerRef(const CEComICEMRLLayerRef& other) : _iMRLLayer(0)
	{
		if (other._iMRLLayer)
		{
			_iMRLLayer = other._iMRLLayer;
			_iMRLLayer->_vtbl->_addRef(_iMRLLayer);
		}
	}

	~CEComICEMRLLayerRef()
	{
		if (_iMRLLayer)
		{
			ICEMRLLayer* tmp = _iMRLLayer;
			_iMRLLayer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEMRLLayer* iMRLLayer;
				void* _ptr;
			} uIntf;
			uIntf.iMRLLayer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEMRLLayer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iMRLLayer)
				{
					ICEMRLLayer* tmp = _iMRLLayer;
					_iMRLLayer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iMRLLayer = uIntf.iMRLLayer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayer* object() const	{ return _iMRLLayer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEMRLLayer* iOther)
	{
		if (_iMRLLayer)
		{
			ICEMRLLayer* tmp = _iMRLLayer;
			_iMRLLayer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iMRLLayer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEMRLLayer* detach()
	{
		ICEMRLLayer* iIntf = _iMRLLayer;
		_iMRLLayer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEMRLLayer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iMRLLayer;
		if (_iMRLLayer)
		{
			_iMRLLayer->_vtbl->_addRef(_iMRLLayer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEMRLLayer*() const	{ return _iMRLLayer; }
	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayer& operator*() const	{ return *_iMRLLayer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iMRLLayer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEMRLLayer* iOther) const	{ return (_iMRLLayer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEMRLLayer* iOther) const	{ return (_iMRLLayer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEMRLLayerRef& operator=(const CEComICEMRLLayerRef& other)	{ return operator=(other._iMRLLayer); }

	CEComICEMRLLayerRef& operator=(const ICEMRLLayer* iOther)
	{
		if (_iMRLLayer != iOther)
		{
			if (_iMRLLayer)
			{
				ICEMRLLayer* tmp = _iMRLLayer;
				_iMRLLayer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iMRLLayer = const_cast<ICEMRLLayer*>(iOther);
			if (_iMRLLayer)
			{
				_iMRLLayer->_vtbl->_addRef(_iMRLLayer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEMRLLayer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEMRLLayerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iMRLLayer && "has a com object reference. clear first.");
		return & _iMRLLayer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEMRLLayerRef& other)
	{
		bool result = false;
		if (_iMRLLayer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iMRLLayer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_queryInterface(_iMRLLayer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iMRLLayer) { _iMRLLayer->_vtbl->_addRef(_iMRLLayer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iMRLLayer) { _iMRLLayer->_vtbl->_release(_iMRLLayer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setUserData(void* userData)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setUserData(_iMRLLayer, userData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getUserData(void* *const userDataOut)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_getUserData(_iMRLLayer, userDataOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCallback(struct ICEMRLLayerCallback* cb)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setCallback(_iMRLLayer, cb) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setName(struct ICEUString* name)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setName(_iMRLLayer, name) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setWindow(struct ICEMRLLWindow* iWin)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setWindow(_iMRLLayer, iWin) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult printTree()	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_printTree(_iMRLLayer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setNeedsDisplay()	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setNeedsDisplay(_iMRLLayer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setNeedsDisplayInRect(float x, float y, float width, float height)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setNeedsDisplayInRect(_iMRLLayer, x, y, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult syncCompositingState()	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_syncCompositingState(_iMRLLayer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult parent(struct ICEMRLLayer* *const parentOut)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_parent(_iMRLLayer, parentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult addChild(struct ICEMRLLayer* layer)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_addChild(_iMRLLayer, layer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeFromParent()	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_removeFromParent(_iMRLLayer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult removeAllChildren()	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_removeAllChildren(_iMRLLayer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setPosition(float x, float y)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setPosition(_iMRLLayer, x, y) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setAnchorPoint(float x, float y, float z)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setAnchorPoint(_iMRLLayer, x, y, z) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSize(float width, float height)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setSize(_iMRLLayer, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setTransform(const float* m16)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setTransform(_iMRLLayer, m16) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setChildrenTransform(const float* m16)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setChildrenTransform(_iMRLLayer, m16) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setPreserves3D(bool b)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setPreserves3D(_iMRLLayer, b) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setMasksToBounds(bool b)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setMasksToBounds(_iMRLLayer, b) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setDrawsContent(bool b)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setDrawsContent(_iMRLLayer, b) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBackgroundColor(float r, float g, float b, float a)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setBackgroundColor(_iMRLLayer, r, g, b, a) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearBackgroundColor()	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_clearBackgroundColor(_iMRLLayer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentsOpaque(bool b)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setContentsOpaque(_iMRLLayer, b) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setBackfaceVisibility(bool b)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setBackfaceVisibility(_iMRLLayer, b) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setOpacity(float o)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setOpacity(_iMRLLayer, o) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentsRect(INT32 x, INT32 y, INT32 width, INT32 height)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setContentsRect(_iMRLLayer, x, y, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentsToImage(struct ICEVGSurface* imgSurface)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setContentsToImage(_iMRLLayer, imgSurface) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentsToMedia(struct ICEUnknown* mediaSurface)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setContentsToMedia(_iMRLLayer, mediaSurface) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentsBackgroundColor(float r, float g, float b, float a)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setContentsBackgroundColor(_iMRLLayer, r, g, b, a) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setGeometryOrientation(eCEMRLCompositingCoordinatesOrientation orientation)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setGeometryOrientation(_iMRLLayer, orientation) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentsOrientation(eCEMRLCompositingCoordinatesOrientation orientation)	{ return _iMRLLayer ? _iMRLLayer->_vtbl->_setContentsOrientation(_iMRLLayer, orientation) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEMRLLayer* _iMRLLayer;
};

/*! @}
 * end of CEComICEMRLLayerRef
 */

#endif // __cplusplus

#endif
