///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlWebKit_h
#define ICEHtmlWebKit_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "CEUITypes.h"
#include "ICEUString.h"
#include "URL.h"
#include "ICEVG.h"
#include "ICEHtmlCredential.h"
#include "ICENetwork.h"
#include "ceuthread.h"
#include "ceulinearlists.h"
#include "CEComAtomicSupport.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------


/*!
 * CEWebKitHtmlFrameScrolling
 */
typedef enum
{
	CEWebKitHtmlFrameScrolling_Undefined,
	CEWebKitHtmlFrameScrolling_No,
	CEWebKitHtmlFrameScrolling_Yes,
	CEWebKitHtmlFrameScrolling_Auto,
	CEWebKitHtmlFrameScrolling_Vertical_No,
	CEWebKitHtmlFrameScrolling_Vertical_Yes,
	CEWebKitHtmlFrameScrolling_Vertical_Auto,
	CEWebKitHtmlFrameScrolling_Horizontal_No,
	CEWebKitHtmlFrameScrolling_Horizontal_Yes,
	CEWebKitHtmlFrameScrolling_Horizontal_Auto,
} CEWebKitHtmlFrameScrolling;

typedef enum
{
	CEWebKitHtmlInputType_Undefined,
	CEWebKitHtmlInputType_TEXT,
	CEWebKitHtmlInputType_PASSWORD,
	CEWebKitHtmlInputType_ISINDEX,
	CEWebKitHtmlInputType_CHECKBOX,
	CEWebKitHtmlInputType_RADIO,
	CEWebKitHtmlInputType_SUBMIT,
	CEWebKitHtmlInputType_RESET,
	CEWebKitHtmlInputType_FILE,
	CEWebKitHtmlInputType_HIDDEN,
	CEWebKitHtmlInputType_IMAGE,
	CEWebKitHtmlInputType_BUTTON,
	CEWebKitHtmlInputType_SEARCH,
	CEWebKitHtmlInputType_RANGE,
	CEWebKitHtmlInputType_EMAIL,
	CEWebKitHtmlInputType_NUMBER,
	CEWebKitHtmlInputType_TELEPHONE,
	CEWebKitHtmlInputType_URL,
} CEWebKitHtmlInputType;

typedef enum
{
	CEWebKitHtmlScrollMode_None,
	CEWebKitHtmlScrollMode_Window, // for old scroll
	CEWebKitHtmlScrollMode_Document,
	CEWebKitHtmlScrollMode_DocumentZoomFactor2
} CEWebKitHtmlScrollMode;

typedef enum
{
	CEWebKitResouceType_None,
	CEWebKitResouceType_Body,
	CEWebKitResouceType_Image,
	CEWebKitResouceType_CSS,
	CEWebKitResouceType_Script,
	CEWebKitResouceType_Font,
	CEWebKitResouceType_XSLT,
	CEWebKitResouceType_XBL,
} CEWebKitResouceType;

typedef enum
{
	CEHtmlDrawWidget_Button,
	CEHtmlDrawWidget_Checkbox,
	CEHtmlDrawWidget_Radio,
	CEHtmlDrawWidget_TextField,
	CEHtmlDrawWidget_TextArea,
	CEHtmlDrawWidget_MenulistButton,
	CEHtmlDrawWidget_Menulist
} CEHtmlDrawWidget;

typedef enum
{
	CEHtmlDrawWidgetState_Enable  = 1 << 0,
	CEHtmlDrawWidgetState_Checked = 1 << 1,
	CEHtmlDrawWidgetState_Pushed  = 1 << 2
} CEHtmlDrawWidgetState;

typedef enum
{
	CEHtmlDrawScrollbarPart_Nop,
	CEHtmlDrawScrollbarPart_BackButton,
	CEHtmlDrawScrollbarPart_BackTrack,
	CEHtmlDrawScrollbarPart_ThumbPart,
	CEHtmlDrawScrollbarPart_ForwardTrack,
	CEHtmlDrawScrollbarPart_ForwardButton
} CEHtmlDrawScrollbarPart;

typedef enum
{
	CEHtmlScrollbarControlSize_Regular,
	CEHtmlScrollbarControlSize_Small
} CEHtmlScrollbarControlSize;


/*!
 * ICEHtmlFocusNavigatorPeer
 */
typedef enum
{
	CEHtmlFocusNavigatorPeerStatus_None = 0,
	CEHtmlFocusNavigatorPeerStatus_Debug_DumpSvg
} CEHtmlFocusNavigatorPeerStatus;


/*!
 * ICEHtmlFocusNavigator
 */
typedef enum
{
	CEHtmlFocusItemType_None = 0,
	CEHtmlFocusItemType_Anchor,
	CEHtmlFocusItemType_Frame,
	CEHtmlFocusItemType_TextLine,
	CEHtmlFocusItemType_TextArea,
	CEHtmlFocusItemType_Canvas
} CEHtmlFocusItemType;

typedef enum
{
	CEHtmlFocusMoveStatus_INVALID            = 0,
	CEHtmlFocusMoveStatus_FOCUSED            = 1,
	CEHtmlFocusMoveStatus_FOCUSED_BY_POINT   = 2,
	CEHtmlFocusMoveStatus_NOT_FOUND          = 3,
	CEHtmlFocusMoveStatus_SCROLL_AND_FOCUSED = 4,
	CEHtmlFocusMoveStatus_SCROLL_ONLY        = 5
} CEHtmlFocusMoveStatus;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEWebKit ICEWebKit
 * @{
 */

/*!
 * ID of ICEWebKit
 */
#define CEComIID_ICEWebKit 0x28f1b3f3

/*!
 * ICEWebKit
 */
typedef struct ICEWebKit
{
	const struct ICEWebKit_vtbl* _vtbl;
} ICEWebKit;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKit	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEWebKit_queryInterface) (ICEWebKit* iWebKit, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKit_addRef) (ICEWebKit* iWebKit);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKit_release) (ICEWebKit* iWebKit);

typedef CEHResult (*iCEWebKit_init) (ICEWebKit* iWebKit, struct ICEHtmlWebKitEnvironment* iEnvironment, struct ICENetwork* iCENetwork);

typedef CEHResult (*iCEWebKit_shutdown) (ICEWebKit* iWebKit);

typedef CEHResult (*iCEWebKit_createWebKitFrameWindow) (ICEWebKit* iWebKit, struct ICEWebKitFrameWindow** iFrameWindowOut);

typedef CEHResult (*iCEWebKit_setJSPrivilegeExtObjectListener) (ICEWebKit* iWebKit, struct ICEJSPrivilegeExtObjectListener* listener);

typedef CEHResult (*iCEWebKit_pruneCache) (ICEWebKit* iWebKit);

typedef CEHResult (*iCEWebKit_setProxy) (ICEWebKit* iWebKit, bool isProxyEnable, struct ICEUString* host, UINT16 port);

typedef CEHResult (*iCEWebKit_setCookieEnable) (ICEWebKit* iWebKit, bool isCookieEnable);

typedef CEHResult (*iCEWebKit_deleteAllCookies) (ICEWebKit* iWebKit);

typedef CEHResult (*iCEWebKit_setCustomHeaderFileds) (ICEWebKit* iWebKit, UINT16 numFields, struct ICEUString* const* fieldNames, struct ICEUString* const* fieldValues);

typedef CEHResult (*iCEWebKit_preparePluginInfo) (ICEWebKit* iWebKit);

typedef CEHResult (*iCEWebKit_setAcceptLanguage) (ICEWebKit* iWebKit, struct ICEUString* acceptLanguage);

/*!
 * V-table of ICEWebKit
 */
struct ICEWebKit_vtbl
{
	iCEWebKit_queryInterface	_queryInterface;	//!< Query interface.
	iCEWebKit_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEWebKit_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEWebKit_init	_init;
	iCEWebKit_shutdown	_shutdown;
	iCEWebKit_createWebKitFrameWindow	_createWebKitFrameWindow;
	iCEWebKit_setJSPrivilegeExtObjectListener	_setJSPrivilegeExtObjectListener;
	iCEWebKit_pruneCache	_pruneCache;
	iCEWebKit_setProxy	_setProxy;
	iCEWebKit_setCookieEnable	_setCookieEnable;
	iCEWebKit_deleteAllCookies	_deleteAllCookies;
	iCEWebKit_setCustomHeaderFileds	_setCustomHeaderFileds;
	iCEWebKit_preparePluginInfo	_preparePluginInfo;
	iCEWebKit_setAcceptLanguage	_setAcceptLanguage;
};

/*! @}
 * end of ICEWebKit
 */

/*! \defgroup ICEHtmlWebKitEnvironment ICEHtmlWebKitEnvironment
 * @{
 */

/*!
 * ID of ICEHtmlWebKitEnvironment
 */
#define CEComIID_ICEHtmlWebKitEnvironment 0x7c9fb70f

/*!
 * ICEHtmlWebKitEnvironment
 */
typedef struct ICEHtmlWebKitEnvironment
{
	const struct ICEHtmlWebKitEnvironment_vtbl* _vtbl;
} ICEHtmlWebKitEnvironment;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitEnvironment	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitEnvironment_queryInterface) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitEnvironment_addRef) (ICEHtmlWebKitEnvironment* iWebKitEnvironment);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitEnvironment_release) (ICEHtmlWebKitEnvironment* iWebKitEnvironment);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getCEUThread) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, CEUThreadRef* ceuthreadOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getUserAgent) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, struct ICEUString* uaOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getDatabasePath) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, struct ICEUString** dbPathOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getPluginPath) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, struct ICEUString** pluginPathOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getProxyHostPort) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, bool* isProxyEnable, struct ICEUString** proxyHostOut, UINT16* proxyPortOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getCertDirInfo) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, struct ICEUString** sslCertDirPathOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getCacheDirInfo) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, struct ICEUString** cacheDataPathOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getEnablePlugin) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, bool* enableOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getAcceptLanguage) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, struct ICEUString** alOut);

typedef CEHResult (*iCEHtmlWebKitEnvironment_getMaxResourceCacheSize) (ICEHtmlWebKitEnvironment* iWebKitEnvironment, UINT32* maxCacheSizeOut);

/*!
 * V-table of ICEHtmlWebKitEnvironment
 */
struct ICEHtmlWebKitEnvironment_vtbl
{
	iCEHtmlWebKitEnvironment_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitEnvironment_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitEnvironment_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitEnvironment_getCEUThread	_getCEUThread;
	iCEHtmlWebKitEnvironment_getUserAgent	_getUserAgent;
	iCEHtmlWebKitEnvironment_getDatabasePath	_getDatabasePath;
	iCEHtmlWebKitEnvironment_getPluginPath	_getPluginPath;
	iCEHtmlWebKitEnvironment_getProxyHostPort	_getProxyHostPort;
	iCEHtmlWebKitEnvironment_getCertDirInfo	_getCertDirInfo;
	iCEHtmlWebKitEnvironment_getCacheDirInfo	_getCacheDirInfo;
	iCEHtmlWebKitEnvironment_getEnablePlugin	_getEnablePlugin;
	iCEHtmlWebKitEnvironment_getAcceptLanguage	_getAcceptLanguage;
	iCEHtmlWebKitEnvironment_getMaxResourceCacheSize	_getMaxResourceCacheSize;
};

/*! @}
 * end of ICEHtmlWebKitEnvironment
 */

/*! \defgroup ICEWebKitFrameWindow ICEWebKitFrameWindow
 * @{
 */

/*!
 * ID of ICEWebKitFrameWindow
 */
#define CEComIID_ICEWebKitFrameWindow 0xc390ed9b

/*!
 * ICEWebKitFrameWindow
 */
typedef struct ICEWebKitFrameWindow
{
	const struct ICEWebKitFrameWindow_vtbl* _vtbl;
} ICEWebKitFrameWindow;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitFrameWindow	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEWebKitFrameWindow_queryInterface) (ICEWebKitFrameWindow* iWebKitFrameWindow, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitFrameWindow_addRef) (ICEWebKitFrameWindow* iWebKitFrameWindow);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitFrameWindow_release) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_init) (ICEWebKitFrameWindow* iWebKitFrameWindow, struct ICEHtmlWebKitFrameWindowWidget* iWidget, struct ICEHtmlWebKitFrameWindowChromeClient* iChromeClient, struct ICEHtmlFocusNavigator* iFocusNavigator);

typedef CEHResult (*iCEWebKitFrameWindow_shutdown) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_load) (ICEWebKitFrameWindow* iWebKitFrameWindow, struct ICEUString* iUrl, struct ICEUString* iReferer);

typedef CEHResult (*iCEWebKitFrameWindow_paint) (ICEWebKitFrameWindow* iWebKitFrameWindow, struct ICEVGContext* iVGC, CERect* dirtyRect);

typedef CEHResult (*iCEWebKitFrameWindow_mouse) (ICEWebKitFrameWindow* iWebKitFrameWindow, CEMouseEventParam* mouseEventParam, bool* consumedOut);

typedef CEHResult (*iCEWebKitFrameWindow_keyboard) (ICEWebKitFrameWindow* iWebKitFrameWindow, CEKeyboardEventParam* keyboardEventParam, bool* consumedOut);

typedef CEHResult (*iCEWebKitFrameWindow_focus) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool focused);

typedef CEHResult (*iCEWebKitFrameWindow_back) (ICEWebKitFrameWindow* iWebKitFrameWindow, UINT32 amount);

typedef CEHResult (*iCEWebKitFrameWindow_forward) (ICEWebKitFrameWindow* iWebKitFrameWindow, UINT32 amount);

typedef CEHResult (*iCEWebKitFrameWindow_reload) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool skipCache);

typedef CEHResult (*iCEWebKitFrameWindow_hitTest) (ICEWebKitFrameWindow* iWebKitFrameWindow, INT32 x, INT32 y, struct ICEURL** linkUrlOut, struct ICEURL** imageUrlOut, struct ICEUString** text, CERect* zoomRect);

typedef CEHResult (*iCEWebKitFrameWindow_insertText) (ICEWebKitFrameWindow* iWebKitFrameWindow, struct ICEUString* iString, CEUUINT32List* styleList, CEUUINT32List* lengthList, INT32 caretPosition, bool* consumedOut);

typedef CEHResult (*iCEWebKitFrameWindow_endComposition) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_clearText) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_exitIME) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_setSelectedItemsPopupMenu) (ICEWebKitFrameWindow* iWebKitFrameWindow, UINT32 selectedIndex, void *client);

typedef CEHResult (*iCEWebKitFrameWindow_shrinkHistory) (ICEWebKitFrameWindow* iWebKitFrameWindow, UINT32 minimumSize);

typedef CEHResult (*iCEWebKitFrameWindow_scroll) (ICEWebKitFrameWindow* iWebKitFrameWindow, INT32 x, INT32 y, INT32 dx, INT32 dy, UINT32 modifiers, bool* consumedOut);

typedef CEHResult (*iCEWebKitFrameWindow_resize) (ICEWebKitFrameWindow* iWebKitFrameWindow, INT32 width, INT32 height);

typedef CEHResult (*iCEWebKitFrameWindow_setCustomTextEncodingName) (ICEWebKitFrameWindow* iWebKitFrameWindow, struct ICEUString* iTitle);

typedef CEHResult (*iCEWebKitFrameWindow_getSettings) (ICEWebKitFrameWindow* iWebKitFrameWindow, struct ICEWebKitSettings** iSettingsOut);

typedef CEHResult (*iCEWebKitFrameWindow_stop) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_emptyPage) (ICEWebKitFrameWindow* iWebKitFrameWindow);

typedef CEHResult (*iCEWebKitFrameWindow_isEmpty) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool* isEmptyOut);

typedef CEHResult (*iCEWebKitFrameWindow_setAllowsScrolling) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool visible);

typedef CEHResult (*iCEWebKitFrameWindow_didReceiveResponseCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderSize, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext, bool syncRequest, UINT32 sslErr);

typedef CEHResult (*iCEWebKitFrameWindow_didReceiveDataCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, UINT32 httpCode, const char* url, const void* data, UINT32 size, bool syncRequest);

typedef CEHResult (*iCEWebKitFrameWindow_didFinishLoadingCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, bool syncRequest);

typedef CEHResult (*iCEWebKitFrameWindow_didFinishLoadingAllInOneCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderSize, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext, const void* data, UINT32 size, bool syncRequest);

typedef CEHResult (*iCEWebKitFrameWindow_willSendRequestCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, const char* url, bool syncRequest);

typedef CEHResult (*iCEWebKitFrameWindow_didFailCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, INT32 lowLevelError, CEHResult resultCode, bool noContext, bool syncRequest);

typedef CEHResult (*iCEWebKitFrameWindow_replyBadCertCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, unsigned long identifier, bool sslContinue);

typedef CEHResult (*iCEWebKitFrameWindow_replyAuthCallback) (ICEWebKitFrameWindow* iWebKitFrameWindow, unsigned long identifier, struct ICEUString* site, struct ICEUString* realm, struct ICEUString* username, struct ICEUString* password, bool authContinue, bool updateSavedFlag);

typedef CEHResult (*iCEWebKitFrameWindow_getContentsSize) (ICEWebKitFrameWindow* iWebKitFrameWindow, INT32* widthOut, INT32* heightOut);

typedef CEHResult (*iCEWebKitFrameWindow_setVisibleRect) (ICEWebKitFrameWindow* iWebKitFrameWindow, INT32 x, INT32 y, INT32 width, INT32 height);

typedef CEHResult (*iCEWebKitFrameWindow_confirmPlugin) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool result, bool keepResult, void *const cData);

typedef CEHResult (*iCEWebKitFrameWindow_replyNetworkLibraryError) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool result, struct ICEUString* errorPageStr);

typedef CEHResult (*iCEWebKitFrameWindow_getPage) (ICEWebKitFrameWindow* iWebKitFrameWindow, void** newPageOut);

typedef CEHResult (*iCEWebKitFrameWindow_setCertificate) (ICEWebKitFrameWindow* iWebKitFrameWindow, const void* webCoreJob, void* cert);

typedef CEHResult (*iCEWebKitFrameWindow_setHitTestPadding) (ICEWebKitFrameWindow* iWebKitFrameWindow, INT32 docPadding);

typedef CEHResult (*iCEWebKitFrameWindow_changeZoomFactor) (ICEWebKitFrameWindow* iWebKitFrameWindow, float scale);

typedef CEHResult (*iCEWebKitFrameWindow_getPageSizeMultiplier) (ICEWebKitFrameWindow* iWebKitFrameWindow, float *const multiplierOut);

typedef CEHResult (*iCEWebKitFrameWindow_getElementUrl) (ICEWebKitFrameWindow* iWebKitFrameWindow, void* hView, struct ICEURL** anchorUrlOut);

typedef CEHResult (*iCEWebKitFrameWindow_getElementRect) (ICEWebKitFrameWindow* iWebKitFrameWindow, void* hView, CERect* rectOut);

typedef CEHResult (*iCEWebKitFrameWindow_isDocumentCoordinateMode) (ICEWebKitFrameWindow* iWebKitFrameWindow, bool* resultOut);

typedef CEHResult (*iCEWebKitFrameWindow_windowRectToContentsRect) (ICEWebKitFrameWindow* iWebKitFrameWindow, const CERect* windowRect, CERect* contentRectOut);

typedef CEHResult (*iCEWebKitFrameWindow_contentsRectToWindowRect) (ICEWebKitFrameWindow* iWebKitFrameWindow, const CERect* contentRect, CERect* windowRectOut);

typedef CEHResult (*iCEWebKitFrameWindow_windowPointToContentsPoint) (ICEWebKitFrameWindow* iWebKitFrameWindow, const CEPointBase* windowPos, CEPointBase* contentPosOut);

typedef CEHResult (*iCEWebKitFrameWindow_contentsPointToWindowPoint) (ICEWebKitFrameWindow* iWebKitFrameWindow, const CEPointBase* contentPos, CEPointBase* windowPosOut);

/*!
 * V-table of ICEWebKitFrameWindow
 */
struct ICEWebKitFrameWindow_vtbl
{
	iCEWebKitFrameWindow_queryInterface	_queryInterface;	//!< Query interface.
	iCEWebKitFrameWindow_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEWebKitFrameWindow_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEWebKitFrameWindow_init	_init;
	iCEWebKitFrameWindow_shutdown	_shutdown;
	iCEWebKitFrameWindow_load	_load;
	iCEWebKitFrameWindow_paint	_paint;
	iCEWebKitFrameWindow_mouse	_mouse;
	iCEWebKitFrameWindow_keyboard	_keyboard;
	iCEWebKitFrameWindow_focus	_focus;
	iCEWebKitFrameWindow_back	_back;
	iCEWebKitFrameWindow_forward	_forward;
	iCEWebKitFrameWindow_reload	_reload;
	iCEWebKitFrameWindow_hitTest	_hitTest;
	iCEWebKitFrameWindow_insertText	_insertText;
	iCEWebKitFrameWindow_endComposition	_endComposition;
	iCEWebKitFrameWindow_clearText	_clearText;
	iCEWebKitFrameWindow_exitIME	_exitIME;
	iCEWebKitFrameWindow_setSelectedItemsPopupMenu	_setSelectedItemsPopupMenu;
	iCEWebKitFrameWindow_shrinkHistory	_shrinkHistory;
	iCEWebKitFrameWindow_scroll	_scroll;
	iCEWebKitFrameWindow_resize	_resize;
	iCEWebKitFrameWindow_setCustomTextEncodingName	_setCustomTextEncodingName;
	iCEWebKitFrameWindow_getSettings	_getSettings;
	iCEWebKitFrameWindow_stop	_stop;
	iCEWebKitFrameWindow_emptyPage	_emptyPage;
	iCEWebKitFrameWindow_isEmpty	_isEmpty;
	iCEWebKitFrameWindow_setAllowsScrolling	_setAllowsScrolling;
	iCEWebKitFrameWindow_didReceiveResponseCallback	_didReceiveResponseCallback;
	iCEWebKitFrameWindow_didReceiveDataCallback	_didReceiveDataCallback;
	iCEWebKitFrameWindow_didFinishLoadingCallback	_didFinishLoadingCallback;
	iCEWebKitFrameWindow_didFinishLoadingAllInOneCallback	_didFinishLoadingAllInOneCallback;
	iCEWebKitFrameWindow_willSendRequestCallback	_willSendRequestCallback;
	iCEWebKitFrameWindow_didFailCallback	_didFailCallback;
	iCEWebKitFrameWindow_replyBadCertCallback	_replyBadCertCallback;
	iCEWebKitFrameWindow_replyAuthCallback	_replyAuthCallback;
	iCEWebKitFrameWindow_getContentsSize	_getContentsSize;
	iCEWebKitFrameWindow_setVisibleRect	_setVisibleRect;
	iCEWebKitFrameWindow_confirmPlugin	_confirmPlugin;
	iCEWebKitFrameWindow_replyNetworkLibraryError	_replyNetworkLibraryError;
	iCEWebKitFrameWindow_getPage	_getPage;
	iCEWebKitFrameWindow_setCertificate	_setCertificate;
	iCEWebKitFrameWindow_setHitTestPadding	_setHitTestPadding;
	iCEWebKitFrameWindow_changeZoomFactor	_changeZoomFactor;
	iCEWebKitFrameWindow_getPageSizeMultiplier	_getPageSizeMultiplier;
	iCEWebKitFrameWindow_getElementUrl	_getElementUrl;
	iCEWebKitFrameWindow_getElementRect	_getElementRect;
	iCEWebKitFrameWindow_isDocumentCoordinateMode	_isDocumentCoordinateMode;
	iCEWebKitFrameWindow_windowRectToContentsRect	_windowRectToContentsRect;
	iCEWebKitFrameWindow_contentsRectToWindowRect	_contentsRectToWindowRect;
	iCEWebKitFrameWindow_windowPointToContentsPoint	_windowPointToContentsPoint;
	iCEWebKitFrameWindow_contentsPointToWindowPoint	_contentsPointToWindowPoint;
};

/*! @}
 * end of ICEWebKitFrameWindow
 */

/*! \defgroup ICEHtmlWebKitNetworkEventHandlerReply ICEHtmlWebKitNetworkEventHandlerReply
 * @{
 */

/*!
 * ID of ICEHtmlWebKitNetworkEventHandlerReply
 */
#define CEComIID_ICEHtmlWebKitNetworkEventHandlerReply 0x5d32da71

/*!
 * ICEHtmlWebKitNetworkEventHandlerReply
 */
typedef struct ICEHtmlWebKitNetworkEventHandlerReply
{
	const struct ICEHtmlWebKitNetworkEventHandlerReply_vtbl* _vtbl;
} ICEHtmlWebKitNetworkEventHandlerReply;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitNetworkEventHandlerReply	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitNetworkEventHandlerReply_queryInterface) (ICEHtmlWebKitNetworkEventHandlerReply* iWebKitNetworkEventHandlerReply, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitNetworkEventHandlerReply_addRef) (ICEHtmlWebKitNetworkEventHandlerReply* iWebKitNetworkEventHandlerReply);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitNetworkEventHandlerReply_release) (ICEHtmlWebKitNetworkEventHandlerReply* iWebKitNetworkEventHandlerReply);

typedef CEHResult (*iCEHtmlWebKitNetworkEventHandlerReply_replyNetworkLibraryError) (ICEHtmlWebKitNetworkEventHandlerReply* iWebKitNetworkEventHandlerReply, bool result, struct ICEUString* errorPageStr);

/*!
 * V-table of ICEHtmlWebKitNetworkEventHandlerReply
 */
struct ICEHtmlWebKitNetworkEventHandlerReply_vtbl
{
	iCEHtmlWebKitNetworkEventHandlerReply_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitNetworkEventHandlerReply_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitNetworkEventHandlerReply_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitNetworkEventHandlerReply_replyNetworkLibraryError	_replyNetworkLibraryError;
};

/*! @}
 * end of ICEHtmlWebKitNetworkEventHandlerReply
 */

/*! \defgroup ICEHtmlWebKitWidget ICEHtmlWebKitWidget
 * @{
 */

/*!
 * ID of ICEHtmlWebKitWidget
 */
#define CEComIID_ICEHtmlWebKitWidget 0x0c273f1b

/*!
 * ICEHtmlWebKitWidget
 */
typedef struct ICEHtmlWebKitWidget
{
	const struct ICEHtmlWebKitWidget_vtbl* _vtbl;
} ICEHtmlWebKitWidget;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitWidget	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitWidget_queryInterface) (ICEHtmlWebKitWidget* iWebKitWidget, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitWidget_addRef) (ICEHtmlWebKitWidget* iWebKitWidget);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitWidget_release) (ICEHtmlWebKitWidget* iWebKitWidget);

/*!
 * V-table of ICEHtmlWebKitWidget
 */
struct ICEHtmlWebKitWidget_vtbl
{
	iCEHtmlWebKitWidget_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitWidget_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitWidget_release	_release;	//!< Decrease the reference count of the specified interface pointer.
};

/*! @}
 * end of ICEHtmlWebKitWidget
 */

/*! \defgroup ICEHtmlWebKitFrameWindowWidget ICEHtmlWebKitFrameWindowWidget
 * @{
 */

/*!
 * ID of ICEHtmlWebKitFrameWindowWidget
 */
#define CEComIID_ICEHtmlWebKitFrameWindowWidget 0xbdd29a36

/*!
 * ICEHtmlWebKitFrameWindowWidget
 */
typedef struct ICEHtmlWebKitFrameWindowWidget
{
	const struct ICEHtmlWebKitFrameWindowWidget_vtbl* _vtbl;
} ICEHtmlWebKitFrameWindowWidget;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitFrameWindowWidget	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_queryInterface) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitFrameWindowWidget_addRef) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitFrameWindowWidget_release) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_initializeTextInput) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, bool isPassword, bool isSingleLine, CEWebKitHtmlInputType inputType, const UTF16CHAR* string_data, UINT32 string_len, const INT32 maxLength, const INT32 lineHieght, const INT32 x, const INT32 y, const INT32 width, const INT32 height, bool isPlugin);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_shutdownTextInput) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, bool nextIsTextInput);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_showPopupMenu) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, CEUUINT32List *attrList, CEUStringList *itemList, INT32 selectedIndex, INT32 x, INT32 y, INT32 width, INT32 height, void *client);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_hidePopupMenu) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_createPluginWidget) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, struct ICEHtmlWebKitPluginWidget** iWidgetOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_getScrollbarPreference) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, CEWebKitHtmlFrameScrolling* const scrollHOut, CEWebKitHtmlFrameScrolling* const scrollVOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_getUpdateDocRect) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, CERectF* const updateRect);

typedef CEHResult (*iCEHtmlWebKitFrameWindowWidget_setCaretPosition) (ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget, INT32 caretPosition);

/*!
 * V-table of ICEHtmlWebKitFrameWindowWidget
 */
struct ICEHtmlWebKitFrameWindowWidget_vtbl
{
	iCEHtmlWebKitFrameWindowWidget_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitFrameWindowWidget_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitFrameWindowWidget_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitFrameWindowWidget_initializeTextInput	_initializeTextInput;
	iCEHtmlWebKitFrameWindowWidget_shutdownTextInput	_shutdownTextInput;
	iCEHtmlWebKitFrameWindowWidget_showPopupMenu	_showPopupMenu;
	iCEHtmlWebKitFrameWindowWidget_hidePopupMenu	_hidePopupMenu;
	iCEHtmlWebKitFrameWindowWidget_createPluginWidget	_createPluginWidget;
	iCEHtmlWebKitFrameWindowWidget_getScrollbarPreference	_getScrollbarPreference;
	iCEHtmlWebKitFrameWindowWidget_getUpdateDocRect	_getUpdateDocRect;
	iCEHtmlWebKitFrameWindowWidget_setCaretPosition	_setCaretPosition;
};

/*! @}
 * end of ICEHtmlWebKitFrameWindowWidget
 */

/*! \defgroup ICEHtmlWebKitPluginWidget ICEHtmlWebKitPluginWidget
 * @{
 */

/*!
 * ID of ICEHtmlWebKitPluginWidget
 */
#define CEComIID_ICEHtmlWebKitPluginWidget 0x0a8d26f2

/*!
 * ICEHtmlWebKitPluginWidget
 */
typedef struct ICEHtmlWebKitPluginWidget
{
	const struct ICEHtmlWebKitPluginWidget_vtbl* _vtbl;
} ICEHtmlWebKitPluginWidget;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitPluginWidget	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitPluginWidget_queryInterface) (ICEHtmlWebKitPluginWidget* iWebKitPluginWidget, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitPluginWidget_addRef) (ICEHtmlWebKitPluginWidget* iWebKitPluginWidget);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitPluginWidget_release) (ICEHtmlWebKitPluginWidget* iWebKitPluginWidget);

typedef CEHResult (*iCEHtmlWebKitPluginWidget_updateBounds) (ICEHtmlWebKitPluginWidget* iWebKitPluginWidget, CERect* rect);

/*!
 * V-table of ICEHtmlWebKitPluginWidget
 */
struct ICEHtmlWebKitPluginWidget_vtbl
{
	iCEHtmlWebKitPluginWidget_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitPluginWidget_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitPluginWidget_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitPluginWidget_updateBounds	_updateBounds;
};

/*! @}
 * end of ICEHtmlWebKitPluginWidget
 */

/*! \defgroup ICEHtmlWebKitFrameWindowChromeClient ICEHtmlWebKitFrameWindowChromeClient
 * @{
 */

/*!
 * ID of ICEHtmlWebKitFrameWindowChromeClient
 */
#define CEComIID_ICEHtmlWebKitFrameWindowChromeClient 0x1717e22e

/*!
 * ICEHtmlWebKitFrameWindowChromeClient
 */
typedef struct ICEHtmlWebKitFrameWindowChromeClient
{
	const struct ICEHtmlWebKitFrameWindowChromeClient_vtbl* _vtbl;
} ICEHtmlWebKitFrameWindowChromeClient;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitFrameWindowChromeClient	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_queryInterface) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitFrameWindowChromeClient_addRef) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitFrameWindowChromeClient_release) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_chromeDestroyed) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_setWindowRect) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CERectF* rect);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_getWindowRect) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CERectF* rectOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_getPageRect) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CERectF* rectOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_getScaleFactor) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, float* scaleOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_focus) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_unfocus) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_repaint) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CERect* rect);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_titleChange) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* title_data, UINT32 title_len);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_urlChange) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* url_data, UINT32 url_len);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_keyboardEvent) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CEKeyboardEventParam* keyEventParam, CEATOMIC* consumingCount, bool *const consumedOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_progressStartNotification) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_progressFinishedNotification) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_progressPercentageNotification) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, double percentage);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_notifyCursorInformation) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, INT32 x, INT32 y);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_alert) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* msg_data, UINT32 msg_len);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_shouldInterruptJavaScript) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, bool* interruptOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_setCanBackAndForward) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, bool canBack, bool canFwd);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_unsupportedMimeType) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* mimetype_data, UINT32 mimetype_len, const UTF16CHAR* url_data, UINT32 url_len);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_confirm) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* msg_data, UINT32 msg_len, bool *const isOkOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_prompt) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* msg_data, UINT32 msg_len, const UTF16CHAR* msg_Defaultdata, UINT32 msg_Defaultlen, struct ICEUString**  msg_Outdata, UINT32* msg_Outlen);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_checkErrorOnRequestComplete) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CEHResult resultCode, INT32 lowLevelError, bool isMainResource, struct ICEUString** htmlOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_checkCanDownloadedMimeType) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* mimetype_data, UINT32 mimetype_len, const UTF16CHAR* url_data, UINT32 url_len, bool* resultOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_focusedNodeChanged) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, struct ICEURL* url, struct ICEUString* text, UINT32 elemId, UINT32 viewId);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_unsupportedScheme) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* iUrlStr, UINT32 iUrlLen);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_willEnterToOrLeaveFromSecureSite) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, bool isEnter, const char* srcUrl, const char* dstUrl, bool* continueOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_willResubmitForm) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const char* srcUrl, const char* dstUrl, bool* continueOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_willSubmitInsecureForm) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, bool fromHttps, bool isPost, const char* srcUrl, const char* dstUrl, bool* continueOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_willLeaveFromSecureSiteAtRedirection) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const char* srcUrl, const char* dstUrl, bool* continueOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_setAllowsScrolling) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, bool visible);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_urlCreationFailed) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, const UTF16CHAR* iUrlStr, UINT32 iUrlLen);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_windowOpen) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, INT32 leftPos, INT32 topPos, INT32 width, INT32 height, const UTF16CHAR* iUrlStr, UINT32 iUrlLen, bool fromJavaScript, void** newPageOut);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_windowClose) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_requestSyncFileChooser) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, struct ICEUString ** fileName, struct ICEUString ** filePath);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_getDeviceScreenRect) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CERect *const deviceScreenRect);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_getScrollMode) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, CEWebKitHtmlScrollMode *const scrollMode);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_setScrollPosition) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, INT32 x, INT32 y);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_notifyChangePage) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_notifyChangeContentSize) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, INT32 width, INT32 height, INT32 fixedLayoutWidth, INT32 fixedLayoutHeight, float zoomFactor);

typedef CEHResult (*iCEHtmlWebKitFrameWindowChromeClient_notifyMouseOverElementChanged) (ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient, struct ICEURL* linkUrl, struct ICEURL* imageUrl, CEHtmlFocusItemType type);

/*!
 * V-table of ICEHtmlWebKitFrameWindowChromeClient
 */
struct ICEHtmlWebKitFrameWindowChromeClient_vtbl
{
	iCEHtmlWebKitFrameWindowChromeClient_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitFrameWindowChromeClient_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitFrameWindowChromeClient_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitFrameWindowChromeClient_chromeDestroyed	_chromeDestroyed;
	iCEHtmlWebKitFrameWindowChromeClient_setWindowRect	_setWindowRect;
	iCEHtmlWebKitFrameWindowChromeClient_getWindowRect	_getWindowRect;
	iCEHtmlWebKitFrameWindowChromeClient_getPageRect	_getPageRect;
	iCEHtmlWebKitFrameWindowChromeClient_getScaleFactor	_getScaleFactor;
	iCEHtmlWebKitFrameWindowChromeClient_focus	_focus;
	iCEHtmlWebKitFrameWindowChromeClient_unfocus	_unfocus;
	iCEHtmlWebKitFrameWindowChromeClient_repaint	_repaint;
	iCEHtmlWebKitFrameWindowChromeClient_titleChange	_titleChange;
	iCEHtmlWebKitFrameWindowChromeClient_urlChange	_urlChange;
	iCEHtmlWebKitFrameWindowChromeClient_keyboardEvent	_keyboardEvent;
	iCEHtmlWebKitFrameWindowChromeClient_progressStartNotification	_progressStartNotification;
	iCEHtmlWebKitFrameWindowChromeClient_progressFinishedNotification	_progressFinishedNotification;
	iCEHtmlWebKitFrameWindowChromeClient_progressPercentageNotification	_progressPercentageNotification;
	iCEHtmlWebKitFrameWindowChromeClient_notifyCursorInformation	_notifyCursorInformation;
	iCEHtmlWebKitFrameWindowChromeClient_alert	_alert;
	iCEHtmlWebKitFrameWindowChromeClient_shouldInterruptJavaScript	_shouldInterruptJavaScript;
	iCEHtmlWebKitFrameWindowChromeClient_setCanBackAndForward	_setCanBackAndForward;
	iCEHtmlWebKitFrameWindowChromeClient_unsupportedMimeType	_unsupportedMimeType;
	iCEHtmlWebKitFrameWindowChromeClient_confirm	_confirm;
	iCEHtmlWebKitFrameWindowChromeClient_prompt	_prompt;
	iCEHtmlWebKitFrameWindowChromeClient_checkErrorOnRequestComplete	_checkErrorOnRequestComplete;
	iCEHtmlWebKitFrameWindowChromeClient_checkCanDownloadedMimeType	_checkCanDownloadedMimeType;
	iCEHtmlWebKitFrameWindowChromeClient_focusedNodeChanged	_focusedNodeChanged;
	iCEHtmlWebKitFrameWindowChromeClient_unsupportedScheme	_unsupportedScheme;
	iCEHtmlWebKitFrameWindowChromeClient_willEnterToOrLeaveFromSecureSite	_willEnterToOrLeaveFromSecureSite;
	iCEHtmlWebKitFrameWindowChromeClient_willResubmitForm	_willResubmitForm;
	iCEHtmlWebKitFrameWindowChromeClient_willSubmitInsecureForm	_willSubmitInsecureForm;
	iCEHtmlWebKitFrameWindowChromeClient_willLeaveFromSecureSiteAtRedirection	_willLeaveFromSecureSiteAtRedirection;
	iCEHtmlWebKitFrameWindowChromeClient_setAllowsScrolling	_setAllowsScrolling;
	iCEHtmlWebKitFrameWindowChromeClient_urlCreationFailed	_urlCreationFailed;
	iCEHtmlWebKitFrameWindowChromeClient_windowOpen	_windowOpen;
	iCEHtmlWebKitFrameWindowChromeClient_windowClose	_windowClose;
	iCEHtmlWebKitFrameWindowChromeClient_requestSyncFileChooser	_requestSyncFileChooser;
	iCEHtmlWebKitFrameWindowChromeClient_getDeviceScreenRect	_getDeviceScreenRect;
	iCEHtmlWebKitFrameWindowChromeClient_getScrollMode	_getScrollMode;
	iCEHtmlWebKitFrameWindowChromeClient_setScrollPosition	_setScrollPosition;
	iCEHtmlWebKitFrameWindowChromeClient_notifyChangePage	_notifyChangePage;
	iCEHtmlWebKitFrameWindowChromeClient_notifyChangeContentSize	_notifyChangeContentSize;
	iCEHtmlWebKitFrameWindowChromeClient_notifyMouseOverElementChanged	_notifyMouseOverElementChanged;
};

/*! @}
 * end of ICEHtmlWebKitFrameWindowChromeClient
 */

/*! \defgroup ICEWebKitSettings ICEWebKitSettings
 * @{
 */

/*!
 * ID of ICEWebKitSettings
 */
#define CEComIID_ICEWebKitSettings 0x2056014a

/*!
 * ICEWebKitSettings
 */
typedef struct ICEWebKitSettings
{
	const struct ICEWebKitSettings_vtbl* _vtbl;
} ICEWebKitSettings;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitSettings	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEWebKitSettings_queryInterface) (ICEWebKitSettings* iWebKitSettings, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitSettings_addRef) (ICEWebKitSettings* iWebKitSettings);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitSettings_release) (ICEWebKitSettings* iWebKitSettings);

typedef CEHResult (*iCEWebKitSettings_setJavaScriptEnabled) (ICEWebKitSettings* iWebKitSettings, bool enabled);

typedef CEHResult (*iCEWebKitSettings_isJavaScriptEnabled) (ICEWebKitSettings* iWebKitSettings, bool* enabledOut);

typedef CEHResult (*iCEWebKitSettings_userStyleSheetLocation) (ICEWebKitSettings* iWebKitSettings, struct ICEURL** locationOut);

typedef CEHResult (*iCEWebKitSettings_setUserStyleSheetLocation) (ICEWebKitSettings* iWebKitSettings, struct ICEURL* location);

typedef CEHResult (*iCEWebKitSettings_setCEA2014ModeEnabled) (ICEWebKitSettings* iWebKitSettings, bool enabled);

typedef CEHResult (*iCEWebKitSettings_isCEA2014ModeEnabled) (ICEWebKitSettings* iWebKitSettings, bool* enabledOut);

typedef CEHResult (*iCEWebKitSettings_setDefaultFontSize) (ICEWebKitSettings* iWebKitSettings, UINT32 size);

typedef CEHResult (*iCEWebKitSettings_setDefaultFixedFontSize) (ICEWebKitSettings* iWebKitSettings, UINT32 size);

typedef CEHResult (*iCEWebKitSettings_setPluginEnabled) (ICEWebKitSettings* iWebKitSettings, bool enabled);

/*!
 * V-table of ICEWebKitSettings
 */
struct ICEWebKitSettings_vtbl
{
	iCEWebKitSettings_queryInterface	_queryInterface;	//!< Query interface.
	iCEWebKitSettings_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEWebKitSettings_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEWebKitSettings_setJavaScriptEnabled	_setJavaScriptEnabled;
	iCEWebKitSettings_isJavaScriptEnabled	_isJavaScriptEnabled;
	iCEWebKitSettings_userStyleSheetLocation	_userStyleSheetLocation;
	iCEWebKitSettings_setUserStyleSheetLocation	_setUserStyleSheetLocation;
	iCEWebKitSettings_setCEA2014ModeEnabled	_setCEA2014ModeEnabled;
	iCEWebKitSettings_isCEA2014ModeEnabled	_isCEA2014ModeEnabled;
	iCEWebKitSettings_setDefaultFontSize	_setDefaultFontSize;
	iCEWebKitSettings_setDefaultFixedFontSize	_setDefaultFixedFontSize;
	iCEWebKitSettings_setPluginEnabled	_setPluginEnabled;
};

/*! @}
 * end of ICEWebKitSettings
 */

/*! \defgroup ICEHtmlWebKitDocumentLoaderClient ICEHtmlWebKitDocumentLoaderClient
 * @{
 */

/*!
 * ID of ICEHtmlWebKitDocumentLoaderClient
 */
#define CEComIID_ICEHtmlWebKitDocumentLoaderClient 0x8a5301e8

/*!
 * ICEHtmlWebKitDocumentLoaderClient
 */
typedef struct ICEHtmlWebKitDocumentLoaderClient
{
	const struct ICEHtmlWebKitDocumentLoaderClient_vtbl* _vtbl;
} ICEHtmlWebKitDocumentLoaderClient;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitDocumentLoaderClient	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_queryInterface) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitDocumentLoaderClient_addRef) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitDocumentLoaderClient_release) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_attachToFrame) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, bool isTop);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_detachToFrame) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_assignIdentifierToInitialRequest) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, unsigned long identifier);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_dispatchDidReceiveResponse) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, unsigned long identifier, CEWebKitResouceType type, bool isSecure, UINT32 sslErr);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_dispatchDidFinishLoading) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, unsigned long identifier);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_dispatchDidFailLoading) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, unsigned long identifier);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_getSSLMode) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, CEHtmlSSLMode* modeOut);

typedef CEHResult (*iCEHtmlWebKitDocumentLoaderClient_getSSLAlert) (ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient, UINT32* alertOut);

/*!
 * V-table of ICEHtmlWebKitDocumentLoaderClient
 */
struct ICEHtmlWebKitDocumentLoaderClient_vtbl
{
	iCEHtmlWebKitDocumentLoaderClient_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitDocumentLoaderClient_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitDocumentLoaderClient_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitDocumentLoaderClient_attachToFrame	_attachToFrame;
	iCEHtmlWebKitDocumentLoaderClient_detachToFrame	_detachToFrame;
	iCEHtmlWebKitDocumentLoaderClient_assignIdentifierToInitialRequest	_assignIdentifierToInitialRequest;
	iCEHtmlWebKitDocumentLoaderClient_dispatchDidReceiveResponse	_dispatchDidReceiveResponse;
	iCEHtmlWebKitDocumentLoaderClient_dispatchDidFinishLoading	_dispatchDidFinishLoading;
	iCEHtmlWebKitDocumentLoaderClient_dispatchDidFailLoading	_dispatchDidFailLoading;
	iCEHtmlWebKitDocumentLoaderClient_getSSLMode	_getSSLMode;
	iCEHtmlWebKitDocumentLoaderClient_getSSLAlert	_getSSLAlert;
};

/*! @}
 * end of ICEHtmlWebKitDocumentLoaderClient
 */

/*! \defgroup ICEHtmlWebKitFrameWindowLoaderClient ICEHtmlWebKitFrameWindowLoaderClient
 * @{
 */

/*!
 * ID of ICEHtmlWebKitFrameWindowLoaderClient
 */
#define CEComIID_ICEHtmlWebKitFrameWindowLoaderClient 0x20d35d22

/*!
 * ICEHtmlWebKitFrameWindowLoaderClient
 */
typedef struct ICEHtmlWebKitFrameWindowLoaderClient
{
	const struct ICEHtmlWebKitFrameWindowLoaderClient_vtbl* _vtbl;
} ICEHtmlWebKitFrameWindowLoaderClient;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitFrameWindowLoaderClient	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitFrameWindowLoaderClient_queryInterface) (ICEHtmlWebKitFrameWindowLoaderClient* iWebKitFrameWindowLoaderClient, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitFrameWindowLoaderClient_addRef) (ICEHtmlWebKitFrameWindowLoaderClient* iWebKitFrameWindowLoaderClient);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitFrameWindowLoaderClient_release) (ICEHtmlWebKitFrameWindowLoaderClient* iWebKitFrameWindowLoaderClient);

typedef CEHResult (*iCEHtmlWebKitFrameWindowLoaderClient_createDocumentLoader) (ICEHtmlWebKitFrameWindowLoaderClient* iWebKitFrameWindowLoaderClient, struct ICEHtmlWebKitDocumentLoaderClient** iDocumentLoaderClientOut);

/*!
 * V-table of ICEHtmlWebKitFrameWindowLoaderClient
 */
struct ICEHtmlWebKitFrameWindowLoaderClient_vtbl
{
	iCEHtmlWebKitFrameWindowLoaderClient_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitFrameWindowLoaderClient_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitFrameWindowLoaderClient_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitFrameWindowLoaderClient_createDocumentLoader	_createDocumentLoader;
};

/*! @}
 * end of ICEHtmlWebKitFrameWindowLoaderClient
 */

/*! \defgroup ICEWebKitWindow ICEWebKitWindow
 * @{
 */

/*!
 * ID of ICEWebKitWindow
 */
#define CEComIID_ICEWebKitWindow 0x63b58802

/*!
 * ICEWebKitWindow
 */
typedef struct ICEWebKitWindow
{
	const struct ICEWebKitWindow_vtbl* _vtbl;
} ICEWebKitWindow;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitWindow	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEWebKitWindow_queryInterface) (ICEWebKitWindow* iWebKitWindow, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitWindow_addRef) (ICEWebKitWindow* iWebKitWindow);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitWindow_release) (ICEWebKitWindow* iWebKitWindow);

/*!
 * V-table of ICEWebKitWindow
 */
struct ICEWebKitWindow_vtbl
{
	iCEWebKitWindow_queryInterface	_queryInterface;	//!< Query interface.
	iCEWebKitWindow_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEWebKitWindow_release	_release;	//!< Decrease the reference count of the specified interface pointer.
};

/*! @}
 * end of ICEWebKitWindow
 */

/*! \defgroup ICEHtmlWebKitTheme ICEHtmlWebKitTheme
 * @{
 */

/*!
 * ID of ICEHtmlWebKitTheme
 */
#define CEComIID_ICEHtmlWebKitTheme 0x8fd3af1a

/*!
 * ICEHtmlWebKitTheme
 */
typedef struct ICEHtmlWebKitTheme
{
	const struct ICEHtmlWebKitTheme_vtbl* _vtbl;
} ICEHtmlWebKitTheme;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitTheme	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitTheme_queryInterface) (ICEHtmlWebKitTheme* iWebKitTheme, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitTheme_addRef) (ICEHtmlWebKitTheme* iWebKitTheme);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitTheme_release) (ICEHtmlWebKitTheme* iWebKitTheme);

typedef CEHResult (*iCEHtmlWebKitTheme_hitTestScrollbar) (ICEHtmlWebKitTheme* iWebKitTheme, CERect* scrollRect, bool horizon, UINT32 testPos, UINT32 viewPos, UINT32 viewLength, UINT32 contentLength, float zoomFactorValue, CEHtmlDrawScrollbarPart* partOut);

typedef CEHResult (*iCEHtmlWebKitTheme_drawScrollbar) (ICEHtmlWebKitTheme* iWebKitTheme, struct ICEVGContext* iVGC, CERect* scrollRect, CERect* dirtyRect, bool horizon, UINT32 viewPos, UINT32 viewLength, UINT32 contentLength, float zoomFactorValue);

typedef CEHResult (*iCEHtmlWebKitTheme_scrollberTickness) (ICEHtmlWebKitTheme* iWebKitTheme, CEHtmlScrollbarControlSize size, UINT32* outWidth);

typedef CEHResult (*iCEHtmlWebKitTheme_drawWidget) (ICEHtmlWebKitTheme* iWebKitTheme, struct ICEVGContext* iVGC, CEHtmlDrawWidget type, CEHtmlDrawWidgetState state, CERect* rect, CERect* dirtyRect);

typedef CEHResult (*iCEHtmlWebKitTheme_getWidgetSize) (ICEHtmlWebKitTheme* iWebKitTheme, CEHtmlDrawWidget type, CEHtmlDrawWidgetState state, UINT32* widthOut, UINT32* heightOut);

typedef CEHResult (*iCEHtmlWebKitTheme_getCaretBlinkInterval) (ICEHtmlWebKitTheme* iWebKitTheme, UINT32* msecOut);

typedef CEHResult (*iCEHtmlWebKitTheme_getMissingImage) (ICEHtmlWebKitTheme* iWebKitTheme, struct ICEVGSurface* *const missingImageOut);

typedef CEHResult (*iCEHtmlWebKitTheme_getNoPluginImage) (ICEHtmlWebKitTheme* iWebKitTheme, struct ICEVGSurface* *const noPluginImageOut);

/*!
 * V-table of ICEHtmlWebKitTheme
 */
struct ICEHtmlWebKitTheme_vtbl
{
	iCEHtmlWebKitTheme_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitTheme_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitTheme_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitTheme_hitTestScrollbar	_hitTestScrollbar;
	iCEHtmlWebKitTheme_drawScrollbar	_drawScrollbar;
	iCEHtmlWebKitTheme_scrollberTickness	_scrollberTickness;
	iCEHtmlWebKitTheme_drawWidget	_drawWidget;
	iCEHtmlWebKitTheme_getWidgetSize	_getWidgetSize;
	iCEHtmlWebKitTheme_getCaretBlinkInterval	_getCaretBlinkInterval;
	iCEHtmlWebKitTheme_getMissingImage	_getMissingImage;
	iCEHtmlWebKitTheme_getNoPluginImage	_getNoPluginImage;
};

/*! @}
 * end of ICEHtmlWebKitTheme
 */

/*! \defgroup ICEHtmlWebKitDeviceInfo ICEHtmlWebKitDeviceInfo
 * @{
 */

/*!
 * ID of ICEHtmlWebKitDeviceInfo
 */
#define CEComIID_ICEHtmlWebKitDeviceInfo 0xcc1fcb73

/*!
 * ICEHtmlWebKitDeviceInfo
 */
typedef struct ICEHtmlWebKitDeviceInfo
{
	const struct ICEHtmlWebKitDeviceInfo_vtbl* _vtbl;
} ICEHtmlWebKitDeviceInfo;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitDeviceInfo	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlWebKitDeviceInfo_queryInterface) (ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitDeviceInfo_addRef) (ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlWebKitDeviceInfo_release) (ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo);

typedef CEHResult (*iCEHtmlWebKitDeviceInfo_getAcceptLanguage) (ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo, struct ICEUString* *const acceptLanguageOut);

typedef CEHResult (*iCEHtmlWebKitDeviceInfo_getUserAgent) (ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo, struct ICEUString* *const userAgentOut);

typedef CEHResult (*iCEHtmlWebKitDeviceInfo_getNoPluginString) (ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo, struct ICEUString* *const noPluginStringOut);

/*!
 * V-table of ICEHtmlWebKitDeviceInfo
 */
struct ICEHtmlWebKitDeviceInfo_vtbl
{
	iCEHtmlWebKitDeviceInfo_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlWebKitDeviceInfo_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlWebKitDeviceInfo_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlWebKitDeviceInfo_getAcceptLanguage	_getAcceptLanguage;
	iCEHtmlWebKitDeviceInfo_getUserAgent	_getUserAgent;
	iCEHtmlWebKitDeviceInfo_getNoPluginString	_getNoPluginString;
};

/*! @}
 * end of ICEHtmlWebKitDeviceInfo
 */

/*! \defgroup ICEHtmlFocusNavigatorPeer ICEHtmlFocusNavigatorPeer
 * @{
 */

/*!
 * ID of ICEHtmlFocusNavigatorPeer
 */
#define CEComIID_ICEHtmlFocusNavigatorPeer 0xb3820058

/*!
 * ICEHtmlFocusNavigatorPeer
 */
typedef struct ICEHtmlFocusNavigatorPeer
{
	const struct ICEHtmlFocusNavigatorPeer_vtbl* _vtbl;
} ICEHtmlFocusNavigatorPeer;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFocusNavigatorPeer	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFocusNavigatorPeer_queryInterface) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFocusNavigatorPeer_addRef) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFocusNavigatorPeer_release) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_isVisible) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, bool* resultOut);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_isFocusable) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, bool* resultOut);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_isEnable) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, bool* resultOut);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_scrollTo) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, CEPointBase* pos);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_getScrollPos) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, CEPointBase* posOut);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_getContentSize) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, CEDim* sizeOut);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_getTabIndex) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView, UINT32* tabIndexOut);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_notifyFocused) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_click) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_notifyDestroy) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, void* hView);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_constructFocusItemTree) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_setStatus) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, CEHtmlFocusNavigatorPeerStatus status, INT32 value);

typedef CEHResult (*iCEHtmlFocusNavigatorPeer_getStatus) (ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer, CEHtmlFocusNavigatorPeerStatus status, INT32* value);

/*!
 * V-table of ICEHtmlFocusNavigatorPeer
 */
struct ICEHtmlFocusNavigatorPeer_vtbl
{
	iCEHtmlFocusNavigatorPeer_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFocusNavigatorPeer_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFocusNavigatorPeer_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFocusNavigatorPeer_isVisible	_isVisible;
	iCEHtmlFocusNavigatorPeer_isFocusable	_isFocusable;
	iCEHtmlFocusNavigatorPeer_isEnable	_isEnable;
	iCEHtmlFocusNavigatorPeer_scrollTo	_scrollTo;
	iCEHtmlFocusNavigatorPeer_getScrollPos	_getScrollPos;
	iCEHtmlFocusNavigatorPeer_getContentSize	_getContentSize;
	iCEHtmlFocusNavigatorPeer_getTabIndex	_getTabIndex;
	iCEHtmlFocusNavigatorPeer_notifyFocused	_notifyFocused;
	iCEHtmlFocusNavigatorPeer_click	_click;
	iCEHtmlFocusNavigatorPeer_notifyDestroy	_notifyDestroy;
	iCEHtmlFocusNavigatorPeer_constructFocusItemTree	_constructFocusItemTree;
	iCEHtmlFocusNavigatorPeer_setStatus	_setStatus;
	iCEHtmlFocusNavigatorPeer_getStatus	_getStatus;
};

/*! @}
 * end of ICEHtmlFocusNavigatorPeer
 */

/*! \defgroup ICEHtmlFocusNavigator ICEHtmlFocusNavigator
 * @{
 */

/*!
 * ID of ICEHtmlFocusNavigator
 */
#define CEComIID_ICEHtmlFocusNavigator 0x280487fd

/*!
 * ICEHtmlFocusNavigator
 */
typedef struct ICEHtmlFocusNavigator
{
	const struct ICEHtmlFocusNavigator_vtbl* _vtbl;
} ICEHtmlFocusNavigator;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iFocusNavigator	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlFocusNavigator_queryInterface) (ICEHtmlFocusNavigator* iFocusNavigator, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFocusNavigator_addRef) (ICEHtmlFocusNavigator* iFocusNavigator);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlFocusNavigator_release) (ICEHtmlFocusNavigator* iFocusNavigator);

typedef CEHResult (*iCEHtmlFocusNavigator_setFocusNavigatorPeer) (ICEHtmlFocusNavigator* iFocusNavigator, struct ICEHtmlFocusNavigatorPeer* peer);

typedef CEHResult (*iCEHtmlFocusNavigator_shutdownFocusNavigatorPeer) (ICEHtmlFocusNavigator* iFocusNavigator);

typedef CEHResult (*iCEHtmlFocusNavigator_setFocusItem) (ICEHtmlFocusNavigator* iFocusNavigator, void** itemOut, void* parentItem, void* hView, void* hElem, CEHtmlFocusItemType type, const CERect* rect, const CEDim* frameSize, const CEPointBase* framePos);

typedef CEHResult (*iCEHtmlFocusNavigator_setScrollPos) (ICEHtmlFocusNavigator* iFocusNavigator, void* item, CEPointBase* pos);

typedef CEHResult (*iCEHtmlFocusNavigator_setContentSize) (ICEHtmlFocusNavigator* iFocusNavigator, void* item, CEDim* dim);

typedef CEHResult (*iCEHtmlFocusNavigator_completeConstruct) (ICEHtmlFocusNavigator* iFocusNavigator, void* parentItem);

typedef CEHResult (*iCEHtmlFocusNavigator_notifyRebuild) (ICEHtmlFocusNavigator* iFocusNavigator);

typedef CEHResult (*iCEHtmlFocusNavigator_notifyRemoveItem) (ICEHtmlFocusNavigator* iFocusNavigator, void* hView);

/*!
 * V-table of ICEHtmlFocusNavigator
 */
struct ICEHtmlFocusNavigator_vtbl
{
	iCEHtmlFocusNavigator_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlFocusNavigator_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlFocusNavigator_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlFocusNavigator_setFocusNavigatorPeer	_setFocusNavigatorPeer;
	iCEHtmlFocusNavigator_shutdownFocusNavigatorPeer	_shutdownFocusNavigatorPeer;
	iCEHtmlFocusNavigator_setFocusItem	_setFocusItem;
	iCEHtmlFocusNavigator_setScrollPos	_setScrollPos;
	iCEHtmlFocusNavigator_setContentSize	_setContentSize;
	iCEHtmlFocusNavigator_completeConstruct	_completeConstruct;
	iCEHtmlFocusNavigator_notifyRebuild	_notifyRebuild;
	iCEHtmlFocusNavigator_notifyRemoveItem	_notifyRemoveItem;
};

/*! @}
 * end of ICEHtmlFocusNavigator
 */

/*! \defgroup ICEWebKitCopyPasteEventHandler ICEWebKitCopyPasteEventHandler
 * @{
 */

/*!
 * ID of ICEWebKitCopyPasteEventHandler
 */
#define CEComIID_ICEWebKitCopyPasteEventHandler 0x735638b1


/*!
 * ICEWebKitCopyPasteEventListener
 */
typedef struct ICEWebKitCopyPasteEventHandler
{
	const struct ICEWebKitCopyPasteEventHandler_vtbl* _vtbl;
} ICEWebKitCopyPasteEventHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iWebKitCopyPasteEventHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEWebKitCopyPasteEventHandler_queryInterface) (ICEWebKitCopyPasteEventHandler* iWebKitCopyPasteEventHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitCopyPasteEventHandler_addRef) (ICEWebKitCopyPasteEventHandler* iWebKitCopyPasteEventHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEWebKitCopyPasteEventHandler_release) (ICEWebKitCopyPasteEventHandler* iWebKitCopyPasteEventHandler);


	/*!
	 * handleCopyEvent
	 */

typedef CEHResult (*iCEWebKitCopyPasteEventHandler_handleCopyEvent) (ICEWebKitCopyPasteEventHandler* iWebKitCopyPasteEventHandler);


	/*!
	 * handlePasteEvent(reserved).
	 */

typedef CEHResult (*iCEWebKitCopyPasteEventHandler_handlePasteEvent) (ICEWebKitCopyPasteEventHandler* iWebKitCopyPasteEventHandler);

/*!
 * V-table of ICEWebKitCopyPasteEventHandler
 */
struct ICEWebKitCopyPasteEventHandler_vtbl
{
	iCEWebKitCopyPasteEventHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEWebKitCopyPasteEventHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEWebKitCopyPasteEventHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEWebKitCopyPasteEventHandler_handleCopyEvent	_handleCopyEvent;
	iCEWebKitCopyPasteEventHandler_handlePasteEvent	_handlePasteEvent;
};

/*! @}
 * end of ICEWebKitCopyPasteEventHandler
 */

/*! \defgroup ICEHtmlOneshotTimerEventListener ICEHtmlOneshotTimerEventListener
 * @{
 */

/*!
 * ID of ICEHtmlOneshotTimerEventListener
 */
#define CEComIID_ICEHtmlOneshotTimerEventListener 0x0da30213

/*!
 * ICEHtmlOneshotTimerEventListener
 */
typedef struct ICEHtmlOneshotTimerEventListener
{
	const struct ICEHtmlOneshotTimerEventListener_vtbl* _vtbl;
} ICEHtmlOneshotTimerEventListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iOneshotTimerEventListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlOneshotTimerEventListener_queryInterface) (ICEHtmlOneshotTimerEventListener* iOneshotTimerEventListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlOneshotTimerEventListener_addRef) (ICEHtmlOneshotTimerEventListener* iOneshotTimerEventListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlOneshotTimerEventListener_release) (ICEHtmlOneshotTimerEventListener* iOneshotTimerEventListener);

typedef CEHResult (*iCEHtmlOneshotTimerEventListener_handleTimerEvent) (ICEHtmlOneshotTimerEventListener* iOneshotTimerEventListener);

/*!
 * V-table of ICEHtmlOneshotTimerEventListener
 */
struct ICEHtmlOneshotTimerEventListener_vtbl
{
	iCEHtmlOneshotTimerEventListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlOneshotTimerEventListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlOneshotTimerEventListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlOneshotTimerEventListener_handleTimerEvent	_handleTimerEvent;
};

/*! @}
 * end of ICEHtmlOneshotTimerEventListener
 */

/*! \defgroup ICEHtmlOneshotTimerManager ICEHtmlOneshotTimerManager
 * @{
 */

/*!
 * ID of ICEHtmlOneshotTimerManager
 */
#define CEComIID_ICEHtmlOneshotTimerManager 0xc8fb7061

/*!
 * ICEHtmlOneshotTimerManager
 */
typedef struct ICEHtmlOneshotTimerManager
{
	const struct ICEHtmlOneshotTimerManager_vtbl* _vtbl;
} ICEHtmlOneshotTimerManager;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iOneshotTimerManager	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlOneshotTimerManager_queryInterface) (ICEHtmlOneshotTimerManager* iOneshotTimerManager, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlOneshotTimerManager_addRef) (ICEHtmlOneshotTimerManager* iOneshotTimerManager);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlOneshotTimerManager_release) (ICEHtmlOneshotTimerManager* iOneshotTimerManager);

typedef CEHResult (*iCEHtmlOneshotTimerManager_setOneshotTimer) (ICEHtmlOneshotTimerManager* iOneshotTimerManager, struct ICEHtmlOneshotTimerEventListener* iListener, INT64 elapsedTimeInUSec);

/*!
 * V-table of ICEHtmlOneshotTimerManager
 */
struct ICEHtmlOneshotTimerManager_vtbl
{
	iCEHtmlOneshotTimerManager_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlOneshotTimerManager_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlOneshotTimerManager_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlOneshotTimerManager_setOneshotTimer	_setOneshotTimer;
};

/*! @}
 * end of ICEHtmlOneshotTimerManager
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEWebKitRef CEComICEWebKitRef
 * @{
 */

class CEComICEWebKitRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEWebKitRef() : _iWebKit(0) {}
	CEComICEWebKitRef(ICEWebKit* iOther) : _iWebKit(0)
	{
		if (iOther)
		{
			_iWebKit = iOther;
			_iWebKit->_vtbl->_addRef(_iWebKit);
		}
	}

	CEComICEWebKitRef(const CEComICEWebKitRef& other) : _iWebKit(0)
	{
		if (other._iWebKit)
		{
			_iWebKit = other._iWebKit;
			_iWebKit->_vtbl->_addRef(_iWebKit);
		}
	}

	~CEComICEWebKitRef()
	{
		if (_iWebKit)
		{
			ICEWebKit* tmp = _iWebKit;
			_iWebKit = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEWebKit* iWebKit;
				void* _ptr;
			} uIntf;
			uIntf.iWebKit = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEWebKit, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKit)
				{
					ICEWebKit* tmp = _iWebKit;
					_iWebKit = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKit = uIntf.iWebKit;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEWebKit* object() const	{ return _iWebKit; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEWebKit* iOther)
	{
		if (_iWebKit)
		{
			ICEWebKit* tmp = _iWebKit;
			_iWebKit = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKit = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEWebKit* detach()
	{
		ICEWebKit* iIntf = _iWebKit;
		_iWebKit = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEWebKit* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKit;
		if (_iWebKit)
		{
			_iWebKit->_vtbl->_addRef(_iWebKit);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEWebKit*() const	{ return _iWebKit; }
	FORCEINLINE_WITHOUT_DEBUG ICEWebKit& operator*() const	{ return *_iWebKit; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKit == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEWebKit* iOther) const	{ return (_iWebKit != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEWebKit* iOther) const	{ return (_iWebKit == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEWebKitRef& operator=(const CEComICEWebKitRef& other)	{ return operator=(other._iWebKit); }

	CEComICEWebKitRef& operator=(const ICEWebKit* iOther)
	{
		if (_iWebKit != iOther)
		{
			if (_iWebKit)
			{
				ICEWebKit* tmp = _iWebKit;
				_iWebKit = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKit = const_cast<ICEWebKit*>(iOther);
			if (_iWebKit)
			{
				_iWebKit->_vtbl->_addRef(_iWebKit);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEWebKit** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEWebKitRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKit && "has a com object reference. clear first.");
		return & _iWebKit; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEWebKitRef& other)
	{
		bool result = false;
		if (_iWebKit)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKit);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKit ? _iWebKit->_vtbl->_queryInterface(_iWebKit, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKit) { _iWebKit->_vtbl->_addRef(_iWebKit); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKit) { _iWebKit->_vtbl->_release(_iWebKit); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult init(struct ICEHtmlWebKitEnvironment* iEnvironment, struct ICENetwork* iCENetwork)	{ return _iWebKit ? _iWebKit->_vtbl->_init(_iWebKit, iEnvironment, iCENetwork) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdown()	{ return _iWebKit ? _iWebKit->_vtbl->_shutdown(_iWebKit) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createWebKitFrameWindow(struct ICEWebKitFrameWindow** iFrameWindowOut)	{ return _iWebKit ? _iWebKit->_vtbl->_createWebKitFrameWindow(_iWebKit, iFrameWindowOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setJSPrivilegeExtObjectListener(struct ICEJSPrivilegeExtObjectListener* listener)	{ return _iWebKit ? _iWebKit->_vtbl->_setJSPrivilegeExtObjectListener(_iWebKit, listener) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult pruneCache()	{ return _iWebKit ? _iWebKit->_vtbl->_pruneCache(_iWebKit) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setProxy(bool isProxyEnable, struct ICEUString* host, UINT16 port)	{ return _iWebKit ? _iWebKit->_vtbl->_setProxy(_iWebKit, isProxyEnable, host, port) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCookieEnable(bool isCookieEnable)	{ return _iWebKit ? _iWebKit->_vtbl->_setCookieEnable(_iWebKit, isCookieEnable) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult deleteAllCookies()	{ return _iWebKit ? _iWebKit->_vtbl->_deleteAllCookies(_iWebKit) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCustomHeaderFileds(UINT16 numFields, struct ICEUString* const* fieldNames, struct ICEUString* const* fieldValues)	{ return _iWebKit ? _iWebKit->_vtbl->_setCustomHeaderFileds(_iWebKit, numFields, fieldNames, fieldValues) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult preparePluginInfo()	{ return _iWebKit ? _iWebKit->_vtbl->_preparePluginInfo(_iWebKit) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setAcceptLanguage(struct ICEUString* acceptLanguage)	{ return _iWebKit ? _iWebKit->_vtbl->_setAcceptLanguage(_iWebKit, acceptLanguage) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEWebKit* _iWebKit;
};

/*! @}
 * end of CEComICEWebKitRef
 */

/*! \defgroup CEComICEHtmlWebKitEnvironmentRef CEComICEHtmlWebKitEnvironmentRef
 * @{
 */

class CEComICEHtmlWebKitEnvironmentRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitEnvironmentRef() : _iWebKitEnvironment(0) {}
	CEComICEHtmlWebKitEnvironmentRef(ICEHtmlWebKitEnvironment* iOther) : _iWebKitEnvironment(0)
	{
		if (iOther)
		{
			_iWebKitEnvironment = iOther;
			_iWebKitEnvironment->_vtbl->_addRef(_iWebKitEnvironment);
		}
	}

	CEComICEHtmlWebKitEnvironmentRef(const CEComICEHtmlWebKitEnvironmentRef& other) : _iWebKitEnvironment(0)
	{
		if (other._iWebKitEnvironment)
		{
			_iWebKitEnvironment = other._iWebKitEnvironment;
			_iWebKitEnvironment->_vtbl->_addRef(_iWebKitEnvironment);
		}
	}

	~CEComICEHtmlWebKitEnvironmentRef()
	{
		if (_iWebKitEnvironment)
		{
			ICEHtmlWebKitEnvironment* tmp = _iWebKitEnvironment;
			_iWebKitEnvironment = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitEnvironment* iWebKitEnvironment;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitEnvironment = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitEnvironment, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitEnvironment)
				{
					ICEHtmlWebKitEnvironment* tmp = _iWebKitEnvironment;
					_iWebKitEnvironment = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitEnvironment = uIntf.iWebKitEnvironment;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitEnvironment* object() const	{ return _iWebKitEnvironment; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitEnvironment* iOther)
	{
		if (_iWebKitEnvironment)
		{
			ICEHtmlWebKitEnvironment* tmp = _iWebKitEnvironment;
			_iWebKitEnvironment = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitEnvironment = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitEnvironment* detach()
	{
		ICEHtmlWebKitEnvironment* iIntf = _iWebKitEnvironment;
		_iWebKitEnvironment = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitEnvironment* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitEnvironment;
		if (_iWebKitEnvironment)
		{
			_iWebKitEnvironment->_vtbl->_addRef(_iWebKitEnvironment);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitEnvironment*() const	{ return _iWebKitEnvironment; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitEnvironment& operator*() const	{ return *_iWebKitEnvironment; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitEnvironment == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitEnvironment* iOther) const	{ return (_iWebKitEnvironment != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitEnvironment* iOther) const	{ return (_iWebKitEnvironment == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitEnvironmentRef& operator=(const CEComICEHtmlWebKitEnvironmentRef& other)	{ return operator=(other._iWebKitEnvironment); }

	CEComICEHtmlWebKitEnvironmentRef& operator=(const ICEHtmlWebKitEnvironment* iOther)
	{
		if (_iWebKitEnvironment != iOther)
		{
			if (_iWebKitEnvironment)
			{
				ICEHtmlWebKitEnvironment* tmp = _iWebKitEnvironment;
				_iWebKitEnvironment = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitEnvironment = const_cast<ICEHtmlWebKitEnvironment*>(iOther);
			if (_iWebKitEnvironment)
			{
				_iWebKitEnvironment->_vtbl->_addRef(_iWebKitEnvironment);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitEnvironment** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitEnvironmentRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitEnvironment && "has a com object reference. clear first.");
		return & _iWebKitEnvironment; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitEnvironmentRef& other)
	{
		bool result = false;
		if (_iWebKitEnvironment)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitEnvironment);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_queryInterface(_iWebKitEnvironment, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitEnvironment) { _iWebKitEnvironment->_vtbl->_addRef(_iWebKitEnvironment); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitEnvironment) { _iWebKitEnvironment->_vtbl->_release(_iWebKitEnvironment); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCEUThread(CEUThreadRef* ceuthreadOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getCEUThread(_iWebKitEnvironment, ceuthreadOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getUserAgent(struct ICEUString* uaOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getUserAgent(_iWebKitEnvironment, uaOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDatabasePath(struct ICEUString** dbPathOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getDatabasePath(_iWebKitEnvironment, dbPathOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPluginPath(struct ICEUString** pluginPathOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getPluginPath(_iWebKitEnvironment, pluginPathOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getProxyHostPort(bool* isProxyEnable, struct ICEUString** proxyHostOut, UINT16* proxyPortOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getProxyHostPort(_iWebKitEnvironment, isProxyEnable, proxyHostOut, proxyPortOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCertDirInfo(struct ICEUString** sslCertDirPathOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getCertDirInfo(_iWebKitEnvironment, sslCertDirPathOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCacheDirInfo(struct ICEUString** cacheDataPathOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getCacheDirInfo(_iWebKitEnvironment, cacheDataPathOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getEnablePlugin(bool* enableOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getEnablePlugin(_iWebKitEnvironment, enableOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAcceptLanguage(struct ICEUString** alOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getAcceptLanguage(_iWebKitEnvironment, alOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getMaxResourceCacheSize(UINT32* maxCacheSizeOut)	{ return _iWebKitEnvironment ? _iWebKitEnvironment->_vtbl->_getMaxResourceCacheSize(_iWebKitEnvironment, maxCacheSizeOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitEnvironment* _iWebKitEnvironment;
};

/*! @}
 * end of CEComICEHtmlWebKitEnvironmentRef
 */

/*! \defgroup CEComICEWebKitFrameWindowRef CEComICEWebKitFrameWindowRef
 * @{
 */

class CEComICEWebKitFrameWindowRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEWebKitFrameWindowRef() : _iWebKitFrameWindow(0) {}
	CEComICEWebKitFrameWindowRef(ICEWebKitFrameWindow* iOther) : _iWebKitFrameWindow(0)
	{
		if (iOther)
		{
			_iWebKitFrameWindow = iOther;
			_iWebKitFrameWindow->_vtbl->_addRef(_iWebKitFrameWindow);
		}
	}

	CEComICEWebKitFrameWindowRef(const CEComICEWebKitFrameWindowRef& other) : _iWebKitFrameWindow(0)
	{
		if (other._iWebKitFrameWindow)
		{
			_iWebKitFrameWindow = other._iWebKitFrameWindow;
			_iWebKitFrameWindow->_vtbl->_addRef(_iWebKitFrameWindow);
		}
	}

	~CEComICEWebKitFrameWindowRef()
	{
		if (_iWebKitFrameWindow)
		{
			ICEWebKitFrameWindow* tmp = _iWebKitFrameWindow;
			_iWebKitFrameWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEWebKitFrameWindow* iWebKitFrameWindow;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitFrameWindow = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEWebKitFrameWindow, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitFrameWindow)
				{
					ICEWebKitFrameWindow* tmp = _iWebKitFrameWindow;
					_iWebKitFrameWindow = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitFrameWindow = uIntf.iWebKitFrameWindow;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitFrameWindow* object() const	{ return _iWebKitFrameWindow; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEWebKitFrameWindow* iOther)
	{
		if (_iWebKitFrameWindow)
		{
			ICEWebKitFrameWindow* tmp = _iWebKitFrameWindow;
			_iWebKitFrameWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitFrameWindow = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEWebKitFrameWindow* detach()
	{
		ICEWebKitFrameWindow* iIntf = _iWebKitFrameWindow;
		_iWebKitFrameWindow = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEWebKitFrameWindow* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitFrameWindow;
		if (_iWebKitFrameWindow)
		{
			_iWebKitFrameWindow->_vtbl->_addRef(_iWebKitFrameWindow);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEWebKitFrameWindow*() const	{ return _iWebKitFrameWindow; }
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitFrameWindow& operator*() const	{ return *_iWebKitFrameWindow; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitFrameWindow == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEWebKitFrameWindow* iOther) const	{ return (_iWebKitFrameWindow != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEWebKitFrameWindow* iOther) const	{ return (_iWebKitFrameWindow == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEWebKitFrameWindowRef& operator=(const CEComICEWebKitFrameWindowRef& other)	{ return operator=(other._iWebKitFrameWindow); }

	CEComICEWebKitFrameWindowRef& operator=(const ICEWebKitFrameWindow* iOther)
	{
		if (_iWebKitFrameWindow != iOther)
		{
			if (_iWebKitFrameWindow)
			{
				ICEWebKitFrameWindow* tmp = _iWebKitFrameWindow;
				_iWebKitFrameWindow = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitFrameWindow = const_cast<ICEWebKitFrameWindow*>(iOther);
			if (_iWebKitFrameWindow)
			{
				_iWebKitFrameWindow->_vtbl->_addRef(_iWebKitFrameWindow);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEWebKitFrameWindow** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEWebKitFrameWindowRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitFrameWindow && "has a com object reference. clear first.");
		return & _iWebKitFrameWindow; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEWebKitFrameWindowRef& other)
	{
		bool result = false;
		if (_iWebKitFrameWindow)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitFrameWindow);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_queryInterface(_iWebKitFrameWindow, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitFrameWindow) { _iWebKitFrameWindow->_vtbl->_addRef(_iWebKitFrameWindow); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitFrameWindow) { _iWebKitFrameWindow->_vtbl->_release(_iWebKitFrameWindow); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult init(struct ICEHtmlWebKitFrameWindowWidget* iWidget, struct ICEHtmlWebKitFrameWindowChromeClient* iChromeClient, struct ICEHtmlFocusNavigator* iFocusNavigator)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_init(_iWebKitFrameWindow, iWidget, iChromeClient, iFocusNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdown()	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_shutdown(_iWebKitFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult load(struct ICEUString* iUrl, struct ICEUString* iReferer)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_load(_iWebKitFrameWindow, iUrl, iReferer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult paint(struct ICEVGContext* iVGC, CERect* dirtyRect)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_paint(_iWebKitFrameWindow, iVGC, dirtyRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult mouse(CEMouseEventParam* mouseEventParam, bool* consumedOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_mouse(_iWebKitFrameWindow, mouseEventParam, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult keyboard(CEKeyboardEventParam* keyboardEventParam, bool* consumedOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_keyboard(_iWebKitFrameWindow, keyboardEventParam, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult focus(bool focused)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_focus(_iWebKitFrameWindow, focused) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult back(UINT32 amount)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_back(_iWebKitFrameWindow, amount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult forward(UINT32 amount)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_forward(_iWebKitFrameWindow, amount) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult reload(bool skipCache)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_reload(_iWebKitFrameWindow, skipCache) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hitTest(INT32 x, INT32 y, struct ICEURL** linkUrlOut, struct ICEURL** imageUrlOut, struct ICEUString** text, CERect* zoomRect)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_hitTest(_iWebKitFrameWindow, x, y, linkUrlOut, imageUrlOut, text, zoomRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult insertText(struct ICEUString* iString, CEUUINT32List* styleList, CEUUINT32List* lengthList, INT32 caretPosition, bool* consumedOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_insertText(_iWebKitFrameWindow, iString, styleList, lengthList, caretPosition, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult endComposition()	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_endComposition(_iWebKitFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult clearText()	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_clearText(_iWebKitFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult exitIME()	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_exitIME(_iWebKitFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setSelectedItemsPopupMenu(UINT32 selectedIndex, void *client)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_setSelectedItemsPopupMenu(_iWebKitFrameWindow, selectedIndex, client) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shrinkHistory(UINT32 minimumSize)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_shrinkHistory(_iWebKitFrameWindow, minimumSize) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult scroll(INT32 x, INT32 y, INT32 dx, INT32 dy, UINT32 modifiers, bool* consumedOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_scroll(_iWebKitFrameWindow, x, y, dx, dy, modifiers, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult resize(INT32 width, INT32 height)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_resize(_iWebKitFrameWindow, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCustomTextEncodingName(struct ICEUString* iTitle)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_setCustomTextEncodingName(_iWebKitFrameWindow, iTitle) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSettings(struct ICEWebKitSettings** iSettingsOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_getSettings(_iWebKitFrameWindow, iSettingsOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult stop()	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_stop(_iWebKitFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult emptyPage()	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_emptyPage(_iWebKitFrameWindow) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEmpty(bool* isEmptyOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_isEmpty(_iWebKitFrameWindow, isEmptyOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setAllowsScrolling(bool visible)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_setAllowsScrolling(_iWebKitFrameWindow, visible) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult didReceiveResponseCallback(const void* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderSize, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext, bool syncRequest, UINT32 sslErr)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_didReceiveResponseCallback(_iWebKitFrameWindow, webCoreJob, responseHeaderBuffer, responseHeaderSize, url, httpCode, expectedContentLength, noContext, syncRequest, sslErr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult didReceiveDataCallback(const void* webCoreJob, UINT32 httpCode, const char* url, const void* data, UINT32 size, bool syncRequest)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_didReceiveDataCallback(_iWebKitFrameWindow, webCoreJob, httpCode, url, data, size, syncRequest) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult didFinishLoadingCallback(const void* webCoreJob, bool syncRequest)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_didFinishLoadingCallback(_iWebKitFrameWindow, webCoreJob, syncRequest) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult didFinishLoadingAllInOneCallback(const void* webCoreJob, const char* responseHeaderBuffer, UINT32 responseHeaderSize, const char* url, UINT32 httpCode, UINT32 expectedContentLength, bool noContext, const void* data, UINT32 size, bool syncRequest)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_didFinishLoadingAllInOneCallback(_iWebKitFrameWindow, webCoreJob, responseHeaderBuffer, responseHeaderSize, url, httpCode, expectedContentLength, noContext, data, size, syncRequest) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult willSendRequestCallback(const void* webCoreJob, const char* url, bool syncRequest)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_willSendRequestCallback(_iWebKitFrameWindow, webCoreJob, url, syncRequest) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult didFailCallback(const void* webCoreJob, INT32 lowLevelError, CEHResult resultCode, bool noContext, bool syncRequest)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_didFailCallback(_iWebKitFrameWindow, webCoreJob, lowLevelError, resultCode, noContext, syncRequest) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyBadCertCallback(unsigned long identifier, bool sslContinue)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_replyBadCertCallback(_iWebKitFrameWindow, identifier, sslContinue) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyAuthCallback(unsigned long identifier, struct ICEUString* site, struct ICEUString* realm, struct ICEUString* username, struct ICEUString* password, bool authContinue, bool updateSavedFlag)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_replyAuthCallback(_iWebKitFrameWindow, identifier, site, realm, username, password, authContinue, updateSavedFlag) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getContentsSize(INT32* widthOut, INT32* heightOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_getContentsSize(_iWebKitFrameWindow, widthOut, heightOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setVisibleRect(INT32 x, INT32 y, INT32 width, INT32 height)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_setVisibleRect(_iWebKitFrameWindow, x, y, width, height) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult confirmPlugin(bool result, bool keepResult, void *const cData)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_confirmPlugin(_iWebKitFrameWindow, result, keepResult, cData) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyNetworkLibraryError(bool result, struct ICEUString* errorPageStr)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_replyNetworkLibraryError(_iWebKitFrameWindow, result, errorPageStr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPage(void** newPageOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_getPage(_iWebKitFrameWindow, newPageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCertificate(const void* webCoreJob, void* cert)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_setCertificate(_iWebKitFrameWindow, webCoreJob, cert) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setHitTestPadding(INT32 docPadding)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_setHitTestPadding(_iWebKitFrameWindow, docPadding) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult changeZoomFactor(float scale)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_changeZoomFactor(_iWebKitFrameWindow, scale) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPageSizeMultiplier(float *const multiplierOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_getPageSizeMultiplier(_iWebKitFrameWindow, multiplierOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementUrl(void* hView, struct ICEURL** anchorUrlOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_getElementUrl(_iWebKitFrameWindow, hView, anchorUrlOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getElementRect(void* hView, CERect* rectOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_getElementRect(_iWebKitFrameWindow, hView, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isDocumentCoordinateMode(bool* resultOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_isDocumentCoordinateMode(_iWebKitFrameWindow, resultOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult windowRectToContentsRect(const CERect* windowRect, CERect* contentRectOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_windowRectToContentsRect(_iWebKitFrameWindow, windowRect, contentRectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult contentsRectToWindowRect(const CERect* contentRect, CERect* windowRectOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_contentsRectToWindowRect(_iWebKitFrameWindow, contentRect, windowRectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult windowPointToContentsPoint(const CEPointBase* windowPos, CEPointBase* contentPosOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_windowPointToContentsPoint(_iWebKitFrameWindow, windowPos, contentPosOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult contentsPointToWindowPoint(const CEPointBase* contentPos, CEPointBase* windowPosOut)	{ return _iWebKitFrameWindow ? _iWebKitFrameWindow->_vtbl->_contentsPointToWindowPoint(_iWebKitFrameWindow, contentPos, windowPosOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEWebKitFrameWindow* _iWebKitFrameWindow;
};

/*! @}
 * end of CEComICEWebKitFrameWindowRef
 */

/*! \defgroup CEComICEHtmlWebKitNetworkEventHandlerReplyRef CEComICEHtmlWebKitNetworkEventHandlerReplyRef
 * @{
 */

class CEComICEHtmlWebKitNetworkEventHandlerReplyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitNetworkEventHandlerReplyRef() : _iWebKitNetworkEventHandlerReply(0) {}
	CEComICEHtmlWebKitNetworkEventHandlerReplyRef(ICEHtmlWebKitNetworkEventHandlerReply* iOther) : _iWebKitNetworkEventHandlerReply(0)
	{
		if (iOther)
		{
			_iWebKitNetworkEventHandlerReply = iOther;
			_iWebKitNetworkEventHandlerReply->_vtbl->_addRef(_iWebKitNetworkEventHandlerReply);
		}
	}

	CEComICEHtmlWebKitNetworkEventHandlerReplyRef(const CEComICEHtmlWebKitNetworkEventHandlerReplyRef& other) : _iWebKitNetworkEventHandlerReply(0)
	{
		if (other._iWebKitNetworkEventHandlerReply)
		{
			_iWebKitNetworkEventHandlerReply = other._iWebKitNetworkEventHandlerReply;
			_iWebKitNetworkEventHandlerReply->_vtbl->_addRef(_iWebKitNetworkEventHandlerReply);
		}
	}

	~CEComICEHtmlWebKitNetworkEventHandlerReplyRef()
	{
		if (_iWebKitNetworkEventHandlerReply)
		{
			ICEHtmlWebKitNetworkEventHandlerReply* tmp = _iWebKitNetworkEventHandlerReply;
			_iWebKitNetworkEventHandlerReply = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitNetworkEventHandlerReply* iWebKitNetworkEventHandlerReply;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitNetworkEventHandlerReply = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitNetworkEventHandlerReply, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitNetworkEventHandlerReply)
				{
					ICEHtmlWebKitNetworkEventHandlerReply* tmp = _iWebKitNetworkEventHandlerReply;
					_iWebKitNetworkEventHandlerReply = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitNetworkEventHandlerReply = uIntf.iWebKitNetworkEventHandlerReply;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitNetworkEventHandlerReply* object() const	{ return _iWebKitNetworkEventHandlerReply; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitNetworkEventHandlerReply* iOther)
	{
		if (_iWebKitNetworkEventHandlerReply)
		{
			ICEHtmlWebKitNetworkEventHandlerReply* tmp = _iWebKitNetworkEventHandlerReply;
			_iWebKitNetworkEventHandlerReply = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitNetworkEventHandlerReply = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitNetworkEventHandlerReply* detach()
	{
		ICEHtmlWebKitNetworkEventHandlerReply* iIntf = _iWebKitNetworkEventHandlerReply;
		_iWebKitNetworkEventHandlerReply = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitNetworkEventHandlerReply* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitNetworkEventHandlerReply;
		if (_iWebKitNetworkEventHandlerReply)
		{
			_iWebKitNetworkEventHandlerReply->_vtbl->_addRef(_iWebKitNetworkEventHandlerReply);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitNetworkEventHandlerReply*() const	{ return _iWebKitNetworkEventHandlerReply; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitNetworkEventHandlerReply& operator*() const	{ return *_iWebKitNetworkEventHandlerReply; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitNetworkEventHandlerReply == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitNetworkEventHandlerReply* iOther) const	{ return (_iWebKitNetworkEventHandlerReply != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitNetworkEventHandlerReply* iOther) const	{ return (_iWebKitNetworkEventHandlerReply == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitNetworkEventHandlerReplyRef& operator=(const CEComICEHtmlWebKitNetworkEventHandlerReplyRef& other)	{ return operator=(other._iWebKitNetworkEventHandlerReply); }

	CEComICEHtmlWebKitNetworkEventHandlerReplyRef& operator=(const ICEHtmlWebKitNetworkEventHandlerReply* iOther)
	{
		if (_iWebKitNetworkEventHandlerReply != iOther)
		{
			if (_iWebKitNetworkEventHandlerReply)
			{
				ICEHtmlWebKitNetworkEventHandlerReply* tmp = _iWebKitNetworkEventHandlerReply;
				_iWebKitNetworkEventHandlerReply = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitNetworkEventHandlerReply = const_cast<ICEHtmlWebKitNetworkEventHandlerReply*>(iOther);
			if (_iWebKitNetworkEventHandlerReply)
			{
				_iWebKitNetworkEventHandlerReply->_vtbl->_addRef(_iWebKitNetworkEventHandlerReply);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitNetworkEventHandlerReply** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitNetworkEventHandlerReplyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitNetworkEventHandlerReply && "has a com object reference. clear first.");
		return & _iWebKitNetworkEventHandlerReply; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitNetworkEventHandlerReplyRef& other)
	{
		bool result = false;
		if (_iWebKitNetworkEventHandlerReply)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitNetworkEventHandlerReply);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitNetworkEventHandlerReply ? _iWebKitNetworkEventHandlerReply->_vtbl->_queryInterface(_iWebKitNetworkEventHandlerReply, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitNetworkEventHandlerReply) { _iWebKitNetworkEventHandlerReply->_vtbl->_addRef(_iWebKitNetworkEventHandlerReply); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitNetworkEventHandlerReply) { _iWebKitNetworkEventHandlerReply->_vtbl->_release(_iWebKitNetworkEventHandlerReply); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyNetworkLibraryError(bool result, struct ICEUString* errorPageStr)	{ return _iWebKitNetworkEventHandlerReply ? _iWebKitNetworkEventHandlerReply->_vtbl->_replyNetworkLibraryError(_iWebKitNetworkEventHandlerReply, result, errorPageStr) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitNetworkEventHandlerReply* _iWebKitNetworkEventHandlerReply;
};

/*! @}
 * end of CEComICEHtmlWebKitNetworkEventHandlerReplyRef
 */

/*! \defgroup CEComICEHtmlWebKitWidgetRef CEComICEHtmlWebKitWidgetRef
 * @{
 */

class CEComICEHtmlWebKitWidgetRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitWidgetRef() : _iWebKitWidget(0) {}
	CEComICEHtmlWebKitWidgetRef(ICEHtmlWebKitWidget* iOther) : _iWebKitWidget(0)
	{
		if (iOther)
		{
			_iWebKitWidget = iOther;
			_iWebKitWidget->_vtbl->_addRef(_iWebKitWidget);
		}
	}

	CEComICEHtmlWebKitWidgetRef(const CEComICEHtmlWebKitWidgetRef& other) : _iWebKitWidget(0)
	{
		if (other._iWebKitWidget)
		{
			_iWebKitWidget = other._iWebKitWidget;
			_iWebKitWidget->_vtbl->_addRef(_iWebKitWidget);
		}
	}

	~CEComICEHtmlWebKitWidgetRef()
	{
		if (_iWebKitWidget)
		{
			ICEHtmlWebKitWidget* tmp = _iWebKitWidget;
			_iWebKitWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitWidget* iWebKitWidget;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitWidget = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitWidget, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitWidget)
				{
					ICEHtmlWebKitWidget* tmp = _iWebKitWidget;
					_iWebKitWidget = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitWidget = uIntf.iWebKitWidget;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitWidget* object() const	{ return _iWebKitWidget; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitWidget* iOther)
	{
		if (_iWebKitWidget)
		{
			ICEHtmlWebKitWidget* tmp = _iWebKitWidget;
			_iWebKitWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitWidget = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitWidget* detach()
	{
		ICEHtmlWebKitWidget* iIntf = _iWebKitWidget;
		_iWebKitWidget = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitWidget* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitWidget;
		if (_iWebKitWidget)
		{
			_iWebKitWidget->_vtbl->_addRef(_iWebKitWidget);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitWidget*() const	{ return _iWebKitWidget; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitWidget& operator*() const	{ return *_iWebKitWidget; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitWidget == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitWidget* iOther) const	{ return (_iWebKitWidget != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitWidget* iOther) const	{ return (_iWebKitWidget == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitWidgetRef& operator=(const CEComICEHtmlWebKitWidgetRef& other)	{ return operator=(other._iWebKitWidget); }

	CEComICEHtmlWebKitWidgetRef& operator=(const ICEHtmlWebKitWidget* iOther)
	{
		if (_iWebKitWidget != iOther)
		{
			if (_iWebKitWidget)
			{
				ICEHtmlWebKitWidget* tmp = _iWebKitWidget;
				_iWebKitWidget = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitWidget = const_cast<ICEHtmlWebKitWidget*>(iOther);
			if (_iWebKitWidget)
			{
				_iWebKitWidget->_vtbl->_addRef(_iWebKitWidget);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitWidget** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitWidgetRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitWidget && "has a com object reference. clear first.");
		return & _iWebKitWidget; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitWidgetRef& other)
	{
		bool result = false;
		if (_iWebKitWidget)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitWidget);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitWidget ? _iWebKitWidget->_vtbl->_queryInterface(_iWebKitWidget, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitWidget) { _iWebKitWidget->_vtbl->_addRef(_iWebKitWidget); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitWidget) { _iWebKitWidget->_vtbl->_release(_iWebKitWidget); } }


private:
	ICEHtmlWebKitWidget* _iWebKitWidget;
};

/*! @}
 * end of CEComICEHtmlWebKitWidgetRef
 */

/*! \defgroup CEComICEHtmlWebKitFrameWindowWidgetRef CEComICEHtmlWebKitFrameWindowWidgetRef
 * @{
 */

class CEComICEHtmlWebKitFrameWindowWidgetRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitFrameWindowWidgetRef() : _iWebKitFrameWindowWidget(0) {}
	CEComICEHtmlWebKitFrameWindowWidgetRef(ICEHtmlWebKitFrameWindowWidget* iOther) : _iWebKitFrameWindowWidget(0)
	{
		if (iOther)
		{
			_iWebKitFrameWindowWidget = iOther;
			_iWebKitFrameWindowWidget->_vtbl->_addRef(_iWebKitFrameWindowWidget);
		}
	}

	CEComICEHtmlWebKitFrameWindowWidgetRef(const CEComICEHtmlWebKitFrameWindowWidgetRef& other) : _iWebKitFrameWindowWidget(0)
	{
		if (other._iWebKitFrameWindowWidget)
		{
			_iWebKitFrameWindowWidget = other._iWebKitFrameWindowWidget;
			_iWebKitFrameWindowWidget->_vtbl->_addRef(_iWebKitFrameWindowWidget);
		}
	}

	~CEComICEHtmlWebKitFrameWindowWidgetRef()
	{
		if (_iWebKitFrameWindowWidget)
		{
			ICEHtmlWebKitFrameWindowWidget* tmp = _iWebKitFrameWindowWidget;
			_iWebKitFrameWindowWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitFrameWindowWidget* iWebKitFrameWindowWidget;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitFrameWindowWidget = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitFrameWindowWidget, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitFrameWindowWidget)
				{
					ICEHtmlWebKitFrameWindowWidget* tmp = _iWebKitFrameWindowWidget;
					_iWebKitFrameWindowWidget = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitFrameWindowWidget = uIntf.iWebKitFrameWindowWidget;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowWidget* object() const	{ return _iWebKitFrameWindowWidget; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitFrameWindowWidget* iOther)
	{
		if (_iWebKitFrameWindowWidget)
		{
			ICEHtmlWebKitFrameWindowWidget* tmp = _iWebKitFrameWindowWidget;
			_iWebKitFrameWindowWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitFrameWindowWidget = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitFrameWindowWidget* detach()
	{
		ICEHtmlWebKitFrameWindowWidget* iIntf = _iWebKitFrameWindowWidget;
		_iWebKitFrameWindowWidget = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitFrameWindowWidget* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitFrameWindowWidget;
		if (_iWebKitFrameWindowWidget)
		{
			_iWebKitFrameWindowWidget->_vtbl->_addRef(_iWebKitFrameWindowWidget);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitFrameWindowWidget*() const	{ return _iWebKitFrameWindowWidget; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowWidget& operator*() const	{ return *_iWebKitFrameWindowWidget; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitFrameWindowWidget == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitFrameWindowWidget* iOther) const	{ return (_iWebKitFrameWindowWidget != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitFrameWindowWidget* iOther) const	{ return (_iWebKitFrameWindowWidget == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitFrameWindowWidgetRef& operator=(const CEComICEHtmlWebKitFrameWindowWidgetRef& other)	{ return operator=(other._iWebKitFrameWindowWidget); }

	CEComICEHtmlWebKitFrameWindowWidgetRef& operator=(const ICEHtmlWebKitFrameWindowWidget* iOther)
	{
		if (_iWebKitFrameWindowWidget != iOther)
		{
			if (_iWebKitFrameWindowWidget)
			{
				ICEHtmlWebKitFrameWindowWidget* tmp = _iWebKitFrameWindowWidget;
				_iWebKitFrameWindowWidget = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitFrameWindowWidget = const_cast<ICEHtmlWebKitFrameWindowWidget*>(iOther);
			if (_iWebKitFrameWindowWidget)
			{
				_iWebKitFrameWindowWidget->_vtbl->_addRef(_iWebKitFrameWindowWidget);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowWidget** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitFrameWindowWidgetRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitFrameWindowWidget && "has a com object reference. clear first.");
		return & _iWebKitFrameWindowWidget; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitFrameWindowWidgetRef& other)
	{
		bool result = false;
		if (_iWebKitFrameWindowWidget)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitFrameWindowWidget);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_queryInterface(_iWebKitFrameWindowWidget, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitFrameWindowWidget) { _iWebKitFrameWindowWidget->_vtbl->_addRef(_iWebKitFrameWindowWidget); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitFrameWindowWidget) { _iWebKitFrameWindowWidget->_vtbl->_release(_iWebKitFrameWindowWidget); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult initializeTextInput(bool isPassword, bool isSingleLine, CEWebKitHtmlInputType inputType, const UTF16CHAR* string_data, UINT32 string_len, const INT32 maxLength, const INT32 lineHieght, const INT32 x, const INT32 y, const INT32 width, const INT32 height, bool isPlugin)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_initializeTextInput(_iWebKitFrameWindowWidget, isPassword, isSingleLine, inputType, string_data, string_len, maxLength, lineHieght, x, y, width, height, isPlugin) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdownTextInput(bool nextIsTextInput)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_shutdownTextInput(_iWebKitFrameWindowWidget, nextIsTextInput) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult showPopupMenu(CEUUINT32List *attrList, CEUStringList *itemList, INT32 selectedIndex, INT32 x, INT32 y, INT32 width, INT32 height, void *client)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_showPopupMenu(_iWebKitFrameWindowWidget, attrList, itemList, selectedIndex, x, y, width, height, client) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hidePopupMenu()	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_hidePopupMenu(_iWebKitFrameWindowWidget) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createPluginWidget(struct ICEHtmlWebKitPluginWidget** iWidgetOut)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_createPluginWidget(_iWebKitFrameWindowWidget, iWidgetOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScrollbarPreference(CEWebKitHtmlFrameScrolling* const scrollHOut, CEWebKitHtmlFrameScrolling* const scrollVOut)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_getScrollbarPreference(_iWebKitFrameWindowWidget, scrollHOut, scrollVOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getUpdateDocRect(CERectF* const updateRect)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_getUpdateDocRect(_iWebKitFrameWindowWidget, updateRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCaretPosition(INT32 caretPosition)	{ return _iWebKitFrameWindowWidget ? _iWebKitFrameWindowWidget->_vtbl->_setCaretPosition(_iWebKitFrameWindowWidget, caretPosition) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitFrameWindowWidget* _iWebKitFrameWindowWidget;
};

/*! @}
 * end of CEComICEHtmlWebKitFrameWindowWidgetRef
 */

/*! \defgroup CEComICEHtmlWebKitPluginWidgetRef CEComICEHtmlWebKitPluginWidgetRef
 * @{
 */

class CEComICEHtmlWebKitPluginWidgetRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitPluginWidgetRef() : _iWebKitPluginWidget(0) {}
	CEComICEHtmlWebKitPluginWidgetRef(ICEHtmlWebKitPluginWidget* iOther) : _iWebKitPluginWidget(0)
	{
		if (iOther)
		{
			_iWebKitPluginWidget = iOther;
			_iWebKitPluginWidget->_vtbl->_addRef(_iWebKitPluginWidget);
		}
	}

	CEComICEHtmlWebKitPluginWidgetRef(const CEComICEHtmlWebKitPluginWidgetRef& other) : _iWebKitPluginWidget(0)
	{
		if (other._iWebKitPluginWidget)
		{
			_iWebKitPluginWidget = other._iWebKitPluginWidget;
			_iWebKitPluginWidget->_vtbl->_addRef(_iWebKitPluginWidget);
		}
	}

	~CEComICEHtmlWebKitPluginWidgetRef()
	{
		if (_iWebKitPluginWidget)
		{
			ICEHtmlWebKitPluginWidget* tmp = _iWebKitPluginWidget;
			_iWebKitPluginWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitPluginWidget* iWebKitPluginWidget;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitPluginWidget = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitPluginWidget, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitPluginWidget)
				{
					ICEHtmlWebKitPluginWidget* tmp = _iWebKitPluginWidget;
					_iWebKitPluginWidget = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitPluginWidget = uIntf.iWebKitPluginWidget;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitPluginWidget* object() const	{ return _iWebKitPluginWidget; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitPluginWidget* iOther)
	{
		if (_iWebKitPluginWidget)
		{
			ICEHtmlWebKitPluginWidget* tmp = _iWebKitPluginWidget;
			_iWebKitPluginWidget = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitPluginWidget = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitPluginWidget* detach()
	{
		ICEHtmlWebKitPluginWidget* iIntf = _iWebKitPluginWidget;
		_iWebKitPluginWidget = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitPluginWidget* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitPluginWidget;
		if (_iWebKitPluginWidget)
		{
			_iWebKitPluginWidget->_vtbl->_addRef(_iWebKitPluginWidget);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitPluginWidget*() const	{ return _iWebKitPluginWidget; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitPluginWidget& operator*() const	{ return *_iWebKitPluginWidget; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitPluginWidget == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitPluginWidget* iOther) const	{ return (_iWebKitPluginWidget != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitPluginWidget* iOther) const	{ return (_iWebKitPluginWidget == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitPluginWidgetRef& operator=(const CEComICEHtmlWebKitPluginWidgetRef& other)	{ return operator=(other._iWebKitPluginWidget); }

	CEComICEHtmlWebKitPluginWidgetRef& operator=(const ICEHtmlWebKitPluginWidget* iOther)
	{
		if (_iWebKitPluginWidget != iOther)
		{
			if (_iWebKitPluginWidget)
			{
				ICEHtmlWebKitPluginWidget* tmp = _iWebKitPluginWidget;
				_iWebKitPluginWidget = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitPluginWidget = const_cast<ICEHtmlWebKitPluginWidget*>(iOther);
			if (_iWebKitPluginWidget)
			{
				_iWebKitPluginWidget->_vtbl->_addRef(_iWebKitPluginWidget);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitPluginWidget** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitPluginWidgetRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitPluginWidget && "has a com object reference. clear first.");
		return & _iWebKitPluginWidget; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitPluginWidgetRef& other)
	{
		bool result = false;
		if (_iWebKitPluginWidget)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitPluginWidget);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitPluginWidget ? _iWebKitPluginWidget->_vtbl->_queryInterface(_iWebKitPluginWidget, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitPluginWidget) { _iWebKitPluginWidget->_vtbl->_addRef(_iWebKitPluginWidget); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitPluginWidget) { _iWebKitPluginWidget->_vtbl->_release(_iWebKitPluginWidget); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult updateBounds(CERect* rect)	{ return _iWebKitPluginWidget ? _iWebKitPluginWidget->_vtbl->_updateBounds(_iWebKitPluginWidget, rect) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitPluginWidget* _iWebKitPluginWidget;
};

/*! @}
 * end of CEComICEHtmlWebKitPluginWidgetRef
 */

/*! \defgroup CEComICEHtmlWebKitFrameWindowChromeClientRef CEComICEHtmlWebKitFrameWindowChromeClientRef
 * @{
 */

class CEComICEHtmlWebKitFrameWindowChromeClientRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitFrameWindowChromeClientRef() : _iWebKitFrameWindowChromeClient(0) {}
	CEComICEHtmlWebKitFrameWindowChromeClientRef(ICEHtmlWebKitFrameWindowChromeClient* iOther) : _iWebKitFrameWindowChromeClient(0)
	{
		if (iOther)
		{
			_iWebKitFrameWindowChromeClient = iOther;
			_iWebKitFrameWindowChromeClient->_vtbl->_addRef(_iWebKitFrameWindowChromeClient);
		}
	}

	CEComICEHtmlWebKitFrameWindowChromeClientRef(const CEComICEHtmlWebKitFrameWindowChromeClientRef& other) : _iWebKitFrameWindowChromeClient(0)
	{
		if (other._iWebKitFrameWindowChromeClient)
		{
			_iWebKitFrameWindowChromeClient = other._iWebKitFrameWindowChromeClient;
			_iWebKitFrameWindowChromeClient->_vtbl->_addRef(_iWebKitFrameWindowChromeClient);
		}
	}

	~CEComICEHtmlWebKitFrameWindowChromeClientRef()
	{
		if (_iWebKitFrameWindowChromeClient)
		{
			ICEHtmlWebKitFrameWindowChromeClient* tmp = _iWebKitFrameWindowChromeClient;
			_iWebKitFrameWindowChromeClient = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitFrameWindowChromeClient* iWebKitFrameWindowChromeClient;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitFrameWindowChromeClient = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitFrameWindowChromeClient, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitFrameWindowChromeClient)
				{
					ICEHtmlWebKitFrameWindowChromeClient* tmp = _iWebKitFrameWindowChromeClient;
					_iWebKitFrameWindowChromeClient = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitFrameWindowChromeClient = uIntf.iWebKitFrameWindowChromeClient;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowChromeClient* object() const	{ return _iWebKitFrameWindowChromeClient; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitFrameWindowChromeClient* iOther)
	{
		if (_iWebKitFrameWindowChromeClient)
		{
			ICEHtmlWebKitFrameWindowChromeClient* tmp = _iWebKitFrameWindowChromeClient;
			_iWebKitFrameWindowChromeClient = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitFrameWindowChromeClient = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitFrameWindowChromeClient* detach()
	{
		ICEHtmlWebKitFrameWindowChromeClient* iIntf = _iWebKitFrameWindowChromeClient;
		_iWebKitFrameWindowChromeClient = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitFrameWindowChromeClient* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitFrameWindowChromeClient;
		if (_iWebKitFrameWindowChromeClient)
		{
			_iWebKitFrameWindowChromeClient->_vtbl->_addRef(_iWebKitFrameWindowChromeClient);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitFrameWindowChromeClient*() const	{ return _iWebKitFrameWindowChromeClient; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowChromeClient& operator*() const	{ return *_iWebKitFrameWindowChromeClient; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitFrameWindowChromeClient == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitFrameWindowChromeClient* iOther) const	{ return (_iWebKitFrameWindowChromeClient != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitFrameWindowChromeClient* iOther) const	{ return (_iWebKitFrameWindowChromeClient == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitFrameWindowChromeClientRef& operator=(const CEComICEHtmlWebKitFrameWindowChromeClientRef& other)	{ return operator=(other._iWebKitFrameWindowChromeClient); }

	CEComICEHtmlWebKitFrameWindowChromeClientRef& operator=(const ICEHtmlWebKitFrameWindowChromeClient* iOther)
	{
		if (_iWebKitFrameWindowChromeClient != iOther)
		{
			if (_iWebKitFrameWindowChromeClient)
			{
				ICEHtmlWebKitFrameWindowChromeClient* tmp = _iWebKitFrameWindowChromeClient;
				_iWebKitFrameWindowChromeClient = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitFrameWindowChromeClient = const_cast<ICEHtmlWebKitFrameWindowChromeClient*>(iOther);
			if (_iWebKitFrameWindowChromeClient)
			{
				_iWebKitFrameWindowChromeClient->_vtbl->_addRef(_iWebKitFrameWindowChromeClient);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowChromeClient** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitFrameWindowChromeClientRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitFrameWindowChromeClient && "has a com object reference. clear first.");
		return & _iWebKitFrameWindowChromeClient; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitFrameWindowChromeClientRef& other)
	{
		bool result = false;
		if (_iWebKitFrameWindowChromeClient)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitFrameWindowChromeClient);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_queryInterface(_iWebKitFrameWindowChromeClient, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitFrameWindowChromeClient) { _iWebKitFrameWindowChromeClient->_vtbl->_addRef(_iWebKitFrameWindowChromeClient); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitFrameWindowChromeClient) { _iWebKitFrameWindowChromeClient->_vtbl->_release(_iWebKitFrameWindowChromeClient); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult chromeDestroyed()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_chromeDestroyed(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setWindowRect(CERectF* rect)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_setWindowRect(_iWebKitFrameWindowChromeClient, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getWindowRect(CERectF* rectOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_getWindowRect(_iWebKitFrameWindowChromeClient, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getPageRect(CERectF* rectOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_getPageRect(_iWebKitFrameWindowChromeClient, rectOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScaleFactor(float* scaleOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_getScaleFactor(_iWebKitFrameWindowChromeClient, scaleOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult focus()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_focus(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unfocus()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_unfocus(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult repaint(CERect* rect)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_repaint(_iWebKitFrameWindowChromeClient, rect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult titleChange(const UTF16CHAR* title_data, UINT32 title_len)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_titleChange(_iWebKitFrameWindowChromeClient, title_data, title_len) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult urlChange(const UTF16CHAR* url_data, UINT32 url_len)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_urlChange(_iWebKitFrameWindowChromeClient, url_data, url_len) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult keyboardEvent(CEKeyboardEventParam* keyEventParam, CEATOMIC* consumingCount, bool *const consumedOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_keyboardEvent(_iWebKitFrameWindowChromeClient, keyEventParam, consumingCount, consumedOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult progressStartNotification()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_progressStartNotification(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult progressFinishedNotification()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_progressFinishedNotification(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult progressPercentageNotification(double percentage)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_progressPercentageNotification(_iWebKitFrameWindowChromeClient, percentage) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyCursorInformation(INT32 x, INT32 y)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_notifyCursorInformation(_iWebKitFrameWindowChromeClient, x, y) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult alert(const UTF16CHAR* msg_data, UINT32 msg_len)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_alert(_iWebKitFrameWindowChromeClient, msg_data, msg_len) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shouldInterruptJavaScript(bool* interruptOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_shouldInterruptJavaScript(_iWebKitFrameWindowChromeClient, interruptOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCanBackAndForward(bool canBack, bool canFwd)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_setCanBackAndForward(_iWebKitFrameWindowChromeClient, canBack, canFwd) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unsupportedMimeType(const UTF16CHAR* mimetype_data, UINT32 mimetype_len, const UTF16CHAR* url_data, UINT32 url_len)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_unsupportedMimeType(_iWebKitFrameWindowChromeClient, mimetype_data, mimetype_len, url_data, url_len) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult confirm(const UTF16CHAR* msg_data, UINT32 msg_len, bool *const isOkOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_confirm(_iWebKitFrameWindowChromeClient, msg_data, msg_len, isOkOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult prompt(const UTF16CHAR* msg_data, UINT32 msg_len, const UTF16CHAR* msg_Defaultdata, UINT32 msg_Defaultlen, struct ICEUString**  msg_Outdata, UINT32* msg_Outlen)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_prompt(_iWebKitFrameWindowChromeClient, msg_data, msg_len, msg_Defaultdata, msg_Defaultlen, msg_Outdata, msg_Outlen) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult checkErrorOnRequestComplete(CEHResult resultCode, INT32 lowLevelError, bool isMainResource, struct ICEUString** htmlOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_checkErrorOnRequestComplete(_iWebKitFrameWindowChromeClient, resultCode, lowLevelError, isMainResource, htmlOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult checkCanDownloadedMimeType(const UTF16CHAR* mimetype_data, UINT32 mimetype_len, const UTF16CHAR* url_data, UINT32 url_len, bool* resultOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_checkCanDownloadedMimeType(_iWebKitFrameWindowChromeClient, mimetype_data, mimetype_len, url_data, url_len, resultOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult focusedNodeChanged(struct ICEURL* url, struct ICEUString* text, UINT32 elemId, UINT32 viewId)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_focusedNodeChanged(_iWebKitFrameWindowChromeClient, url, text, elemId, viewId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult unsupportedScheme(const UTF16CHAR* iUrlStr, UINT32 iUrlLen)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_unsupportedScheme(_iWebKitFrameWindowChromeClient, iUrlStr, iUrlLen) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult willEnterToOrLeaveFromSecureSite(bool isEnter, const char* srcUrl, const char* dstUrl, bool* continueOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_willEnterToOrLeaveFromSecureSite(_iWebKitFrameWindowChromeClient, isEnter, srcUrl, dstUrl, continueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult willResubmitForm(const char* srcUrl, const char* dstUrl, bool* continueOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_willResubmitForm(_iWebKitFrameWindowChromeClient, srcUrl, dstUrl, continueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult willSubmitInsecureForm(bool fromHttps, bool isPost, const char* srcUrl, const char* dstUrl, bool* continueOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_willSubmitInsecureForm(_iWebKitFrameWindowChromeClient, fromHttps, isPost, srcUrl, dstUrl, continueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult willLeaveFromSecureSiteAtRedirection(const char* srcUrl, const char* dstUrl, bool* continueOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_willLeaveFromSecureSiteAtRedirection(_iWebKitFrameWindowChromeClient, srcUrl, dstUrl, continueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setAllowsScrolling(bool visible)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_setAllowsScrolling(_iWebKitFrameWindowChromeClient, visible) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult urlCreationFailed(const UTF16CHAR* iUrlStr, UINT32 iUrlLen)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_urlCreationFailed(_iWebKitFrameWindowChromeClient, iUrlStr, iUrlLen) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult windowOpen(INT32 leftPos, INT32 topPos, INT32 width, INT32 height, const UTF16CHAR* iUrlStr, UINT32 iUrlLen, bool fromJavaScript, void** newPageOut)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_windowOpen(_iWebKitFrameWindowChromeClient, leftPos, topPos, width, height, iUrlStr, iUrlLen, fromJavaScript, newPageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult windowClose()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_windowClose(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestSyncFileChooser(struct ICEUString ** fileName, struct ICEUString ** filePath)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_requestSyncFileChooser(_iWebKitFrameWindowChromeClient, fileName, filePath) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getDeviceScreenRect(CERect *const deviceScreenRect)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_getDeviceScreenRect(_iWebKitFrameWindowChromeClient, deviceScreenRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScrollMode(CEWebKitHtmlScrollMode *const scrollMode)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_getScrollMode(_iWebKitFrameWindowChromeClient, scrollMode) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setScrollPosition(INT32 x, INT32 y)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_setScrollPosition(_iWebKitFrameWindowChromeClient, x, y) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyChangePage()	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_notifyChangePage(_iWebKitFrameWindowChromeClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyChangeContentSize(INT32 width, INT32 height, INT32 fixedLayoutWidth, INT32 fixedLayoutHeight, float zoomFactor)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_notifyChangeContentSize(_iWebKitFrameWindowChromeClient, width, height, fixedLayoutWidth, fixedLayoutHeight, zoomFactor) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyMouseOverElementChanged(struct ICEURL* linkUrl, struct ICEURL* imageUrl, CEHtmlFocusItemType type)	{ return _iWebKitFrameWindowChromeClient ? _iWebKitFrameWindowChromeClient->_vtbl->_notifyMouseOverElementChanged(_iWebKitFrameWindowChromeClient, linkUrl, imageUrl, type) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitFrameWindowChromeClient* _iWebKitFrameWindowChromeClient;
};

/*! @}
 * end of CEComICEHtmlWebKitFrameWindowChromeClientRef
 */

/*! \defgroup CEComICEWebKitSettingsRef CEComICEWebKitSettingsRef
 * @{
 */

class CEComICEWebKitSettingsRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEWebKitSettingsRef() : _iWebKitSettings(0) {}
	CEComICEWebKitSettingsRef(ICEWebKitSettings* iOther) : _iWebKitSettings(0)
	{
		if (iOther)
		{
			_iWebKitSettings = iOther;
			_iWebKitSettings->_vtbl->_addRef(_iWebKitSettings);
		}
	}

	CEComICEWebKitSettingsRef(const CEComICEWebKitSettingsRef& other) : _iWebKitSettings(0)
	{
		if (other._iWebKitSettings)
		{
			_iWebKitSettings = other._iWebKitSettings;
			_iWebKitSettings->_vtbl->_addRef(_iWebKitSettings);
		}
	}

	~CEComICEWebKitSettingsRef()
	{
		if (_iWebKitSettings)
		{
			ICEWebKitSettings* tmp = _iWebKitSettings;
			_iWebKitSettings = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEWebKitSettings* iWebKitSettings;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitSettings = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEWebKitSettings, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitSettings)
				{
					ICEWebKitSettings* tmp = _iWebKitSettings;
					_iWebKitSettings = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitSettings = uIntf.iWebKitSettings;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitSettings* object() const	{ return _iWebKitSettings; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEWebKitSettings* iOther)
	{
		if (_iWebKitSettings)
		{
			ICEWebKitSettings* tmp = _iWebKitSettings;
			_iWebKitSettings = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitSettings = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEWebKitSettings* detach()
	{
		ICEWebKitSettings* iIntf = _iWebKitSettings;
		_iWebKitSettings = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEWebKitSettings* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitSettings;
		if (_iWebKitSettings)
		{
			_iWebKitSettings->_vtbl->_addRef(_iWebKitSettings);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEWebKitSettings*() const	{ return _iWebKitSettings; }
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitSettings& operator*() const	{ return *_iWebKitSettings; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitSettings == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEWebKitSettings* iOther) const	{ return (_iWebKitSettings != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEWebKitSettings* iOther) const	{ return (_iWebKitSettings == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEWebKitSettingsRef& operator=(const CEComICEWebKitSettingsRef& other)	{ return operator=(other._iWebKitSettings); }

	CEComICEWebKitSettingsRef& operator=(const ICEWebKitSettings* iOther)
	{
		if (_iWebKitSettings != iOther)
		{
			if (_iWebKitSettings)
			{
				ICEWebKitSettings* tmp = _iWebKitSettings;
				_iWebKitSettings = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitSettings = const_cast<ICEWebKitSettings*>(iOther);
			if (_iWebKitSettings)
			{
				_iWebKitSettings->_vtbl->_addRef(_iWebKitSettings);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEWebKitSettings** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEWebKitSettingsRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitSettings && "has a com object reference. clear first.");
		return & _iWebKitSettings; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEWebKitSettingsRef& other)
	{
		bool result = false;
		if (_iWebKitSettings)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitSettings);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_queryInterface(_iWebKitSettings, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitSettings) { _iWebKitSettings->_vtbl->_addRef(_iWebKitSettings); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitSettings) { _iWebKitSettings->_vtbl->_release(_iWebKitSettings); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setJavaScriptEnabled(bool enabled)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_setJavaScriptEnabled(_iWebKitSettings, enabled) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isJavaScriptEnabled(bool* enabledOut)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_isJavaScriptEnabled(_iWebKitSettings, enabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult userStyleSheetLocation(struct ICEURL** locationOut)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_userStyleSheetLocation(_iWebKitSettings, locationOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setUserStyleSheetLocation(struct ICEURL* location)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_setUserStyleSheetLocation(_iWebKitSettings, location) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setCEA2014ModeEnabled(bool enabled)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_setCEA2014ModeEnabled(_iWebKitSettings, enabled) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isCEA2014ModeEnabled(bool* enabledOut)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_isCEA2014ModeEnabled(_iWebKitSettings, enabledOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setDefaultFontSize(UINT32 size)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_setDefaultFontSize(_iWebKitSettings, size) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setDefaultFixedFontSize(UINT32 size)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_setDefaultFixedFontSize(_iWebKitSettings, size) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setPluginEnabled(bool enabled)	{ return _iWebKitSettings ? _iWebKitSettings->_vtbl->_setPluginEnabled(_iWebKitSettings, enabled) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEWebKitSettings* _iWebKitSettings;
};

/*! @}
 * end of CEComICEWebKitSettingsRef
 */

/*! \defgroup CEComICEHtmlWebKitDocumentLoaderClientRef CEComICEHtmlWebKitDocumentLoaderClientRef
 * @{
 */

class CEComICEHtmlWebKitDocumentLoaderClientRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitDocumentLoaderClientRef() : _iWebKitDocumentLoaderClient(0) {}
	CEComICEHtmlWebKitDocumentLoaderClientRef(ICEHtmlWebKitDocumentLoaderClient* iOther) : _iWebKitDocumentLoaderClient(0)
	{
		if (iOther)
		{
			_iWebKitDocumentLoaderClient = iOther;
			_iWebKitDocumentLoaderClient->_vtbl->_addRef(_iWebKitDocumentLoaderClient);
		}
	}

	CEComICEHtmlWebKitDocumentLoaderClientRef(const CEComICEHtmlWebKitDocumentLoaderClientRef& other) : _iWebKitDocumentLoaderClient(0)
	{
		if (other._iWebKitDocumentLoaderClient)
		{
			_iWebKitDocumentLoaderClient = other._iWebKitDocumentLoaderClient;
			_iWebKitDocumentLoaderClient->_vtbl->_addRef(_iWebKitDocumentLoaderClient);
		}
	}

	~CEComICEHtmlWebKitDocumentLoaderClientRef()
	{
		if (_iWebKitDocumentLoaderClient)
		{
			ICEHtmlWebKitDocumentLoaderClient* tmp = _iWebKitDocumentLoaderClient;
			_iWebKitDocumentLoaderClient = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitDocumentLoaderClient* iWebKitDocumentLoaderClient;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitDocumentLoaderClient = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitDocumentLoaderClient, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitDocumentLoaderClient)
				{
					ICEHtmlWebKitDocumentLoaderClient* tmp = _iWebKitDocumentLoaderClient;
					_iWebKitDocumentLoaderClient = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitDocumentLoaderClient = uIntf.iWebKitDocumentLoaderClient;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitDocumentLoaderClient* object() const	{ return _iWebKitDocumentLoaderClient; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitDocumentLoaderClient* iOther)
	{
		if (_iWebKitDocumentLoaderClient)
		{
			ICEHtmlWebKitDocumentLoaderClient* tmp = _iWebKitDocumentLoaderClient;
			_iWebKitDocumentLoaderClient = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitDocumentLoaderClient = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitDocumentLoaderClient* detach()
	{
		ICEHtmlWebKitDocumentLoaderClient* iIntf = _iWebKitDocumentLoaderClient;
		_iWebKitDocumentLoaderClient = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitDocumentLoaderClient* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitDocumentLoaderClient;
		if (_iWebKitDocumentLoaderClient)
		{
			_iWebKitDocumentLoaderClient->_vtbl->_addRef(_iWebKitDocumentLoaderClient);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitDocumentLoaderClient*() const	{ return _iWebKitDocumentLoaderClient; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitDocumentLoaderClient& operator*() const	{ return *_iWebKitDocumentLoaderClient; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitDocumentLoaderClient == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitDocumentLoaderClient* iOther) const	{ return (_iWebKitDocumentLoaderClient != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitDocumentLoaderClient* iOther) const	{ return (_iWebKitDocumentLoaderClient == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitDocumentLoaderClientRef& operator=(const CEComICEHtmlWebKitDocumentLoaderClientRef& other)	{ return operator=(other._iWebKitDocumentLoaderClient); }

	CEComICEHtmlWebKitDocumentLoaderClientRef& operator=(const ICEHtmlWebKitDocumentLoaderClient* iOther)
	{
		if (_iWebKitDocumentLoaderClient != iOther)
		{
			if (_iWebKitDocumentLoaderClient)
			{
				ICEHtmlWebKitDocumentLoaderClient* tmp = _iWebKitDocumentLoaderClient;
				_iWebKitDocumentLoaderClient = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitDocumentLoaderClient = const_cast<ICEHtmlWebKitDocumentLoaderClient*>(iOther);
			if (_iWebKitDocumentLoaderClient)
			{
				_iWebKitDocumentLoaderClient->_vtbl->_addRef(_iWebKitDocumentLoaderClient);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitDocumentLoaderClient** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitDocumentLoaderClientRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitDocumentLoaderClient && "has a com object reference. clear first.");
		return & _iWebKitDocumentLoaderClient; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitDocumentLoaderClientRef& other)
	{
		bool result = false;
		if (_iWebKitDocumentLoaderClient)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitDocumentLoaderClient);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_queryInterface(_iWebKitDocumentLoaderClient, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitDocumentLoaderClient) { _iWebKitDocumentLoaderClient->_vtbl->_addRef(_iWebKitDocumentLoaderClient); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitDocumentLoaderClient) { _iWebKitDocumentLoaderClient->_vtbl->_release(_iWebKitDocumentLoaderClient); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult attachToFrame(bool isTop)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_attachToFrame(_iWebKitDocumentLoaderClient, isTop) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult detachToFrame()	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_detachToFrame(_iWebKitDocumentLoaderClient) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult assignIdentifierToInitialRequest(unsigned long identifier)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_assignIdentifierToInitialRequest(_iWebKitDocumentLoaderClient, identifier) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dispatchDidReceiveResponse(unsigned long identifier, CEWebKitResouceType type, bool isSecure, UINT32 sslErr)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_dispatchDidReceiveResponse(_iWebKitDocumentLoaderClient, identifier, type, isSecure, sslErr) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dispatchDidFinishLoading(unsigned long identifier)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_dispatchDidFinishLoading(_iWebKitDocumentLoaderClient, identifier) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult dispatchDidFailLoading(unsigned long identifier)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_dispatchDidFailLoading(_iWebKitDocumentLoaderClient, identifier) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSSLMode(CEHtmlSSLMode* modeOut)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_getSSLMode(_iWebKitDocumentLoaderClient, modeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getSSLAlert(UINT32* alertOut)	{ return _iWebKitDocumentLoaderClient ? _iWebKitDocumentLoaderClient->_vtbl->_getSSLAlert(_iWebKitDocumentLoaderClient, alertOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitDocumentLoaderClient* _iWebKitDocumentLoaderClient;
};

/*! @}
 * end of CEComICEHtmlWebKitDocumentLoaderClientRef
 */

/*! \defgroup CEComICEHtmlWebKitFrameWindowLoaderClientRef CEComICEHtmlWebKitFrameWindowLoaderClientRef
 * @{
 */

class CEComICEHtmlWebKitFrameWindowLoaderClientRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitFrameWindowLoaderClientRef() : _iWebKitFrameWindowLoaderClient(0) {}
	CEComICEHtmlWebKitFrameWindowLoaderClientRef(ICEHtmlWebKitFrameWindowLoaderClient* iOther) : _iWebKitFrameWindowLoaderClient(0)
	{
		if (iOther)
		{
			_iWebKitFrameWindowLoaderClient = iOther;
			_iWebKitFrameWindowLoaderClient->_vtbl->_addRef(_iWebKitFrameWindowLoaderClient);
		}
	}

	CEComICEHtmlWebKitFrameWindowLoaderClientRef(const CEComICEHtmlWebKitFrameWindowLoaderClientRef& other) : _iWebKitFrameWindowLoaderClient(0)
	{
		if (other._iWebKitFrameWindowLoaderClient)
		{
			_iWebKitFrameWindowLoaderClient = other._iWebKitFrameWindowLoaderClient;
			_iWebKitFrameWindowLoaderClient->_vtbl->_addRef(_iWebKitFrameWindowLoaderClient);
		}
	}

	~CEComICEHtmlWebKitFrameWindowLoaderClientRef()
	{
		if (_iWebKitFrameWindowLoaderClient)
		{
			ICEHtmlWebKitFrameWindowLoaderClient* tmp = _iWebKitFrameWindowLoaderClient;
			_iWebKitFrameWindowLoaderClient = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitFrameWindowLoaderClient* iWebKitFrameWindowLoaderClient;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitFrameWindowLoaderClient = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitFrameWindowLoaderClient, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitFrameWindowLoaderClient)
				{
					ICEHtmlWebKitFrameWindowLoaderClient* tmp = _iWebKitFrameWindowLoaderClient;
					_iWebKitFrameWindowLoaderClient = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitFrameWindowLoaderClient = uIntf.iWebKitFrameWindowLoaderClient;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowLoaderClient* object() const	{ return _iWebKitFrameWindowLoaderClient; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitFrameWindowLoaderClient* iOther)
	{
		if (_iWebKitFrameWindowLoaderClient)
		{
			ICEHtmlWebKitFrameWindowLoaderClient* tmp = _iWebKitFrameWindowLoaderClient;
			_iWebKitFrameWindowLoaderClient = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitFrameWindowLoaderClient = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitFrameWindowLoaderClient* detach()
	{
		ICEHtmlWebKitFrameWindowLoaderClient* iIntf = _iWebKitFrameWindowLoaderClient;
		_iWebKitFrameWindowLoaderClient = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitFrameWindowLoaderClient* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitFrameWindowLoaderClient;
		if (_iWebKitFrameWindowLoaderClient)
		{
			_iWebKitFrameWindowLoaderClient->_vtbl->_addRef(_iWebKitFrameWindowLoaderClient);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitFrameWindowLoaderClient*() const	{ return _iWebKitFrameWindowLoaderClient; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowLoaderClient& operator*() const	{ return *_iWebKitFrameWindowLoaderClient; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitFrameWindowLoaderClient == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitFrameWindowLoaderClient* iOther) const	{ return (_iWebKitFrameWindowLoaderClient != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitFrameWindowLoaderClient* iOther) const	{ return (_iWebKitFrameWindowLoaderClient == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitFrameWindowLoaderClientRef& operator=(const CEComICEHtmlWebKitFrameWindowLoaderClientRef& other)	{ return operator=(other._iWebKitFrameWindowLoaderClient); }

	CEComICEHtmlWebKitFrameWindowLoaderClientRef& operator=(const ICEHtmlWebKitFrameWindowLoaderClient* iOther)
	{
		if (_iWebKitFrameWindowLoaderClient != iOther)
		{
			if (_iWebKitFrameWindowLoaderClient)
			{
				ICEHtmlWebKitFrameWindowLoaderClient* tmp = _iWebKitFrameWindowLoaderClient;
				_iWebKitFrameWindowLoaderClient = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitFrameWindowLoaderClient = const_cast<ICEHtmlWebKitFrameWindowLoaderClient*>(iOther);
			if (_iWebKitFrameWindowLoaderClient)
			{
				_iWebKitFrameWindowLoaderClient->_vtbl->_addRef(_iWebKitFrameWindowLoaderClient);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitFrameWindowLoaderClient** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitFrameWindowLoaderClientRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitFrameWindowLoaderClient && "has a com object reference. clear first.");
		return & _iWebKitFrameWindowLoaderClient; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitFrameWindowLoaderClientRef& other)
	{
		bool result = false;
		if (_iWebKitFrameWindowLoaderClient)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitFrameWindowLoaderClient);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitFrameWindowLoaderClient ? _iWebKitFrameWindowLoaderClient->_vtbl->_queryInterface(_iWebKitFrameWindowLoaderClient, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitFrameWindowLoaderClient) { _iWebKitFrameWindowLoaderClient->_vtbl->_addRef(_iWebKitFrameWindowLoaderClient); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitFrameWindowLoaderClient) { _iWebKitFrameWindowLoaderClient->_vtbl->_release(_iWebKitFrameWindowLoaderClient); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createDocumentLoader(struct ICEHtmlWebKitDocumentLoaderClient** iDocumentLoaderClientOut)	{ return _iWebKitFrameWindowLoaderClient ? _iWebKitFrameWindowLoaderClient->_vtbl->_createDocumentLoader(_iWebKitFrameWindowLoaderClient, iDocumentLoaderClientOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitFrameWindowLoaderClient* _iWebKitFrameWindowLoaderClient;
};

/*! @}
 * end of CEComICEHtmlWebKitFrameWindowLoaderClientRef
 */

/*! \defgroup CEComICEWebKitWindowRef CEComICEWebKitWindowRef
 * @{
 */

class CEComICEWebKitWindowRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEWebKitWindowRef() : _iWebKitWindow(0) {}
	CEComICEWebKitWindowRef(ICEWebKitWindow* iOther) : _iWebKitWindow(0)
	{
		if (iOther)
		{
			_iWebKitWindow = iOther;
			_iWebKitWindow->_vtbl->_addRef(_iWebKitWindow);
		}
	}

	CEComICEWebKitWindowRef(const CEComICEWebKitWindowRef& other) : _iWebKitWindow(0)
	{
		if (other._iWebKitWindow)
		{
			_iWebKitWindow = other._iWebKitWindow;
			_iWebKitWindow->_vtbl->_addRef(_iWebKitWindow);
		}
	}

	~CEComICEWebKitWindowRef()
	{
		if (_iWebKitWindow)
		{
			ICEWebKitWindow* tmp = _iWebKitWindow;
			_iWebKitWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEWebKitWindow* iWebKitWindow;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitWindow = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEWebKitWindow, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitWindow)
				{
					ICEWebKitWindow* tmp = _iWebKitWindow;
					_iWebKitWindow = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitWindow = uIntf.iWebKitWindow;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitWindow* object() const	{ return _iWebKitWindow; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEWebKitWindow* iOther)
	{
		if (_iWebKitWindow)
		{
			ICEWebKitWindow* tmp = _iWebKitWindow;
			_iWebKitWindow = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitWindow = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEWebKitWindow* detach()
	{
		ICEWebKitWindow* iIntf = _iWebKitWindow;
		_iWebKitWindow = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEWebKitWindow* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitWindow;
		if (_iWebKitWindow)
		{
			_iWebKitWindow->_vtbl->_addRef(_iWebKitWindow);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEWebKitWindow*() const	{ return _iWebKitWindow; }
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitWindow& operator*() const	{ return *_iWebKitWindow; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitWindow == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEWebKitWindow* iOther) const	{ return (_iWebKitWindow != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEWebKitWindow* iOther) const	{ return (_iWebKitWindow == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEWebKitWindowRef& operator=(const CEComICEWebKitWindowRef& other)	{ return operator=(other._iWebKitWindow); }

	CEComICEWebKitWindowRef& operator=(const ICEWebKitWindow* iOther)
	{
		if (_iWebKitWindow != iOther)
		{
			if (_iWebKitWindow)
			{
				ICEWebKitWindow* tmp = _iWebKitWindow;
				_iWebKitWindow = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitWindow = const_cast<ICEWebKitWindow*>(iOther);
			if (_iWebKitWindow)
			{
				_iWebKitWindow->_vtbl->_addRef(_iWebKitWindow);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEWebKitWindow** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEWebKitWindowRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitWindow && "has a com object reference. clear first.");
		return & _iWebKitWindow; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEWebKitWindowRef& other)
	{
		bool result = false;
		if (_iWebKitWindow)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitWindow);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitWindow ? _iWebKitWindow->_vtbl->_queryInterface(_iWebKitWindow, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitWindow) { _iWebKitWindow->_vtbl->_addRef(_iWebKitWindow); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitWindow) { _iWebKitWindow->_vtbl->_release(_iWebKitWindow); } }


private:
	ICEWebKitWindow* _iWebKitWindow;
};

/*! @}
 * end of CEComICEWebKitWindowRef
 */

/*! \defgroup CEComICEHtmlWebKitThemeRef CEComICEHtmlWebKitThemeRef
 * @{
 */

class CEComICEHtmlWebKitThemeRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitThemeRef() : _iWebKitTheme(0) {}
	CEComICEHtmlWebKitThemeRef(ICEHtmlWebKitTheme* iOther) : _iWebKitTheme(0)
	{
		if (iOther)
		{
			_iWebKitTheme = iOther;
			_iWebKitTheme->_vtbl->_addRef(_iWebKitTheme);
		}
	}

	CEComICEHtmlWebKitThemeRef(const CEComICEHtmlWebKitThemeRef& other) : _iWebKitTheme(0)
	{
		if (other._iWebKitTheme)
		{
			_iWebKitTheme = other._iWebKitTheme;
			_iWebKitTheme->_vtbl->_addRef(_iWebKitTheme);
		}
	}

	~CEComICEHtmlWebKitThemeRef()
	{
		if (_iWebKitTheme)
		{
			ICEHtmlWebKitTheme* tmp = _iWebKitTheme;
			_iWebKitTheme = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitTheme* iWebKitTheme;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitTheme = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitTheme, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitTheme)
				{
					ICEHtmlWebKitTheme* tmp = _iWebKitTheme;
					_iWebKitTheme = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitTheme = uIntf.iWebKitTheme;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitTheme* object() const	{ return _iWebKitTheme; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitTheme* iOther)
	{
		if (_iWebKitTheme)
		{
			ICEHtmlWebKitTheme* tmp = _iWebKitTheme;
			_iWebKitTheme = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitTheme = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitTheme* detach()
	{
		ICEHtmlWebKitTheme* iIntf = _iWebKitTheme;
		_iWebKitTheme = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitTheme* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitTheme;
		if (_iWebKitTheme)
		{
			_iWebKitTheme->_vtbl->_addRef(_iWebKitTheme);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitTheme*() const	{ return _iWebKitTheme; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitTheme& operator*() const	{ return *_iWebKitTheme; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitTheme == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitTheme* iOther) const	{ return (_iWebKitTheme != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitTheme* iOther) const	{ return (_iWebKitTheme == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitThemeRef& operator=(const CEComICEHtmlWebKitThemeRef& other)	{ return operator=(other._iWebKitTheme); }

	CEComICEHtmlWebKitThemeRef& operator=(const ICEHtmlWebKitTheme* iOther)
	{
		if (_iWebKitTheme != iOther)
		{
			if (_iWebKitTheme)
			{
				ICEHtmlWebKitTheme* tmp = _iWebKitTheme;
				_iWebKitTheme = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitTheme = const_cast<ICEHtmlWebKitTheme*>(iOther);
			if (_iWebKitTheme)
			{
				_iWebKitTheme->_vtbl->_addRef(_iWebKitTheme);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitTheme** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitThemeRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitTheme && "has a com object reference. clear first.");
		return & _iWebKitTheme; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitThemeRef& other)
	{
		bool result = false;
		if (_iWebKitTheme)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitTheme);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_queryInterface(_iWebKitTheme, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitTheme) { _iWebKitTheme->_vtbl->_addRef(_iWebKitTheme); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitTheme) { _iWebKitTheme->_vtbl->_release(_iWebKitTheme); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult hitTestScrollbar(CERect* scrollRect, bool horizon, UINT32 testPos, UINT32 viewPos, UINT32 viewLength, UINT32 contentLength, float zoomFactorValue, CEHtmlDrawScrollbarPart* partOut)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_hitTestScrollbar(_iWebKitTheme, scrollRect, horizon, testPos, viewPos, viewLength, contentLength, zoomFactorValue, partOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawScrollbar(struct ICEVGContext* iVGC, CERect* scrollRect, CERect* dirtyRect, bool horizon, UINT32 viewPos, UINT32 viewLength, UINT32 contentLength, float zoomFactorValue)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_drawScrollbar(_iWebKitTheme, iVGC, scrollRect, dirtyRect, horizon, viewPos, viewLength, contentLength, zoomFactorValue) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult scrollberTickness(CEHtmlScrollbarControlSize size, UINT32* outWidth)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_scrollberTickness(_iWebKitTheme, size, outWidth) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult drawWidget(struct ICEVGContext* iVGC, CEHtmlDrawWidget type, CEHtmlDrawWidgetState state, CERect* rect, CERect* dirtyRect)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_drawWidget(_iWebKitTheme, iVGC, type, state, rect, dirtyRect) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getWidgetSize(CEHtmlDrawWidget type, CEHtmlDrawWidgetState state, UINT32* widthOut, UINT32* heightOut)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_getWidgetSize(_iWebKitTheme, type, state, widthOut, heightOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getCaretBlinkInterval(UINT32* msecOut)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_getCaretBlinkInterval(_iWebKitTheme, msecOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getMissingImage(struct ICEVGSurface* *const missingImageOut)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_getMissingImage(_iWebKitTheme, missingImageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNoPluginImage(struct ICEVGSurface* *const noPluginImageOut)	{ return _iWebKitTheme ? _iWebKitTheme->_vtbl->_getNoPluginImage(_iWebKitTheme, noPluginImageOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitTheme* _iWebKitTheme;
};

/*! @}
 * end of CEComICEHtmlWebKitThemeRef
 */

/*! \defgroup CEComICEHtmlWebKitDeviceInfoRef CEComICEHtmlWebKitDeviceInfoRef
 * @{
 */

class CEComICEHtmlWebKitDeviceInfoRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlWebKitDeviceInfoRef() : _iWebKitDeviceInfo(0) {}
	CEComICEHtmlWebKitDeviceInfoRef(ICEHtmlWebKitDeviceInfo* iOther) : _iWebKitDeviceInfo(0)
	{
		if (iOther)
		{
			_iWebKitDeviceInfo = iOther;
			_iWebKitDeviceInfo->_vtbl->_addRef(_iWebKitDeviceInfo);
		}
	}

	CEComICEHtmlWebKitDeviceInfoRef(const CEComICEHtmlWebKitDeviceInfoRef& other) : _iWebKitDeviceInfo(0)
	{
		if (other._iWebKitDeviceInfo)
		{
			_iWebKitDeviceInfo = other._iWebKitDeviceInfo;
			_iWebKitDeviceInfo->_vtbl->_addRef(_iWebKitDeviceInfo);
		}
	}

	~CEComICEHtmlWebKitDeviceInfoRef()
	{
		if (_iWebKitDeviceInfo)
		{
			ICEHtmlWebKitDeviceInfo* tmp = _iWebKitDeviceInfo;
			_iWebKitDeviceInfo = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlWebKitDeviceInfo* iWebKitDeviceInfo;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitDeviceInfo = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlWebKitDeviceInfo, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitDeviceInfo)
				{
					ICEHtmlWebKitDeviceInfo* tmp = _iWebKitDeviceInfo;
					_iWebKitDeviceInfo = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitDeviceInfo = uIntf.iWebKitDeviceInfo;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitDeviceInfo* object() const	{ return _iWebKitDeviceInfo; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlWebKitDeviceInfo* iOther)
	{
		if (_iWebKitDeviceInfo)
		{
			ICEHtmlWebKitDeviceInfo* tmp = _iWebKitDeviceInfo;
			_iWebKitDeviceInfo = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitDeviceInfo = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlWebKitDeviceInfo* detach()
	{
		ICEHtmlWebKitDeviceInfo* iIntf = _iWebKitDeviceInfo;
		_iWebKitDeviceInfo = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlWebKitDeviceInfo* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitDeviceInfo;
		if (_iWebKitDeviceInfo)
		{
			_iWebKitDeviceInfo->_vtbl->_addRef(_iWebKitDeviceInfo);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlWebKitDeviceInfo*() const	{ return _iWebKitDeviceInfo; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitDeviceInfo& operator*() const	{ return *_iWebKitDeviceInfo; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitDeviceInfo == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlWebKitDeviceInfo* iOther) const	{ return (_iWebKitDeviceInfo != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlWebKitDeviceInfo* iOther) const	{ return (_iWebKitDeviceInfo == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlWebKitDeviceInfoRef& operator=(const CEComICEHtmlWebKitDeviceInfoRef& other)	{ return operator=(other._iWebKitDeviceInfo); }

	CEComICEHtmlWebKitDeviceInfoRef& operator=(const ICEHtmlWebKitDeviceInfo* iOther)
	{
		if (_iWebKitDeviceInfo != iOther)
		{
			if (_iWebKitDeviceInfo)
			{
				ICEHtmlWebKitDeviceInfo* tmp = _iWebKitDeviceInfo;
				_iWebKitDeviceInfo = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitDeviceInfo = const_cast<ICEHtmlWebKitDeviceInfo*>(iOther);
			if (_iWebKitDeviceInfo)
			{
				_iWebKitDeviceInfo->_vtbl->_addRef(_iWebKitDeviceInfo);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlWebKitDeviceInfo** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlWebKitDeviceInfoRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitDeviceInfo && "has a com object reference. clear first.");
		return & _iWebKitDeviceInfo; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlWebKitDeviceInfoRef& other)
	{
		bool result = false;
		if (_iWebKitDeviceInfo)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitDeviceInfo);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitDeviceInfo ? _iWebKitDeviceInfo->_vtbl->_queryInterface(_iWebKitDeviceInfo, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitDeviceInfo) { _iWebKitDeviceInfo->_vtbl->_addRef(_iWebKitDeviceInfo); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitDeviceInfo) { _iWebKitDeviceInfo->_vtbl->_release(_iWebKitDeviceInfo); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getAcceptLanguage(struct ICEUString* *const acceptLanguageOut)	{ return _iWebKitDeviceInfo ? _iWebKitDeviceInfo->_vtbl->_getAcceptLanguage(_iWebKitDeviceInfo, acceptLanguageOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getUserAgent(struct ICEUString* *const userAgentOut)	{ return _iWebKitDeviceInfo ? _iWebKitDeviceInfo->_vtbl->_getUserAgent(_iWebKitDeviceInfo, userAgentOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getNoPluginString(struct ICEUString* *const noPluginStringOut)	{ return _iWebKitDeviceInfo ? _iWebKitDeviceInfo->_vtbl->_getNoPluginString(_iWebKitDeviceInfo, noPluginStringOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlWebKitDeviceInfo* _iWebKitDeviceInfo;
};

/*! @}
 * end of CEComICEHtmlWebKitDeviceInfoRef
 */

/*! \defgroup CEComICEHtmlFocusNavigatorPeerRef CEComICEHtmlFocusNavigatorPeerRef
 * @{
 */

class CEComICEHtmlFocusNavigatorPeerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFocusNavigatorPeerRef() : _iFocusNavigatorPeer(0) {}
	CEComICEHtmlFocusNavigatorPeerRef(ICEHtmlFocusNavigatorPeer* iOther) : _iFocusNavigatorPeer(0)
	{
		if (iOther)
		{
			_iFocusNavigatorPeer = iOther;
			_iFocusNavigatorPeer->_vtbl->_addRef(_iFocusNavigatorPeer);
		}
	}

	CEComICEHtmlFocusNavigatorPeerRef(const CEComICEHtmlFocusNavigatorPeerRef& other) : _iFocusNavigatorPeer(0)
	{
		if (other._iFocusNavigatorPeer)
		{
			_iFocusNavigatorPeer = other._iFocusNavigatorPeer;
			_iFocusNavigatorPeer->_vtbl->_addRef(_iFocusNavigatorPeer);
		}
	}

	~CEComICEHtmlFocusNavigatorPeerRef()
	{
		if (_iFocusNavigatorPeer)
		{
			ICEHtmlFocusNavigatorPeer* tmp = _iFocusNavigatorPeer;
			_iFocusNavigatorPeer = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFocusNavigatorPeer* iFocusNavigatorPeer;
				void* _ptr;
			} uIntf;
			uIntf.iFocusNavigatorPeer = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFocusNavigatorPeer, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFocusNavigatorPeer)
				{
					ICEHtmlFocusNavigatorPeer* tmp = _iFocusNavigatorPeer;
					_iFocusNavigatorPeer = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFocusNavigatorPeer = uIntf.iFocusNavigatorPeer;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusNavigatorPeer* object() const	{ return _iFocusNavigatorPeer; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFocusNavigatorPeer* iOther)
	{
		if (_iFocusNavigatorPeer)
		{
			ICEHtmlFocusNavigatorPeer* tmp = _iFocusNavigatorPeer;
			_iFocusNavigatorPeer = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFocusNavigatorPeer = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFocusNavigatorPeer* detach()
	{
		ICEHtmlFocusNavigatorPeer* iIntf = _iFocusNavigatorPeer;
		_iFocusNavigatorPeer = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFocusNavigatorPeer* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFocusNavigatorPeer;
		if (_iFocusNavigatorPeer)
		{
			_iFocusNavigatorPeer->_vtbl->_addRef(_iFocusNavigatorPeer);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFocusNavigatorPeer*() const	{ return _iFocusNavigatorPeer; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusNavigatorPeer& operator*() const	{ return *_iFocusNavigatorPeer; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFocusNavigatorPeer == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFocusNavigatorPeer* iOther) const	{ return (_iFocusNavigatorPeer != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFocusNavigatorPeer* iOther) const	{ return (_iFocusNavigatorPeer == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFocusNavigatorPeerRef& operator=(const CEComICEHtmlFocusNavigatorPeerRef& other)	{ return operator=(other._iFocusNavigatorPeer); }

	CEComICEHtmlFocusNavigatorPeerRef& operator=(const ICEHtmlFocusNavigatorPeer* iOther)
	{
		if (_iFocusNavigatorPeer != iOther)
		{
			if (_iFocusNavigatorPeer)
			{
				ICEHtmlFocusNavigatorPeer* tmp = _iFocusNavigatorPeer;
				_iFocusNavigatorPeer = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFocusNavigatorPeer = const_cast<ICEHtmlFocusNavigatorPeer*>(iOther);
			if (_iFocusNavigatorPeer)
			{
				_iFocusNavigatorPeer->_vtbl->_addRef(_iFocusNavigatorPeer);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusNavigatorPeer** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFocusNavigatorPeerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFocusNavigatorPeer && "has a com object reference. clear first.");
		return & _iFocusNavigatorPeer; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFocusNavigatorPeerRef& other)
	{
		bool result = false;
		if (_iFocusNavigatorPeer)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFocusNavigatorPeer);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_queryInterface(_iFocusNavigatorPeer, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFocusNavigatorPeer) { _iFocusNavigatorPeer->_vtbl->_addRef(_iFocusNavigatorPeer); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFocusNavigatorPeer) { _iFocusNavigatorPeer->_vtbl->_release(_iFocusNavigatorPeer); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isVisible(void* hView, bool* resultOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_isVisible(_iFocusNavigatorPeer, hView, resultOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isFocusable(void* hView, bool* resultOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_isFocusable(_iFocusNavigatorPeer, hView, resultOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult isEnable(void* hView, bool* resultOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_isEnable(_iFocusNavigatorPeer, hView, resultOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult scrollTo(void* hView, CEPointBase* pos)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_scrollTo(_iFocusNavigatorPeer, hView, pos) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getScrollPos(void* hView, CEPointBase* posOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_getScrollPos(_iFocusNavigatorPeer, hView, posOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getContentSize(void* hView, CEDim* sizeOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_getContentSize(_iFocusNavigatorPeer, hView, sizeOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getTabIndex(void* hView, UINT32* tabIndexOut)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_getTabIndex(_iFocusNavigatorPeer, hView, tabIndexOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyFocused(void* hView)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_notifyFocused(_iFocusNavigatorPeer, hView) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult click(void* hView)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_click(_iFocusNavigatorPeer, hView) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyDestroy(void* hView)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_notifyDestroy(_iFocusNavigatorPeer, hView) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult constructFocusItemTree()	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_constructFocusItemTree(_iFocusNavigatorPeer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setStatus(CEHtmlFocusNavigatorPeerStatus status, INT32 value)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_setStatus(_iFocusNavigatorPeer, status, value) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getStatus(CEHtmlFocusNavigatorPeerStatus status, INT32* value)	{ return _iFocusNavigatorPeer ? _iFocusNavigatorPeer->_vtbl->_getStatus(_iFocusNavigatorPeer, status, value) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFocusNavigatorPeer* _iFocusNavigatorPeer;
};

/*! @}
 * end of CEComICEHtmlFocusNavigatorPeerRef
 */

/*! \defgroup CEComICEHtmlFocusNavigatorRef CEComICEHtmlFocusNavigatorRef
 * @{
 */

class CEComICEHtmlFocusNavigatorRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlFocusNavigatorRef() : _iFocusNavigator(0) {}
	CEComICEHtmlFocusNavigatorRef(ICEHtmlFocusNavigator* iOther) : _iFocusNavigator(0)
	{
		if (iOther)
		{
			_iFocusNavigator = iOther;
			_iFocusNavigator->_vtbl->_addRef(_iFocusNavigator);
		}
	}

	CEComICEHtmlFocusNavigatorRef(const CEComICEHtmlFocusNavigatorRef& other) : _iFocusNavigator(0)
	{
		if (other._iFocusNavigator)
		{
			_iFocusNavigator = other._iFocusNavigator;
			_iFocusNavigator->_vtbl->_addRef(_iFocusNavigator);
		}
	}

	~CEComICEHtmlFocusNavigatorRef()
	{
		if (_iFocusNavigator)
		{
			ICEHtmlFocusNavigator* tmp = _iFocusNavigator;
			_iFocusNavigator = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlFocusNavigator* iFocusNavigator;
				void* _ptr;
			} uIntf;
			uIntf.iFocusNavigator = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlFocusNavigator, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iFocusNavigator)
				{
					ICEHtmlFocusNavigator* tmp = _iFocusNavigator;
					_iFocusNavigator = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iFocusNavigator = uIntf.iFocusNavigator;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusNavigator* object() const	{ return _iFocusNavigator; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlFocusNavigator* iOther)
	{
		if (_iFocusNavigator)
		{
			ICEHtmlFocusNavigator* tmp = _iFocusNavigator;
			_iFocusNavigator = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iFocusNavigator = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlFocusNavigator* detach()
	{
		ICEHtmlFocusNavigator* iIntf = _iFocusNavigator;
		_iFocusNavigator = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlFocusNavigator* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iFocusNavigator;
		if (_iFocusNavigator)
		{
			_iFocusNavigator->_vtbl->_addRef(_iFocusNavigator);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlFocusNavigator*() const	{ return _iFocusNavigator; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusNavigator& operator*() const	{ return *_iFocusNavigator; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iFocusNavigator == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlFocusNavigator* iOther) const	{ return (_iFocusNavigator != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlFocusNavigator* iOther) const	{ return (_iFocusNavigator == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlFocusNavigatorRef& operator=(const CEComICEHtmlFocusNavigatorRef& other)	{ return operator=(other._iFocusNavigator); }

	CEComICEHtmlFocusNavigatorRef& operator=(const ICEHtmlFocusNavigator* iOther)
	{
		if (_iFocusNavigator != iOther)
		{
			if (_iFocusNavigator)
			{
				ICEHtmlFocusNavigator* tmp = _iFocusNavigator;
				_iFocusNavigator = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iFocusNavigator = const_cast<ICEHtmlFocusNavigator*>(iOther);
			if (_iFocusNavigator)
			{
				_iFocusNavigator->_vtbl->_addRef(_iFocusNavigator);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlFocusNavigator** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlFocusNavigatorRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iFocusNavigator && "has a com object reference. clear first.");
		return & _iFocusNavigator; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlFocusNavigatorRef& other)
	{
		bool result = false;
		if (_iFocusNavigator)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iFocusNavigator);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_queryInterface(_iFocusNavigator, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iFocusNavigator) { _iFocusNavigator->_vtbl->_addRef(_iFocusNavigator); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iFocusNavigator) { _iFocusNavigator->_vtbl->_release(_iFocusNavigator); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFocusNavigatorPeer(struct ICEHtmlFocusNavigatorPeer* peer)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_setFocusNavigatorPeer(_iFocusNavigator, peer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult shutdownFocusNavigatorPeer()	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_shutdownFocusNavigatorPeer(_iFocusNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setFocusItem(void** itemOut, void* parentItem, void* hView, void* hElem, CEHtmlFocusItemType type, const CERect* rect, const CEDim* frameSize, const CEPointBase* framePos)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_setFocusItem(_iFocusNavigator, itemOut, parentItem, hView, hElem, type, rect, frameSize, framePos) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setScrollPos(void* item, CEPointBase* pos)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_setScrollPos(_iFocusNavigator, item, pos) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setContentSize(void* item, CEDim* dim)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_setContentSize(_iFocusNavigator, item, dim) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult completeConstruct(void* parentItem)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_completeConstruct(_iFocusNavigator, parentItem) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyRebuild()	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_notifyRebuild(_iFocusNavigator) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyRemoveItem(void* hView)	{ return _iFocusNavigator ? _iFocusNavigator->_vtbl->_notifyRemoveItem(_iFocusNavigator, hView) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlFocusNavigator* _iFocusNavigator;
};

/*! @}
 * end of CEComICEHtmlFocusNavigatorRef
 */

/*! \defgroup CEComICEWebKitCopyPasteEventHandlerRef CEComICEWebKitCopyPasteEventHandlerRef
 * @{
 */

class CEComICEWebKitCopyPasteEventHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEWebKitCopyPasteEventHandlerRef() : _iWebKitCopyPasteEventHandler(0) {}
	CEComICEWebKitCopyPasteEventHandlerRef(ICEWebKitCopyPasteEventHandler* iOther) : _iWebKitCopyPasteEventHandler(0)
	{
		if (iOther)
		{
			_iWebKitCopyPasteEventHandler = iOther;
			_iWebKitCopyPasteEventHandler->_vtbl->_addRef(_iWebKitCopyPasteEventHandler);
		}
	}

	CEComICEWebKitCopyPasteEventHandlerRef(const CEComICEWebKitCopyPasteEventHandlerRef& other) : _iWebKitCopyPasteEventHandler(0)
	{
		if (other._iWebKitCopyPasteEventHandler)
		{
			_iWebKitCopyPasteEventHandler = other._iWebKitCopyPasteEventHandler;
			_iWebKitCopyPasteEventHandler->_vtbl->_addRef(_iWebKitCopyPasteEventHandler);
		}
	}

	~CEComICEWebKitCopyPasteEventHandlerRef()
	{
		if (_iWebKitCopyPasteEventHandler)
		{
			ICEWebKitCopyPasteEventHandler* tmp = _iWebKitCopyPasteEventHandler;
			_iWebKitCopyPasteEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEWebKitCopyPasteEventHandler* iWebKitCopyPasteEventHandler;
				void* _ptr;
			} uIntf;
			uIntf.iWebKitCopyPasteEventHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEWebKitCopyPasteEventHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iWebKitCopyPasteEventHandler)
				{
					ICEWebKitCopyPasteEventHandler* tmp = _iWebKitCopyPasteEventHandler;
					_iWebKitCopyPasteEventHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iWebKitCopyPasteEventHandler = uIntf.iWebKitCopyPasteEventHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitCopyPasteEventHandler* object() const	{ return _iWebKitCopyPasteEventHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEWebKitCopyPasteEventHandler* iOther)
	{
		if (_iWebKitCopyPasteEventHandler)
		{
			ICEWebKitCopyPasteEventHandler* tmp = _iWebKitCopyPasteEventHandler;
			_iWebKitCopyPasteEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iWebKitCopyPasteEventHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEWebKitCopyPasteEventHandler* detach()
	{
		ICEWebKitCopyPasteEventHandler* iIntf = _iWebKitCopyPasteEventHandler;
		_iWebKitCopyPasteEventHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEWebKitCopyPasteEventHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iWebKitCopyPasteEventHandler;
		if (_iWebKitCopyPasteEventHandler)
		{
			_iWebKitCopyPasteEventHandler->_vtbl->_addRef(_iWebKitCopyPasteEventHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEWebKitCopyPasteEventHandler*() const	{ return _iWebKitCopyPasteEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEWebKitCopyPasteEventHandler& operator*() const	{ return *_iWebKitCopyPasteEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iWebKitCopyPasteEventHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEWebKitCopyPasteEventHandler* iOther) const	{ return (_iWebKitCopyPasteEventHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEWebKitCopyPasteEventHandler* iOther) const	{ return (_iWebKitCopyPasteEventHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEWebKitCopyPasteEventHandlerRef& operator=(const CEComICEWebKitCopyPasteEventHandlerRef& other)	{ return operator=(other._iWebKitCopyPasteEventHandler); }

	CEComICEWebKitCopyPasteEventHandlerRef& operator=(const ICEWebKitCopyPasteEventHandler* iOther)
	{
		if (_iWebKitCopyPasteEventHandler != iOther)
		{
			if (_iWebKitCopyPasteEventHandler)
			{
				ICEWebKitCopyPasteEventHandler* tmp = _iWebKitCopyPasteEventHandler;
				_iWebKitCopyPasteEventHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iWebKitCopyPasteEventHandler = const_cast<ICEWebKitCopyPasteEventHandler*>(iOther);
			if (_iWebKitCopyPasteEventHandler)
			{
				_iWebKitCopyPasteEventHandler->_vtbl->_addRef(_iWebKitCopyPasteEventHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEWebKitCopyPasteEventHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEWebKitCopyPasteEventHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iWebKitCopyPasteEventHandler && "has a com object reference. clear first.");
		return & _iWebKitCopyPasteEventHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEWebKitCopyPasteEventHandlerRef& other)
	{
		bool result = false;
		if (_iWebKitCopyPasteEventHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iWebKitCopyPasteEventHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iWebKitCopyPasteEventHandler ? _iWebKitCopyPasteEventHandler->_vtbl->_queryInterface(_iWebKitCopyPasteEventHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iWebKitCopyPasteEventHandler) { _iWebKitCopyPasteEventHandler->_vtbl->_addRef(_iWebKitCopyPasteEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iWebKitCopyPasteEventHandler) { _iWebKitCopyPasteEventHandler->_vtbl->_release(_iWebKitCopyPasteEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleCopyEvent()	{ return _iWebKitCopyPasteEventHandler ? _iWebKitCopyPasteEventHandler->_vtbl->_handleCopyEvent(_iWebKitCopyPasteEventHandler) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handlePasteEvent()	{ return _iWebKitCopyPasteEventHandler ? _iWebKitCopyPasteEventHandler->_vtbl->_handlePasteEvent(_iWebKitCopyPasteEventHandler) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEWebKitCopyPasteEventHandler* _iWebKitCopyPasteEventHandler;
};

/*! @}
 * end of CEComICEWebKitCopyPasteEventHandlerRef
 */

/*! \defgroup CEComICEHtmlOneshotTimerEventListenerRef CEComICEHtmlOneshotTimerEventListenerRef
 * @{
 */

class CEComICEHtmlOneshotTimerEventListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlOneshotTimerEventListenerRef() : _iOneshotTimerEventListener(0) {}
	CEComICEHtmlOneshotTimerEventListenerRef(ICEHtmlOneshotTimerEventListener* iOther) : _iOneshotTimerEventListener(0)
	{
		if (iOther)
		{
			_iOneshotTimerEventListener = iOther;
			_iOneshotTimerEventListener->_vtbl->_addRef(_iOneshotTimerEventListener);
		}
	}

	CEComICEHtmlOneshotTimerEventListenerRef(const CEComICEHtmlOneshotTimerEventListenerRef& other) : _iOneshotTimerEventListener(0)
	{
		if (other._iOneshotTimerEventListener)
		{
			_iOneshotTimerEventListener = other._iOneshotTimerEventListener;
			_iOneshotTimerEventListener->_vtbl->_addRef(_iOneshotTimerEventListener);
		}
	}

	~CEComICEHtmlOneshotTimerEventListenerRef()
	{
		if (_iOneshotTimerEventListener)
		{
			ICEHtmlOneshotTimerEventListener* tmp = _iOneshotTimerEventListener;
			_iOneshotTimerEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlOneshotTimerEventListener* iOneshotTimerEventListener;
				void* _ptr;
			} uIntf;
			uIntf.iOneshotTimerEventListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlOneshotTimerEventListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iOneshotTimerEventListener)
				{
					ICEHtmlOneshotTimerEventListener* tmp = _iOneshotTimerEventListener;
					_iOneshotTimerEventListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iOneshotTimerEventListener = uIntf.iOneshotTimerEventListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOneshotTimerEventListener* object() const	{ return _iOneshotTimerEventListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlOneshotTimerEventListener* iOther)
	{
		if (_iOneshotTimerEventListener)
		{
			ICEHtmlOneshotTimerEventListener* tmp = _iOneshotTimerEventListener;
			_iOneshotTimerEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iOneshotTimerEventListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlOneshotTimerEventListener* detach()
	{
		ICEHtmlOneshotTimerEventListener* iIntf = _iOneshotTimerEventListener;
		_iOneshotTimerEventListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlOneshotTimerEventListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iOneshotTimerEventListener;
		if (_iOneshotTimerEventListener)
		{
			_iOneshotTimerEventListener->_vtbl->_addRef(_iOneshotTimerEventListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlOneshotTimerEventListener*() const	{ return _iOneshotTimerEventListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOneshotTimerEventListener& operator*() const	{ return *_iOneshotTimerEventListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iOneshotTimerEventListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlOneshotTimerEventListener* iOther) const	{ return (_iOneshotTimerEventListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlOneshotTimerEventListener* iOther) const	{ return (_iOneshotTimerEventListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlOneshotTimerEventListenerRef& operator=(const CEComICEHtmlOneshotTimerEventListenerRef& other)	{ return operator=(other._iOneshotTimerEventListener); }

	CEComICEHtmlOneshotTimerEventListenerRef& operator=(const ICEHtmlOneshotTimerEventListener* iOther)
	{
		if (_iOneshotTimerEventListener != iOther)
		{
			if (_iOneshotTimerEventListener)
			{
				ICEHtmlOneshotTimerEventListener* tmp = _iOneshotTimerEventListener;
				_iOneshotTimerEventListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iOneshotTimerEventListener = const_cast<ICEHtmlOneshotTimerEventListener*>(iOther);
			if (_iOneshotTimerEventListener)
			{
				_iOneshotTimerEventListener->_vtbl->_addRef(_iOneshotTimerEventListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOneshotTimerEventListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlOneshotTimerEventListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iOneshotTimerEventListener && "has a com object reference. clear first.");
		return & _iOneshotTimerEventListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlOneshotTimerEventListenerRef& other)
	{
		bool result = false;
		if (_iOneshotTimerEventListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iOneshotTimerEventListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iOneshotTimerEventListener ? _iOneshotTimerEventListener->_vtbl->_queryInterface(_iOneshotTimerEventListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iOneshotTimerEventListener) { _iOneshotTimerEventListener->_vtbl->_addRef(_iOneshotTimerEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iOneshotTimerEventListener) { _iOneshotTimerEventListener->_vtbl->_release(_iOneshotTimerEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleTimerEvent()	{ return _iOneshotTimerEventListener ? _iOneshotTimerEventListener->_vtbl->_handleTimerEvent(_iOneshotTimerEventListener) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlOneshotTimerEventListener* _iOneshotTimerEventListener;
};

/*! @}
 * end of CEComICEHtmlOneshotTimerEventListenerRef
 */

/*! \defgroup CEComICEHtmlOneshotTimerManagerRef CEComICEHtmlOneshotTimerManagerRef
 * @{
 */

class CEComICEHtmlOneshotTimerManagerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlOneshotTimerManagerRef() : _iOneshotTimerManager(0) {}
	CEComICEHtmlOneshotTimerManagerRef(ICEHtmlOneshotTimerManager* iOther) : _iOneshotTimerManager(0)
	{
		if (iOther)
		{
			_iOneshotTimerManager = iOther;
			_iOneshotTimerManager->_vtbl->_addRef(_iOneshotTimerManager);
		}
	}

	CEComICEHtmlOneshotTimerManagerRef(const CEComICEHtmlOneshotTimerManagerRef& other) : _iOneshotTimerManager(0)
	{
		if (other._iOneshotTimerManager)
		{
			_iOneshotTimerManager = other._iOneshotTimerManager;
			_iOneshotTimerManager->_vtbl->_addRef(_iOneshotTimerManager);
		}
	}

	~CEComICEHtmlOneshotTimerManagerRef()
	{
		if (_iOneshotTimerManager)
		{
			ICEHtmlOneshotTimerManager* tmp = _iOneshotTimerManager;
			_iOneshotTimerManager = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlOneshotTimerManager* iOneshotTimerManager;
				void* _ptr;
			} uIntf;
			uIntf.iOneshotTimerManager = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlOneshotTimerManager, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iOneshotTimerManager)
				{
					ICEHtmlOneshotTimerManager* tmp = _iOneshotTimerManager;
					_iOneshotTimerManager = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iOneshotTimerManager = uIntf.iOneshotTimerManager;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOneshotTimerManager* object() const	{ return _iOneshotTimerManager; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlOneshotTimerManager* iOther)
	{
		if (_iOneshotTimerManager)
		{
			ICEHtmlOneshotTimerManager* tmp = _iOneshotTimerManager;
			_iOneshotTimerManager = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iOneshotTimerManager = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlOneshotTimerManager* detach()
	{
		ICEHtmlOneshotTimerManager* iIntf = _iOneshotTimerManager;
		_iOneshotTimerManager = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlOneshotTimerManager* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iOneshotTimerManager;
		if (_iOneshotTimerManager)
		{
			_iOneshotTimerManager->_vtbl->_addRef(_iOneshotTimerManager);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlOneshotTimerManager*() const	{ return _iOneshotTimerManager; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOneshotTimerManager& operator*() const	{ return *_iOneshotTimerManager; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iOneshotTimerManager == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlOneshotTimerManager* iOther) const	{ return (_iOneshotTimerManager != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlOneshotTimerManager* iOther) const	{ return (_iOneshotTimerManager == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlOneshotTimerManagerRef& operator=(const CEComICEHtmlOneshotTimerManagerRef& other)	{ return operator=(other._iOneshotTimerManager); }

	CEComICEHtmlOneshotTimerManagerRef& operator=(const ICEHtmlOneshotTimerManager* iOther)
	{
		if (_iOneshotTimerManager != iOther)
		{
			if (_iOneshotTimerManager)
			{
				ICEHtmlOneshotTimerManager* tmp = _iOneshotTimerManager;
				_iOneshotTimerManager = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iOneshotTimerManager = const_cast<ICEHtmlOneshotTimerManager*>(iOther);
			if (_iOneshotTimerManager)
			{
				_iOneshotTimerManager->_vtbl->_addRef(_iOneshotTimerManager);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlOneshotTimerManager** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlOneshotTimerManagerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iOneshotTimerManager && "has a com object reference. clear first.");
		return & _iOneshotTimerManager; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlOneshotTimerManagerRef& other)
	{
		bool result = false;
		if (_iOneshotTimerManager)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iOneshotTimerManager);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iOneshotTimerManager ? _iOneshotTimerManager->_vtbl->_queryInterface(_iOneshotTimerManager, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iOneshotTimerManager) { _iOneshotTimerManager->_vtbl->_addRef(_iOneshotTimerManager); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iOneshotTimerManager) { _iOneshotTimerManager->_vtbl->_release(_iOneshotTimerManager); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setOneshotTimer(struct ICEHtmlOneshotTimerEventListener* iListener, INT64 elapsedTimeInUSec)	{ return _iOneshotTimerManager ? _iOneshotTimerManager->_vtbl->_setOneshotTimer(_iOneshotTimerManager, iListener, elapsedTimeInUSec) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlOneshotTimerManager* _iOneshotTimerManager;
};

/*! @}
 * end of CEComICEHtmlOneshotTimerManagerRef
 */

#endif // __cplusplus

#endif
