///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEHtmlNetworkEventHandler_h
#define ICEHtmlNetworkEventHandler_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEHtmlNetworkEventHandler ICEHtmlNetworkEventHandler
 * @{
 */

/*!
 * ID of ICEHtmlNetworkEventHandler
 */
#define CEComIID_ICEHtmlNetworkEventHandler 0xf794efeb


/*!
 * ICEHtmlNetworkEventHandler
 */
typedef struct ICEHtmlNetworkEventHandler
{
	const struct ICEHtmlNetworkEventHandler_vtbl* _vtbl;
} ICEHtmlNetworkEventHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNetworkEventHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlNetworkEventHandler_queryInterface) (ICEHtmlNetworkEventHandler* iNetworkEventHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkEventHandler_addRef) (ICEHtmlNetworkEventHandler* iNetworkEventHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkEventHandler_release) (ICEHtmlNetworkEventHandler* iNetworkEventHandler);

typedef CEHResult (*iCEHtmlNetworkEventHandler_notifyNetworkLibraryError) (ICEHtmlNetworkEventHandler* iNetworkEventHandler, INT32 internalErr, bool isMainResource);

/*!
 * V-table of ICEHtmlNetworkEventHandler
 */
struct ICEHtmlNetworkEventHandler_vtbl
{
	iCEHtmlNetworkEventHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlNetworkEventHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlNetworkEventHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlNetworkEventHandler_notifyNetworkLibraryError	_notifyNetworkLibraryError;
};

/*! @}
 * end of ICEHtmlNetworkEventHandler
 */

/*! \defgroup ICEHtmlNetworkEventHandlerReply ICEHtmlNetworkEventHandlerReply
 * @{
 */

/*!
 * ID of ICEHtmlNetworkEventHandlerReply
 */
#define CEComIID_ICEHtmlNetworkEventHandlerReply 0x2701b365

/*!
 * ICEHtmlNetworkEventHandlerReply
 */
typedef struct ICEHtmlNetworkEventHandlerReply
{
	const struct ICEHtmlNetworkEventHandlerReply_vtbl* _vtbl;
} ICEHtmlNetworkEventHandlerReply;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNetworkEventHandlerReply	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlNetworkEventHandlerReply_queryInterface) (ICEHtmlNetworkEventHandlerReply* iNetworkEventHandlerReply, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkEventHandlerReply_addRef) (ICEHtmlNetworkEventHandlerReply* iNetworkEventHandlerReply);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkEventHandlerReply_release) (ICEHtmlNetworkEventHandlerReply* iNetworkEventHandlerReply);

typedef CEHResult (*iCEHtmlNetworkEventHandlerReply_replyNetworkLibraryError) (ICEHtmlNetworkEventHandlerReply* iNetworkEventHandlerReply, bool result, struct ICEUString* errorPageStr);

/*!
 * V-table of ICEHtmlNetworkEventHandlerReply
 */
struct ICEHtmlNetworkEventHandlerReply_vtbl
{
	iCEHtmlNetworkEventHandlerReply_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlNetworkEventHandlerReply_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlNetworkEventHandlerReply_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlNetworkEventHandlerReply_replyNetworkLibraryError	_replyNetworkLibraryError;
};

/*! @}
 * end of ICEHtmlNetworkEventHandlerReply
 */

/*! \defgroup ICEHtmlNetworkPromptHandler ICEHtmlNetworkPromptHandler
 * @{
 */

/*!
 * ID of ICEHtmlNetworkPromptHandler
 */
#define CEComIID_ICEHtmlNetworkPromptHandler 0x0596d0b7

/*!
 * ICEHtmlNetworkPromptHandler
 */
typedef struct ICEHtmlNetworkPromptHandler
{
	const struct ICEHtmlNetworkPromptHandler_vtbl* _vtbl;
} ICEHtmlNetworkPromptHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNetworkPromptHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlNetworkPromptHandler_queryInterface) (ICEHtmlNetworkPromptHandler* iNetworkPromptHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkPromptHandler_addRef) (ICEHtmlNetworkPromptHandler* iNetworkPromptHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkPromptHandler_release) (ICEHtmlNetworkPromptHandler* iNetworkPromptHandler);

typedef CEHResult (*iCEHtmlNetworkPromptHandler_sslBadCert) (ICEHtmlNetworkPromptHandler* iNetworkPromptHandler, struct ICEUString* iUrl, UINT32 errCode, const char* issuedTo, const char* issuedBy, double issuedDate, double expireDate, const char* serialNumber, const char* fingerPrint, bool withCert, bool *const continueOut);

typedef CEHResult (*iCEHtmlNetworkPromptHandler_credential) (ICEHtmlNetworkPromptHandler* iNetworkPromptHandler, struct ICEUString* site, struct ICEUString* realm, struct ICEUString* defaultUserName, struct ICEUString* defaultPassword, bool wasSaved, struct ICEUString* *const username, struct ICEUString* *const password, bool *const continueOut, bool *const updatedSavedFlag);

/*!
 * V-table of ICEHtmlNetworkPromptHandler
 */
struct ICEHtmlNetworkPromptHandler_vtbl
{
	iCEHtmlNetworkPromptHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlNetworkPromptHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlNetworkPromptHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlNetworkPromptHandler_sslBadCert	_sslBadCert;
	iCEHtmlNetworkPromptHandler_credential	_credential;
};

/*! @}
 * end of ICEHtmlNetworkPromptHandler
 */

/*! \defgroup ICEHtmlNetworkUserNotifyHandler ICEHtmlNetworkUserNotifyHandler
 * @{
 */

/*!
 * ID of ICEHtmlNetworkUserNotifyHandler
 */
#define CEComIID_ICEHtmlNetworkUserNotifyHandler 0x193bd7fe

/*!
 * ICEHtmlNetworkUserNotifyHandler
 */
typedef struct ICEHtmlNetworkUserNotifyHandler
{
	const struct ICEHtmlNetworkUserNotifyHandler_vtbl* _vtbl;
} ICEHtmlNetworkUserNotifyHandler;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iNetworkUserNotifyHandler	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEHtmlNetworkUserNotifyHandler_queryInterface) (ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkUserNotifyHandler_addRef) (ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEHtmlNetworkUserNotifyHandler_release) (ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler);

typedef CEHResult (*iCEHtmlNetworkUserNotifyHandler_requestBadCertificate) (ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler, struct ICEUString* iUrl, UINT32 errCode, const char* issuedTo, const char* issuedBy, double issuedDate, double expireDate, const char* serialNumber, const char* fingerPrint, bool withCert);

/*!
 * V-table of ICEHtmlNetworkUserNotifyHandler
 */
struct ICEHtmlNetworkUserNotifyHandler_vtbl
{
	iCEHtmlNetworkUserNotifyHandler_queryInterface	_queryInterface;	//!< Query interface.
	iCEHtmlNetworkUserNotifyHandler_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEHtmlNetworkUserNotifyHandler_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEHtmlNetworkUserNotifyHandler_requestBadCertificate	_requestBadCertificate;
};

/*! @}
 * end of ICEHtmlNetworkUserNotifyHandler
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEHtmlNetworkEventHandlerRef CEComICEHtmlNetworkEventHandlerRef
 * @{
 */

class CEComICEHtmlNetworkEventHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlNetworkEventHandlerRef() : _iNetworkEventHandler(0) {}
	CEComICEHtmlNetworkEventHandlerRef(ICEHtmlNetworkEventHandler* iOther) : _iNetworkEventHandler(0)
	{
		if (iOther)
		{
			_iNetworkEventHandler = iOther;
			_iNetworkEventHandler->_vtbl->_addRef(_iNetworkEventHandler);
		}
	}

	CEComICEHtmlNetworkEventHandlerRef(const CEComICEHtmlNetworkEventHandlerRef& other) : _iNetworkEventHandler(0)
	{
		if (other._iNetworkEventHandler)
		{
			_iNetworkEventHandler = other._iNetworkEventHandler;
			_iNetworkEventHandler->_vtbl->_addRef(_iNetworkEventHandler);
		}
	}

	~CEComICEHtmlNetworkEventHandlerRef()
	{
		if (_iNetworkEventHandler)
		{
			ICEHtmlNetworkEventHandler* tmp = _iNetworkEventHandler;
			_iNetworkEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlNetworkEventHandler* iNetworkEventHandler;
				void* _ptr;
			} uIntf;
			uIntf.iNetworkEventHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlNetworkEventHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNetworkEventHandler)
				{
					ICEHtmlNetworkEventHandler* tmp = _iNetworkEventHandler;
					_iNetworkEventHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNetworkEventHandler = uIntf.iNetworkEventHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkEventHandler* object() const	{ return _iNetworkEventHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlNetworkEventHandler* iOther)
	{
		if (_iNetworkEventHandler)
		{
			ICEHtmlNetworkEventHandler* tmp = _iNetworkEventHandler;
			_iNetworkEventHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNetworkEventHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlNetworkEventHandler* detach()
	{
		ICEHtmlNetworkEventHandler* iIntf = _iNetworkEventHandler;
		_iNetworkEventHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlNetworkEventHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNetworkEventHandler;
		if (_iNetworkEventHandler)
		{
			_iNetworkEventHandler->_vtbl->_addRef(_iNetworkEventHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlNetworkEventHandler*() const	{ return _iNetworkEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkEventHandler& operator*() const	{ return *_iNetworkEventHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNetworkEventHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlNetworkEventHandler* iOther) const	{ return (_iNetworkEventHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlNetworkEventHandler* iOther) const	{ return (_iNetworkEventHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlNetworkEventHandlerRef& operator=(const CEComICEHtmlNetworkEventHandlerRef& other)	{ return operator=(other._iNetworkEventHandler); }

	CEComICEHtmlNetworkEventHandlerRef& operator=(const ICEHtmlNetworkEventHandler* iOther)
	{
		if (_iNetworkEventHandler != iOther)
		{
			if (_iNetworkEventHandler)
			{
				ICEHtmlNetworkEventHandler* tmp = _iNetworkEventHandler;
				_iNetworkEventHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNetworkEventHandler = const_cast<ICEHtmlNetworkEventHandler*>(iOther);
			if (_iNetworkEventHandler)
			{
				_iNetworkEventHandler->_vtbl->_addRef(_iNetworkEventHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkEventHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlNetworkEventHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNetworkEventHandler && "has a com object reference. clear first.");
		return & _iNetworkEventHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlNetworkEventHandlerRef& other)
	{
		bool result = false;
		if (_iNetworkEventHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNetworkEventHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNetworkEventHandler ? _iNetworkEventHandler->_vtbl->_queryInterface(_iNetworkEventHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNetworkEventHandler) { _iNetworkEventHandler->_vtbl->_addRef(_iNetworkEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNetworkEventHandler) { _iNetworkEventHandler->_vtbl->_release(_iNetworkEventHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult notifyNetworkLibraryError(INT32 internalErr, bool isMainResource)	{ return _iNetworkEventHandler ? _iNetworkEventHandler->_vtbl->_notifyNetworkLibraryError(_iNetworkEventHandler, internalErr, isMainResource) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlNetworkEventHandler* _iNetworkEventHandler;
};

/*! @}
 * end of CEComICEHtmlNetworkEventHandlerRef
 */

/*! \defgroup CEComICEHtmlNetworkEventHandlerReplyRef CEComICEHtmlNetworkEventHandlerReplyRef
 * @{
 */

class CEComICEHtmlNetworkEventHandlerReplyRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlNetworkEventHandlerReplyRef() : _iNetworkEventHandlerReply(0) {}
	CEComICEHtmlNetworkEventHandlerReplyRef(ICEHtmlNetworkEventHandlerReply* iOther) : _iNetworkEventHandlerReply(0)
	{
		if (iOther)
		{
			_iNetworkEventHandlerReply = iOther;
			_iNetworkEventHandlerReply->_vtbl->_addRef(_iNetworkEventHandlerReply);
		}
	}

	CEComICEHtmlNetworkEventHandlerReplyRef(const CEComICEHtmlNetworkEventHandlerReplyRef& other) : _iNetworkEventHandlerReply(0)
	{
		if (other._iNetworkEventHandlerReply)
		{
			_iNetworkEventHandlerReply = other._iNetworkEventHandlerReply;
			_iNetworkEventHandlerReply->_vtbl->_addRef(_iNetworkEventHandlerReply);
		}
	}

	~CEComICEHtmlNetworkEventHandlerReplyRef()
	{
		if (_iNetworkEventHandlerReply)
		{
			ICEHtmlNetworkEventHandlerReply* tmp = _iNetworkEventHandlerReply;
			_iNetworkEventHandlerReply = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlNetworkEventHandlerReply* iNetworkEventHandlerReply;
				void* _ptr;
			} uIntf;
			uIntf.iNetworkEventHandlerReply = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlNetworkEventHandlerReply, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNetworkEventHandlerReply)
				{
					ICEHtmlNetworkEventHandlerReply* tmp = _iNetworkEventHandlerReply;
					_iNetworkEventHandlerReply = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNetworkEventHandlerReply = uIntf.iNetworkEventHandlerReply;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkEventHandlerReply* object() const	{ return _iNetworkEventHandlerReply; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlNetworkEventHandlerReply* iOther)
	{
		if (_iNetworkEventHandlerReply)
		{
			ICEHtmlNetworkEventHandlerReply* tmp = _iNetworkEventHandlerReply;
			_iNetworkEventHandlerReply = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNetworkEventHandlerReply = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlNetworkEventHandlerReply* detach()
	{
		ICEHtmlNetworkEventHandlerReply* iIntf = _iNetworkEventHandlerReply;
		_iNetworkEventHandlerReply = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlNetworkEventHandlerReply* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNetworkEventHandlerReply;
		if (_iNetworkEventHandlerReply)
		{
			_iNetworkEventHandlerReply->_vtbl->_addRef(_iNetworkEventHandlerReply);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlNetworkEventHandlerReply*() const	{ return _iNetworkEventHandlerReply; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkEventHandlerReply& operator*() const	{ return *_iNetworkEventHandlerReply; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNetworkEventHandlerReply == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlNetworkEventHandlerReply* iOther) const	{ return (_iNetworkEventHandlerReply != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlNetworkEventHandlerReply* iOther) const	{ return (_iNetworkEventHandlerReply == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlNetworkEventHandlerReplyRef& operator=(const CEComICEHtmlNetworkEventHandlerReplyRef& other)	{ return operator=(other._iNetworkEventHandlerReply); }

	CEComICEHtmlNetworkEventHandlerReplyRef& operator=(const ICEHtmlNetworkEventHandlerReply* iOther)
	{
		if (_iNetworkEventHandlerReply != iOther)
		{
			if (_iNetworkEventHandlerReply)
			{
				ICEHtmlNetworkEventHandlerReply* tmp = _iNetworkEventHandlerReply;
				_iNetworkEventHandlerReply = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNetworkEventHandlerReply = const_cast<ICEHtmlNetworkEventHandlerReply*>(iOther);
			if (_iNetworkEventHandlerReply)
			{
				_iNetworkEventHandlerReply->_vtbl->_addRef(_iNetworkEventHandlerReply);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkEventHandlerReply** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlNetworkEventHandlerReplyRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNetworkEventHandlerReply && "has a com object reference. clear first.");
		return & _iNetworkEventHandlerReply; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlNetworkEventHandlerReplyRef& other)
	{
		bool result = false;
		if (_iNetworkEventHandlerReply)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNetworkEventHandlerReply);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNetworkEventHandlerReply ? _iNetworkEventHandlerReply->_vtbl->_queryInterface(_iNetworkEventHandlerReply, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNetworkEventHandlerReply) { _iNetworkEventHandlerReply->_vtbl->_addRef(_iNetworkEventHandlerReply); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNetworkEventHandlerReply) { _iNetworkEventHandlerReply->_vtbl->_release(_iNetworkEventHandlerReply); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult replyNetworkLibraryError(bool result, struct ICEUString* errorPageStr)	{ return _iNetworkEventHandlerReply ? _iNetworkEventHandlerReply->_vtbl->_replyNetworkLibraryError(_iNetworkEventHandlerReply, result, errorPageStr) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlNetworkEventHandlerReply* _iNetworkEventHandlerReply;
};

/*! @}
 * end of CEComICEHtmlNetworkEventHandlerReplyRef
 */

/*! \defgroup CEComICEHtmlNetworkPromptHandlerRef CEComICEHtmlNetworkPromptHandlerRef
 * @{
 */

class CEComICEHtmlNetworkPromptHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlNetworkPromptHandlerRef() : _iNetworkPromptHandler(0) {}
	CEComICEHtmlNetworkPromptHandlerRef(ICEHtmlNetworkPromptHandler* iOther) : _iNetworkPromptHandler(0)
	{
		if (iOther)
		{
			_iNetworkPromptHandler = iOther;
			_iNetworkPromptHandler->_vtbl->_addRef(_iNetworkPromptHandler);
		}
	}

	CEComICEHtmlNetworkPromptHandlerRef(const CEComICEHtmlNetworkPromptHandlerRef& other) : _iNetworkPromptHandler(0)
	{
		if (other._iNetworkPromptHandler)
		{
			_iNetworkPromptHandler = other._iNetworkPromptHandler;
			_iNetworkPromptHandler->_vtbl->_addRef(_iNetworkPromptHandler);
		}
	}

	~CEComICEHtmlNetworkPromptHandlerRef()
	{
		if (_iNetworkPromptHandler)
		{
			ICEHtmlNetworkPromptHandler* tmp = _iNetworkPromptHandler;
			_iNetworkPromptHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlNetworkPromptHandler* iNetworkPromptHandler;
				void* _ptr;
			} uIntf;
			uIntf.iNetworkPromptHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlNetworkPromptHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNetworkPromptHandler)
				{
					ICEHtmlNetworkPromptHandler* tmp = _iNetworkPromptHandler;
					_iNetworkPromptHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNetworkPromptHandler = uIntf.iNetworkPromptHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkPromptHandler* object() const	{ return _iNetworkPromptHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlNetworkPromptHandler* iOther)
	{
		if (_iNetworkPromptHandler)
		{
			ICEHtmlNetworkPromptHandler* tmp = _iNetworkPromptHandler;
			_iNetworkPromptHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNetworkPromptHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlNetworkPromptHandler* detach()
	{
		ICEHtmlNetworkPromptHandler* iIntf = _iNetworkPromptHandler;
		_iNetworkPromptHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlNetworkPromptHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNetworkPromptHandler;
		if (_iNetworkPromptHandler)
		{
			_iNetworkPromptHandler->_vtbl->_addRef(_iNetworkPromptHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlNetworkPromptHandler*() const	{ return _iNetworkPromptHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkPromptHandler& operator*() const	{ return *_iNetworkPromptHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNetworkPromptHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlNetworkPromptHandler* iOther) const	{ return (_iNetworkPromptHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlNetworkPromptHandler* iOther) const	{ return (_iNetworkPromptHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlNetworkPromptHandlerRef& operator=(const CEComICEHtmlNetworkPromptHandlerRef& other)	{ return operator=(other._iNetworkPromptHandler); }

	CEComICEHtmlNetworkPromptHandlerRef& operator=(const ICEHtmlNetworkPromptHandler* iOther)
	{
		if (_iNetworkPromptHandler != iOther)
		{
			if (_iNetworkPromptHandler)
			{
				ICEHtmlNetworkPromptHandler* tmp = _iNetworkPromptHandler;
				_iNetworkPromptHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNetworkPromptHandler = const_cast<ICEHtmlNetworkPromptHandler*>(iOther);
			if (_iNetworkPromptHandler)
			{
				_iNetworkPromptHandler->_vtbl->_addRef(_iNetworkPromptHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkPromptHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlNetworkPromptHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNetworkPromptHandler && "has a com object reference. clear first.");
		return & _iNetworkPromptHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlNetworkPromptHandlerRef& other)
	{
		bool result = false;
		if (_iNetworkPromptHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNetworkPromptHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNetworkPromptHandler ? _iNetworkPromptHandler->_vtbl->_queryInterface(_iNetworkPromptHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNetworkPromptHandler) { _iNetworkPromptHandler->_vtbl->_addRef(_iNetworkPromptHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNetworkPromptHandler) { _iNetworkPromptHandler->_vtbl->_release(_iNetworkPromptHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult sslBadCert(struct ICEUString* iUrl, UINT32 errCode, const char* issuedTo, const char* issuedBy, double issuedDate, double expireDate, const char* serialNumber, const char* fingerPrint, bool withCert, bool *const continueOut)	{ return _iNetworkPromptHandler ? _iNetworkPromptHandler->_vtbl->_sslBadCert(_iNetworkPromptHandler, iUrl, errCode, issuedTo, issuedBy, issuedDate, expireDate, serialNumber, fingerPrint, withCert, continueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult credential(struct ICEUString* site, struct ICEUString* realm, struct ICEUString* defaultUserName, struct ICEUString* defaultPassword, bool wasSaved, struct ICEUString* *const username, struct ICEUString* *const password, bool *const continueOut, bool *const updatedSavedFlag)	{ return _iNetworkPromptHandler ? _iNetworkPromptHandler->_vtbl->_credential(_iNetworkPromptHandler, site, realm, defaultUserName, defaultPassword, wasSaved, username, password, continueOut, updatedSavedFlag) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlNetworkPromptHandler* _iNetworkPromptHandler;
};

/*! @}
 * end of CEComICEHtmlNetworkPromptHandlerRef
 */

/*! \defgroup CEComICEHtmlNetworkUserNotifyHandlerRef CEComICEHtmlNetworkUserNotifyHandlerRef
 * @{
 */

class CEComICEHtmlNetworkUserNotifyHandlerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEHtmlNetworkUserNotifyHandlerRef() : _iNetworkUserNotifyHandler(0) {}
	CEComICEHtmlNetworkUserNotifyHandlerRef(ICEHtmlNetworkUserNotifyHandler* iOther) : _iNetworkUserNotifyHandler(0)
	{
		if (iOther)
		{
			_iNetworkUserNotifyHandler = iOther;
			_iNetworkUserNotifyHandler->_vtbl->_addRef(_iNetworkUserNotifyHandler);
		}
	}

	CEComICEHtmlNetworkUserNotifyHandlerRef(const CEComICEHtmlNetworkUserNotifyHandlerRef& other) : _iNetworkUserNotifyHandler(0)
	{
		if (other._iNetworkUserNotifyHandler)
		{
			_iNetworkUserNotifyHandler = other._iNetworkUserNotifyHandler;
			_iNetworkUserNotifyHandler->_vtbl->_addRef(_iNetworkUserNotifyHandler);
		}
	}

	~CEComICEHtmlNetworkUserNotifyHandlerRef()
	{
		if (_iNetworkUserNotifyHandler)
		{
			ICEHtmlNetworkUserNotifyHandler* tmp = _iNetworkUserNotifyHandler;
			_iNetworkUserNotifyHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEHtmlNetworkUserNotifyHandler* iNetworkUserNotifyHandler;
				void* _ptr;
			} uIntf;
			uIntf.iNetworkUserNotifyHandler = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEHtmlNetworkUserNotifyHandler, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iNetworkUserNotifyHandler)
				{
					ICEHtmlNetworkUserNotifyHandler* tmp = _iNetworkUserNotifyHandler;
					_iNetworkUserNotifyHandler = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iNetworkUserNotifyHandler = uIntf.iNetworkUserNotifyHandler;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkUserNotifyHandler* object() const	{ return _iNetworkUserNotifyHandler; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEHtmlNetworkUserNotifyHandler* iOther)
	{
		if (_iNetworkUserNotifyHandler)
		{
			ICEHtmlNetworkUserNotifyHandler* tmp = _iNetworkUserNotifyHandler;
			_iNetworkUserNotifyHandler = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iNetworkUserNotifyHandler = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEHtmlNetworkUserNotifyHandler* detach()
	{
		ICEHtmlNetworkUserNotifyHandler* iIntf = _iNetworkUserNotifyHandler;
		_iNetworkUserNotifyHandler = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEHtmlNetworkUserNotifyHandler* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iNetworkUserNotifyHandler;
		if (_iNetworkUserNotifyHandler)
		{
			_iNetworkUserNotifyHandler->_vtbl->_addRef(_iNetworkUserNotifyHandler);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEHtmlNetworkUserNotifyHandler*() const	{ return _iNetworkUserNotifyHandler; }
	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkUserNotifyHandler& operator*() const	{ return *_iNetworkUserNotifyHandler; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iNetworkUserNotifyHandler == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEHtmlNetworkUserNotifyHandler* iOther) const	{ return (_iNetworkUserNotifyHandler != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEHtmlNetworkUserNotifyHandler* iOther) const	{ return (_iNetworkUserNotifyHandler == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEHtmlNetworkUserNotifyHandlerRef& operator=(const CEComICEHtmlNetworkUserNotifyHandlerRef& other)	{ return operator=(other._iNetworkUserNotifyHandler); }

	CEComICEHtmlNetworkUserNotifyHandlerRef& operator=(const ICEHtmlNetworkUserNotifyHandler* iOther)
	{
		if (_iNetworkUserNotifyHandler != iOther)
		{
			if (_iNetworkUserNotifyHandler)
			{
				ICEHtmlNetworkUserNotifyHandler* tmp = _iNetworkUserNotifyHandler;
				_iNetworkUserNotifyHandler = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iNetworkUserNotifyHandler = const_cast<ICEHtmlNetworkUserNotifyHandler*>(iOther);
			if (_iNetworkUserNotifyHandler)
			{
				_iNetworkUserNotifyHandler->_vtbl->_addRef(_iNetworkUserNotifyHandler);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEHtmlNetworkUserNotifyHandler** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEHtmlNetworkUserNotifyHandlerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iNetworkUserNotifyHandler && "has a com object reference. clear first.");
		return & _iNetworkUserNotifyHandler; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEHtmlNetworkUserNotifyHandlerRef& other)
	{
		bool result = false;
		if (_iNetworkUserNotifyHandler)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iNetworkUserNotifyHandler);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iNetworkUserNotifyHandler ? _iNetworkUserNotifyHandler->_vtbl->_queryInterface(_iNetworkUserNotifyHandler, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iNetworkUserNotifyHandler) { _iNetworkUserNotifyHandler->_vtbl->_addRef(_iNetworkUserNotifyHandler); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iNetworkUserNotifyHandler) { _iNetworkUserNotifyHandler->_vtbl->_release(_iNetworkUserNotifyHandler); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult requestBadCertificate(struct ICEUString* iUrl, UINT32 errCode, const char* issuedTo, const char* issuedBy, double issuedDate, double expireDate, const char* serialNumber, const char* fingerPrint, bool withCert)	{ return _iNetworkUserNotifyHandler ? _iNetworkUserNotifyHandler->_vtbl->_requestBadCertificate(_iNetworkUserNotifyHandler, iUrl, errCode, issuedTo, issuedBy, issuedDate, expireDate, serialNumber, fingerPrint, withCert) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEHtmlNetworkUserNotifyHandler* _iNetworkUserNotifyHandler;
};

/*! @}
 * end of CEComICEHtmlNetworkUserNotifyHandlerRef
 */

#endif // __cplusplus

#endif
