///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysMemory_h__
#define __CESysMemory_h__

#include "CESysDefs.h"
#include "CESysHandle.h"


#ifdef __cplusplus
extern "C"
{
#endif

	/////////////////////////////////////////////////////////////
	//  Basic Memory Operations
	/////////////////////////////////////////////////////////////

	//! copy between byte buffers
	//! \param[in] dst       specifies the destination buffer
	//! \param[in] capacity  the capacity of the destination buffer in bytes
	//! \param[in] src       specifies the src buffer
	//! \param[in] length    specifies the length to be copied in bytes
	//! \note This function behaves same as memcpy_s()
	CE_DLL_EXPORT CEHResult CESysCopyMemory(void* dst, size_t capacity, const void* src, size_t length);

	//! copy between overlapping byte buffers
	//! \param[in] dst       specifies the destination buffer
	//! \param[in] capacity  the capacity of the destination buffer in bytes
	//! \param[in] src       specifies the src buffer
	//! \param[in] length    specifies the length to be copied in bytes
	//! \note This function behaves same as memmove_s()
	CE_DLL_EXPORT CEHResult CESysMoveMemory(void* dst, size_t capacity, const void* src, size_t length);

	//! fill buffer with specified byte
	//! \param[in] dst       specifies the destination buffer
	//! \param[in] src       fill data
	//! \param[in] length    specifies the length to be filled in bytes
	//! \return  the destination buffer (like memset)
	CE_DLL_EXPORT void* CESysFillMemory(void* dst, UINT8 src, size_t length);

	//! compare buffers
	//! \param[in] buf1      specifies the first buffer
	//! \param[in] buf2      specifies the second buffer
	//! \param[in] length    specifies the length to be exchanged in bytes
	//! \return 0   if buf1 == buf2
	//!         <0  if buf1 < buf2
	//!         >0  if buf1 > buf2
	CE_DLL_EXPORT INT_PTR CESysCompareMemory(const void* buf1, const void* buf2, size_t length);


#ifdef __cplusplus
}
#endif

#endif // __CESysMemory_h__
