///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2007,2008 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CESysGetTimeOfDay_h__
#define __CESysGetTimeOfDay_h__

#include "CESysConfig.h"


#ifdef __cplusplus
extern "C"
{
#endif

	//
	//  time-of-day
	//  POSIX timeval and timezone compatible structures
	//

	typedef struct _CESysTimeval
	{
		INT64 tv_sec;   /* seconds from 1970/1/1 UTC */
		INT32 tv_usec;  /* microseconds part */
	} CESysTimeval;

	typedef struct _CESysTimezone
	{
		INT32 tz_minuteswest;	/* timezone offset in minutes */
	} CESysTimezone;

	//!
	//!  time-of-day
	//!
	//! \param[out] tvOut  pointer to the variable to receive the current time in UTC
	//! \param[out] tzOut  pointer to the variable to receive the current time-zone offset
	//! \note
	//! when tvOut or tzOut is null, it is just ignored silently.
	CE_DLL_EXPORT CEHResult CESysGetTimeOfDay(CESysTimeval* tvOut, CESysTimezone* tzOut);


	//!  monotonic-tick
	//!  Retrieves the number of ticks from the system epoch.
	//!  \note Usually 1 tick means 1 microsec.
	//!  \note The system epoch means the time that the system started, except Linux.
	//!        It may be different because CLOCK_MONOTONIC for clock_gettime(2) on Linux doesn't define its epoch.
	CE_DLL_EXPORT INT64 CESysGetMonotonicTick();

	// <----- Backward compatibility use only ------
	//!  gets the number of milliseconds that has elapsed from the system-dependent epoch.
	CE_DLL_EXPORT UINT32 CESysGetMonotonicTickInMilliseconds();
	// ----- Backward compatibility use only ------>



#ifdef __cplusplus
}
#endif

#endif // __CESysGetTimeOfDay_h__
