///////////////////////////////////////////////////////////////////////////////
// Copyright 2006,2007,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEComAtomicSupport_h
#define CEComAtomicSupport_h

#include "CESysAtomicOps.h"

//--------------------------------------------------------------------
// atomic
//--------------------------------------------------------------------

// atomic implementation
// each platform/target have to define
//
// CEATOMIC 
//
// and implement following 4 functions
// 
// ---------------------------------------
// Initialize CEATOMIC
// @param    atm [in,out]CEATOMIC to initialize
// void CEComAtomicInit(CEATOMIC& atm)
//
// ---------------------------------------
// Increment CEATOMIC
// @param    atm [in,out]CEATOMIC to increment
// @return   count in CEATOMIC after increment
// INT32 CEComAtomicIncrement(CEATOMIC& atm)
//
// ---------------------------------------
// Decrement CEATOMIC
// @param    atm [in,out]CEATOMIC to decrement
// @return   count in CEATOMIC after decrement
// INT32 CEComAtomicDecrement(CEATOMIC& atm)
//
// ---------------------------------------
// get current count in CEATOMIC
// @param    atm [in] CEATOMIC to get count
// @return   count in CEATOMIC
// INT32 CEComAtomicCount(CEATOMIC atm)

typedef CESysAtomicINT32 CEATOMIC;

#define CEComAtomicInit(atm)  CESysInterlockedInit(&atm)

FORCEINLINE INT32 CEComAtomicIncrement(CEATOMIC& v)
{
	return CESysInterlockedIncrement(&v);
}
FORCEINLINE INT32 CEComAtomicDecrement(CEATOMIC& v)
{
	return CESysInterlockedDecrement(&v);
}

#define CEComAtomicCount(atm)  (atm)



#endif	// #ifndef CEComAtomicSupport_h
