///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef CEApiUnknown_h
#define CEApiUnknown_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CESysDefs.h"
#include "CESysAssert.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEUnknown ICEUnknown
 * @{
 */

/*!
 * ID of ICEUnknown
 */
#define CEComIID_ICEUnknown 0xe1a75f0c


/*!
 * ICEUnknown
 */
typedef struct ICEUnknown
{
	const struct ICEUnknown_vtbl* _vtbl;
} ICEUnknown;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iUnknown	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEUnknown_queryInterface) (ICEUnknown* iUnknown, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUnknown_addRef) (ICEUnknown* iUnknown);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEUnknown_release) (ICEUnknown* iUnknown);

/*!
 * V-table of ICEUnknown
 */
struct ICEUnknown_vtbl
{
	iCEUnknown_queryInterface	_queryInterface;	//!< Query interface.
	iCEUnknown_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEUnknown_release	_release;	//!< Decrease the reference count of the specified interface pointer.
};

/*! @}
 * end of ICEUnknown
 */

/*! \defgroup ICEClassFactory ICEClassFactory
 * @{
 */

/*!
 * ID of ICEClassFactory
 */
#define CEComIID_ICEClassFactory 0x915d79ce


/*!
 * ICEClassFactory
 */
typedef struct ICEClassFactory
{
	const struct ICEClassFactory_vtbl* _vtbl;
} ICEClassFactory;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iClassFactory	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEClassFactory_queryInterface) (ICEClassFactory* iClassFactory, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEClassFactory_addRef) (ICEClassFactory* iClassFactory);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEClassFactory_release) (ICEClassFactory* iClassFactory);


/*!
* <b>Summary:</b>
* creates com instance and returns interface pointer of specified iid.
* 
* \param[in]	iClassFactory	Specifies interface pointer
* \param[in]	pUnkOuter	TBD.
* \param[in]	iid	 iid to create.
* \param[out]	ppv	created interface pointer.
*
* \return error code.
*/
typedef CEHResult (*iCEClassFactory_createInstance) (ICEClassFactory* iClassFactory, struct ICEUnknown* pUnkOuter, UINT32 iid, void* *const ppv);

/*!
 * V-table of ICEClassFactory
 */
struct ICEClassFactory_vtbl
{
	iCEClassFactory_queryInterface	_queryInterface;	//!< Query interface.
	iCEClassFactory_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEClassFactory_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEClassFactory_createInstance	_createInstance;
};

/*! @}
 * end of ICEClassFactory
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEUnknownRef CEComICEUnknownRef
 * @{
 */

class CEComICEUnknownRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEUnknownRef() : _iUnknown(0) {}
	CEComICEUnknownRef(ICEUnknown* iOther) : _iUnknown(0)
	{
		if (iOther)
		{
			_iUnknown = iOther;
			_iUnknown->_vtbl->_addRef(_iUnknown);
		}
	}

	CEComICEUnknownRef(const CEComICEUnknownRef& other) : _iUnknown(0)
	{
		if (other._iUnknown)
		{
			_iUnknown = other._iUnknown;
			_iUnknown->_vtbl->_addRef(_iUnknown);
		}
	}

	~CEComICEUnknownRef()
	{
		if (_iUnknown)
		{
			ICEUnknown* tmp = _iUnknown;
			_iUnknown = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEUnknown* iUnknown;
				void* _ptr;
			} uIntf;
			uIntf.iUnknown = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEUnknown, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iUnknown)
				{
					ICEUnknown* tmp = _iUnknown;
					_iUnknown = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iUnknown = uIntf.iUnknown;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEUnknown* object() const	{ return _iUnknown; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEUnknown* iOther)
	{
		if (_iUnknown)
		{
			ICEUnknown* tmp = _iUnknown;
			_iUnknown = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iUnknown = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEUnknown* detach()
	{
		ICEUnknown* iIntf = _iUnknown;
		_iUnknown = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEUnknown* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iUnknown;
		if (_iUnknown)
		{
			_iUnknown->_vtbl->_addRef(_iUnknown);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEUnknown*() const	{ return _iUnknown; }
	FORCEINLINE_WITHOUT_DEBUG ICEUnknown& operator*() const	{ return *_iUnknown; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iUnknown == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEUnknown* iOther) const	{ return (_iUnknown != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEUnknown* iOther) const	{ return (_iUnknown == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEUnknownRef& operator=(const CEComICEUnknownRef& other)	{ return operator=(other._iUnknown); }

	CEComICEUnknownRef& operator=(const ICEUnknown* iOther)
	{
		if (_iUnknown != iOther)
		{
			if (_iUnknown)
			{
				ICEUnknown* tmp = _iUnknown;
				_iUnknown = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iUnknown = const_cast<ICEUnknown*>(iOther);
			if (_iUnknown)
			{
				_iUnknown->_vtbl->_addRef(_iUnknown);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEUnknown** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEUnknownRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iUnknown && "has a com object reference. clear first.");
		return & _iUnknown; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEUnknownRef& other)
	{
		bool result = false;
		if (_iUnknown)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iUnknown);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iUnknown ? _iUnknown->_vtbl->_queryInterface(_iUnknown, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iUnknown) { _iUnknown->_vtbl->_addRef(_iUnknown); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iUnknown) { _iUnknown->_vtbl->_release(_iUnknown); } }


private:
	ICEUnknown* _iUnknown;
};

/*! @}
 * end of CEComICEUnknownRef
 */

/*! \defgroup CEComICEClassFactoryRef CEComICEClassFactoryRef
 * @{
 */

class CEComICEClassFactoryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEClassFactoryRef() : _iClassFactory(0) {}
	CEComICEClassFactoryRef(ICEClassFactory* iOther) : _iClassFactory(0)
	{
		if (iOther)
		{
			_iClassFactory = iOther;
			_iClassFactory->_vtbl->_addRef(_iClassFactory);
		}
	}

	CEComICEClassFactoryRef(const CEComICEClassFactoryRef& other) : _iClassFactory(0)
	{
		if (other._iClassFactory)
		{
			_iClassFactory = other._iClassFactory;
			_iClassFactory->_vtbl->_addRef(_iClassFactory);
		}
	}

	~CEComICEClassFactoryRef()
	{
		if (_iClassFactory)
		{
			ICEClassFactory* tmp = _iClassFactory;
			_iClassFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEClassFactory* iClassFactory;
				void* _ptr;
			} uIntf;
			uIntf.iClassFactory = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEClassFactory, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iClassFactory)
				{
					ICEClassFactory* tmp = _iClassFactory;
					_iClassFactory = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iClassFactory = uIntf.iClassFactory;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEClassFactory* object() const	{ return _iClassFactory; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEClassFactory* iOther)
	{
		if (_iClassFactory)
		{
			ICEClassFactory* tmp = _iClassFactory;
			_iClassFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iClassFactory = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEClassFactory* detach()
	{
		ICEClassFactory* iIntf = _iClassFactory;
		_iClassFactory = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEClassFactory* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iClassFactory;
		if (_iClassFactory)
		{
			_iClassFactory->_vtbl->_addRef(_iClassFactory);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEClassFactory*() const	{ return _iClassFactory; }
	FORCEINLINE_WITHOUT_DEBUG ICEClassFactory& operator*() const	{ return *_iClassFactory; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iClassFactory == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEClassFactory* iOther) const	{ return (_iClassFactory != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEClassFactory* iOther) const	{ return (_iClassFactory == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEClassFactoryRef& operator=(const CEComICEClassFactoryRef& other)	{ return operator=(other._iClassFactory); }

	CEComICEClassFactoryRef& operator=(const ICEClassFactory* iOther)
	{
		if (_iClassFactory != iOther)
		{
			if (_iClassFactory)
			{
				ICEClassFactory* tmp = _iClassFactory;
				_iClassFactory = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iClassFactory = const_cast<ICEClassFactory*>(iOther);
			if (_iClassFactory)
			{
				_iClassFactory->_vtbl->_addRef(_iClassFactory);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEClassFactory** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEClassFactoryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iClassFactory && "has a com object reference. clear first.");
		return & _iClassFactory; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEClassFactoryRef& other)
	{
		bool result = false;
		if (_iClassFactory)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iClassFactory);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iClassFactory ? _iClassFactory->_vtbl->_queryInterface(_iClassFactory, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iClassFactory) { _iClassFactory->_vtbl->_addRef(_iClassFactory); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iClassFactory) { _iClassFactory->_vtbl->_release(_iClassFactory); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createInstance(struct ICEUnknown* pUnkOuter, UINT32 iid, void* *const ppv)	{ return _iClassFactory ? _iClassFactory->_vtbl->_createInstance(_iClassFactory, pUnkOuter, iid, ppv) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEClassFactory* _iClassFactory;
};

/*! @}
 * end of CEComICEClassFactoryRef
 */

#endif // __cplusplus

#endif
