///////////////////////////////////////////////////////////////////////////////
// Copyright 2004,2005,2006,2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef __CEULinearLists_H__
#define __CEULinearLists_H__

#include "CEGenDefs.h"
#include "ICEUString.h"
#include "ICETextSupport.h"


class CEULinearListElement
{
public:
	CEALLOCATORS;

	CEULinearListElement() : m_next(0) {};
	virtual ~CEULinearListElement(){};
	virtual CEULinearListElement *clone() = 0;

	CEULinearListElement *m_next;
};


class CEULinearList
{
public:
	CEALLOCATORS;

	CEULinearList() : m_head(0) {};
	virtual ~CEULinearList(){};

	CEHResult add(UINT32 index, CEULinearListElement *elm)//index: 0 to n
	{
		CEHResult hr = CE_SILK_ERR_BADARGS;

		if(index == 0) {
			CEULinearListElement *next = m_head;
			m_head = elm;
			elm->m_next = next;
			hr = CE_S_OK;
		} else {
			CEULinearListElement *prev;
			if( (prev = get(index-1)) ) {
				elm->m_next = prev->m_next;
				prev->m_next = elm;
				hr = CE_S_OK;
			}
		}
		return hr;
	}

	CEHResult addToHead(CEULinearListElement *elm)
	{
		return add(0, elm);
	}

	CEHResult addToTail(CEULinearListElement *elm)
	{
		return add(size(), elm);
	}

	CEHResult remove(CEULinearListElement *elm)
	{
		CEHResult hr = CE_SILK_ERR_BADARGS;

		if(m_head == elm) {
			m_head = elm->m_next;
			hr = CE_S_OK;
		} else {
			CEULinearListElement *prev;
			for(prev = m_head; prev->m_next; prev=prev->m_next) {
				if(prev->m_next == elm) {
					prev->m_next = elm->m_next;
					hr = CE_S_OK;
					break;
				}
			}
		}
		return hr;
	}

	CEULinearListElement *get(UINT32 index)
	{
		CEULinearListElement *elm;
		
		for(elm = m_head; elm && index>0; elm=elm->m_next, index--);
		return elm;
	}

	UINT32 size()
	{
		UINT32 count = 0;
		CEULinearListElement *elm;
		for(elm = m_head; elm; elm=elm->m_next) {
			count++;
		}
		return count;
	}

	CEHResult duplicate(CEULinearList *srcList)
	{
		CEHResult hr = CE_SILK_ERR_MEMERR;

		UINT32 index;
		UINT32 srcListSize = srcList->size();
		for(index=0; index<srcListSize; index++) {
			CEULinearListElement *newElm;
			CEULinearListElement *srcElm = srcList->get(index);
			if( (newElm = srcElm->clone()) ) {
				this->addToTail(newElm);
			} else {
				break;
			}
		}

		if(index == srcListSize)
		{
			hr = CE_S_OK;
		} else {
			CEULinearListElement *elm;
			while( (elm=this->get(0)) ) {
				this->remove(elm);
				delete elm;
			}
		}
		return hr;
	}

	void disposeAllElements()
	{
		CEULinearListElement *elm;
		while((elm = this->get(0))) {
			this->remove(elm);
			delete elm;
		}
	}
private:
	CEULinearListElement *m_head;
};


////////////////////////////////////////////////////////////////
// CEUString List
////////////////////////////////////////////////////////////////
class CEUStringListElement : public CEULinearListElement
{
public:
	CEUStringListElement(ICEUString *str) { m_str = str; }
	~CEUStringListElement() {}

	ICEUString *getData() { return m_str; }
protected:
	CEULinearListElement *clone() {
		CEUStringListElement *newElm = new CEUStringListElement(getData());
		return newElm;
	}
private:
	CEComICEUStringRef m_str;
};

class CEUStringList : public CEULinearList
{
public:
	CEUStringList(){};
	~CEUStringList(){};

	CEUStringListElement *get(UINT32 index)
	{
		return reinterpret_cast<CEUStringListElement*>(CEULinearList::get(index));
	}

	CEHResult initWithSTRARRAY(STRARRAY_BUF *buf, STRARRAY_LEN len)
	{
		UINT32 index;
		CEHResult hr = CE_S_OK;

		disposeAllElements();
		for(index=0; index<len; index++)
		{
			CEComICEUStringRef iStr;
			hr = ICEUStringCreate(CEComStdClassID_CEUString, iStr);
			if (CESucceeded(hr))
			{
				hr = iStr.initWithByteArray(buf[index].buf, eICEI18nEncoding_utf_8, buf[index].len);
				if(CESucceeded(hr))
				{
					CEUStringListElement *elm = new CEUStringListElement(iStr);
					if(elm) {
						addToTail(elm);
					} else {
						hr = CE_SILK_ERR_MEMERR;
						break;
					}
				}
			}
		}
		return hr;
	}

	STRARRAY_BUF *createArray()
	{
		CEHResult hr;

		UINT32 count = size();
		UINT32 index;
		UINT32 buf_size = 0;
		UINT8 *buf;

		STR_BUF*        strBuf = 0;
		STR_LEN         strLen = 0;

		for(index=0; index<count; index++) {
			CEUStringListElement *elm = get(index);
			ICEUString *str = elm->getData();
			if(str) {
				CEComICEUStringRef iStrRef(const_cast<ICEUString*>(str));

				strBuf = 0;
				strLen = 0;
				hr = iStrRef.getBytesWithAlloc(eICEI18nEncoding_utf_8, CEComGetAllocatorRec(), &strBuf, &strLen);//todo: replace function.
				if(hr == CE_S_OK) {
					buf_size += strLen;
					if (strBuf) {
						CEFREE(strBuf);
					}
				} else {
					break;
				}
			}
		}

		if(hr != CE_S_OK)
		{
			return 0;
		}

		buf = static_cast<UINT8*>(CEMALLOC(buf_size + sizeof(STRARRAY_BUF)*count));

		STRARRAY_BUF *strArray = reinterpret_cast<STRARRAY_BUF *>(buf);

		//copy strings to buf.
		UINT8 *ptr = reinterpret_cast<UINT8*>(&(strArray[count]));//Copy string data after STRARRAY_BUF structure.
		for(index=0; index<count; index++) {

			strBuf = 0;
			strLen = 0;

			CEUStringListElement *elm = get(index);
			ICEUString *str = elm->getData();
			if(str) {
				CEComICEUStringRef iStrRef(const_cast<ICEUString*>(str));

				hr = iStrRef.getBytesWithAlloc(eICEI18nEncoding_utf_8, CEComGetAllocatorRec(), &strBuf, &strLen);
				if (hr == CE_S_OK) {
					if(strBuf) {
						memcpy(ptr, strBuf, strLen);
						CEFREE(strBuf);
					}
					strArray[index].buf = ptr;
					strArray[index].len = strLen;
				} else {
					CEFREE(strArray);
					strArray = 0;
					break;
				}
			} else {
				strArray[index].buf = ptr;
				strArray[index].len = strLen;
			}
			ptr += strLen;
		}
		return strArray;
	}
};

////////////////////////////////////////////////////////////////
// CEUUINT32 List
////////////////////////////////////////////////////////////////
class CEUUINT32ListElement : public CEULinearListElement
{
public:
	CEUUINT32ListElement(UINT32 val) { m_val = val; }
	~CEUUINT32ListElement() {}

	UINT32 getData() { return m_val; }
protected:
	CEULinearListElement *clone() {
		CEUUINT32ListElement *newElm = new CEUUINT32ListElement(getData());
		return newElm;
	}
private:
	UINT32 m_val;
};

class CEUUINT32List : public CEULinearList
{
public:
	CEUUINT32List(){};
	~CEUUINT32List(){};

	CEUUINT32ListElement *get(UINT32 index)
	{
		return reinterpret_cast<CEUUINT32ListElement*>(CEULinearList::get(index));
	}

	CEHResult initWithUINT32ARRAY(UINT32ARRAY_BUF *buf, UINT32ARRAY_LEN len)
	{
		UINT32 index;
		CEHResult hr = CE_S_OK;

		disposeAllElements();
		for(index=0; index<len; index++)
		{
			CEUUINT32ListElement *elm = new CEUUINT32ListElement(buf[index].val);
			if(elm) {
				addToTail(elm);
			} else {
				hr = CE_SILK_ERR_MEMERR;
				break;
			}
		}
		return hr;
	}

	UINT32ARRAY_BUF *createArray()
	{
		UINT32 count = size();
		UINT32 index;
		UINT8 *buf;

		buf = static_cast<UINT8*>( CEMALLOC(sizeof(UINT32ARRAY_BUF)*count) );

		UINT32ARRAY_BUF *uint32Array = reinterpret_cast<UINT32ARRAY_BUF *>(buf);

		//copy strings to buf.
		for(index=0; index<count; index++) {
			CEUUINT32ListElement *elm = get(index);

			uint32Array[index].val = elm->getData();
		}
		return uint32Array;
	}
};
#endif // __CEULinearLists__
