///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEPluginGraphicsContext_h
#define ICEPluginGraphicsContext_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//! context2D's state (color)
typedef enum
{
	eCEPluginGCtxColorState_FillColor			= 1,
} eCEPluginGCtxColorState;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEPluginGraphicsContext ICEPluginGraphicsContext
 * @{
 */

/*!
 * ID of ICEPluginGraphicsContext
 */
#define CEComIID_ICEPluginGraphicsContext 0x3b393970

/*!
 * ICEPluginGraphicsContext
 */
typedef struct ICEPluginGraphicsContext
{
	const struct ICEPluginGraphicsContext_vtbl* _vtbl;
} ICEPluginGraphicsContext;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iPluginGraphicsContext	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEPluginGraphicsContext_queryInterface) (ICEPluginGraphicsContext* iPluginGraphicsContext, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginGraphicsContext_addRef) (ICEPluginGraphicsContext* iPluginGraphicsContext);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEPluginGraphicsContext_release) (ICEPluginGraphicsContext* iPluginGraphicsContext);

	//! set a color state

typedef CEHResult (*iCEPluginGraphicsContext_setStateC) (ICEPluginGraphicsContext* iPluginGraphicsContext, eCEPluginGCtxColorState state, const CERGBAColor* pColor);

	//! get a color state

typedef CEHResult (*iCEPluginGraphicsContext_getStateC) (ICEPluginGraphicsContext* iPluginGraphicsContext, eCEPluginGCtxColorState state, CERGBAColor *const pColorOut);

	//! paint the area contained within a rectangle.

typedef CEHResult (*iCEPluginGraphicsContext_fillRectI) (ICEPluginGraphicsContext* iPluginGraphicsContext, const CERect*  pRect);

/*!
 * V-table of ICEPluginGraphicsContext
 */
struct ICEPluginGraphicsContext_vtbl
{
	iCEPluginGraphicsContext_queryInterface	_queryInterface;	//!< Query interface.
	iCEPluginGraphicsContext_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEPluginGraphicsContext_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEPluginGraphicsContext_setStateC	_setStateC;
	iCEPluginGraphicsContext_getStateC	_getStateC;
	iCEPluginGraphicsContext_fillRectI	_fillRectI;
};

/*! @}
 * end of ICEPluginGraphicsContext
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEPluginGraphicsContextRef CEComICEPluginGraphicsContextRef
 * @{
 */

class CEComICEPluginGraphicsContextRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEPluginGraphicsContextRef() : _iPluginGraphicsContext(0) {}
	CEComICEPluginGraphicsContextRef(ICEPluginGraphicsContext* iOther) : _iPluginGraphicsContext(0)
	{
		if (iOther)
		{
			_iPluginGraphicsContext = iOther;
			_iPluginGraphicsContext->_vtbl->_addRef(_iPluginGraphicsContext);
		}
	}

	CEComICEPluginGraphicsContextRef(const CEComICEPluginGraphicsContextRef& other) : _iPluginGraphicsContext(0)
	{
		if (other._iPluginGraphicsContext)
		{
			_iPluginGraphicsContext = other._iPluginGraphicsContext;
			_iPluginGraphicsContext->_vtbl->_addRef(_iPluginGraphicsContext);
		}
	}

	~CEComICEPluginGraphicsContextRef()
	{
		if (_iPluginGraphicsContext)
		{
			ICEPluginGraphicsContext* tmp = _iPluginGraphicsContext;
			_iPluginGraphicsContext = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEPluginGraphicsContext* iPluginGraphicsContext;
				void* _ptr;
			} uIntf;
			uIntf.iPluginGraphicsContext = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEPluginGraphicsContext, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iPluginGraphicsContext)
				{
					ICEPluginGraphicsContext* tmp = _iPluginGraphicsContext;
					_iPluginGraphicsContext = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iPluginGraphicsContext = uIntf.iPluginGraphicsContext;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEPluginGraphicsContext* object() const	{ return _iPluginGraphicsContext; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEPluginGraphicsContext* iOther)
	{
		if (_iPluginGraphicsContext)
		{
			ICEPluginGraphicsContext* tmp = _iPluginGraphicsContext;
			_iPluginGraphicsContext = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iPluginGraphicsContext = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEPluginGraphicsContext* detach()
	{
		ICEPluginGraphicsContext* iIntf = _iPluginGraphicsContext;
		_iPluginGraphicsContext = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEPluginGraphicsContext* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iPluginGraphicsContext;
		if (_iPluginGraphicsContext)
		{
			_iPluginGraphicsContext->_vtbl->_addRef(_iPluginGraphicsContext);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEPluginGraphicsContext*() const	{ return _iPluginGraphicsContext; }
	FORCEINLINE_WITHOUT_DEBUG ICEPluginGraphicsContext& operator*() const	{ return *_iPluginGraphicsContext; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iPluginGraphicsContext == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEPluginGraphicsContext* iOther) const	{ return (_iPluginGraphicsContext != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEPluginGraphicsContext* iOther) const	{ return (_iPluginGraphicsContext == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEPluginGraphicsContextRef& operator=(const CEComICEPluginGraphicsContextRef& other)	{ return operator=(other._iPluginGraphicsContext); }

	CEComICEPluginGraphicsContextRef& operator=(const ICEPluginGraphicsContext* iOther)
	{
		if (_iPluginGraphicsContext != iOther)
		{
			if (_iPluginGraphicsContext)
			{
				ICEPluginGraphicsContext* tmp = _iPluginGraphicsContext;
				_iPluginGraphicsContext = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iPluginGraphicsContext = const_cast<ICEPluginGraphicsContext*>(iOther);
			if (_iPluginGraphicsContext)
			{
				_iPluginGraphicsContext->_vtbl->_addRef(_iPluginGraphicsContext);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEPluginGraphicsContext** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEPluginGraphicsContextRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iPluginGraphicsContext && "has a com object reference. clear first.");
		return & _iPluginGraphicsContext; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEPluginGraphicsContextRef& other)
	{
		bool result = false;
		if (_iPluginGraphicsContext)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iPluginGraphicsContext);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iPluginGraphicsContext ? _iPluginGraphicsContext->_vtbl->_queryInterface(_iPluginGraphicsContext, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iPluginGraphicsContext) { _iPluginGraphicsContext->_vtbl->_addRef(_iPluginGraphicsContext); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iPluginGraphicsContext) { _iPluginGraphicsContext->_vtbl->_release(_iPluginGraphicsContext); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult setStateC(eCEPluginGCtxColorState state, const CERGBAColor* pColor)	{ return _iPluginGraphicsContext ? _iPluginGraphicsContext->_vtbl->_setStateC(_iPluginGraphicsContext, state, pColor) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult getStateC(eCEPluginGCtxColorState state, CERGBAColor *const pColorOut)	{ return _iPluginGraphicsContext ? _iPluginGraphicsContext->_vtbl->_getStateC(_iPluginGraphicsContext, state, pColorOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult fillRectI(const CERect*  pRect)	{ return _iPluginGraphicsContext ? _iPluginGraphicsContext->_vtbl->_fillRectI(_iPluginGraphicsContext, pRect) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEPluginGraphicsContext* _iPluginGraphicsContext;
};

/*! @}
 * end of CEComICEPluginGraphicsContextRef
 */

#endif // __cplusplus

#endif
