///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSRuntimeEventListener_h
#define ICEJSRuntimeEventListener_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEJSContext.h"
#include "ICEJSException.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSRuntimeEventListener ICEJSRuntimeEventListener
 * @{
 */

/*!
 * ID of ICEJSRuntimeEventListener
 */
#define CEComIID_ICEJSRuntimeEventListener 0x5451ca4a


/*!
 * ICEJSRuntimeEventListener
 */
typedef struct ICEJSRuntimeEventListener
{
	const struct ICEJSRuntimeEventListener_vtbl* _vtbl;
} ICEJSRuntimeEventListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSRuntimeEventListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSRuntimeEventListener_queryInterface) (ICEJSRuntimeEventListener* iJSRuntimeEventListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSRuntimeEventListener_addRef) (ICEJSRuntimeEventListener* iJSRuntimeEventListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSRuntimeEventListener_release) (ICEJSRuntimeEventListener* iJSRuntimeEventListener);

typedef CEHResult (*iCEJSRuntimeEventListener_handleScriptReady) (ICEJSRuntimeEventListener* iJSRuntimeEventListener, struct ICEJSContext* iJSContext);

typedef CEHResult (*iCEJSRuntimeEventListener_handleLoadComplete) (ICEJSRuntimeEventListener* iJSRuntimeEventListener, struct ICEJSContext* iJSContext);

typedef CEHResult (*iCEJSRuntimeEventListener_handleJSException) (ICEJSRuntimeEventListener* iJSRuntimeEventListener, struct ICEJSException* iJSException);

/*!
 * V-table of ICEJSRuntimeEventListener
 */
struct ICEJSRuntimeEventListener_vtbl
{
	iCEJSRuntimeEventListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSRuntimeEventListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSRuntimeEventListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSRuntimeEventListener_handleScriptReady	_handleScriptReady;
	iCEJSRuntimeEventListener_handleLoadComplete	_handleLoadComplete;
	iCEJSRuntimeEventListener_handleJSException	_handleJSException;
};

/*! @}
 * end of ICEJSRuntimeEventListener
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSRuntimeEventListenerRef CEComICEJSRuntimeEventListenerRef
 * @{
 */

class CEComICEJSRuntimeEventListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSRuntimeEventListenerRef() : _iJSRuntimeEventListener(0) {}
	CEComICEJSRuntimeEventListenerRef(ICEJSRuntimeEventListener* iOther) : _iJSRuntimeEventListener(0)
	{
		if (iOther)
		{
			_iJSRuntimeEventListener = iOther;
			_iJSRuntimeEventListener->_vtbl->_addRef(_iJSRuntimeEventListener);
		}
	}

	CEComICEJSRuntimeEventListenerRef(const CEComICEJSRuntimeEventListenerRef& other) : _iJSRuntimeEventListener(0)
	{
		if (other._iJSRuntimeEventListener)
		{
			_iJSRuntimeEventListener = other._iJSRuntimeEventListener;
			_iJSRuntimeEventListener->_vtbl->_addRef(_iJSRuntimeEventListener);
		}
	}

	~CEComICEJSRuntimeEventListenerRef()
	{
		if (_iJSRuntimeEventListener)
		{
			ICEJSRuntimeEventListener* tmp = _iJSRuntimeEventListener;
			_iJSRuntimeEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSRuntimeEventListener* iJSRuntimeEventListener;
				void* _ptr;
			} uIntf;
			uIntf.iJSRuntimeEventListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSRuntimeEventListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSRuntimeEventListener)
				{
					ICEJSRuntimeEventListener* tmp = _iJSRuntimeEventListener;
					_iJSRuntimeEventListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSRuntimeEventListener = uIntf.iJSRuntimeEventListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSRuntimeEventListener* object() const	{ return _iJSRuntimeEventListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSRuntimeEventListener* iOther)
	{
		if (_iJSRuntimeEventListener)
		{
			ICEJSRuntimeEventListener* tmp = _iJSRuntimeEventListener;
			_iJSRuntimeEventListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSRuntimeEventListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSRuntimeEventListener* detach()
	{
		ICEJSRuntimeEventListener* iIntf = _iJSRuntimeEventListener;
		_iJSRuntimeEventListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSRuntimeEventListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSRuntimeEventListener;
		if (_iJSRuntimeEventListener)
		{
			_iJSRuntimeEventListener->_vtbl->_addRef(_iJSRuntimeEventListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSRuntimeEventListener*() const	{ return _iJSRuntimeEventListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSRuntimeEventListener& operator*() const	{ return *_iJSRuntimeEventListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSRuntimeEventListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSRuntimeEventListener* iOther) const	{ return (_iJSRuntimeEventListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSRuntimeEventListener* iOther) const	{ return (_iJSRuntimeEventListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSRuntimeEventListenerRef& operator=(const CEComICEJSRuntimeEventListenerRef& other)	{ return operator=(other._iJSRuntimeEventListener); }

	CEComICEJSRuntimeEventListenerRef& operator=(const ICEJSRuntimeEventListener* iOther)
	{
		if (_iJSRuntimeEventListener != iOther)
		{
			if (_iJSRuntimeEventListener)
			{
				ICEJSRuntimeEventListener* tmp = _iJSRuntimeEventListener;
				_iJSRuntimeEventListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSRuntimeEventListener = const_cast<ICEJSRuntimeEventListener*>(iOther);
			if (_iJSRuntimeEventListener)
			{
				_iJSRuntimeEventListener->_vtbl->_addRef(_iJSRuntimeEventListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSRuntimeEventListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSRuntimeEventListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSRuntimeEventListener && "has a com object reference. clear first.");
		return & _iJSRuntimeEventListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSRuntimeEventListenerRef& other)
	{
		bool result = false;
		if (_iJSRuntimeEventListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSRuntimeEventListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSRuntimeEventListener ? _iJSRuntimeEventListener->_vtbl->_queryInterface(_iJSRuntimeEventListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSRuntimeEventListener) { _iJSRuntimeEventListener->_vtbl->_addRef(_iJSRuntimeEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSRuntimeEventListener) { _iJSRuntimeEventListener->_vtbl->_release(_iJSRuntimeEventListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleScriptReady(struct ICEJSContext* iJSContext)	{ return _iJSRuntimeEventListener ? _iJSRuntimeEventListener->_vtbl->_handleScriptReady(_iJSRuntimeEventListener, iJSContext) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleLoadComplete(struct ICEJSContext* iJSContext)	{ return _iJSRuntimeEventListener ? _iJSRuntimeEventListener->_vtbl->_handleLoadComplete(_iJSRuntimeEventListener, iJSContext) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleJSException(struct ICEJSException* iJSException)	{ return _iJSRuntimeEventListener ? _iJSRuntimeEventListener->_vtbl->_handleJSException(_iJSRuntimeEventListener, iJSException) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSRuntimeEventListener* _iJSRuntimeEventListener;
};

/*! @}
 * end of CEComICEJSRuntimeEventListenerRef
 */

#endif // __cplusplus

#endif
