///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSPrivilegeExtObjectListener_h
#define ICEJSPrivilegeExtObjectListener_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEJSExtVariant.h"
#include "ICEJSExtVariantFactory.h"
#include "ICEJSPrivilegeExtObjectDeclarer.h"
#include "ICEJSExtPropertyDeclarer.h"
#include "ICEHtmlCredential.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

typedef enum
{
	CEJSAuthStatus_Authorized,
	CEJSAuthStatus_Unauthorized,
	CEJSAuthStatus_UnauthorizedTemporarily,
} CEJSAuthStatus;

typedef enum
{
	CEJSIsDirtyStatus_NotDirty,
	CEJSIsDirtyStatus_Dirty
} CEJSIsDirtyStatus;

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSPrivilegeExtObjectListener ICEJSPrivilegeExtObjectListener
 * @{
 */

/*!
 * ID of ICEJSPrivilegeExtObjectListener
 */
#define CEComIID_ICEJSPrivilegeExtObjectListener 0x20956f1a


/*!
 * ICEJSPrivilegeExtObjectListener
 */
typedef struct ICEJSPrivilegeExtObjectListener
{
	const struct ICEJSPrivilegeExtObjectListener_vtbl* _vtbl;
} ICEJSPrivilegeExtObjectListener;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSPrivilegeExtObjectListener	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSPrivilegeExtObjectListener_queryInterface) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeExtObjectListener_addRef) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSPrivilegeExtObjectListener_release) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleDeclarePrivilegeExtObject) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, struct ICEJSPrivilegeExtObjectDeclarer* iDeclarer);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleAuthorize) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT32 classId, struct ICEHtmlCredential* iCredential, CEJSAuthStatus* statusOut, INT_PTR* objectIdOut);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleFinalizeObjectId) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT_PTR objectId);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleDeclareProperty) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT_PTR objectId, struct ICEJSExtPropertyDeclarer* iDeclarer);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleGetProperty) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleSetProperty) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariant* iValue, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleIsDirtyProperty) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT_PTR objectId, INT32 propertyId, CEJSIsDirtyStatus* statusOut);

typedef CEHResult (*iCEJSPrivilegeExtObjectListener_handleInvokeMethod) (ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener, INT_PTR objectId, INT32 methodId, struct ICEJSExtVariant** iArgValues, UINT32 argCount, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut);

/*!
 * V-table of ICEJSPrivilegeExtObjectListener
 */
struct ICEJSPrivilegeExtObjectListener_vtbl
{
	iCEJSPrivilegeExtObjectListener_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSPrivilegeExtObjectListener_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSPrivilegeExtObjectListener_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSPrivilegeExtObjectListener_handleDeclarePrivilegeExtObject	_handleDeclarePrivilegeExtObject;
	iCEJSPrivilegeExtObjectListener_handleAuthorize	_handleAuthorize;
	iCEJSPrivilegeExtObjectListener_handleFinalizeObjectId	_handleFinalizeObjectId;
	iCEJSPrivilegeExtObjectListener_handleDeclareProperty	_handleDeclareProperty;
	iCEJSPrivilegeExtObjectListener_handleGetProperty	_handleGetProperty;
	iCEJSPrivilegeExtObjectListener_handleSetProperty	_handleSetProperty;
	iCEJSPrivilegeExtObjectListener_handleIsDirtyProperty	_handleIsDirtyProperty;
	iCEJSPrivilegeExtObjectListener_handleInvokeMethod	_handleInvokeMethod;
};

/*! @}
 * end of ICEJSPrivilegeExtObjectListener
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSPrivilegeExtObjectListenerRef CEComICEJSPrivilegeExtObjectListenerRef
 * @{
 */

class CEComICEJSPrivilegeExtObjectListenerRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSPrivilegeExtObjectListenerRef() : _iJSPrivilegeExtObjectListener(0) {}
	CEComICEJSPrivilegeExtObjectListenerRef(ICEJSPrivilegeExtObjectListener* iOther) : _iJSPrivilegeExtObjectListener(0)
	{
		if (iOther)
		{
			_iJSPrivilegeExtObjectListener = iOther;
			_iJSPrivilegeExtObjectListener->_vtbl->_addRef(_iJSPrivilegeExtObjectListener);
		}
	}

	CEComICEJSPrivilegeExtObjectListenerRef(const CEComICEJSPrivilegeExtObjectListenerRef& other) : _iJSPrivilegeExtObjectListener(0)
	{
		if (other._iJSPrivilegeExtObjectListener)
		{
			_iJSPrivilegeExtObjectListener = other._iJSPrivilegeExtObjectListener;
			_iJSPrivilegeExtObjectListener->_vtbl->_addRef(_iJSPrivilegeExtObjectListener);
		}
	}

	~CEComICEJSPrivilegeExtObjectListenerRef()
	{
		if (_iJSPrivilegeExtObjectListener)
		{
			ICEJSPrivilegeExtObjectListener* tmp = _iJSPrivilegeExtObjectListener;
			_iJSPrivilegeExtObjectListener = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSPrivilegeExtObjectListener* iJSPrivilegeExtObjectListener;
				void* _ptr;
			} uIntf;
			uIntf.iJSPrivilegeExtObjectListener = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSPrivilegeExtObjectListener, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSPrivilegeExtObjectListener)
				{
					ICEJSPrivilegeExtObjectListener* tmp = _iJSPrivilegeExtObjectListener;
					_iJSPrivilegeExtObjectListener = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSPrivilegeExtObjectListener = uIntf.iJSPrivilegeExtObjectListener;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeExtObjectListener* object() const	{ return _iJSPrivilegeExtObjectListener; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSPrivilegeExtObjectListener* iOther)
	{
		if (_iJSPrivilegeExtObjectListener)
		{
			ICEJSPrivilegeExtObjectListener* tmp = _iJSPrivilegeExtObjectListener;
			_iJSPrivilegeExtObjectListener = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSPrivilegeExtObjectListener = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSPrivilegeExtObjectListener* detach()
	{
		ICEJSPrivilegeExtObjectListener* iIntf = _iJSPrivilegeExtObjectListener;
		_iJSPrivilegeExtObjectListener = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSPrivilegeExtObjectListener* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSPrivilegeExtObjectListener;
		if (_iJSPrivilegeExtObjectListener)
		{
			_iJSPrivilegeExtObjectListener->_vtbl->_addRef(_iJSPrivilegeExtObjectListener);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSPrivilegeExtObjectListener*() const	{ return _iJSPrivilegeExtObjectListener; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeExtObjectListener& operator*() const	{ return *_iJSPrivilegeExtObjectListener; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSPrivilegeExtObjectListener == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSPrivilegeExtObjectListener* iOther) const	{ return (_iJSPrivilegeExtObjectListener != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSPrivilegeExtObjectListener* iOther) const	{ return (_iJSPrivilegeExtObjectListener == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSPrivilegeExtObjectListenerRef& operator=(const CEComICEJSPrivilegeExtObjectListenerRef& other)	{ return operator=(other._iJSPrivilegeExtObjectListener); }

	CEComICEJSPrivilegeExtObjectListenerRef& operator=(const ICEJSPrivilegeExtObjectListener* iOther)
	{
		if (_iJSPrivilegeExtObjectListener != iOther)
		{
			if (_iJSPrivilegeExtObjectListener)
			{
				ICEJSPrivilegeExtObjectListener* tmp = _iJSPrivilegeExtObjectListener;
				_iJSPrivilegeExtObjectListener = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSPrivilegeExtObjectListener = const_cast<ICEJSPrivilegeExtObjectListener*>(iOther);
			if (_iJSPrivilegeExtObjectListener)
			{
				_iJSPrivilegeExtObjectListener->_vtbl->_addRef(_iJSPrivilegeExtObjectListener);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSPrivilegeExtObjectListener** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSPrivilegeExtObjectListenerRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSPrivilegeExtObjectListener && "has a com object reference. clear first.");
		return & _iJSPrivilegeExtObjectListener; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSPrivilegeExtObjectListenerRef& other)
	{
		bool result = false;
		if (_iJSPrivilegeExtObjectListener)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSPrivilegeExtObjectListener);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_queryInterface(_iJSPrivilegeExtObjectListener, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSPrivilegeExtObjectListener) { _iJSPrivilegeExtObjectListener->_vtbl->_addRef(_iJSPrivilegeExtObjectListener); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSPrivilegeExtObjectListener) { _iJSPrivilegeExtObjectListener->_vtbl->_release(_iJSPrivilegeExtObjectListener); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleDeclarePrivilegeExtObject(struct ICEJSPrivilegeExtObjectDeclarer* iDeclarer)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleDeclarePrivilegeExtObject(_iJSPrivilegeExtObjectListener, iDeclarer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleAuthorize(INT32 classId, struct ICEHtmlCredential* iCredential, CEJSAuthStatus* statusOut, INT_PTR* objectIdOut)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleAuthorize(_iJSPrivilegeExtObjectListener, classId, iCredential, statusOut, objectIdOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleFinalizeObjectId(INT_PTR objectId)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleFinalizeObjectId(_iJSPrivilegeExtObjectListener, objectId) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleDeclareProperty(INT_PTR objectId, struct ICEJSExtPropertyDeclarer* iDeclarer)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleDeclareProperty(_iJSPrivilegeExtObjectListener, objectId, iDeclarer) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleGetProperty(INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleGetProperty(_iJSPrivilegeExtObjectListener, objectId, propertyId, iFactory, iValueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleSetProperty(INT_PTR objectId, INT32 propertyId, struct ICEJSExtVariant* iValue, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleSetProperty(_iJSPrivilegeExtObjectListener, objectId, propertyId, iValue, iFactory, iValueOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleIsDirtyProperty(INT_PTR objectId, INT32 propertyId, CEJSIsDirtyStatus* statusOut)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleIsDirtyProperty(_iJSPrivilegeExtObjectListener, objectId, propertyId, statusOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult handleInvokeMethod(INT_PTR objectId, INT32 methodId, struct ICEJSExtVariant** iArgValues, UINT32 argCount, struct ICEJSExtVariantFactory* iFactory, struct ICEJSExtVariant** iValueOut)	{ return _iJSPrivilegeExtObjectListener ? _iJSPrivilegeExtObjectListener->_vtbl->_handleInvokeMethod(_iJSPrivilegeExtObjectListener, objectId, methodId, iArgValues, argCount, iFactory, iValueOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSPrivilegeExtObjectListener* _iJSPrivilegeExtObjectListener;
};

/*! @}
 * end of CEComICEJSPrivilegeExtObjectListenerRef
 */

#endif // __cplusplus

#endif
