///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef ICEJSExtVariantFactory_h
#define ICEJSExtVariantFactory_h

//----------------------------------------------------------------
// Includes
//----------------------------------------------------------------

#include "CEApiUnknown.h"
#include "ICEJSExtVariant.h"

#ifdef __cplusplus
extern "C" {
#endif

//----------------------------------------------------------------
// Prototypes
//----------------------------------------------------------------


//----------------------------------------------------------------
// Enumerators
//----------------------------------------------------------------

//----------------------------------------------------------------
// Structures
//----------------------------------------------------------------

//----------------------------------------------------------------
// Interfaces
//----------------------------------------------------------------

/*! \defgroup ICEJSExtVariantFactory ICEJSExtVariantFactory
 * @{
 */

/*!
 * ID of ICEJSExtVariantFactory
 */
#define CEComIID_ICEJSExtVariantFactory 0x5b663ed7


/*!
 * ICEJSExtVariantFactory
 */
typedef struct ICEJSExtVariantFactory
{
	const struct ICEJSExtVariantFactory_vtbl* _vtbl;
} ICEJSExtVariantFactory;


/*! 
 * <b>Summary:</b>
 * Query interface.<br>
 * 
 * \param[in]	iJSExtVariantFactory	Specifies interface pointer
 * \param[in]	iId	Specifies interface ID
 * \param[out]	iOut	Recieves interface of result
 *
 * \return Error status
 * 
 * <b>Description:</b>
 * - This function gets an address of the interface if it gets the interface.
 * - The list of available interface ID is in the list of CEApiIID. (All interfaces have their own unique IID). 
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */
typedef CEHResult (*iCEJSExtVariantFactory_queryInterface) (ICEJSExtVariantFactory* iJSExtVariantFactory, const UINT32 iId, void* *const iOut);


/*!
 * <b>Summary:</b>
 * Increase the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function increases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes to be referred.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSExtVariantFactory_addRef) (ICEJSExtVariantFactory* iJSExtVariantFactory);


/*!
 * <b>Summary:</b>
 * Decrease the reference count of the specified interface pointer.<br>
 * 
 * <b>Description:</b>
 * - This function decreases the reference count of the specified interface pointer.
 * - It should be called when the instance of the specified interface pointer becomes not to be referred.
 * - The instance of the interface pointer is removed when the reference count becomes zero.
 *
 * <b>Precondition:</b>
 * None
 *
 * <b>Limitation:</b>
 * None
 *
 * <b>Example:</b>
 * None
 *
 * <b>See also:</b>
 * None
 * 
 *
 */

typedef void (*iCEJSExtVariantFactory_release) (ICEJSExtVariantFactory* iJSExtVariantFactory);

typedef CEHResult (*iCEJSExtVariantFactory_createFromUndefined) (ICEJSExtVariantFactory* iJSExtVariantFactory, struct ICEJSExtVariant** iVariantOut);

typedef CEHResult (*iCEJSExtVariantFactory_createFromNull) (ICEJSExtVariantFactory* iJSExtVariantFactory, struct ICEJSExtVariant** iVariantOut);

typedef CEHResult (*iCEJSExtVariantFactory_createFromBoolean) (ICEJSExtVariantFactory* iJSExtVariantFactory, UINT8 booleanValue, struct ICEJSExtVariant** iVariantOut);

typedef CEHResult (*iCEJSExtVariantFactory_createFromInt32) (ICEJSExtVariantFactory* iJSExtVariantFactory, INT32 int32Value, struct ICEJSExtVariant** iVariantOut);

typedef CEHResult (*iCEJSExtVariantFactory_createFromNumber) (ICEJSExtVariantFactory* iJSExtVariantFactory, double doubleValue, struct ICEJSExtVariant** iVariantOut);

typedef CEHResult (*iCEJSExtVariantFactory_createFromString) (ICEJSExtVariantFactory* iJSExtVariantFactory, const UTF16CHAR* pCharArray16, UINT32 numOfChars16, struct ICEJSExtVariant** iVariantOut);

/*!
 * V-table of ICEJSExtVariantFactory
 */
struct ICEJSExtVariantFactory_vtbl
{
	iCEJSExtVariantFactory_queryInterface	_queryInterface;	//!< Query interface.
	iCEJSExtVariantFactory_addRef	_addRef;	//!< Increase the reference count of the specified interface pointer.
	iCEJSExtVariantFactory_release	_release;	//!< Decrease the reference count of the specified interface pointer.
	iCEJSExtVariantFactory_createFromUndefined	_createFromUndefined;
	iCEJSExtVariantFactory_createFromNull	_createFromNull;
	iCEJSExtVariantFactory_createFromBoolean	_createFromBoolean;
	iCEJSExtVariantFactory_createFromInt32	_createFromInt32;
	iCEJSExtVariantFactory_createFromNumber	_createFromNumber;
	iCEJSExtVariantFactory_createFromString	_createFromString;
};

/*! @}
 * end of ICEJSExtVariantFactory
 */

#ifdef __cplusplus
} // end of extern "C"
#endif

//----------------------------------------------------------------
// Interface Wrappers
//----------------------------------------------------------------

#ifdef __cplusplus

/*! \defgroup CEComICEJSExtVariantFactoryRef CEComICEJSExtVariantFactoryRef
 * @{
 */

class CEComICEJSExtVariantFactoryRef
{
public:
	//----------------------------------------------------------------
	// constructor / destructor.
	//----------------------------------------------------------------
	CEComICEJSExtVariantFactoryRef() : _iJSExtVariantFactory(0) {}
	CEComICEJSExtVariantFactoryRef(ICEJSExtVariantFactory* iOther) : _iJSExtVariantFactory(0)
	{
		if (iOther)
		{
			_iJSExtVariantFactory = iOther;
			_iJSExtVariantFactory->_vtbl->_addRef(_iJSExtVariantFactory);
		}
	}

	CEComICEJSExtVariantFactoryRef(const CEComICEJSExtVariantFactoryRef& other) : _iJSExtVariantFactory(0)
	{
		if (other._iJSExtVariantFactory)
		{
			_iJSExtVariantFactory = other._iJSExtVariantFactory;
			_iJSExtVariantFactory->_vtbl->_addRef(_iJSExtVariantFactory);
		}
	}

	~CEComICEJSExtVariantFactoryRef()
	{
		if (_iJSExtVariantFactory)
		{
			ICEJSExtVariantFactory* tmp = _iJSExtVariantFactory;
			_iJSExtVariantFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
	}

	//----------------------------------------------------------------
	// initialize instance which uses queryInterface().
	//   Warning: this method does not increment the reference count.
	//----------------------------------------------------------------
	CEHResult initByQueryInterface(void* iIn)
	{
		CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
		if (iIn)
		{
			// explicit type-punning to notify aliasing to compiler
			union
			{
				ICEJSExtVariantFactory* iJSExtVariantFactory;
				void* _ptr;
			} uIntf;
			uIntf.iJSExtVariantFactory = 0;
			hr = reinterpret_cast<ICEUnknown*>(iIn)->_vtbl->_queryInterface(reinterpret_cast<ICEUnknown*>(iIn), CEComIID_ICEJSExtVariantFactory, &uIntf._ptr);
			if (CESucceeded(hr))
			{
				if (_iJSExtVariantFactory)
				{
					ICEJSExtVariantFactory* tmp = _iJSExtVariantFactory;
					_iJSExtVariantFactory = 0;
					tmp->_vtbl->_release(tmp);
				}
				_iJSExtVariantFactory = uIntf.iJSExtVariantFactory;
			}
		}
		else
		{
			hr = CE_SILK_ERR_BADARGS;
		}
		return hr;
	}

	//----------------------------------------------------------------
	// get the interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG ICEJSExtVariantFactory* object() const	{ return _iJSExtVariantFactory; }

	//----------------------------------------------------------------
	// attach this smart pointer to an existing interface.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	void attach(ICEJSExtVariantFactory* iOther)
	{
		if (_iJSExtVariantFactory)
		{
			ICEJSExtVariantFactory* tmp = _iJSExtVariantFactory;
			_iJSExtVariantFactory = 0;
			tmp->_vtbl->_release(tmp);
		}
		_iJSExtVariantFactory = iOther;
	}

	//----------------------------------------------------------------
	// detach the interface pointer from this.
	//   Warning: this method does not change the reference count.
	//----------------------------------------------------------------
	ICEJSExtVariantFactory* detach()
	{
		ICEJSExtVariantFactory* iIntf = _iJSExtVariantFactory;
		_iJSExtVariantFactory = 0;
		return iIntf;
	}

	//----------------------------------------------------------------
	// copy this to an existing interface pointer holder.
	//----------------------------------------------------------------
	CEHResult copyTo(ICEJSExtVariantFactory* *const iIntfOut)
	{
		if (!iIntfOut)
		{
			return CE_SILK_ERR_BADARGS;
		}
		*iIntfOut = _iJSExtVariantFactory;
		if (_iJSExtVariantFactory)
		{
			_iJSExtVariantFactory->_vtbl->_addRef(_iJSExtVariantFactory);
		}
		return CE_S_OK;
	}

	//----------------------------------------------------------------
	// operator overwrite.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG operator ICEJSExtVariantFactory*() const	{ return _iJSExtVariantFactory; }
	FORCEINLINE_WITHOUT_DEBUG ICEJSExtVariantFactory& operator*() const	{ return *_iJSExtVariantFactory; }
	FORCEINLINE_WITHOUT_DEBUG bool operator!() const	{ return (_iJSExtVariantFactory == 0); }
	FORCEINLINE_WITHOUT_DEBUG bool operator!=(ICEJSExtVariantFactory* iOther) const	{ return (_iJSExtVariantFactory != iOther); }
	FORCEINLINE_WITHOUT_DEBUG bool operator==(ICEJSExtVariantFactory* iOther) const	{ return (_iJSExtVariantFactory == iOther); }
	FORCEINLINE_WITHOUT_DEBUG CEComICEJSExtVariantFactoryRef& operator=(const CEComICEJSExtVariantFactoryRef& other)	{ return operator=(other._iJSExtVariantFactory); }

	CEComICEJSExtVariantFactoryRef& operator=(const ICEJSExtVariantFactory* iOther)
	{
		if (_iJSExtVariantFactory != iOther)
		{
			if (_iJSExtVariantFactory)
			{
				ICEJSExtVariantFactory* tmp = _iJSExtVariantFactory;
				_iJSExtVariantFactory = 0;
				tmp->_vtbl->_release(tmp);
			}

			_iJSExtVariantFactory = const_cast<ICEJSExtVariantFactory*>(iOther);
			if (_iJSExtVariantFactory)
			{
				_iJSExtVariantFactory->_vtbl->_addRef(_iJSExtVariantFactory);
			}
		}
		return *this;
	}

	FORCEINLINE_WITHOUT_DEBUG ICEJSExtVariantFactory** operator&() 
	{
		// operator& must be used for [out] pointer.
		// But, If this object has a reference to the com object, 
		// the reference will be leaked. So, clear the reference first:
		// 
		// CEComICEJSExtVariantFactoryRef foo;
		// clazz.createInstance(&foo);  //OK
		// clazz.createInstance(&foo);  //NG (assert).
		// foo = 0;
		// clazz.createInstance(&foo);  //OK
		//CEASSERT(!_iJSExtVariantFactory && "has a com object reference. clear first.");
		return & _iJSExtVariantFactory; 
	}
protected:
	void* operator new(size_t) throw()	{ return 0; }
	void operator delete(void*)	{}
	void* operator new[](size_t) throw()	{ return 0; }
#if (__GNUC__ == 2)
public:
#endif
	void operator delete[](void*)	{}

public:
	bool compareICEUnknown(CEComICEJSExtVariantFactoryRef& other)
	{
		bool result = false;
		if (_iJSExtVariantFactory)
		{
			CEComICEUnknownRef unknown;
			CEHResult hr = unknown.initByQueryInterface(_iJSExtVariantFactory);
			if(CESucceeded(hr))
			{
				CEComICEUnknownRef otherUnknown;
				hr = otherUnknown.initByQueryInterface(other);
				if (CESucceeded(hr))
				{
					result = (unknown == otherUnknown);
				}
			}
		}
		else
		{
			result = (other == NULL);
		}
		return result;
	}
public:
	//----------------------------------------------------------------
	// interface methods.
	//----------------------------------------------------------------
	FORCEINLINE_WITHOUT_DEBUG CEHResult queryInterface(const UINT32 iId, void* *const iOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_queryInterface(_iJSExtVariantFactory, iId, iOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG void addRef()	{ if (_iJSExtVariantFactory) { _iJSExtVariantFactory->_vtbl->_addRef(_iJSExtVariantFactory); } }

	FORCEINLINE_WITHOUT_DEBUG void release()	{ if (_iJSExtVariantFactory) { _iJSExtVariantFactory->_vtbl->_release(_iJSExtVariantFactory); } }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createFromUndefined(struct ICEJSExtVariant** iVariantOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_createFromUndefined(_iJSExtVariantFactory, iVariantOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createFromNull(struct ICEJSExtVariant** iVariantOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_createFromNull(_iJSExtVariantFactory, iVariantOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createFromBoolean(UINT8 booleanValue, struct ICEJSExtVariant** iVariantOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_createFromBoolean(_iJSExtVariantFactory, booleanValue, iVariantOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createFromInt32(INT32 int32Value, struct ICEJSExtVariant** iVariantOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_createFromInt32(_iJSExtVariantFactory, int32Value, iVariantOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createFromNumber(double doubleValue, struct ICEJSExtVariant** iVariantOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_createFromNumber(_iJSExtVariantFactory, doubleValue, iVariantOut) : CE_SILK_ERR_UNINITIALIZED; }

	FORCEINLINE_WITHOUT_DEBUG CEHResult createFromString(const UTF16CHAR* pCharArray16, UINT32 numOfChars16, struct ICEJSExtVariant** iVariantOut)	{ return _iJSExtVariantFactory ? _iJSExtVariantFactory->_vtbl->_createFromString(_iJSExtVariantFactory, pCharArray16, numOfChars16, iVariantOut) : CE_SILK_ERR_UNINITIALIZED; }


private:
	ICEJSExtVariantFactory* _iJSExtVariantFactory;
};

/*! @}
 * end of CEComICEJSExtVariantFactoryRef
 */

#endif // __cplusplus

#endif
